/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.eis.mappings;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.eis.EISException;
import oracle.toplink.eis.mappings.EISMapping;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.indirection.EISOneToManyQueryBasedValueHolder;
import oracle.toplink.internal.ox.XPathEngine;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.DOMRecord;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ModifyQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sdk.SDKCollectionMapping;
import oracle.toplink.sdk.SDKCollectionMappingHelper;
import org.w3c.dom.Element;

public class EISOneToManyMapping
extends CollectionMapping
implements EISMapping,
SDKCollectionMapping {
    protected boolean isForeignKeyRelationship = false;
    protected transient List targetForeignKeyFields;
    protected transient List sourceForeignKeyFields = new ArrayList(1);
    protected transient Map sourceForeignKeysToTargetKeys;
    protected XMLField foreignKeyGroupingElement;

    public EISOneToManyMapping() {
        this.targetForeignKeyFields = new ArrayList(1);
        this.sourceForeignKeysToTargetKeys = new HashMap(2);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    public boolean isEISMapping() {
        return true;
    }

    public void addForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getSourceForeignKeyFields().add(databaseField);
        this.getTargetForeignKeyFields().add(databaseField2);
        this.setIsForeignKeyRelationship(true);
    }

    public void addForeignKeyFieldName(String string, String string2) {
        this.addForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    public boolean isForeignKeyRelationship() {
        return this.isForeignKeyRelationship;
    }

    public void setIsForeignKeyRelationship(boolean bl) {
        this.isForeignKeyRelationship = bl;
    }

    public XMLField getForeignKeyGroupingElement() {
        return this.foreignKeyGroupingElement;
    }

    public void setForeignKeyGroupingElement(String string) {
        this.setForeignKeyGroupingElement(new XMLField(string));
    }

    public boolean hasCustomDeleteAllQuery() {
        return this.hasCustomDeleteAllQuery;
    }

    public ModifyQuery getDeleteAllQuery() {
        if (this.deleteAllQuery == null) {
            this.deleteAllQuery = new DataModifyQuery();
        }
        return this.deleteAllQuery;
    }

    public void setDeleteAllCall(Call call) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setCall(call);
        this.setDeleteAllQuery(deleteAllQuery);
        this.setHasCustomDeleteAllQuery(true);
    }

    protected void setForeignKeyGroupingElement(XMLField xMLField) {
        this.foreignKeyGroupingElement = xMLField;
    }

    public List getSourceForeignKeyFields() {
        return this.sourceForeignKeyFields;
    }

    public void setSourceForeignKeyFields(List list) {
        this.sourceForeignKeyFields = list;
        if (list != null && list.size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public List getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public void setTargetForeignKeyFields(List list) {
        this.targetForeignKeyFields = list;
    }

    public Map getSourceForeignKeysToTargetKeys() {
        return this.sourceForeignKeysToTargetKeys;
    }

    public void setSourceForeignKeysToTargetKeys(Map map) {
        this.sourceForeignKeysToTargetKeys = map;
        if (map != null && map.keySet() != null && map.keySet().size() > 0) {
            this.setIsForeignKeyRelationship(true);
        }
    }

    public boolean hasInverseConstraintDependency() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (!this.hasCustomSelectionQuery()) {
            throw DescriptorException.operationNotSupported("customSelectionQueryRequired");
        }
        if (this.getForeignKeyGroupingElement() == null && this.getSourceForeignKeysToTargetKeys().size() > 1) {
            throw EISException.groupingElementRequired();
        }
        if (this.getForeignKeyGroupingElement() != null) {
            this.getDescriptor().buildField(this.getForeignKeyGroupingElement());
        }
        this.initializeSourceForeignKeysToTargetKeys();
        this.initializeDeleteAllQuery();
    }

    protected void initializeSourceForeignKeysToTargetKeys() throws DescriptorException {
        int n;
        if (this.getSourceForeignKeyFields().size() != this.getTargetForeignKeyFields().size()) {
            throw DescriptorException.sizeMismatchOfForeignKeys(this);
        }
        for (n = 0; n < this.getTargetForeignKeyFields().size(); ++n) {
            this.getReferenceDescriptor().buildField((DatabaseField)this.getTargetForeignKeyFields().get(n));
        }
        for (n = 0; n < this.getSourceForeignKeyFields().size(); ++n) {
            this.getReferenceDescriptor().buildField((DatabaseField)this.getSourceForeignKeyFields().get(n));
            this.getSourceForeignKeysToTargetKeys().put(this.getSourceForeignKeyFields().get(n), this.getTargetForeignKeyFields().get(n));
        }
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
        }
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        Descriptor descriptor = this.getReferenceDescriptor();
        return descriptor.hasDependencyOnParts() || descriptor.usesOptimisticLocking() || descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses() || descriptor.hasMultipleTables();
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isForeignKeyRelationship()) {
            return super.shouldObjectModifyCascadeToParts(objectLevelModifyQuery);
        }
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    public boolean verifyDelete(Object object, Session session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object object2 = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                if (session.verifyDelete(containerPolicy.next(object3, session))) continue;
                return false;
            }
        }
        return true;
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        if (this.hasCustomDeleteAllQuery()) {
            this.deleteAll(deleteObjectQuery, object);
        } else {
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        }
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery);
        }
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            UnitOfWorkChangeSet unitOfWorkChangeSet;
            WriteObjectQuery writeObjectQuery2;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                writeObjectQuery2 = new InsertObjectQuery();
                writeObjectQuery2.setIsExecutionClone(true);
                writeObjectQuery2.setObject(object3);
                writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            if (writeObjectQuery.getSession().isUnitOfWork() && (unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet()) != null) {
                writeObjectQuery2.setObjectChangeSet((ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3));
            }
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isForeignKeyRelationship()) {
            return;
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public Object buildAddedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2 = null;
            object2 = mergeManager.shouldMergeChangesIntoDistributedCache() ? objectChangeSet.getTargetVersionOfSourceObject(mergeManager.getSession(), true) : objectChangeSet.getUnitOfWorkClone();
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object buildChangeSet(Object object, ObjectChangeSet objectChangeSet, Session session) {
        ObjectBuilder objectBuilder = session.getDescriptor(object).getObjectBuilder();
        return objectBuilder.createObjectChangeSet(object, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), session);
    }

    protected Object buildElementFromChangeSet(Object object, MergeManager mergeManager) {
        return ((ObjectChangeSet)object).getTargetVersionOfSourceObject(mergeManager.getSession());
    }

    public Object buildElementFromElement(Object object, MergeManager mergeManager) {
        if (this.shouldMergeCascadeParts(mergeManager)) {
            Object object2;
            ObjectChangeSet objectChangeSet = null;
            if (mergeManager.getSession().isUnitOfWork() && (object2 = (UnitOfWorkChangeSet)((UnitOfWork)mergeManager.getSession()).getUnitOfWorkChangeSet()) != null) {
                objectChangeSet = (ObjectChangeSet)((UnitOfWorkChangeSet)object2).getObjectChangeSetForClone(object);
            }
            object2 = mergeManager.getObjectToMerge(object);
            mergeManager.mergeChanges(object2, objectChangeSet);
        }
        return mergeManager.getTargetVersionOfSourceObject(object);
    }

    public Object buildRemovedElementFromChangeSet(Object object, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)object;
        if (!mergeManager.shouldMergeChangesIntoDistributedCache()) {
            mergeManager.registerRemovedNewObjectIfRequired(objectChangeSet.getUnitOfWorkClone());
        }
        return this.buildElementFromChangeSet(object, mergeManager);
    }

    public Object clone() {
        EISOneToManyMapping eISOneToManyMapping = (EISOneToManyMapping)super.clone();
        eISOneToManyMapping.setSourceForeignKeysToTargetKeys((Map)((HashMap)this.getSourceForeignKeysToTargetKeys()).clone());
        return eISOneToManyMapping;
    }

    protected Vector collectFields() {
        if (this.isForeignKeyRelationship()) {
            if (this.getForeignKeyGroupingElement() != null) {
                Vector<XMLField> vector = new Vector<XMLField>(1);
                vector.addElement(this.getForeignKeyGroupingElement());
                return vector;
            }
            return NO_FIELDS;
        }
        return NO_FIELDS;
    }

    public boolean compareElements(Object object, Object object2, Session session) {
        Vector vector;
        CacheKey cacheKey;
        if (!this.isForeignKeyRelationship()) {
            return false;
        }
        Vector vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, session);
        CacheKey cacheKey2 = new CacheKey(vector2);
        if (!cacheKey2.equals(cacheKey = new CacheKey(vector = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object2, session)))) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return session.compareObjects(object, object2);
        }
        return true;
    }

    public boolean mapKeyHasChanged(Object object, Session session) {
        return !this.getContainerPolicy().compareKeys(object, session);
    }

    public boolean compareElementsForChange(Object object, Object object2, Session session) {
        return object == object2;
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getAttributeValueFromObject(object) != null && !this.isAttributeValueInstantiatedOrChanged(object)) {
                return null;
            }
            return new SDKCollectionMappingHelper(this).compareForChange(object, object2, objectChangeSet, session);
        }
        return super.compareForChange(object, object2, objectChangeSet, session);
    }

    public boolean compareObjects(Object object, Object object2, Session session) {
        if (this.isForeignKeyRelationship()) {
            return new SDKCollectionMappingHelper(this).compareObjects(object, object2, session);
        }
        return super.compareObjects(object, object2, session);
    }

    public void simpleAddToCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        new SDKCollectionMappingHelper(this).simpleAddToCollectionChangeRecord(object, object2, objectChangeSet, session);
    }

    public void simpleRemoveFromCollectionChangeRecord(Object object, Object object2, ObjectChangeSet objectChangeSet, Session session) {
        new SDKCollectionMappingHelper(this).simpleRemoveFromCollectionChangeRecord(object, object2, objectChangeSet, session);
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException {
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object, deleteObjectQuery.getSession()));
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        this.deleteAll(deleteObjectQuery, object);
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected XMLRecord extractKeyRowFromReferenceObject(Object object, Session session, XMLRecord xMLRecord) {
        Element element = XPathEngine.getInstance().createUnownedElement(xMLRecord.getDOM(), this.getForeignKeyGroupingElement());
        DOMRecord dOMRecord = new DOMRecord(element);
        for (int i = 0; i < this.getSourceForeignKeyFields().size(); ++i) {
            DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(i);
            if (object == null) {
                ((DatabaseRow)dOMRecord).add(databaseField, null);
                continue;
            }
            DatabaseField databaseField2 = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(databaseField);
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, session);
            ((DatabaseRow)dOMRecord).add(databaseField, object2);
        }
        return dOMRecord;
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        ReadQuery readQuery = this.getSelectionQuery();
        if (!this.isForeignKeyRelationship) {
            if (readQuery.isObjectLevelReadQuery() && (objectLevelReadQuery.shouldCascadeAllParts() || objectLevelReadQuery.shouldCascadePrivateParts() && this.isPrivateOwned() || objectLevelReadQuery.shouldCascadeByMapping() && this.cascadeRefresh)) {
                readQuery = (ObjectLevelReadQuery)readQuery.clone();
                ((ObjectLevelReadQuery)readQuery).setShouldRefreshIdentityMapResult(objectLevelReadQuery.shouldRefreshIdentityMapResult());
                readQuery.setCascadePolicy(objectLevelReadQuery.getCascadePolicy());
                readQuery.setQueryId(objectLevelReadQuery.getQueryId());
                if (readQuery.shouldMaintainCache()) {
                    readQuery.setShouldMaintainCache(objectLevelReadQuery.shouldMaintainCache());
                }
            }
            return this.getIndirectionPolicy().valueFromQuery(readQuery, databaseRow, objectLevelReadQuery.getSession());
        }
        if (this.getIndirectionPolicy().usesIndirection()) {
            EISOneToManyQueryBasedValueHolder eISOneToManyQueryBasedValueHolder = new EISOneToManyQueryBasedValueHolder(this, readQuery, databaseRow, objectLevelReadQuery.getSession());
            return eISOneToManyQueryBasedValueHolder;
        }
        Vector vector = this.getForeignKeyRows(databaseRow);
        if (vector == null) {
            return null;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object = containerPolicy.containerInstance(vector.size());
        for (int i = 0; i < vector.size(); ++i) {
            Iterator<Object> iterator;
            XMLRecord xMLRecord = (XMLRecord)vector.elementAt(i);
            Object object2 = this.getIndirectionPolicy().valueFromQuery(readQuery, xMLRecord, objectLevelReadQuery.getSession());
            if (object2 instanceof Collection) {
                iterator = ((Collection)object2).iterator();
                while (iterator.hasNext()) {
                    containerPolicy.addInto(iterator.next(), object, session);
                }
                continue;
            }
            if (object2 instanceof Map) {
                iterator = ((Map)object2).values().iterator();
                while (iterator.hasNext()) {
                    containerPolicy.addInto(iterator.next(), object, session);
                }
                continue;
            }
            containerPolicy.addInto(object2, object, session);
        }
        if (containerPolicy.sizeFor(object) == 0) {
            return null;
        }
        return object;
    }

    public Vector getForeignKeyRows(DatabaseRow databaseRow) {
        Vector vector = new Vector();
        if (this.getForeignKeyGroupingElement() == null) {
            Object object;
            if (this.getSourceForeignKeyFields().size() > 0 && (object = databaseRow.getValues((DatabaseField)this.getSourceForeignKeyFields().get(0))) != null) {
                if (object instanceof Vector) {
                    int n = ((Vector)object).size();
                    for (int i = 0; i < n; ++i) {
                        DOMRecord dOMRecord = new DOMRecord("test");
                        dOMRecord.put(this.getSourceForeignKeyFields().get(0), ((Vector)object).get(i));
                        vector.add(dOMRecord);
                    }
                } else {
                    DOMRecord dOMRecord = new DOMRecord("test");
                    dOMRecord.put(this.getSourceForeignKeyFields().get(0), object);
                    vector.add(dOMRecord);
                }
            }
        } else {
            vector = (Vector)databaseRow.getValues(this.getForeignKeyGroupingElement());
        }
        return vector;
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (!this.isForeignKeyRelationship) {
            return;
        }
        if (this.getSourceForeignKeysToTargetKeys() == null || this.getSourceForeignKeysToTargetKeys().size() == 0) {
            return;
        }
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow2 != null) {
            if (this.getForeignKeyGroupingElement() != null) {
                databaseRow.put(this.getForeignKeyGroupingElement(), databaseRow2.getValues(this.getForeignKeyGroupingElement()));
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
                databaseRow.put(databaseField, databaseRow2.getValues(databaseField));
            }
            return;
        }
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = this.getRealCollectionAttributeValueFromObject(object, session);
        Vector<XMLRecord> vector = new Vector<XMLRecord>(containerPolicy.sizeFor(object2));
        if (this.getForeignKeyGroupingElement() != null) {
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                XMLRecord xMLRecord = this.extractKeyRowFromReferenceObject(containerPolicy.next(object3, session), session, (XMLRecord)databaseRow);
                vector.addElement(xMLRecord);
            }
            databaseRow.add(this.getForeignKeyGroupingElement(), vector);
        } else {
            DatabaseField databaseField = (DatabaseField)this.getSourceForeignKeyFields().get(0);
            DatabaseField databaseField2 = (DatabaseField)this.getSourceForeignKeysToTargetKeys().get(databaseField);
            Object object4 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object4)) {
                Object object5 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(containerPolicy.next(object4, session), databaseField2, session);
                databaseRow.add(databaseField, object5);
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                databaseRow.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                databaseRow.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsert(object, databaseRow, session);
        }
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                databaseRow.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                databaseRow.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeFromObjectIntoRowForShallowInsertWithChangeRecord(changeRecord, databaseRow, session);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        Object object;
        Object object2;
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Session session = writeObjectQuery.getSession();
        if (session.isUnitOfWork() && this.compareObjectsWithoutPrivateOwned(object2 = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), session), object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getBackupClone(), session), session)) {
            return;
        }
        this.writeFromObjectIntoRow(writeObjectQuery.getObject(), databaseRow, session);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isForeignKeyRelationship()) {
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            this.writeFromObjectIntoRow(object, databaseRow, session);
        } else {
            super.writeFromObjectIntoRowWithChangeRecord(changeRecord, databaseRow, session);
        }
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isForeignKeyRelationship() && !this.isReadOnly()) {
            if (this.getForeignKeyGroupingElement() != null) {
                databaseRow.put(this.getForeignKeyGroupingElement(), (Object)null);
            } else if (this.getSourceForeignKeyFields().size() > 0) {
                databaseRow.put(this.getSourceForeignKeyFields().get(0), (Object)null);
            }
        } else {
            super.writeInsertFieldsIntoRow(databaseRow, session);
        }
    }

    protected Object executeBatchQueryForPessimisticLocking(DatabaseQuery databaseQuery, UnitOfWork unitOfWork, DatabaseRow databaseRow) {
        throw DescriptorException.invalidMappingOperation(this, "executeBatchQueryForPessimisticLocking");
    }

    public void setSelectionSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionSQLString");
    }

    public void setSelectionCriteria(Expression expression) {
        throw DescriptorException.invalidMappingOperation(this, "setSelectionCriteria");
    }

    public void setUsesBatchReading(boolean bl) {
        throw DescriptorException.invalidMappingOperation(this, "setUsesBatchReading");
    }

    public boolean shouldUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "shouldUseBatchReading");
    }

    public void useBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "useBatchReading");
    }

    public void dontUseBatchReading() {
        throw DescriptorException.invalidMappingOperation(this, "dontUseBatchReading");
    }

    public void addAscendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addAscendingOrdering");
    }

    public void addDescendingOrdering(String string) {
        throw DescriptorException.invalidMappingOperation(this, "addDescendingOrdering");
    }

    public void setDeleteAllSQLString(String string) {
        throw DescriptorException.invalidMappingOperation(this, "setDeleteAllSQLString");
    }
}

