/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import oracle.toplink.descriptors.ClassExtractor;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.sessions.Record;
import oracle.toplink.sessions.Session;

public class MethodClassExtractor
extends ClassExtractor {
    protected transient Descriptor descriptor;
    protected String classExtractionMethodName;
    protected transient Method classExtractionMethod;

    public Method getClassExtractionMethod() {
        return this.classExtractionMethod;
    }

    public String getClassExtractionMethodName() {
        return this.classExtractionMethodName;
    }

    protected void setClassExtractionMethod(Method method) {
        this.classExtractionMethod = method;
    }

    public void setClassExtractionMethodName(String string) {
        this.classExtractionMethodName = string;
    }

    public void initialize(Descriptor descriptor, Session session) throws DescriptorException {
        this.setDescriptor(descriptor);
        Class[] classArray = new Class[]{ClassConstants.DatabaseRow_Class};
        try {
            this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), classArray));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            classArray[0] = ClassConstants.Record_Class;
            try {
                this.setClassExtractionMethod(Helper.getDeclaredMethod(descriptor.getJavaClass(), this.getClassExtractionMethodName(), classArray));
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw DescriptorException.noSuchMethodWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, noSuchMethodException2);
            }
        }
        catch (SecurityException securityException) {
            throw DescriptorException.securityWhileInitializingClassExtractionMethod(this.getClassExtractionMethodName(), descriptor, securityException);
        }
        if (!Modifier.isStatic(this.getClassExtractionMethod().getModifiers())) {
            throw DescriptorException.classExtractionMethodMustBeStatic(this.getClassExtractionMethodName(), descriptor);
        }
    }

    public Class extractClassFromRow(Record record, Session session) {
        Class clazz;
        try {
            Object[] objectArray = new Object[]{record};
            clazz = (Class)PrivilegedAccessController.invokeMethod(this.getClassExtractionMethod(), null, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw DescriptorException.illegalAccessWhileInvokingRowExtractionMethod((DatabaseRow)record, this.getClassExtractionMethod(), this.getDescriptor(), illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw DescriptorException.targetInvocationWhileInvokingRowExtractionMethod((DatabaseRow)record, this.getClassExtractionMethod(), this.getDescriptor(), invocationTargetException);
        }
        return clazz;
    }

    protected Descriptor getDescriptor() {
        return this.descriptor;
    }

    protected void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }
}

