/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.descriptors;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.descriptors.ClassDescriptor;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.FetchGroup;
import oracle.toplink.queryframework.FetchGroupTracker;
import oracle.toplink.queryframework.ObjectLevelReadQuery;

public class FetchGroupManager {
    private Map fetchGroups = null;
    private FetchGroup defaultFetchGroup;
    private Descriptor descriptor;
    static /* synthetic */ Class class$oracle$toplink$descriptors$ClassDescriptor;

    public void addFetchGroup(FetchGroup fetchGroup) {
        this.getFetchGroups().put(fetchGroup.getName(), fetchGroup);
    }

    public Map getFetchGroups() {
        if (this.fetchGroups == null) {
            this.fetchGroups = new HashMap(2);
        }
        return this.fetchGroups;
    }

    public FetchGroup getDefaultFetchGroup() {
        return this.defaultFetchGroup;
    }

    public FetchGroup getFetchGroup(String string) {
        return (FetchGroup)this.getFetchGroups().get(string);
    }

    public void setDefaultFetchGroup(FetchGroup fetchGroup) {
        this.defaultFetchGroup = fetchGroup;
    }

    public boolean isPartialObject(Object object) {
        if (object != null) {
            FetchGroup fetchGroup = ((FetchGroupTracker)object).getFetchGroup();
            return fetchGroup != null;
        }
        return false;
    }

    public boolean isObjectValidForFetchGroup(Object object, FetchGroup fetchGroup) {
        FetchGroup fetchGroup2 = ((FetchGroupTracker)object).getFetchGroup();
        return fetchGroup2 == null || fetchGroup2.isSupersetOf(fetchGroup);
    }

    public boolean shouldWriteInto(Object object, Object object2) {
        if (this.isPartialObject(object2)) {
            FetchGroup fetchGroup = ((FetchGroupTracker)object).getFetchGroup();
            FetchGroup fetchGroup2 = ((FetchGroupTracker)object2).getFetchGroup();
            return fetchGroup2 != null && !fetchGroup2.isSupersetOf(fetchGroup) || ((FetchGroupTracker)object).shouldRefreshFetchGroup();
        }
        return false;
    }

    public void writePartialIntoClones(Object object, Object object2, UnitOfWork unitOfWork) {
        FetchGroup fetchGroup = ((FetchGroupTracker)object2).getFetchGroup();
        FetchGroup fetchGroup2 = ((FetchGroupTracker)object).getFetchGroup();
        Object object3 = unitOfWork.getBackupClone(object2);
        if (((FetchGroupTracker)object).shouldRefreshFetchGroup()) {
            this.refreshFetchGroupIntoClones(object, object2, object3, fetchGroup2, fetchGroup, unitOfWork);
        } else {
            this.revertDataIntoUnfetchedAttributesOfClones(object, object2, object3, fetchGroup2, fetchGroup, unitOfWork);
        }
        fetchGroup2 = this.unionFetchGroups(fetchGroup2, fetchGroup);
        this.setObjectFetchGroup(object2, fetchGroup2);
        this.setObjectFetchGroup(object3, fetchGroup2);
    }

    private void refreshFetchGroupIntoClones(Object object, Object object2, Object object3, FetchGroup fetchGroup, FetchGroup fetchGroup2, UnitOfWork unitOfWork) {
        Vector vector = this.descriptor.getMappings();
        boolean bl = fetchGroup != null;
        Set set = bl ? fetchGroup.getAttributes() : null;
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (bl && (set == null || !set.contains(databaseMapping.getAttributeName()))) continue;
            databaseMapping.buildClone(object, object2, unitOfWork);
            databaseMapping.buildClone(object2, object3, unitOfWork);
        }
    }

    private void revertDataIntoUnfetchedAttributesOfClones(Object object, Object object2, Object object3, FetchGroup fetchGroup, FetchGroup fetchGroup2, UnitOfWork unitOfWork) {
        if (this.isObjectValidForFetchGroup(object2, fetchGroup)) {
            return;
        }
        Vector vector = this.descriptor.getMappings();
        Set set = fetchGroup2.getAttributes();
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping = (DatabaseMapping)vector.get(i);
            if (!this.isAttributeFetched(object, databaseMapping.getAttributeName()) || set.contains(databaseMapping.getAttributeName())) continue;
            databaseMapping.buildClone(object, object2, unitOfWork);
            databaseMapping.buildClone(object2, object3, unitOfWork);
        }
    }

    public void copyFetchGroupInto(Object object, Object object2) {
        if (this.isPartialObject(object)) {
            ((FetchGroupTracker)object2).setFetchGroup(((FetchGroupTracker)object).getFetchGroup());
        }
    }

    public void unionFetchGroupIntoObject(Object object, FetchGroup fetchGroup) {
        FetchGroupTracker fetchGroupTracker = (FetchGroupTracker)object;
        fetchGroupTracker.setFetchGroup(this.unionFetchGroups(fetchGroupTracker.getFetchGroup(), fetchGroup));
    }

    public FetchGroup unionFetchGroups(FetchGroup fetchGroup, FetchGroup fetchGroup2) {
        if (fetchGroup == null || fetchGroup2 == null) {
            return null;
        }
        if (fetchGroup.isSupersetOf(fetchGroup2)) {
            return fetchGroup;
        }
        if (fetchGroup2.isSupersetOf(fetchGroup)) {
            return fetchGroup2;
        }
        StringBuffer stringBuffer = new StringBuffer(fetchGroup.getName());
        stringBuffer.append("_");
        stringBuffer.append(fetchGroup2.getName());
        FetchGroup fetchGroup3 = new FetchGroup(stringBuffer.toString());
        fetchGroup3.addAttributes(fetchGroup.getAttributes());
        fetchGroup3.addAttributes(fetchGroup2.getAttributes());
        return fetchGroup3;
    }

    public void reset(Object object) {
        ((FetchGroupTracker)object).resetFetchGroup();
    }

    public void setObjectFetchGroup(Object object, FetchGroup fetchGroup) {
        if (this.descriptor.getFetchGroupManager() != null) {
            ((FetchGroupTracker)object).setFetchGroup(fetchGroup);
        }
    }

    public void setRefreshOnFetchGroupToObject(Object object, boolean bl) {
        ((FetchGroupTracker)object).setShouldRefreshFetchGroup(bl);
    }

    public boolean isAttributeFetched(Object object, String string) {
        FetchGroup fetchGroup = ((FetchGroupTracker)object).getFetchGroup();
        return fetchGroup == null || fetchGroup.getAttributes().contains(string);
    }

    public Descriptor getDescriptor() {
        return this.descriptor;
    }

    public ClassDescriptor getClassDescriptor() {
        Descriptor descriptor = this.getDescriptor();
        if (descriptor instanceof ClassDescriptor) {
            return (ClassDescriptor)descriptor;
        }
        throw ValidationException.cannotCastToClass(descriptor, descriptor.getClass(), class$oracle$toplink$descriptors$ClassDescriptor == null ? (class$oracle$toplink$descriptors$ClassDescriptor = FetchGroupManager.class$("oracle.toplink.descriptors.ClassDescriptor")) : class$oracle$toplink$descriptors$ClassDescriptor);
    }

    public void setDescriptor(Descriptor descriptor) {
        this.descriptor = descriptor;
    }

    public void prepareQueryWithFetchGroup(ObjectLevelReadQuery objectLevelReadQuery) {
        DatabaseMapping databaseMapping;
        objectLevelReadQuery.initializeFetchGroup();
        if (!objectLevelReadQuery.hasFetchGroup()) {
            return;
        }
        if (objectLevelReadQuery.isReportQuery()) {
            throw QueryException.fetchGroupNotSupportOnReportQuery();
        }
        if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
            throw QueryException.fetchGroupNotSupportOnPartialAttributeReading();
        }
        Object object = this.getDescriptor().getObjectBuilder().getPrimaryKeyMappings().iterator();
        while (object.hasNext()) {
            databaseMapping = (DatabaseMapping)object.next();
            objectLevelReadQuery.getFetchGroup().addAttribute(databaseMapping.getAttributeName());
        }
        if (objectLevelReadQuery.shouldMaintainCache() && this.getDescriptor().usesOptimisticLocking() && (object = this.getDescriptor().getOptimisticLockingPolicy().getWriteLockField()) != null && (databaseMapping = this.getDescriptor().getObjectBuilder().getMappingForField((DatabaseField)object)) != null) {
            objectLevelReadQuery.getFetchGroup().addAttribute(databaseMapping.getAttributeName());
        }
    }

    public Object clone() {
        Object object = null;
        try {
            object = super.clone();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

