/*
 * Decompiled with CFR 0.152.
 */
package Projet;

import Projet.Compte;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class FichierCompte {
    private String nomDuFichier = "Compte.dat";
    private ObjectOutputStream fWo;
    private ObjectInputStream fRo;
    private char mode;

    public boolean ouvrir(String tmp, String s) {
        try {
            this.mode = s.toUpperCase().charAt(0);
            this.nomDuFichier = tmp;
            if (this.mode == 'R' || this.mode == 'L') {
                this.fRo = new ObjectInputStream(new FileInputStream(this.nomDuFichier));
            } else if (this.mode == 'W' || this.mode == 'E') {
                this.fWo = new ObjectOutputStream(new FileOutputStream(this.nomDuFichier));
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void fermer() {
        try {
            if (this.mode == 'R' || this.mode == 'L') {
                this.fRo.close();
            } else if (this.mode == 'W' || this.mode == 'E') {
                this.fWo.close();
            }
        }
        catch (IOException e) {
            System.out.println(this.nomDuFichier + " : Erreur \u2021 la fermeture ");
        }
    }

    public Compte lire() {
        try {
            Compte tmp = (Compte)this.fRo.readObject();
            return tmp;
        }
        catch (IOException e) {
            System.out.println(this.nomDuFichier + " : Erreur  de lecture ");
        }
        catch (ClassNotFoundException e) {
            System.out.println(this.nomDuFichier + " n'est pas du bon format ");
        }
        return null;
    }

    public void ecrire(Compte tmp) {
        try {
            if (tmp != null) {
                this.fWo.writeObject(tmp);
            }
        }
        catch (IOException e) {
            System.out.println(this.nomDuFichier + " : Erreur en cours d'\u00c8criture ");
        }
    }
}

