/*
 * Decompiled with CFR 0.152.
 */
package Introduction;

import Introduction.Cercle;
import Introduction.Forme;
import Introduction.ListeDeFormes;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import org.jdesktop.layout.GroupLayout;

public class FeuilleDeDessins
extends JPanel {
    private int debutX;
    private int debutY;
    private int deltaX;
    private int deltaY;
    private int couleur = 4;
    private String forme = "cercle";
    private ListeDeFormes listeAdessiner;

    public FeuilleDeDessins(ListeDeFormes ldf) {
        this.listeAdessiner = ldf;
        this.initComponents();
        this.setVisible(true);
        this.setBounds(0, 0, 500, 500);
        this.setCursor(new Cursor(1));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        ArrayList<Forme> tmpListe = this.listeAdessiner.getListeFormes();
        int nbFormes = tmpListe.size();
        if (nbFormes > 0) {
            for (Forme f : tmpListe) {
                f.dessiner(g);
            }
        } else {
            System.out.print("Il n'y a pas de forme dans cette liste ");
        }
    }

    public void setCouleur(int ncol) {
        this.couleur = ncol;
    }

    public void setForme(String nf) {
        this.forme = nf;
    }

    public void dessinerLesFormes(ListeDeFormes liste) {
        this.listeAdessiner = liste;
        this.repaint();
    }

    private void initComponents() {
        this.setBackground(new Color(254, 254, 254));
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                FeuilleDeDessins.this.formMousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                FeuilleDeDessins.this.formMouseReleased(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(0, 398, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(0, 298, Short.MAX_VALUE));
    }

    private void dessinerUnCercle() {
        int delta = 0;
        int decalageX = 0;
        int decalageY = 0;
        if (Math.abs(this.deltaX) > Math.abs(this.deltaY)) {
            delta = this.deltaX;
            if (delta < 0) {
                decalageX = delta;
                delta = -delta;
            } else {
                decalageX = 0;
            }
        }
        if (Math.abs(this.deltaY) > Math.abs(this.deltaX)) {
            delta = this.deltaY;
            if (delta < 0) {
                decalageY = delta;
                delta = -delta;
            } else {
                decalageY = 0;
            }
        }
        Cercle c = new Cercle(this.debutX + decalageX, this.debutY + decalageY, delta, this.couleur);
        this.listeAdessiner.ajouterUneForme(c);
        this.repaint();
    }

    private void formMousePressed(MouseEvent evt) {
        this.debutX = evt.getX();
        this.debutY = evt.getY();
    }

    private void formMouseReleased(MouseEvent evt) {
        this.deltaX = evt.getX() - this.debutX;
        this.deltaY = evt.getY() - this.debutY;
        if (this.forme.equals("cercle")) {
            this.dessinerUnCercle();
        }
    }
}

