/*
#	Le livre de Java 1er langage
#	A. Tasso
#	Chapitre 12 : Créer une interface graphique
#	Section  : Gestion de bulletins de notes
#	Fichier  : ClasseSwing.java
#	Class    : ClasseSwing
*/

// Le fichier ClasseSwing.java se trouve dans le répertoire 
// Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/src/Introduction

package Introduction;
// Pour traiter les opérations sur les fichiers
import java.io.File;
// Pour rechercher un fichier dans votre système de fichiers
import javax.swing.JFileChooser;

// La classe ClasseSwing hérite des propriétés et méthodes de la la classe JFRame
public class CursusSwing extends javax.swing.JFrame {
    // Initialiser la photo par défaut à celle d'une silhouette
    // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
    // Les photos se trouvent dans le répertoire 
    // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Photos
    private String urlPhoto="/Users/VotreCompte/Photos/Inconnu.jpg";
    private String periode ;
    private String [] listeMatieres;

    public CursusSwing() {
        // Afficher les composants graphiques tels qu'ils sont placés dans le fenêtre Design
        initComponents();
        // Placer la fenêtre en 100, 100 par rapport au coin supérieur gauche de l'écran
        // largeur 450, hauteur 500
        setBounds(100, 100, 450, 500);
        // Afficher un texte dans la zone info
        info.setText("  Créer : Tous les champs doivent être renseignés !");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        groupeBtn = new javax.swing.ButtonGroup();
        labelTitre = new javax.swing.JLabel();
        separationTitre = new javax.swing.JSeparator();
        labelNom = new javax.swing.JLabel();
        nomAsaisir = new javax.swing.JTextField();
        labelPrenom = new javax.swing.JLabel();
        prenomAsaisir = new javax.swing.JTextField();
        labelPeriode = new javax.swing.JLabel();
        choixPeriode = new javax.swing.JComboBox();
        labelPhoto = new javax.swing.JLabel();
        rechercherBtn = new javax.swing.JButton();
        info = new javax.swing.JLabel();
        validerBtn = new javax.swing.JButton();
        fermerBtn = new javax.swing.JButton();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Gestion des Étudiants");
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                formMouseEntered(evt);
            }
        });

        labelTitre.setFont(new java.awt.Font("Arial", 0, 18));
        labelTitre.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        labelTitre.setText("Étudiant  ");

        labelNom.setText("Nom :");

        nomAsaisir.setDragEnabled(false);
        nomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                nomAsaisirMouseEntered(evt);
            }
        });

        labelPrenom.setText("Prénom :");

        prenomAsaisir.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                prenomAsaisirMouseEntered(evt);
            }
        });

        labelPeriode.setText("Période :");

        choixPeriode.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Quel semestre ?", "Semestre 1", "Semestre 2", "Semestre 3", "Semestre 4" }));
        choixPeriode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                choixPeriodeActionPerformed(evt);
            }
        });

        labelPhoto.setText("Photo :");

        rechercherBtn.setText("Rechercher");
        rechercherBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                rechercherBtnActionPerformed(evt);
            }
        });
        rechercherBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                rechercherBtnMouseEntered(evt);
            }
        });

        info.setBackground(new java.awt.Color(250, 250, 250));
        info.setFont(new java.awt.Font("Arial", 2, 13));
        info.setForeground(new java.awt.Color(120, 120, 120));
        info.setText(" info :");
        info.setBorder(javax.swing.BorderFactory.createEtchedBorder());
        info.setOpaque(true);

        validerBtn.setText("Valider");
        validerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                validerBtnActionPerformed(evt);
            }
        });
        validerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                validerBtnMouseEntered(evt);
            }
        });

        fermerBtn.setText("Fermer");
        fermerBtn.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                fermerBtnActionPerformed(evt);
            }
        });
        fermerBtn.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseEntered(java.awt.event.MouseEvent evt) {
                fermerBtnMouseEntered(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(separationTitre, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 472, Short.MAX_VALUE)
            .add(layout.createSequentialGroup()
                .add(35, 35, 35)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(labelPrenom, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 79, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(labelPeriode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 71, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(labelPhoto, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 60, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(labelNom, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 105, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(prenomAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 163, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(rechercherBtn)
                    .add(choixPeriode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 193, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(nomAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 166, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(129, 129, 129))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(89, 89, 89)
                .add(validerBtn)
                .add(74, 74, 74)
                .add(fermerBtn)
                .add(143, 143, 143))
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .add(3, 3, 3)
                .add(info, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 449, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(119, 119, 119)
                .add(labelTitre, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 197, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(156, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .add(28, 28, 28)
                .add(labelTitre)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(separationTitre, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(26, 26, 26)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(107, 107, 107)
                        .add(rechercherBtn))
                    .add(layout.createSequentialGroup()
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(labelNom, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(nomAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(prenomAsaisir, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(choixPeriode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(layout.createSequentialGroup()
                        .add(36, 36, 36)
                        .add(labelPrenom, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(labelPeriode, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 28, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(labelPhoto, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 29, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .add(51, 51, 51)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(validerBtn)
                    .add(fermerBtn))
                .add(45, 45, 45)
                .add(info, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 37, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(52, Short.MAX_VALUE))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void choixPeriodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_choixPeriodeActionPerformed
  // Récupérer le semestre sélectionné
  periode = (String) choixPeriode.getSelectedItem();
  // Rechercher la liste des matières en fonction du semestre
  rechercherMatiere(periode);
}//GEN-LAST:event_choixPeriodeActionPerformed

private void rechercherMatiere(String quelSemestre){    
  Fichier fichierTxt = new Fichier(); 
  listeMatieres = new String [5];
  String [] tousLesmots = new String[6];
   // Modifier l'url d'accès au fichier Inconnu.jpg selon votre système d'exploitation
  // Le fichier Ressources.txt se trouve dans le répertoire 
  // Sources/Exemples/Chapitre12/NetBeansProjects/GestionClasseExemple/Ressources
  if (fichierTxt.ouvrir("/Users/VotreCompte/Ressources/Ressources.txt", "R")){
      // Voir chapitre 10, corrigé de l'exercice 10.5
      do {
        tousLesmots = fichierTxt.lire();
        if (tousLesmots[0].equalsIgnoreCase(quelSemestre)){
         for (int i=1; i < tousLesmots.length; i++){
            listeMatieres[i-1] = tousLesmots[i]; 
         }
         break;
      }
    } while (tousLesmots[0]!= null);
    fichierTxt.fermer();
  }
}

private void rechercherBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_rechercherBtnActionPerformed
  // Création d’un objet de type File
  File fichierPhoto;
  // Création d’un composant JFileChooser 
  JFileChooser fichierArechercher= new JFileChooser();
  //  Ouvrir une boite de dialogue qui permet la recherche d’un fichier
  int etatRetour = fichierArechercher.showOpenDialog(CursusSwing.this);
  //  Si l’utilisateur a sélectionné un fichier
  if (etatRetour == JFileChooser.APPROVE_OPTION) {
    //  Récupérer le fichier sélectionné
    fichierPhoto = fichierArechercher.getSelectedFile();
    //  Stocker le chemin d’accès au fichier dans urlPhoto
    urlPhoto  = fichierPhoto.toString();
  } 
}//GEN-LAST:event_rechercherBtnActionPerformed

private void validerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_validerBtnActionPerformed
//   Enregistrer les nom et prénom de l’étudiant
  String nom = nomAsaisir.getText();
  String prenom = prenomAsaisir.getText();
  //    Créer et initialiser à 0 le tableau des moyennes
  double [] moyenne = new double[listeMatieres.length];
  for (int i=0; i < moyenne.length; i++) moyenne[i]=0;
  //  Créer un étudiant 
  Etudiant eleve = new Etudiant(nom, prenom, urlPhoto, listeMatieres, periode, moyenne);
  //  Créer un bulletin de notes 
  BulletinNotes bn = new BulletinNotes(eleve);

   
}//GEN-LAST:event_validerBtnActionPerformed


private void fermerBtnActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_fermerBtnActionPerformed
    // Sortir de l'application
    System.exit(0);
}//GEN-LAST:event_fermerBtnActionPerformed

private void nomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_nomAsaisirMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Saisir le nom de l'étudiant" );
}//GEN-LAST:event_nomAsaisirMouseEntered

private void prenomAsaisirMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_prenomAsaisirMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Saisir le prénom de l'étudiant" );
}//GEN-LAST:event_prenomAsaisirMouseEntered

private void rechercherBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_rechercherBtnMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Rechercher la photo de l'étudiant" );
}//GEN-LAST:event_rechercherBtnMouseEntered

private void validerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_validerBtnMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Afficher le bulletin de notes de l'étudiant" );
}//GEN-LAST:event_validerBtnMouseEntered

private void fermerBtnMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_fermerBtnMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Quitter l'application " );
}//GEN-LAST:event_fermerBtnMouseEntered

private void formMouseEntered(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_formMouseEntered
    // Afficher un texte dans la zone info
    info.setText("  Info : Tous les champs doivent être renseignés !");
}//GEN-LAST:event_formMouseEntered



    /**q
    * @param args the command line arguments
    */
    public static void main(String args[]) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new CursusSwing().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox choixPeriode;
    private javax.swing.JButton fermerBtn;
    private javax.swing.ButtonGroup groupeBtn;
    private javax.swing.JLabel info;
    private javax.swing.JLabel labelNom;
    private javax.swing.JLabel labelPeriode;
    private javax.swing.JLabel labelPhoto;
    private javax.swing.JLabel labelPrenom;
    private javax.swing.JLabel labelTitre;
    private javax.swing.JTextField nomAsaisir;
    private javax.swing.JTextField prenomAsaisir;
    private javax.swing.JButton rechercherBtn;
    private javax.swing.JSeparator separationTitre;
    private javax.swing.JButton validerBtn;
    // End of variables declaration//GEN-END:variables

       

}
