/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.transaction;

import oracle.toplink.transaction.AbstractSynchronizationListener;
import oracle.toplink.transaction.AbstractTransactionController;
import oracle.toplink.transaction.OTSSynchronizationListener;
import org.omg.CosTransactions.Control;
import org.omg.CosTransactions.Current;
import org.omg.CosTransactions.Status;
import org.omg.CosTransactions.Synchronization;

public abstract class OTSTransactionController
extends AbstractTransactionController {
    public static final boolean DEFAULT_REPORT_HEURISTICS = false;
    public boolean reportHeuristicsOnCommit;
    static String[] codes = new String[]{"STATUS_ACTIVE", "MARKED_ROLLBACK", "PREPARED", "COMMITTED", "ROLLEDBACK", "UNKNOWN", "NO_TRANSACTION", "PREPARING", "COMMITTING", "ROLLING_BACK"};

    public OTSTransactionController() {
        this.listenerFactory = new OTSSynchronizationListener();
        this.reportHeuristicsOnCommit = false;
    }

    protected abstract Current acquireCurrent() throws Exception;

    public boolean getReportHeuristicsOnCommit() {
        return this.reportHeuristicsOnCommit;
    }

    public void setReportHeuristicsOnCommit(boolean bl) {
        this.reportHeuristicsOnCommit = bl;
    }

    protected void registerSynchronization_impl(AbstractSynchronizationListener abstractSynchronizationListener, Object object) throws Exception {
        Synchronization synchronization = ((OTSSynchronizationListener)abstractSynchronizationListener).getSynchronization();
        ((Control)object).get_coordinator().register_synchronization(synchronization);
    }

    protected Object getTransaction_impl() throws Exception {
        return this.acquireCurrent().get_control();
    }

    protected Object getTransactionKey_impl(Object object) throws Exception {
        if (object == null) {
            return null;
        }
        return ((Control)object).get_coordinator().get_transaction_name();
    }

    protected Object getTransactionStatus_impl() throws Exception {
        return this.acquireCurrent().get_status();
    }

    protected void beginTransaction_impl() throws Exception {
        this.acquireCurrent().begin();
    }

    protected void commitTransaction_impl() throws Exception {
        this.acquireCurrent().commit(this.getReportHeuristicsOnCommit());
    }

    protected void rollbackTransaction_impl() throws Exception {
        this.acquireCurrent().rollback();
    }

    protected void markTransactionForRollback_impl() throws Exception {
        this.acquireCurrent().rollback_only();
    }

    protected boolean canBeginTransaction_impl(Object object) {
        return this.getIntStatus(object) == 6;
    }

    protected boolean canCommitTransaction_impl(Object object) {
        return this.getIntStatus(object) == 0;
    }

    protected boolean canRollbackTransaction_impl(Object object) {
        return this.getIntStatus(object) == 0;
    }

    protected boolean canIssueSQLToDatabase_impl(Object object) {
        int n = this.getIntStatus(object);
        return n == 0 || n == 7;
    }

    protected boolean canMergeUnitOfWork_impl(Object object) {
        return this.getIntStatus(object) == 3;
    }

    public boolean isRolledBack_impl(Object object) {
        return this.getIntStatus(object) == 4;
    }

    protected int getIntStatus(Object object) {
        return ((Status)object).value();
    }

    protected String statusToString_impl(Object object) {
        int n = this.getIntStatus(object);
        return codes[n];
    }
}

