/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.workbench.expressions;

import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.tools.workbench.expressions.ExpressionArgumentRepresentation;

public final class QueryableArgumentRepresentation
extends ExpressionArgumentRepresentation {
    private String queryKey;
    private boolean isOuterJoin;
    private boolean isToMany;
    private QueryableArgumentRepresentation baseQueryKey;

    private QueryableArgumentRepresentation() {
    }

    public String displayString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.baseQueryKey != null) {
            stringBuffer.append(this.baseQueryKey.displayString());
            stringBuffer.append(".");
        }
        if (this.isToMany) {
            if (this.isOuterJoin) {
                stringBuffer.append("anyOfAllowingNone(");
            } else {
                stringBuffer.append("anyOf(");
            }
        } else if (this.isOuterJoin) {
            stringBuffer.append("getAllowingNull(");
        } else {
            stringBuffer.append("get(");
        }
        stringBuffer.append("\"");
        stringBuffer.append(this.queryKey);
        stringBuffer.append("\"");
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public boolean isQueryableArgument() {
        return true;
    }

    public String getQueryKeyName() {
        return this.queryKey;
    }

    public boolean isOuterJoin() {
        return this.isOuterJoin;
    }

    public boolean isToMany() {
        return this.isToMany;
    }

    public void setQueryKeyName(String string) {
        this.queryKey = string;
    }

    public void setIsOuterJoin(boolean bl) {
        this.isOuterJoin = bl;
    }

    public void setIsToMany(boolean bl) {
        this.isToMany = bl;
    }

    public Expression convertToRuntime(Expression expression) {
        if (this.baseQueryKey != null) {
            expression = this.baseQueryKey.convertToRuntime(expression);
        }
        expression = this.isToMany ? (this.isOuterJoin ? expression.anyOfAllowingNone(this.queryKey) : expression.anyOf(this.queryKey)) : (this.isOuterJoin ? expression.getAllowingNull(this.queryKey) : expression.get(this.queryKey));
        return expression;
    }

    public static QueryableArgumentRepresentation convertFromRuntime(QueryKeyExpression queryKeyExpression) {
        QueryableArgumentRepresentation queryableArgumentRepresentation = new QueryableArgumentRepresentation();
        queryableArgumentRepresentation.setQueryKeyName(queryKeyExpression.getName());
        queryableArgumentRepresentation.setIsToMany(queryKeyExpression.shouldQueryToManyRelationship());
        queryableArgumentRepresentation.setIsOuterJoin(queryKeyExpression.shouldUseOuterJoin());
        if (queryKeyExpression.getBaseExpression().isQueryKeyExpression()) {
            queryableArgumentRepresentation.baseQueryKey = QueryableArgumentRepresentation.convertFromRuntime((QueryKeyExpression)queryKeyExpression.getBaseExpression());
        }
        return queryableArgumentRepresentation;
    }

    public String convertToRuntimeString(String string) {
        return string + "." + this.displayString();
    }
}

