/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabasePlatform;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.tools.schemaframework.DatabaseObjectDefinition;
import oracle.toplink.tools.schemaframework.FieldDefinition;
import oracle.toplink.tools.schemaframework.ForeignKeyConstraint;

public class TableDefinition
extends DatabaseObjectDefinition {
    protected Vector fields = new Vector();
    protected Vector foreignKeys = new Vector();

    public void addField(String string, Class clazz) {
        this.addField(new FieldDefinition(string, clazz));
    }

    public void addField(String string, Class clazz, int n) {
        this.addField(new FieldDefinition(string, clazz, n));
    }

    public void addField(String string, Class clazz, int n, int n2) {
        this.addField(new FieldDefinition(string, clazz, n, n2));
    }

    public void addField(String string, String string2) {
        this.addField(new FieldDefinition(string, string2));
    }

    public void addField(FieldDefinition fieldDefinition) {
        this.getFields().addElement(fieldDefinition);
    }

    public void addForeignKeyConstraint(String string, String string2, String string3, String string4) {
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint(string, string2, string3, string4);
        this.addForeignKeyConstraint(foreignKeyConstraint);
    }

    public void addForeignKeyConstraint(ForeignKeyConstraint foreignKeyConstraint) {
        this.getForeignKeys().addElement(foreignKeyConstraint);
    }

    public void addIdentityField(String string, Class clazz) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz);
        fieldDefinition.setIsIdentity(true);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addIdentityField(String string, Class clazz, int n) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz, n);
        fieldDefinition.setIsIdentity(true);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addPrimaryKeyField(String string, Class clazz) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public void addPrimaryKeyField(String string, Class clazz, int n) {
        FieldDefinition fieldDefinition = new FieldDefinition(string, clazz, n);
        fieldDefinition.setIsPrimaryKey(true);
        this.addField(fieldDefinition);
    }

    public Writer buildConstraintCreationWriter(Session session, ForeignKeyConstraint foreignKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(" ADD CONSTRAINT ");
            if (!session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(foreignKeyConstraint.getName() + " ");
            }
            foreignKeyConstraint.appendDBString(writer, session);
            if (session.getPlatform().shouldPrintConstraintNameAfter()) {
                writer.write(" CONSTRAINT " + foreignKeyConstraint.getName());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildConstraintDeletionWriter(Session session, ForeignKeyConstraint foreignKeyConstraint, Writer writer) throws ValidationException {
        try {
            writer.write("ALTER TABLE " + this.getFullName());
            writer.write(session.getPlatform().getConstraintDeletionString() + foreignKeyConstraint.getName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildCreationWriter(Session session, Writer writer) throws ValidationException {
        try {
            Object object;
            String string = this.getFullName();
            writer.write("CREATE TABLE " + string + " (");
            Object object2 = this.getFields().elements();
            while (object2.hasMoreElements()) {
                object = (FieldDefinition)object2.nextElement();
                ((FieldDefinition)object).appendDBString(writer, session, this);
                if (!object2.hasMoreElements()) continue;
                writer.write(", ");
            }
            object2 = this.getPrimaryKeyFieldNames();
            if (!((Vector)object2).isEmpty() && session.getPlatform().supportsPrimaryKeyConstraint()) {
                writer.write(", ");
                if (session.getPlatform().requiresNamedPrimaryKeyConstraints()) {
                    writer.write("CONSTRAINT " + string + "_PK ");
                }
                writer.write("PRIMARY KEY (");
                object = ((Vector)object2).elements();
                while (object.hasMoreElements()) {
                    writer.write((String)object.nextElement());
                    if (!object.hasMoreElements()) continue;
                    writer.write(", ");
                }
                writer.write(")");
            }
            writer.write(")");
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(Session session, Writer writer) throws ValidationException {
        try {
            writer.write("DROP TABLE " + this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    protected void buildFieldTypes(Session session) {
        Hashtable hashtable = session.getPlatform().getClassTypes();
        FieldDefinition fieldDefinition = null;
        Vector vector = (Vector)this.getForeignKeys().clone();
        this.setForeignKeys(new Vector());
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            fieldDefinition = (FieldDefinition)enumeration.nextElement();
            if (fieldDefinition.getForeignKeyFieldName() != null) {
                this.addForeignKeyConstraint(this.buildForeignKeyConstraint(fieldDefinition, this, session.getPlatform()));
            }
            if (fieldDefinition.getType() != null) continue;
            fieldDefinition.setType((Class)hashtable.get(fieldDefinition.getTypeName()));
            if (fieldDefinition.getType() == null) continue;
            fieldDefinition.setTypeName(null);
        }
        if (this.getForeignKeys().isEmpty()) {
            this.setForeignKeys(vector);
        }
    }

    protected ForeignKeyConstraint buildForeignKeyConstraint(FieldDefinition fieldDefinition, TableDefinition tableDefinition, DatabasePlatform databasePlatform) {
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        ForeignKeyConstraint foreignKeyConstraint = new ForeignKeyConstraint();
        DatabaseField databaseField = new DatabaseField(fieldDefinition.getForeignKeyFieldName());
        DatabaseField databaseField2 = new DatabaseField(fieldDefinition.getName());
        vector.addElement(databaseField2.getName());
        vector2.addElement(databaseField.getName());
        foreignKeyConstraint.setSourceFields(vector);
        foreignKeyConstraint.setTargetFields(vector2);
        foreignKeyConstraint.setTargetTable(databaseField.getTableName());
        String string = this.buildForeignKeyConstraintName(tableDefinition.getName(), databaseField2.getName(), databasePlatform.getMaxForeignKeyNameSize());
        foreignKeyConstraint.setName(string);
        return foreignKeyConstraint;
    }

    protected String buildForeignKeyConstraintName(String string, String string2, int n) {
        String string3;
        String string4;
        CharSequence charSequence;
        String string5 = string;
        if (string5.indexOf(32) != -1 || string5.indexOf(34) != -1 || string5.indexOf(96) != -1) {
            charSequence = new StringBuffer();
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == ' ' || c == '\"' || c == '`') continue;
                ((StringBuffer)charSequence).append(c);
            }
            string5 = ((StringBuffer)charSequence).toString();
        }
        if (((String)(charSequence = "FK_" + string5 + "_" + string2)).length() > n && ((String)(charSequence = string5 + "_" + string2)).length() > n && ((String)(charSequence = Helper.removeAllButAlphaNumericToFit(string5 + string2, n))).length() > n && ((String)(charSequence = Helper.shortenStringsByRemovingVowelsToFit(string4 = Helper.removeAllButAlphaNumericToFit(string5, 0), string3 = Helper.removeAllButAlphaNumericToFit(string2, 0), n))).length() > n) {
            String string6 = Helper.removeVowels(string3);
            String string7 = Helper.removeVowels(string4);
            charSequence = Helper.truncate(string7, n - string6.length()) + string6;
        }
        return charSequence;
    }

    public Object clone() {
        TableDefinition tableDefinition = (TableDefinition)super.clone();
        if (this.fields != null) {
            tableDefinition.setFields(new Vector(this.fields.size()));
            Enumeration enumeration = this.getFields().elements();
            while (enumeration.hasMoreElements()) {
                FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
                tableDefinition.addField((FieldDefinition)fieldDefinition.clone());
            }
        }
        if (this.foreignKeys != null) {
            tableDefinition.setForeignKeys((Vector)this.foreignKeys.clone());
        }
        return tableDefinition;
    }

    public void createConstraints(Session session, Writer writer) throws TopLinkException {
        if (writer == null) {
            this.createConstraintsOnDatabase(session);
        } else {
            Enumeration enumeration = this.getForeignKeys().elements();
            while (enumeration.hasMoreElements()) {
                ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)enumeration.nextElement();
                this.buildConstraintCreationWriter(session, foreignKeyConstraint, writer).toString();
                try {
                    writer.write(session.getPlatform().getStoredProcedureTerminationToken());
                    writer.write("\n");
                }
                catch (IOException iOException) {
                    throw ValidationException.fileError(iOException);
                }
            }
        }
    }

    public void createConstraintsOnDatabase(Session session) throws TopLinkException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeys().isEmpty()) {
            return;
        }
        Enumeration enumeration = this.getForeignKeys().elements();
        while (enumeration.hasMoreElements()) {
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)enumeration.nextElement();
            session.executeNonSelectingCall(new SQLCall(this.buildConstraintCreationWriter(session, foreignKeyConstraint, new StringWriter()).toString()));
        }
    }

    public String deletionStringFor(DatabaseAccessor databaseAccessor) {
        return "DROP TABLE " + this.getName();
    }

    public void dropConstraints(Session session, Writer writer) throws TopLinkException {
        if (writer == null) {
            this.dropConstraintsOnDatabase(session);
        } else {
            Enumeration enumeration = this.getForeignKeys().elements();
            while (enumeration.hasMoreElements()) {
                ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)enumeration.nextElement();
                this.buildConstraintDeletionWriter(session, foreignKeyConstraint, writer).toString();
                try {
                    writer.write(session.getPlatform().getStoredProcedureTerminationToken());
                    writer.write("\n");
                }
                catch (IOException iOException) {
                    throw ValidationException.fileError(iOException);
                }
            }
        }
    }

    public void dropConstraintsOnDatabase(Session session) throws TopLinkException {
        if (!session.getPlatform().supportsForeignKeyConstraints() || this.getForeignKeys().isEmpty()) {
            return;
        }
        Enumeration enumeration = this.getForeignKeys().elements();
        while (enumeration.hasMoreElements()) {
            ForeignKeyConstraint foreignKeyConstraint = (ForeignKeyConstraint)enumeration.nextElement();
            try {
                session.executeNonSelectingCall(new SQLCall(this.buildConstraintDeletionWriter(session, foreignKeyConstraint, new StringWriter()).toString()));
            }
            catch (DatabaseException databaseException) {}
        }
    }

    public Vector getFields() {
        return this.fields;
    }

    public Vector getForeignKeys() {
        return this.foreignKeys;
    }

    public Vector getPrimaryKeyFieldNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            FieldDefinition fieldDefinition = (FieldDefinition)enumeration.nextElement();
            if (!fieldDefinition.isPrimaryKey()) continue;
            vector.addElement(fieldDefinition.getName());
        }
        return vector;
    }

    public void setFields(Vector vector) {
        this.fields = vector;
    }

    public void setForeignKeys(Vector vector) {
        this.foreignKeys = vector;
    }
}

