/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.expressions.ParameterExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.CallQueryMechanism;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.OneToManyMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.queryframework.UpdateObjectQuery;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Project;
import oracle.toplink.tools.schemaframework.FieldDefinition;
import oracle.toplink.tools.schemaframework.SchemaManager;
import oracle.toplink.tools.schemaframework.StoredProcedureDefinition;

public class StoredProcedureGenerator {
    public SchemaManager schemaManager;
    private int state;
    private Hashtable storedProcedures;
    private Hashtable mappingStoredProcedures;
    private Hashtable tableFields;
    private Hashtable intToTypeConverterHash;
    private Writer writer;
    private String prefix;
    private static final String DEFAULT_PREFIX = "";
    private Hashtable sequenceProcedures;
    private static final int MAX_NAME_SIZE = 30;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$sql$Time;

    public StoredProcedureGenerator(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.sequenceProcedures = new Hashtable();
        this.state = 0;
        this.tableFields = new Hashtable();
        this.storedProcedures = new Hashtable();
        this.mappingStoredProcedures = new Hashtable();
        this.buildIntToTypeConverterHash();
        this.prefix = DEFAULT_PREFIX;
        this.verify();
    }

    protected void buildIntToTypeConverterHash() {
        this.intToTypeConverterHash = new Hashtable();
        this.intToTypeConverterHash.put(new Integer(8), class$java$lang$Double == null ? (class$java$lang$Double = StoredProcedureGenerator.class$("java.lang.Double")) : class$java$lang$Double);
        this.intToTypeConverterHash.put(new Integer(-7), class$java$lang$Boolean == null ? (class$java$lang$Boolean = StoredProcedureGenerator.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        this.intToTypeConverterHash.put(new Integer(-3), array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = StoredProcedureGenerator.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        this.intToTypeConverterHash.put(new Integer(-6), class$java$lang$Short == null ? (class$java$lang$Short = StoredProcedureGenerator.class$("java.lang.Short")) : class$java$lang$Short);
        this.intToTypeConverterHash.put(new Integer(5), class$java$lang$Short == null ? (class$java$lang$Short = StoredProcedureGenerator.class$("java.lang.Short")) : class$java$lang$Short);
        this.intToTypeConverterHash.put(new Integer(4), class$java$lang$Integer == null ? (class$java$lang$Integer = StoredProcedureGenerator.class$("java.lang.Integer")) : class$java$lang$Integer);
        this.intToTypeConverterHash.put(new Integer(2), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = StoredProcedureGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.intToTypeConverterHash.put(new Integer(6), class$java$lang$Float == null ? (class$java$lang$Float = StoredProcedureGenerator.class$("java.lang.Float")) : class$java$lang$Float);
        this.intToTypeConverterHash.put(new Integer(1), class$java$lang$Character == null ? (class$java$lang$Character = StoredProcedureGenerator.class$("java.lang.Character")) : class$java$lang$Character);
        this.intToTypeConverterHash.put(new Integer(12), class$java$lang$String == null ? (class$java$lang$String = StoredProcedureGenerator.class$("java.lang.String")) : class$java$lang$String);
        this.intToTypeConverterHash.put(new Integer(91), class$java$sql$Date == null ? (class$java$sql$Date = StoredProcedureGenerator.class$("java.sql.Date")) : class$java$sql$Date);
        this.intToTypeConverterHash.put(new Integer(93), class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = StoredProcedureGenerator.class$("java.sql.Timestamp")) : class$java$sql$Timestamp);
        this.intToTypeConverterHash.put(new Integer(3), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = StoredProcedureGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.intToTypeConverterHash.put(new Integer(-5), class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = StoredProcedureGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal);
        this.intToTypeConverterHash.put(new Integer(7), class$java$lang$Float == null ? (class$java$lang$Float = StoredProcedureGenerator.class$("java.lang.Float")) : class$java$lang$Float);
        this.intToTypeConverterHash.put(new Integer(-1), class$java$lang$String == null ? (class$java$lang$String = StoredProcedureGenerator.class$("java.lang.String")) : class$java$lang$String);
        this.intToTypeConverterHash.put(new Integer(92), class$java$sql$Time == null ? (class$java$sql$Time = StoredProcedureGenerator.class$("java.sql.Time")) : class$java$sql$Time);
        this.intToTypeConverterHash.put(new Integer(-2), array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = StoredProcedureGenerator.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
        this.intToTypeConverterHash.put(new Integer(-4), array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = StoredProcedureGenerator.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte);
    }

    protected String buildProcedureString(SQLCall sQLCall) {
        String string = sQLCall.getSQLString();
        String string2 = this.getSession().getPlatform().getStoredProcedureParameterPrefix();
        StringWriter stringWriter = new StringWriter();
        int n = 0;
        int n2 = 0;
        int n3 = string.indexOf("?");
        while (n3 != -1) {
            stringWriter.write(string.substring(n, n3));
            n = n3 + 1;
            Object e = sQLCall.getParameters().elementAt(n2);
            if (e instanceof DatabaseField) {
                stringWriter.write(string2);
                stringWriter.write(((DatabaseField)e).getName());
            } else if (e instanceof ParameterExpression) {
                stringWriter.write(string2);
                stringWriter.write(((ParameterExpression)e).getField().getName());
            } else {
                this.getSession().getPlatform().appendParameter(sQLCall, stringWriter, e);
            }
            n3 = string.indexOf("?", n);
            ++n2;
        }
        stringWriter.write(string.substring(n));
        return stringWriter.toString();
    }

    public void generateAmendmentClass(Writer writer, String string, String string2) throws ValidationException {
        String string3 = "/**\n * TopLink generated method. \n * <b>WARNING</b>: This code was generated by an automated tool.\n * Any changes will be lost when the code is re-generated\n */";
        try {
            FieldDefinition fieldDefinition;
            Enumeration enumeration;
            Vector vector;
            StoredProcedureDefinition storedProcedureDefinition;
            writer.write("package ");
            writer.write(string);
            writer.write(";\n\nimport java.util.*;\nimport java.lang.reflect.*;");
            writer.write("\nimport oracle.toplink.queryframework.*;\nimport oracle.toplink.publicinterface.*;\nimport oracle.toplink.mappings.*;\n\n/**\n * ");
            writer.write("This is a TopLink generated class to add stored procedure admendments to a project.  \n * Anychanges to this code will be lost when the class is regenerated \n */\npublic class ");
            writer.write(string2);
            writer.write("{\n");
            Enumeration enumeration2 = this.storedProcedures.keys();
            while (enumeration2.hasMoreElements()) {
                Descriptor descriptor = (Descriptor)enumeration2.nextElement();
                if (descriptor.isDescriptorForInterface() || descriptor.isAggregateDescriptor()) continue;
                writer.write(string3);
                writer.write("\npublic static void amend");
                writer.write(Helper.getShortClassName(descriptor.getJavaClass()));
                writer.write("Descriptor(Descriptor descriptor){\n\t");
                Vector vector2 = (Vector)this.storedProcedures.get(descriptor);
                Hashtable hashtable = (Hashtable)this.mappingStoredProcedures.get(descriptor);
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(0);
                writer.write("\n\t//INSERT QUERY\n");
                writer.write("\tInsertObjectQuery insertQuery = new InsertObjectQuery();\n\tStoredProcedureCall call = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("insertQuery.setCall(call);\n\tdescriptor.getQueryManager().setInsertQuery(insertQuery);\n\t");
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(1);
                if (storedProcedureDefinition != null) {
                    writer.write("\n\t//UPDATE QUERY\n");
                    writer.write("\tUpdateObjectQuery updateQuery = new UpdateObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("updateQuery.setCall(call);\n\tdescriptor.getQueryManager().setUpdateQuery(updateQuery);\n");
                }
                storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(2);
                writer.write("\n\t//DELETE QUERY\n");
                writer.write("\tDeleteObjectQuery deleteQuery = new DeleteObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("deleteQuery.setCall(call);\n\tdescriptor.getQueryManager().setDeleteQuery(deleteQuery);\n");
                if (vector2.size() > 3) {
                    storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(3);
                    writer.write("\n\t//READ OBJECT QUERY\n");
                    writer.write("\tReadObjectQuery readQuery = new ReadObjectQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("readQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadObjectQuery(readQuery);\n");
                }
                if (vector2.size() > 4) {
                    storedProcedureDefinition = (StoredProcedureDefinition)vector2.elementAt(4);
                    writer.write("\n\t//READ ALL QUERY\n");
                    writer.write("\tReadAllQuery readAllQuery = new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                    writer.write("\tcall.setProcedureName(\"");
                    writer.write(storedProcedureDefinition.getName());
                    writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                    vector = storedProcedureDefinition.getArguments();
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        fieldDefinition = (FieldDefinition)enumeration.nextElement();
                        writer.write("call.addNamedArgument(\"");
                        writer.write(fieldDefinition.getName());
                        writer.write("\", \"");
                        writer.write(this.getFieldName(fieldDefinition.getName()));
                        writer.write("\");\n\t");
                    }
                    writer.write("readAllQuery.setCall(call);\n\tdescriptor.getQueryManager().setReadAllQuery(readAllQuery);\n");
                }
                if (hashtable != null) {
                    writer.write("\n\t//MAPPING QUERIES\n");
                    writer.write("\tReadAllQuery mappingQuery; \n");
                    writer.write("\tDeleteAllQuery deleteMappingQuery; \n");
                    Enumeration enumeration3 = hashtable.keys();
                    while (enumeration3.hasMoreElements()) {
                        String string4 = (String)enumeration3.nextElement();
                        storedProcedureDefinition = (StoredProcedureDefinition)((Hashtable)hashtable.get(string4)).get("1MREAD");
                        if (storedProcedureDefinition != null) {
                            writer.write("\n\t//MAPPING READALL QUERY FOR " + string4 + "\n");
                            writer.write("\tmappingQuery= new ReadAllQuery();\n\tcall = new StoredProcedureCall();\n");
                            writer.write("\tcall.setProcedureName(\"");
                            writer.write(storedProcedureDefinition.getName());
                            writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                            vector = storedProcedureDefinition.getArguments();
                            enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                fieldDefinition = (FieldDefinition)enumeration.nextElement();
                                writer.write("call.addNamedArgument(\"");
                                writer.write(fieldDefinition.getName());
                                writer.write("\", \"");
                                writer.write(this.getFieldName(fieldDefinition.getName()));
                                writer.write("\");\n\t");
                            }
                            writer.write("mappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + string4 + "\")).setCustomSelectionQuery(mappingQuery);\n");
                        }
                        if ((storedProcedureDefinition = (StoredProcedureDefinition)((Hashtable)hashtable.get(string4)).get("1MDALL")) == null) continue;
                        writer.write("\n\t//MAPPING DELETEALL QUERY FOR " + string4 + "\n");
                        writer.write("\tdeleteMappingQuery= new DeleteAllQuery();\n\tcall = new StoredProcedureCall();\n");
                        writer.write("\tcall.setProcedureName(\"");
                        writer.write(storedProcedureDefinition.getName());
                        writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                        vector = storedProcedureDefinition.getArguments();
                        enumeration = vector.elements();
                        while (enumeration.hasMoreElements()) {
                            fieldDefinition = (FieldDefinition)enumeration.nextElement();
                            writer.write("call.addNamedArgument(\"");
                            writer.write(fieldDefinition.getName());
                            writer.write("\", \"");
                            writer.write(this.getFieldName(fieldDefinition.getName()));
                            writer.write("\");\n\t");
                        }
                        writer.write("deleteMappingQuery.setCall(call);\n\t((OneToManyMapping)descriptor.getMappingForAttributeName(\"" + string4 + "\")).setCustomDeleteAllQuery(deleteMappingQuery);\n");
                    }
                }
                writer.write("}\n");
            }
            storedProcedureDefinition = (StoredProcedureDefinition)this.sequenceProcedures.get("SELECT");
            if (storedProcedureDefinition != null) {
                writer.write("\n\tValueReadQuery seqSelectQuery = new ValueReadQuery();\n\tcall = new StoredProcedureCall();\n");
                writer.write("\tcall.setProcedureName(\"");
                writer.write(storedProcedureDefinition.getName());
                writer.write("\");\n\tcall.setShouldCacheStatement(true);\n\t");
                vector = storedProcedureDefinition.getArguments();
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    fieldDefinition = (FieldDefinition)enumeration.nextElement();
                    writer.write("call.addNamedArgument(\"");
                    writer.write(fieldDefinition.getName());
                    writer.write("\", \"");
                    writer.write(this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                    writer.write("seqSelectQuery.addArgument(\"" + this.getFieldName(fieldDefinition.getName()));
                    writer.write("\");\n\t");
                }
                writer.write("seqSelectQuery.setCall(call);\n\tproject.getLogin().setSelectSequenceNumberQuery(seqSelectQuery);\n");
            }
            writer.write("}\n");
            writer.write(string3);
            writer.write("\npublic static void amendDescriptors(oracle.toplink.sessions.Project project) throws Exception{");
            writer.write("\n\tamendSequences(project);");
            writer.write("\n\tfor(Iterator enumtr = project.getDescriptors().values().iterator(); enumtr.hasNext();) {");
            writer.write("\n\t\tDescriptor descriptor = (Descriptor)enumtr.next();");
            writer.write("\n\t\tif(!(descriptor.isAggregateDescriptor() || descriptor.isDescriptorForInterface())) {");
            writer.write("\n\t\t\tMethod method = " + string2 + ".class.getMethod(\"amend\"+oracle.toplink.internal.helper.Helper.getShortClassName(descriptor.getJavaClass())+\"Descriptor\", new Class[] {Descriptor.class});");
            writer.write("\n\t\t\tmethod.invoke(null, new Object[] {descriptor});");
            writer.write("\n\t\t}");
            writer.write("\n\t}");
            writer.write("\n}");
            writer.write("\n}\n");
            writer.flush();
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
    }

    protected StoredProcedureDefinition generateDeleteStoredProcedure(Descriptor descriptor) {
        DeleteObjectQuery deleteObjectQuery = new DeleteObjectQuery();
        deleteObjectQuery.setDescriptor(descriptor);
        deleteObjectQuery.setModifyRow(new DatabaseRecord());
        return this.generateObjectStoredProcedure(deleteObjectQuery, descriptor.getPrimaryKeyFields(), "DEL_");
    }

    protected StoredProcedureDefinition generateInsertStoredProcedure(Descriptor descriptor) {
        InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
        insertObjectQuery.setDescriptor(descriptor);
        insertObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateInsertRow(this.getSession()));
        return this.generateObjectStoredProcedure(insertObjectQuery, descriptor.getFields(), "INS_");
    }

    protected Hashtable generateMappingStoredProcedures(Descriptor descriptor) {
        Vector vector = descriptor.getMappings();
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Hashtable<String, StoredProcedureDefinition> hashtable2 = new Hashtable<String, StoredProcedureDefinition>();
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            if (!databaseMapping.isOneToManyMapping()) continue;
            if (!this.getSession().getPlatform().isOracle()) {
                hashtable2.put("1MREAD", this.generateOneToManyMappingReadProcedure((OneToManyMapping)databaseMapping));
            }
            if (databaseMapping.isPrivateOwned()) {
                hashtable2.put("1MDALL", this.generateOneToManyMappingDeleteAllProcedure((OneToManyMapping)databaseMapping));
            }
            hashtable.put(databaseMapping.getAttributeName(), hashtable2);
        }
        return hashtable;
    }

    protected StoredProcedureDefinition generateObjectStoredProcedure(DatabaseQuery databaseQuery, List list, String string) {
        String string2 = Helper.getShortClassName(databaseQuery.getDescriptor().getJavaClass());
        return this.generateStoredProcedure(databaseQuery, list, this.getPrefix() + string + string2);
    }

    protected StoredProcedureDefinition generateOneToManyMappingDeleteAllProcedure(OneToManyMapping oneToManyMapping) {
        Descriptor descriptor = oneToManyMapping.getReferenceDescriptor();
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setDescriptor(descriptor);
        deleteAllQuery.setReferenceClass(descriptor.getJavaClass());
        deleteAllQuery.setSelectionCriteria(oneToManyMapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(oneToManyMapping, deleteAllQuery, oneToManyMapping.getTargetForeignKeyToSourceKeys(), "D_1M_");
    }

    protected StoredProcedureDefinition generateOneToManyMappingProcedures(OneToManyMapping oneToManyMapping, DatabaseQuery databaseQuery, Map map, String string) {
        String string2 = Helper.getShortClassName(oneToManyMapping.getDescriptor().getJavaClass());
        Iterator iterator = oneToManyMapping.getTargetForeignKeyToSourceKeys().values().iterator();
        return this.generateStoredProcedure(databaseQuery, new ArrayList(map.values()), this.getPrefix() + string + string2 + "_" + oneToManyMapping.getAttributeName());
    }

    protected StoredProcedureDefinition generateOneToManyMappingReadProcedure(OneToManyMapping oneToManyMapping) {
        Descriptor descriptor = oneToManyMapping.getReferenceDescriptor();
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(descriptor);
        readAllQuery.setReferenceClass(descriptor.getJavaClass());
        readAllQuery.setSelectionCriteria(oneToManyMapping.getSelectionCriteria());
        return this.generateOneToManyMappingProcedures(oneToManyMapping, readAllQuery, oneToManyMapping.getTargetForeignKeyToSourceKeys(), "R_1M_");
    }

    protected StoredProcedureDefinition generateReadAllStoredProcedure(Descriptor descriptor) {
        ReadAllQuery readAllQuery = new ReadAllQuery();
        readAllQuery.setDescriptor(descriptor);
        readAllQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readAllQuery, descriptor.getPrimaryKeyFields(), "RALL_");
    }

    protected StoredProcedureDefinition generateReadStoredProcedure(Descriptor descriptor) {
        ReadObjectQuery readObjectQuery = new ReadObjectQuery();
        readObjectQuery.setDescriptor(descriptor);
        readObjectQuery.setReferenceClass(descriptor.getJavaClass());
        return this.generateObjectStoredProcedure(readObjectQuery, descriptor.getPrimaryKeyFields(), "READ_");
    }

    protected void generateSequenceStoredProcedures(Project project) {
        DatabaseLogin databaseLogin = (DatabaseLogin)project.getDatasourceLogin();
        if (databaseLogin.shouldUseNativeSequencing()) {
            return;
        }
        if (project.usesSequencing() && !this.getSession().getPlatform().isOracle()) {
            StoredProcedureDefinition storedProcedureDefinition = new StoredProcedureDefinition();
            storedProcedureDefinition.setName(Helper.truncate(project.getName() + "SEQ_SEL", 30));
            storedProcedureDefinition.addArgument("SEQ_NAME", class$java$lang$String == null ? (class$java$lang$String = StoredProcedureGenerator.class$("java.lang.String")) : class$java$lang$String, 100);
            storedProcedureDefinition.addArgument("PREALLOC_SIZE", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = StoredProcedureGenerator.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, 10);
            storedProcedureDefinition.addStatement("UPDATE " + databaseLogin.getSequenceTableName() + " SET " + databaseLogin.getSequenceCounterFieldName() + " = " + databaseLogin.getSequenceCounterFieldName() + " + " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "PREALLOC_SIZE WHERE " + databaseLogin.getSequenceNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            storedProcedureDefinition.addStatement("SELECT " + databaseLogin.getSequenceCounterFieldName() + " FROM " + databaseLogin.getSequenceTableName() + " WHERE " + databaseLogin.getSequenceNameFieldName() + " = " + this.getSession().getPlatform().getStoredProcedureParameterPrefix() + "SEQ_NAME");
            this.sequenceProcedures.put("SELECT", storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
        }
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery databaseQuery, List list, String string) {
        return this.generateStoredProcedure(databaseQuery, list, new DatabaseRecord(), string);
    }

    protected StoredProcedureDefinition generateStoredProcedure(DatabaseQuery databaseQuery, List list, DatabaseRow databaseRow, String string) {
        Cloneable cloneable;
        StoredProcedureDefinition storedProcedureDefinition = new StoredProcedureDefinition();
        Vector<String> vector = new Vector<String>();
        databaseQuery.checkPrepare(this.getSession(), databaseRow, true);
        Vector vector2 = ((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCalls();
        if (vector2.isEmpty() && ((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCall() != null) {
            vector2.addElement(((CallQueryMechanism)databaseQuery.getQueryMechanism()).getCall());
        }
        Enumeration enumeration = vector2.elements();
        StringWriter stringWriter = new StringWriter();
        while (enumeration.hasMoreElements()) {
            cloneable = (SQLCall)enumeration.nextElement();
            vector.addElement(this.buildProcedureString((SQLCall)cloneable));
        }
        storedProcedureDefinition.setStatements(vector);
        Hashtable hashtable = new Hashtable();
        List list2 = list;
        for (int i = 0; i < list2.size(); ++i) {
            cloneable = (DatabaseField)list2.get(i);
            hashtable.put(((DatabaseField)cloneable).getName(), this.schemaManager.getColumnInfo(null, null, ((DatabaseField)cloneable).getTableName(), ((DatabaseField)cloneable).getName()).firstElement());
        }
        storedProcedureDefinition.setName(Helper.truncate(string, 30));
        Enumeration enumeration2 = hashtable.keys();
        String string2 = this.getSession().getPlatform().isOracle() ? this.getSession().getPlatform().getStoredProcedureParameterPrefix() : DEFAULT_PREFIX;
        while (enumeration2.hasMoreElements()) {
            DatabaseRow databaseRow2 = (DatabaseRow)hashtable.get(enumeration2.nextElement());
            Number number = (Number)databaseRow2.get("DATA_TYPE");
            Class clazz = this.getFieldType(number);
            String string3 = (String)databaseRow2.get("TYPE_NAME");
            if (clazz != null || string3 == null || string3.length() == 0) {
                storedProcedureDefinition.addArgument(string2 + (String)databaseRow2.get("COLUMN_NAME"), clazz, ((Number)databaseRow2.get("COLUMN_SIZE")).intValue());
                continue;
            }
            storedProcedureDefinition.addArgument(string2 + (String)databaseRow2.get("COLUMN_NAME"), string3);
        }
        return storedProcedureDefinition;
    }

    public void generateStoredProcedures() {
        Map map = this.getSession().getProject().getDescriptors();
        Iterator iterator = map.keySet().iterator();
        this.generateSequenceStoredProcedures(this.getSession().getProject());
        while (iterator.hasNext()) {
            Descriptor descriptor = (Descriptor)map.get(iterator.next());
            if (descriptor.isDescriptorForInterface() || descriptor.isAggregateDescriptor()) continue;
            StoredProcedureDefinition storedProcedureDefinition = this.generateInsertStoredProcedure(descriptor);
            Vector<StoredProcedureDefinition> vector = new Vector<StoredProcedureDefinition>();
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            storedProcedureDefinition = this.generateUpdateStoredProcedure(descriptor);
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            storedProcedureDefinition = this.generateDeleteStoredProcedure(descriptor);
            vector.addElement(storedProcedureDefinition);
            this.writeDefinition(storedProcedureDefinition);
            if (!this.getSession().getPlatform().isOracle()) {
                storedProcedureDefinition = this.generateReadStoredProcedure(descriptor);
                vector.addElement(storedProcedureDefinition);
                this.writeDefinition(storedProcedureDefinition);
                storedProcedureDefinition = this.generateReadAllStoredProcedure(descriptor);
                vector.addElement(storedProcedureDefinition);
                this.writeDefinition(storedProcedureDefinition);
            }
            Hashtable hashtable = this.generateMappingStoredProcedures(descriptor);
            Enumeration enumeration = hashtable.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable2 = (Hashtable)enumeration.nextElement();
                storedProcedureDefinition = (StoredProcedureDefinition)hashtable2.get("1MREAD");
                if (storedProcedureDefinition != null) {
                    this.writeDefinition(storedProcedureDefinition);
                }
                if ((storedProcedureDefinition = (StoredProcedureDefinition)hashtable2.get("1MDALL")) == null) continue;
                this.writeDefinition(storedProcedureDefinition);
            }
            this.storedProcedures.put(descriptor, vector);
            if (hashtable.isEmpty()) continue;
            this.mappingStoredProcedures.put(descriptor, hashtable);
        }
    }

    public void generateStoredProcedures(Writer writer) {
        this.writer = writer;
        this.schemaManager.outputDDLToWriter(this.getWriter());
        this.generateStoredProcedures();
        try {
            this.getWriter().flush();
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            iOException.printStackTrace();
        }
    }

    protected StoredProcedureDefinition generateUpdateStoredProcedure(Descriptor descriptor) {
        UpdateObjectQuery updateObjectQuery = new UpdateObjectQuery();
        updateObjectQuery.setDescriptor(descriptor);
        updateObjectQuery.setModifyRow(descriptor.getObjectBuilder().buildTemplateUpdateRow(this.getSession()));
        return this.generateObjectStoredProcedure(updateObjectQuery, descriptor.getFields(), "UPD_");
    }

    protected String getFieldName(String string) {
        if (this.getSession().getPlatform().isOracle()) {
            return string.substring(this.getSession().getPlatform().getStoredProcedureParameterPrefix().length());
        }
        return string;
    }

    protected Class getFieldType(Object object) {
        Integer n = new Integer(((Number)object).intValue());
        return (Class)this.intToTypeConverterHash.get(n);
    }

    public String getPrefix() {
        return this.prefix;
    }

    public Session getSession() {
        return this.schemaManager.getSession();
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    protected void verify() throws ValidationException {
        if (this.getSession().getProject().usesOptimisticLocking()) {
            throw ValidationException.optimisticLockingNotSupportedWithStoredProcedureGeneration();
        }
    }

    public void writeDefinition(StoredProcedureDefinition storedProcedureDefinition) {
        this.schemaManager.replaceObject(storedProcedureDefinition);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

