/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.SQLCall;
import oracle.toplink.sequencing.NativeSequence;
import oracle.toplink.tools.schemaframework.SequenceDefinition;

public class OracleSequenceDefinition
extends SequenceDefinition {
    protected int increment;
    protected int start;

    public OracleSequenceDefinition(String string, int n) {
        super(string);
        this.setStartAndIncrement(n);
    }

    public OracleSequenceDefinition(String string) {
        this(string, 1);
    }

    public OracleSequenceDefinition(NativeSequence nativeSequence) {
        this(nativeSequence.getName(), nativeSequence.getPreallocationSize());
    }

    public Writer buildCreationWriter(Session session, Writer writer) {
        try {
            writer.write("CREATE SEQUENCE ");
            writer.write(this.getFullName());
            if (this.getIncrement() != 1) {
                writer.write(" INCREMENT BY " + this.getIncrement());
            }
            if (this.getStart() != 1) {
                writer.write(" START WITH " + this.getStart());
            }
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(Session session, Writer writer) {
        try {
            writer.write("DROP SEQUENCE ");
            writer.write(this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildAlterIncrementWriter(Session session, Writer writer) {
        try {
            writer.write("ALTER SEQUENCE ");
            writer.write(this.getFullName());
            writer.write(" INCREMENT BY " + this.getIncrement());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public boolean checkIfExist(Session session) throws DatabaseException {
        try {
            session.executeSelectingCall(new SQLCall("SELECT " + this.getName() + ".NEXTVAL FROM DUAL"));
        }
        catch (DatabaseException databaseException) {
            return false;
        }
        return true;
    }

    public int getIncrement() {
        return this.increment;
    }

    public void setIncrement(int n) {
        this.increment = n;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int n) {
        this.start = n;
    }

    public void setStartAndIncrement(int n) {
        this.setStart(n);
        this.setIncrement(n);
    }

    public boolean isAlterSupported() {
        return true;
    }

    public void alterOnDatabase(Session session) throws TopLinkException {
        try {
            session.executeSelectingCall(new SQLCall("SELECT " + this.getName() + ".CURRVAL FROM DUAL"));
            session.executeNonSelectingCall(new SQLCall(this.buildAlterIncrementWriter(session, new StringWriter()).toString()));
        }
        catch (DatabaseException databaseException) {
            this.dropFromDatabase(session);
            this.createOnDatabase(session);
        }
    }

    public void alterIncrement(Session session, Writer writer) throws ValidationException {
        if (writer == null) {
            this.alterOnDatabase(session);
        } else {
            this.buildAlterIncrementWriter(session, writer);
        }
    }
}

