/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.CRC32;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import oracle.toplink.exceptions.EJBJarXMLException;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.tools.ejbjar.EjbJar;
import oracle.toplink.tools.ejbjar.EjbJarConstants;
import oracle.toplink.tools.ejbjar.EjbJarXMLDocument;
import oracle.toplink.tools.ejbjar.XMLParser;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLManager
implements EjbJarConstants {
    public static final String EJB_JAR_FILE_NAME = "ejb-jar.xml";
    public static String EJB_JAR_2_0_DTD_FILE_NAME = "ejb-jar_2_0.dtd";
    public static String EJB_JAR_1_1_DTD_FILE_NAME = "ejb-jar_1_1.dtd";
    public static String EJB_JAR_DTD_LOCAL_DIR_PATH = "/dtd/";
    public static String EJB_JAR_DTD_2_0_LOCAL_RESOURCE = EJB_JAR_DTD_LOCAL_DIR_PATH + EJB_JAR_2_0_DTD_FILE_NAME;
    public static final String EJB_JAR_DOC_NAME = "ejb-jar";
    public static final String EJB_JAR_2_0_DOCTYPE_DESC = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN";
    public static final String EJB_JAR_1_1_DOCTYPE_DESC = "-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN";
    public static final String EJB_JAR_2_0_DTD_URL = "http://java.sun.com/dtd/ejb-jar_2_0.dtd";
    public static final String EJB_JAR_1_1_DTD_URL = "http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd";
    public static final String EJB_JAR_XML_ENTRY_NAME = "META-INF/ejb-jar.xml";
    public static final String XML_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String XML_SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_SCHEMA_LOCATION = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";

    public static Document readEjbXmlFile(EjbJarXMLDocument ejbJarXMLDocument, String string) throws FileNotFoundException, NullPointerException, EJBJarXMLException {
        return XMLManager.readEjbXmlFile(ejbJarXMLDocument, string, -2);
    }

    public static Document readEjbXmlFile(EjbJarXMLDocument ejbJarXMLDocument, String string, int n) throws FileNotFoundException, NullPointerException, EJBJarXMLException {
        Document document = null;
        document = string.endsWith(".jar") ? XMLManager.readEjbXmlFileFromJarFile(string, n) : XMLManager.readEjbXmlFileFromDirectory(string, n);
        ejbJarXMLDocument.setDocument(document);
        ejbJarXMLDocument.setXmlFileLocation(string);
        return document;
    }

    private static Document readEjbXmlFileFromDirectory(String string, int n) throws FileNotFoundException, NullPointerException, EJBJarXMLException {
        File file = null;
        InputSource inputSource = null;
        if (!new File(string).exists()) {
            Object[] objectArray = new Object[]{string};
            throw new FileNotFoundException(ExceptionLocalization.buildMessage("directory_not_exist", objectArray));
        }
        String string2 = EJB_JAR_FILE_NAME;
        if (string != null) {
            string2 = string.endsWith(".xml") ? string : string + System.getProperty("file.separator") + string2;
        }
        FileInputStream fileInputStream = null;
        file = new File(string2);
        Document document = null;
        try {
            fileInputStream = new FileInputStream(file);
            inputSource = new InputSource(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));
            document = XMLManager.readEjbXmlFileFromInputSource(inputSource, n);
            fileInputStream.close();
        }
        catch (IOException iOException) {
            throw EJBJarXMLException.errorReadingDescriptor(iOException);
        }
        return document;
    }

    private static Document readEjbXmlFileFromJarFile(String string, int n) throws FileNotFoundException, NullPointerException, EJBJarXMLException {
        File file = null;
        InputSource inputSource = null;
        Document document = null;
        Object[] objectArray = new Object[]{string};
        if (!new File(string).exists()) {
            throw new FileNotFoundException(ExceptionLocalization.buildMessage("jar_not_exist", objectArray));
        }
        file = new File(string);
        InputStream inputStream = null;
        try {
            JarEntry jarEntry;
            JarFile jarFile;
            if (file.toString().endsWith(".jar")) {
                jarFile = new JarFile(file);
                jarEntry = XMLManager.getEjbJarXmlEntry(jarFile);
                if (null == jarEntry) {
                    Object[] objectArray2 = new Object[]{string, EJB_JAR_XML_ENTRY_NAME};
                    throw new FileNotFoundException(ExceptionLocalization.buildMessage("may_not_contain_xml_entry", objectArray2));
                }
            } else {
                throw new FileNotFoundException(ExceptionLocalization.buildMessage("not_jar_file", objectArray));
            }
            inputStream = jarFile.getInputStream(jarEntry);
            inputSource = new InputSource(new InputStreamReader(inputStream, "UTF-8"));
            document = XMLManager.readEjbXmlFileFromInputSource(inputSource, n);
            inputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw EJBJarXMLException.errorReadingDescriptor(iOException);
        }
        return document;
    }

    private static Document readEjbXmlFileFromInputSource(InputSource inputSource, int n) throws FileNotFoundException, EJBJarXMLException {
        Document document;
        try {
            document = XMLParser.parseXML(inputSource, n);
            inputSource.getCharacterStream().close();
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw EJBJarXMLException.errorReadingDescriptor(xMLPlatformException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw fileNotFoundException;
        }
        catch (IOException iOException) {
            throw EJBJarXMLException.errorReadingDescriptor(iOException);
        }
        return document;
    }

    public static void writeEjbXmlFile(EjbJarXMLDocument ejbJarXMLDocument, String string, boolean bl) throws FileNotFoundException, IOException {
        XMLManager.writeEjbXmlFileFromEjbJar(ejbJarXMLDocument.getEjbJar(), string, bl);
        ejbJarXMLDocument.setXmlFileLocation(string);
    }

    public static void writeEjbXmlFileFromEjbJar(EjbJar ejbJar, String string, boolean bl) throws FileNotFoundException, IOException {
        File file = null;
        if (string == null || string.trim().length() == 0) {
            Object[] objectArray = new Object[]{string};
            throw new FileNotFoundException(ExceptionLocalization.buildMessage("file_not_exist", objectArray));
        }
        file = new File(string);
        StringBuffer stringBuffer = XMLManager.getXML(ejbJar, bl);
        if (file.toString().endsWith(".jar")) {
            if (file.exists()) {
                Object object;
                JarEntry jarEntry;
                Object object2;
                File file2 = File.createTempFile("ejbjar", ".jar");
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(file);
                }
                catch (ZipException zipException) {
                    object2 = new JarOutputStream((OutputStream)new FileOutputStream(file), new Manifest());
                    ((JarOutputStream)object2).putNextEntry(new JarEntry(EJB_JAR_XML_ENTRY_NAME));
                    ((ZipOutputStream)object2).close();
                    jarFile = new JarFile(file);
                }
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file2));
                object2 = jarFile.entries();
                while (object2.hasMoreElements()) {
                    jarEntry = (JarEntry)object2.nextElement();
                    if (jarEntry.getName().equalsIgnoreCase(EJB_JAR_XML_ENTRY_NAME)) continue;
                    if (!jarEntry.isDirectory()) {
                        object = jarFile.getInputStream(jarEntry);
                        InputStream inputStream = object;
                        byte[] byArray = new byte[(int)jarEntry.getSize()];
                        inputStream.read(byArray);
                        CRC32 cRC32 = new CRC32();
                        cRC32.update(byArray);
                        jarEntry.setCrc(cRC32.getValue());
                        jarEntry.setCompressedSize(byArray.length);
                        jarEntry.setMethod(0);
                        jarOutputStream.putNextEntry(jarEntry);
                        jarOutputStream.write(byArray, 0, byArray.length);
                        jarOutputStream.flush();
                    } else {
                        jarOutputStream.putNextEntry(jarEntry);
                    }
                    jarOutputStream.closeEntry();
                }
                object2 = stringBuffer.toString().getBytes();
                jarEntry = new JarEntry(EJB_JAR_XML_ENTRY_NAME);
                jarEntry.setSize(((Object)object2).length);
                jarEntry.setCompressedSize(((Object)object2).length);
                object = new CRC32();
                object.update((byte[])object2);
                jarEntry.setCrc(((CRC32)object).getValue());
                jarEntry.setMethod(0);
                jarOutputStream.putNextEntry(jarEntry);
                jarOutputStream.write((byte[])object2, 0, ((Object)object2).length);
                jarOutputStream.closeEntry();
                jarOutputStream.close();
                jarFile.close();
                boolean bl2 = true;
                System.gc();
                try {
                    bl2 = file.delete();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                if (bl2) {
                    boolean bl3 = file2.renameTo(file);
                } else {
                    XMLManager.move(file2, file, true);
                }
            } else {
                JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(file));
                jarOutputStream.putNextEntry(new JarEntry(EJB_JAR_XML_ENTRY_NAME));
                byte[] byArray = stringBuffer.toString().getBytes();
                jarOutputStream.write(byArray, 0, byArray.length);
                jarOutputStream.closeEntry();
                jarOutputStream.close();
            }
        } else if (file.toString().endsWith(".xml")) {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            DataOutputStream dataOutputStream = new DataOutputStream(fileOutputStream);
            dataOutputStream.write(stringBuffer.toString().getBytes("UTF-8"));
            dataOutputStream.close();
        }
    }

    public static JarEntry getEjbJarXmlEntry(JarFile jarFile) {
        JarEntry jarEntry = (JarEntry)jarFile.getEntry(EJB_JAR_XML_ENTRY_NAME);
        if (null == jarEntry) {
            jarEntry = (JarEntry)jarFile.getEntry(EJB_JAR_XML_ENTRY_NAME.toLowerCase());
        }
        return jarEntry;
    }

    public static StringBuffer getXML(EjbJar ejbJar, boolean bl) {
        String string = System.getProperty("line.separator");
        Document document = bl ? XMLManager.documentForEjb_2_0(ejbJar) : XMLManager.documentForEjb_1_1(ejbJar);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (!ejbJar.usesXmlSchema()) {
            DocumentType documentType = document.getDoctype();
            stringBuffer.append(string + "<!DOCTYPE " + documentType.getName());
            if (documentType.getPublicId() != null) {
                stringBuffer.append(" PUBLIC \"" + documentType.getPublicId() + "\" ");
            } else {
                stringBuffer.append(" SYSTEM ");
            }
            stringBuffer.append("\"" + documentType.getSystemId() + "\">");
            stringBuffer.append(string);
        }
        stringBuffer.append(XMLManager.generateXML(document.getDocumentElement(), "     ").toString());
        return stringBuffer;
    }

    public static void createDirectoryStructure(File file) {
        File file2 = file.getParentFile();
        if (!file2.exists()) {
            XMLManager.createDirectoryStructure(file2);
        }
        file2.mkdir();
    }

    public static void createEjbJarFile(String string) throws IOException {
        File file = XMLManager.createFile(string);
        JarOutputStream jarOutputStream = new JarOutputStream((OutputStream)new FileOutputStream(file), new Manifest());
        jarOutputStream.putNextEntry(new JarEntry(EJB_JAR_XML_ENTRY_NAME));
        jarOutputStream.close();
    }

    public static void createEjbJarXmlFile(String string) throws IOException {
        XMLManager.createFile(string);
    }

    public static File createFile(String string) throws IOException {
        File file = new File(string);
        XMLManager.createDirectoryStructure(file);
        file.createNewFile();
        return file;
    }

    private static Document documentForEjb_1_1(EjbJar ejbJar) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xMLPlatform.createDocumentWithPublicIdentifier(EJB_JAR_DOC_NAME, EJB_JAR_1_1_DOCTYPE_DESC, EJB_JAR_1_1_DTD_URL);
        ejbJar.toElement(document);
        return document;
    }

    private static Document documentForEjb_2_0(EjbJar ejbJar) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        Document document = xMLPlatform.createDocumentWithPublicIdentifier(EJB_JAR_DOC_NAME, EJB_JAR_2_0_DOCTYPE_DESC, EJB_JAR_2_0_DTD_URL);
        ejbJar.toElement(document);
        return document;
    }

    public static StringBuffer generateXML(Node node, String string) {
        String string2 = System.getProperty("line.separator");
        StringBuffer stringBuffer = new StringBuffer();
        switch (node.getNodeType()) {
            case 9: {
                stringBuffer.append("<xml version=\"1.0\">\n");
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(XMLManager.generateXML(nodeList.item(i), "").toString());
                }
                break;
            }
            case 1: {
                String string3 = node.getNodeName();
                stringBuffer.append(string2 + string + "<" + string3);
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                for (int i = 0; i < n; ++i) {
                    Node node2 = namedNodeMap.item(i);
                    stringBuffer.append(" " + node2.getNodeName() + "=\"" + node2.getNodeValue() + "\"");
                }
                NodeList nodeList = node.getChildNodes();
                if (nodeList != null && nodeList.getLength() > 0) {
                    stringBuffer.append(">");
                    int n2 = nodeList.getLength();
                    for (int i = 0; i < n2; ++i) {
                        stringBuffer.append(XMLManager.generateXML(nodeList.item(i), string + "     ").toString());
                    }
                    if (nodeList.getLength() == 1 && (nodeList.item(0).getNodeType() == 3 || nodeList.item(0).getNodeType() == 4)) {
                        stringBuffer.append("</" + string3 + ">");
                        break;
                    }
                    stringBuffer.append(string2 + string + "</" + string3 + ">");
                    break;
                }
                stringBuffer.append("></" + string3 + ">");
                break;
            }
            case 3: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 4: {
                stringBuffer.append("<![CDATA[");
                stringBuffer.append(node.getNodeValue());
                stringBuffer.append("]]>");
                break;
            }
            case 7: {
                stringBuffer.append("<?" + node.getNodeName() + " " + node.getNodeValue() + "?>");
                break;
            }
            case 5: {
                stringBuffer.append("&" + node.getNodeName() + ";");
            }
        }
        return stringBuffer;
    }

    public static void move(File file, File file2, boolean bl) throws IOException {
        if (file.equals(file2)) {
            return;
        }
        if (file.isDirectory()) {
            throw new IOException(ExceptionLocalization.buildMessage("can_not_move_directory", null));
        }
        if (file2.isFile() && bl) {
            XMLManager.move(file, file2);
        } else {
            if (file2.isFile() && !bl) {
                Object[] objectArray = new Object[]{file2};
                throw new IOException(ExceptionLocalization.buildMessage("file_exists", objectArray));
            }
            if (file2.isDirectory()) {
                XMLManager.move(file, new File(file2, file.getName()));
            } else if (file2.getPath().endsWith(System.getProperty("file.separator"))) {
                if (!file2.mkdirs()) {
                    Object[] objectArray = new Object[]{file2};
                    throw new IOException(ExceptionLocalization.buildMessage("can_not_create_file", objectArray));
                }
                XMLManager.move(file, new File(file2, file.getName()));
            } else {
                String string = file2.getParent();
                if (string != null && !new File(string).mkdirs()) {
                    Object[] objectArray = new Object[]{string};
                    throw new IOException(ExceptionLocalization.buildMessage("can_not_create_directory", objectArray));
                }
                XMLManager.move(file, file2);
            }
        }
    }

    private static void move(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        XMLManager.copy(fileInputStream, fileOutputStream);
        fileOutputStream.close();
        fileInputStream.close();
        file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        InputStream inputStream2 = inputStream;
        synchronized (inputStream2) {
            OutputStream outputStream2 = outputStream;
            synchronized (outputStream2) {
                int n;
                byte[] byArray = new byte[256];
                while ((n = inputStream.read(byArray)) != -1) {
                    outputStream.write(byArray, 0, n);
                }
            }
        }
    }
}

