/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.tools.ejbjar.AssemblyDescriptor;
import oracle.toplink.tools.ejbjar.Description;
import oracle.toplink.tools.ejbjar.EnterpriseObject;
import oracle.toplink.tools.ejbjar.Entity;
import oracle.toplink.tools.ejbjar.MessageDriven;
import oracle.toplink.tools.ejbjar.Relationship;
import oracle.toplink.tools.ejbjar.Relationships;
import oracle.toplink.tools.ejbjar.Session;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EjbJar
extends Description {
    String displayName;
    String smallIcon;
    String largeIcon;
    Vector enterpriseObjects = new Vector();
    Relationships relationships;
    AssemblyDescriptor assemblyDescriptor;
    String ejbClientJar;
    String xmlns;
    String xsi;
    String schemaLocation;
    String version;

    public void addEnterpriseObjects(Vector vector) {
        if (this.enterpriseObjects == null) {
            this.enterpriseObjects = new Vector();
        }
        this.enterpriseObjects.addAll(vector);
    }

    public void addEntity(Entity entity) {
        if (this.enterpriseObjects == null) {
            this.enterpriseObjects = new Vector();
        }
        this.enterpriseObjects.add(entity);
    }

    public void addRelationship(Relationship relationship) {
        if (this.relationships == null) {
            this.relationships = new Relationships();
        }
        this.relationships.addRelationship(relationship);
    }

    public AssemblyDescriptor getAssemblyDescriptor() {
        return this.assemblyDescriptor;
    }

    public String getEjbClientJar() {
        return this.ejbClientJar;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Vector getEnterpriseObjects() {
        return this.enterpriseObjects;
    }

    public Vector getEntities() {
        Vector<EnterpriseObject> vector = new Vector<EnterpriseObject>();
        Iterator iterator = this.enterpriseObjects.iterator();
        while (iterator.hasNext()) {
            EnterpriseObject enterpriseObject = (EnterpriseObject)iterator.next();
            if (!enterpriseObject.isEntity()) continue;
            vector.add(enterpriseObject);
        }
        return vector;
    }

    public Entity getEntityForEjbClass(String string) {
        Iterator iterator = this.getEntities().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.getEjbClass().equals(string)) continue;
            return entity;
        }
        return null;
    }

    public Entity getEntityForEjbName(String string) {
        Iterator iterator = this.getEntities().iterator();
        while (iterator.hasNext()) {
            Entity entity = (Entity)iterator.next();
            if (!entity.getEjbName().equals(string)) continue;
            return entity;
        }
        return null;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    public Vector getMessageDrivens() {
        Vector<EnterpriseObject> vector = new Vector<EnterpriseObject>();
        EnterpriseObject enterpriseObject = null;
        Iterator iterator = this.enterpriseObjects.iterator();
        while (iterator.hasNext()) {
            enterpriseObject = (EnterpriseObject)iterator.next();
            if (!enterpriseObject.isMessageDriven()) continue;
            vector.add(enterpriseObject);
        }
        return vector;
    }

    public Relationships getRelationships() {
        return this.relationships;
    }

    public Vector getSessions() {
        Vector<EnterpriseObject> vector = new Vector<EnterpriseObject>();
        Iterator iterator = this.enterpriseObjects.iterator();
        while (iterator.hasNext()) {
            EnterpriseObject enterpriseObject = (EnterpriseObject)iterator.next();
            if (!enterpriseObject.isSession()) continue;
            vector.add(enterpriseObject);
        }
        return vector;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    public static EjbJar loadFromDocument(Document document) {
        EjbJar ejbJar = new EjbJar();
        ejbJar.loadFromElement(document.getDocumentElement());
        return ejbJar;
    }

    public void removeEntity(Entity entity) {
        this.enterpriseObjects.remove(entity);
    }

    public void removeRelationships(Collection collection) {
        if (this.relationships == null) {
            return;
        }
        this.relationships.removeRelationships(collection);
        if (this.relationships.getRelationships().size() == 0) {
            this.relationships = null;
        }
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    public void setEjbClientJar(String string) {
        this.ejbClientJar = string;
    }

    public void setEnterpriseObjects(Vector vector) {
        this.enterpriseObjects = vector;
    }

    public void setLargeIcon(String string) {
        this.largeIcon = string;
    }

    public void setRelationships(Relationships relationships) {
        this.relationships = relationships;
    }

    public Relationship getRelasionshipOfCmr(String string, String string2) {
        Relationship relationship = null;
        if (this.relationships != null) {
            Iterator iterator = this.relationships.getRelationships().iterator();
            while (iterator.hasNext()) {
                Relationship relationship2 = (Relationship)iterator.next();
                if (!relationship2.isRelationshipForCmr(string, string2)) continue;
                relationship = relationship2;
            }
        }
        return relationship;
    }

    public void setSmallIcon(String string) {
        this.smallIcon = string;
    }

    public void loadFromElement(Element element) {
        super.loadFromElement(element);
        this.displayName = this.optionalStringFromElement(element, "display-name");
        this.smallIcon = this.optionalStringFromElement(element, "small-icon");
        this.largeIcon = this.optionalStringFromElement(element, "large-icon");
        this.xmlns = this.optionalAttributeFromElement(element, "xmlns");
        this.xsi = this.optionalAttributeFromElement(element, "xmlns:xsi");
        this.schemaLocation = this.optionalAttributeFromElement(element, "xsi:schemaLocation");
        this.version = this.optionalAttributeFromElement(element, "version");
        Vector vector = this.optionalObjectsFromElement(element, "entity", new Entity());
        if (vector != null) {
            this.addEnterpriseObjects(vector);
        }
        if ((vector = this.optionalObjectsFromElement(element, "message-driven", new MessageDriven())) != null) {
            this.addEnterpriseObjects(vector);
        }
        if ((vector = this.optionalObjectsFromElement(element, "session", new Session())) != null) {
            this.addEnterpriseObjects(vector);
        }
        this.relationships = (Relationships)this.optionalObjectFromElement(element, "relationships", new Relationships());
        this.assemblyDescriptor = (AssemblyDescriptor)this.optionalObjectFromElement(element, "assembly-descriptor", new AssemblyDescriptor());
        this.ejbClientJar = this.optionalStringFromElement(element, "ejb-client-jar");
    }

    public Element toElement(Document document) {
        Element element = document.getDocumentElement();
        this.inheritedFields(document, element);
        this.optionallyAddText(document, element, "display-name", this.displayName);
        this.optionallyAddText(document, element, "small-icon", this.smallIcon);
        this.optionallyAddText(document, element, "large-icon", this.largeIcon);
        this.optionallyAddAttribute(element, "xmlns", this.xmlns);
        this.optionallyAddAttribute(element, "xmlns:xsi", this.xsi);
        this.optionallyAddAttribute(element, "xsi:schemaLocation", this.schemaLocation);
        this.optionallyAddAttribute(element, "version", this.version);
        Element element2 = document.createElement("enterprise-beans");
        element.appendChild(element2);
        this.optionallyAddCollection(document, element2, this.getEntities());
        this.optionallyAddCollection(document, element2, this.getSessions());
        this.optionallyAddCollection(document, element2, this.getMessageDrivens());
        if (this.relationships != null) {
            element.appendChild(this.relationships.toElement(document));
        }
        if (this.assemblyDescriptor != null) {
            element.appendChild(this.assemblyDescriptor.toElement(document));
        }
        this.optionallyAddText(document, element, "ejb-client-jar", this.ejbClientJar);
        return element;
    }

    public boolean usesXmlSchema() {
        return this.xmlns != null;
    }

    public void setXmlns(String string) {
        this.xmlns = string;
    }

    public void setXsi(String string) {
        this.xsi = string;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public void setVersion(String string) {
        this.version = string;
    }

    public void initializeEjb21Schema() {
        this.xmlns = "http://java.sun.com/xml/ns/j2ee";
        this.xsi = "http://www.w3.org/2001/XMLSchema-instance";
        this.schemaLocation = "http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd";
        this.version = "2.1";
    }
}

