/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejbjar;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.tools.ejbjar.EjbJarConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class DomObject
implements EjbJarConstants {
    protected void addCollection(Document document, Element element, Vector vector) {
        if (vector == null) {
            this.missingObjectValueError("child of " + element.getTagName());
        }
        this.optionallyAddCollection(document, element, vector);
    }

    protected void addText(Document document, Element element, String string, String string2) {
        if (string2 == null) {
            this.missingObjectValueError(string);
        } else {
            this.optionallyAddText(document, element, string, string2);
        }
    }

    protected void addTextCollection(Document document, Element element, String string, Vector vector) {
        if (vector == null) {
            this.missingObjectValueError("child of " + element.getTagName());
        }
        this.optionallyAddTextCollection(document, element, string, vector);
    }

    protected Element createElement(Document document, String string, String string2) {
        Element element = document.createElement(string);
        if (string2 != null) {
            element.appendChild(document.createTextNode(string2));
        }
        return element;
    }

    protected void emptyCollectionError(String string) {
        throw new Error("Collection of " + string + " must be non-empty");
    }

    protected Element getFirstElementByTagName(String string, Element element) {
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeName() == null || !node.getNodeName().equals(string)) continue;
            return (Element)node;
        }
        return null;
    }

    protected List getChildrenElementsByTagName(String string, Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node = element.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!node.getNodeName().equals(string)) continue;
            arrayList.add((Element)node);
        }
        return arrayList;
    }

    protected String getTextValue(Element element) {
        Node node;
        if (element == null) {
            return null;
        }
        NodeList nodeList = element.getChildNodes();
        if (nodeList.getLength() != 0 && (node = nodeList.item(0)).getNodeType() == 3) {
            return ((Text)node).getData().trim();
        }
        return "";
    }

    protected void instantiationError(Exception exception) {
        throw new Error("Could not instantiate " + this + " - " + exception);
    }

    public abstract void loadFromElement(Element var1);

    protected void missingElementError(String string) {
        throw new Error("Missing " + string + " element");
    }

    protected void missingObjectValueError(String string) {
        throw new Error("Missing object value for " + string + " element");
    }

    protected DomObject objectFromElement(Element element, String string, DomObject domObject) {
        Vector vector = this.objectsFromElement(element, string, domObject);
        return (DomObject)vector.elementAt(0);
    }

    protected Vector objectsFromElement(Element element, String string, DomObject domObject) {
        Vector vector = this.optionalObjectsFromElement(element, string, domObject);
        if (vector == null) {
            this.missingElementError(string);
        }
        return vector;
    }

    protected void optionallyAddCollection(Document document, Element element, Vector vector) {
        if (element != null && vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Element element2 = ((DomObject)vector.elementAt(i)).toElement(document);
                element.appendChild(element2);
            }
        }
    }

    protected void optionallyAddText(Document document, Element element, String string, String string2) {
        if (element != null && string2 != null) {
            Element element2 = this.createElement(document, string, string2);
            element.appendChild(element2);
        }
    }

    protected void optionallyAddAttribute(Element element, String string, String string2) {
        if (element != null && string2 != null) {
            element.setAttribute(string, string2);
        }
    }

    protected void optionallyAddTextCollection(Document document, Element element, String string, Vector vector) {
        if (element != null && vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Element element2 = this.createElement(document, string, (String)vector.elementAt(i));
                element.appendChild(element2);
            }
        }
    }

    protected DomObject optionalObjectFromElement(Element element, String string, DomObject domObject) {
        return this.optionalObjectFromElement(element, string, domObject, false);
    }

    protected DomObject optionalObjectFromElement(Element element, String string, DomObject domObject, boolean bl) {
        Vector vector = this.optionalObjectsFromElement(element, string, domObject, bl);
        return vector == null || vector.isEmpty() ? null : (DomObject)vector.elementAt(0);
    }

    protected Vector optionalObjectsFromElement(Element element, String string, DomObject domObject) {
        return this.optionalObjectsFromElement(element, string, domObject, false);
    }

    protected Vector optionalObjectsFromElement(Element element, String string, DomObject domObject, boolean bl) {
        Object object;
        List<Element> list = new ArrayList();
        if (bl) {
            list = this.getChildrenElementsByTagName(string, element);
        } else {
            object = element.getElementsByTagName(string);
            if (object == null) {
                return null;
            }
            int n = object.getLength();
            for (int i = 0; i < n; ++i) {
                list.add((Element)object.item(i));
            }
        }
        object = new Vector();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Element element2 = (Element)iterator.next();
            DomObject domObject2 = null;
            try {
                domObject2 = (DomObject)PrivilegedAccessController.newInstanceFromClass(domObject.getClass());
            }
            catch (InstantiationException instantiationException) {
                this.instantiationError(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                this.instantiationError(illegalAccessException);
            }
            domObject2.loadFromElement(element2);
            ((Vector)object).add(domObject2);
        }
        return object;
    }

    protected String optionalAttributeFromElement(Element element, String string) {
        String string2 = element.getAttribute(string);
        return string2 == null || string2 == "" ? null : string2;
    }

    protected String optionalStringFromElement(Element element, String string) {
        Element element2 = this.getFirstElementByTagName(string, element);
        return element2 == null ? null : this.getTextValue(element2);
    }

    protected Vector optionalStringsFromElement(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        if (nodeList == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            vector.add(this.getTextValue((Element)nodeList.item(i)));
        }
        return vector;
    }

    protected String stringFromElement(Element element, String string) {
        String string2 = this.optionalStringFromElement(element, string);
        if (string2 == null) {
            this.missingElementError(string);
        }
        return string2;
    }

    protected Vector stringsFromElement(Element element, String string) {
        Vector vector = this.optionalStringsFromElement(element, string);
        if (vector == null) {
            this.missingElementError(string);
        }
        return vector;
    }

    public abstract Element toElement(Document var1);

    public static void trace(String string) {
        System.out.println(string);
    }
}

