/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.tools.ejb11;

import java.util.Hashtable;
import java.util.Properties;
import oracle.toplink.ejb.DeploymentException;
import oracle.toplink.tools.ejb11.BeanInformationDefinition;
import oracle.toplink.tools.ejb11.FinderDefinition;
import oracle.toplink.tools.ejb11.ProjectDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import weblogic.apache.xerces.dom.DocumentImpl;
import weblogic.apache.xerces.dom.DocumentTypeImpl;

public class CMPBeanDefinition
extends BeanInformationDefinition {
    private String ejbName;
    private Element beanElement;
    private ProjectDefinition project;
    private Hashtable finderList;
    private Element beanPropertiesElement;
    private Properties beanProperties;
    public static final String SYNCHRONOUS = "Synchronous";
    public static final String ASYNCHRONOUS = "Asynchronous";
    public static final String DO_NOT_CHECK_CACHE = "DoNotCheckCache";
    public static final String CHECK_CACHE_BY_EXACT_PRIMARY_KEY = "CheckCacheByExactPrimaryKey";
    public static final String CHECK_CACHE_BY_PRIMARY_KEY = "CheckCacheByPrimaryKey";
    public static final String CHECK_CACHE_THEN_DATABASE = "CheckCacheThenDatabase";
    public static final String CHECK_CACHE_ONLY = "CheckCacheOnly";
    public static final String CONFORM_RESULTS_IN_UNIT_OF_WORK = "ConformResultsInUnitOfWork";
    public static final String TI_TRANSACTION_NONE = "None";
    public static final String TI_TRANSACTION_READ_UNCOMMITTED = "ReadUncommitted";
    public static final String TI_TRANSACTION_READ_COMMITTED = "ReadCommitted";
    public static final String TI_TRANSACTION_REPEATABLE_READ = "RepeatableRead";
    public static final String TI_TRANSACTION_SERIALIZABLE = "Serializable";

    public CMPBeanDefinition() {
        this.setFinderList(new Hashtable());
        this.beanProperties = new Properties();
    }

    public CMPBeanDefinition(String string) {
        this();
        this.ejbName = string;
    }

    public CMPBeanDefinition(Element element) {
        this();
        this.setBeanElement(element);
        this.initializeBeanPropertiesElement();
    }

    public void addFinder(FinderDefinition finderDefinition) {
        if (finderDefinition != null && finderDefinition.getMethodNameWithParamTypes() != null) {
            this.getFinderList().put(finderDefinition.getMethodNameWithParamTypes(), finderDefinition);
        }
    }

    private Element getBeanElement() {
        return this.beanElement;
    }

    public Properties getBeanProperties() {
        return this.beanProperties;
    }

    private Element getBeanPropertiesElement() {
        return this.beanPropertiesElement;
    }

    public String getBeanProperty(String string) {
        return this.getBeanProperties().getProperty(string);
    }

    public String getCacheUsage() {
        return this.getBeanProperty("cache-usage");
    }

    public String getCustomizationClassName() {
        return this.getProject().getCustomizationClassName();
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public FinderDefinition getFinder(String string) {
        return (FinderDefinition)this.getFinderList().get(string);
    }

    public Hashtable getFinderList() {
        return this.finderList;
    }

    public String getJdbcLevel() {
        return this.getProject().getJdbcLevel();
    }

    public String getLogDestination() {
        return this.getProject().getLogDestination();
    }

    public boolean getLogMessages() {
        return this.getProject().getLogMessages();
    }

    public ProjectDefinition getProject() {
        return this.project;
    }

    public String getProjectClassName() {
        return this.getProject().getProjectClassName();
    }

    public String getProjectDataSource() {
        return this.getProject().getProjectDataSource();
    }

    public String getProjectFileName() {
        return this.getProject().getProjectFileName();
    }

    public String getProjectIdentifier() {
        return this.getProject().getProjectIdentifier();
    }

    public String getProjectPlatform() {
        return this.getProject().getProjectPlatform();
    }

    public String getProjectPoolName() {
        return this.getProject().getProjectPoolName();
    }

    public String getProjectReadOnlyDataSource() {
        return this.getProject().getProjectReadOnlyDataSource();
    }

    public Boolean getReadOnly() {
        String string = this.getBeanProperty("read-only");
        return string == null ? Boolean.FALSE : new Boolean(string);
    }

    public Boolean getRefreshCache() {
        String string = this.getBeanProperty("refresh-cache");
        return string == null ? null : new Boolean(string);
    }

    public String getTransactionIsolation() {
        return this.getProject().getTransactionIsolation();
    }

    public String getUpdatePropagation() {
        return this.getProject().getUpdatePropagation();
    }

    public void initializeBeanPropertiesElement() {
        Element element = this.getFirstElementByTagName("bean-attributes", this.getBeanElement());
        this.setBeanPropertiesElement(element);
    }

    public static int intValueFromCacheUsageString(String string) throws DeploymentException {
        if (string.equalsIgnoreCase(DO_NOT_CHECK_CACHE)) {
            return 0;
        }
        if (string.equalsIgnoreCase(CHECK_CACHE_BY_EXACT_PRIMARY_KEY)) {
            return 1;
        }
        if (string.equalsIgnoreCase(CHECK_CACHE_BY_PRIMARY_KEY)) {
            return 2;
        }
        if (string.equalsIgnoreCase(CHECK_CACHE_THEN_DATABASE)) {
            return 3;
        }
        if (string.equalsIgnoreCase(CHECK_CACHE_ONLY)) {
            return 4;
        }
        if (string.equalsIgnoreCase(CONFORM_RESULTS_IN_UNIT_OF_WORK)) {
            return 5;
        }
        DeploymentException.invalidCacheUsageString(string);
        return 0;
    }

    public static int intValueFromTxnIsolationString(String string) throws DeploymentException {
        if (string.equalsIgnoreCase(TI_TRANSACTION_NONE)) {
            return 0;
        }
        if (string.equalsIgnoreCase(TI_TRANSACTION_READ_UNCOMMITTED)) {
            return 1;
        }
        if (string.equalsIgnoreCase(TI_TRANSACTION_READ_COMMITTED)) {
            return 2;
        }
        if (string.equalsIgnoreCase(TI_TRANSACTION_REPEATABLE_READ)) {
            return 4;
        }
        if (string.equalsIgnoreCase(TI_TRANSACTION_SERIALIZABLE)) {
            return 8;
        }
        DeploymentException.invalidTxnIsolation(string);
        return 0;
    }

    public static int intValueFromUpdatePropagationString(String string) throws DeploymentException {
        return 0;
    }

    private void loadBeanAttributes() {
        this.loadBeanProperty("read-only");
        this.loadBeanProperty("cache-usage");
        this.loadBeanProperty("refresh-cache");
    }

    protected void loadBeanProperty(String string) {
        Element element = this.getFirstElementByTagName(string, this.getBeanPropertiesElement());
        String string2 = this.getTextValue(element);
        if (string != null && string2 != null) {
            this.getBeanProperties().put(string, string2);
        }
    }

    private void loadFinder(Element element) {
        FinderDefinition finderDefinition = new FinderDefinition(element);
        finderDefinition.loadProperties();
        this.addFinder(finderDefinition);
    }

    private void loadFinders() {
        Element element;
        if (this.getBeanElement() == null) {
            this.setFinderList(null);
        }
        if ((element = this.getFirstElementByTagName("finder-list", this.beanElement)) == null) {
            this.setFinderList(null);
            return;
        }
        NodeList nodeList = element.getElementsByTagName("finder");
        if (nodeList.getLength() != 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                this.loadFinder((Element)node);
            }
        }
    }

    private void loadProject() {
        if (this.getBeanElement() == null) {
            this.project = null;
        }
        Element element = this.getFirstElementByTagName("project", this.getBeanElement());
        ProjectDefinition projectDefinition = new ProjectDefinition(element);
        projectDefinition.loadProperties();
        this.project = projectDefinition;
    }

    public void loadProperties() {
        this.loadProject();
        if (this.getBeanPropertiesElement() != null) {
            this.loadBeanAttributes();
        }
        this.loadFinders();
    }

    public void setBeanElement(Element element) {
        this.beanElement = element;
        this.initializeBeanPropertiesElement();
    }

    private void setBeanProperties(Properties properties) {
        this.beanProperties = properties;
    }

    public void setBeanPropertiesElement(Element element) {
        this.beanPropertiesElement = element;
    }

    protected void setBeanProperty(String string, String string2) {
        if (string != null && string2 != null) {
            this.getBeanProperties().put(string, string2);
        }
    }

    public void setCacheUsage(String string) {
        this.setBeanProperty("cache-usage", string);
    }

    public void setEJBName(String string) {
        this.ejbName = string;
    }

    public void setFinderList(Hashtable hashtable) {
        this.finderList = hashtable;
    }

    public void setProject(ProjectDefinition projectDefinition) {
        this.project = projectDefinition;
    }

    public void setReadOnly(Boolean bl) {
        this.setBeanProperty("read-only", bl.toString());
    }

    public void setRefreshCache(Boolean bl) {
        this.setBeanProperty("refresh-cache", bl.toString());
    }

    public Document storeProperties() {
        Node node;
        Object object;
        Element element;
        DocumentTypeImpl documentTypeImpl = new DocumentTypeImpl(null, "", BeanInformationDefinition.TOPLINK_DOCTYPE_DESC, BeanInformationDefinition.TOPLINK_DOCTYPE_URL);
        DocumentImpl documentImpl = new DocumentImpl((DocumentType)documentTypeImpl);
        Element element2 = documentImpl.createElement("toplink-cmp-bean");
        documentImpl.appendChild(element2);
        Element element3 = this.getProject().storeProperties((Document)documentImpl);
        element2.appendChild(element3);
        if (!this.getBeanProperties().isEmpty()) {
            element = documentImpl.createElement("bean-attributes");
            if (this.getBeanProperty("read-only") != null) {
                object = documentImpl.createElement("read-only");
                node = documentImpl.createTextNode(this.getBeanProperty("read-only"));
                object.appendChild(node);
                element.appendChild((Node)object);
            }
            if (this.getBeanProperty("cache-usage") != null) {
                object = documentImpl.createElement("cache-usage");
                node = documentImpl.createTextNode(this.getBeanProperty("cache-usage"));
                object.appendChild(node);
                element.appendChild((Node)object);
            }
            if (this.getBeanProperty("refresh-cache") != null) {
                object = documentImpl.createElement("refresh-cache");
                node = documentImpl.createTextNode(this.getBeanProperty("refresh-cache"));
                object.appendChild(node);
                element.appendChild((Node)object);
            }
            element2.appendChild(element);
        }
        element = documentImpl.createElement("finder-list");
        element2.appendChild(element);
        object = this.getFinderList().elements();
        while (object.hasMoreElements()) {
            node = ((FinderDefinition)object.nextElement()).storeProperties((Document)documentImpl);
            element.appendChild(node);
        }
        return documentImpl;
    }
}

