/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.threetier;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.sequencing.SequencingCallback;
import oracle.toplink.internal.sequencing.SequencingServer;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.internal.sessions.ExclusiveIsolatedClientSession;
import oracle.toplink.internal.sessions.FinalizedClientSession;
import oracle.toplink.internal.sessions.IsolatedClientSession;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.sessions.Login;
import oracle.toplink.sessions.Project;
import oracle.toplink.threetier.ClientSession;
import oracle.toplink.threetier.ConnectionPolicy;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ExternalConnectionPool;
import oracle.toplink.threetier.ReadConnectionPool;
import oracle.toplink.threetier.Server;

public class ServerSession
extends DatabaseSessionImpl
implements Server {
    protected ConnectionPool readConnectionPool;
    protected Map connectionPools = new HashMap(10);
    protected ConnectionPolicy defaultConnectionPolicy;
    protected int maxNumberOfNonPooledConnections;
    protected int numberOfNonPooledConnectionsUsed;

    public ServerSession() {
    }

    public ServerSession(Login login) {
        this(new Project(login));
    }

    public ServerSession(Login login, int n, int n2) {
        this(new Project(login), n, n2);
    }

    public ServerSession(Login login, ConnectionPolicy connectionPolicy) {
        this(new Project(login), connectionPolicy);
    }

    public ServerSession(Project project) {
        this(project, 5, 10);
    }

    public ServerSession(Project project, int n, int n2) {
        this(project, new ConnectionPolicy("default"));
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, int n, int n2, Login login) {
        this(project, new ConnectionPolicy("default"), login);
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, int n, int n2, Login login, Login login2) {
        this(project, new ConnectionPolicy("default"), login, login2);
        ConnectionPool connectionPool = null;
        connectionPool = project.getDatasourceLogin().shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("default", project.getDatasourceLogin(), this) : new ConnectionPool("default", project.getDatasourceLogin(), n, n2, this);
        this.connectionPools.put("default", connectionPool);
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy) {
        super(project);
        this.defaultConnectionPolicy = connectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        this.setReadConnectionPool(project.getDatasourceLogin());
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy, Login login) {
        super(project);
        this.defaultConnectionPolicy = connectionPolicy;
        this.maxNumberOfNonPooledConnections = 50;
        this.numberOfNonPooledConnectionsUsed = 0;
        Login login2 = login != null ? login : project.getDatasourceLogin();
        this.setReadConnectionPool(login2);
    }

    public ServerSession(Project project, ConnectionPolicy connectionPolicy, Login login, Login login2) {
        this(project, connectionPolicy, login);
        if (login2 != null) {
            this.getSequencingControl().setShouldUseSeparateConnection(true);
            this.getSequencingControl().setLogin(login2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acquireClientConnection(ClientSession clientSession) throws DatabaseException, ConcurrencyException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool connectionPool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            Accessor accessor = connectionPool.acquireConnection();
            clientSession.setWriteConnection(accessor);
            this.getEventManager().postAcquireConnection(accessor);
        } else {
            ServerSession serverSession = this;
            synchronized (serverSession) {
                while (this.getNumberOfNonPooledConnectionsUsed() >= this.getMaxNumberOfNonPooledConnections()) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        throw ConcurrencyException.waitFailureOnServerSession(interruptedException);
                    }
                }
                this.setNumberOfNonPooledConnectionsUsed(this.getNumberOfNonPooledConnectionsUsed() + 1);
                clientSession.setWriteConnection(clientSession.getLogin().buildAccessor());
                clientSession.connect();
            }
        }
        if (clientSession.getConnectionPolicy().shouldUseExclusiveConnection()) {
            this.getEventManager().postAcquireExclusiveConnection(clientSession, clientSession.getWriteConnection());
        }
    }

    public ClientSession acquireClientSession() throws DatabaseException {
        return this.acquireClientSession(this.getDefaultConnectionPolicy());
    }

    public ClientSession acquireClientSession(String string) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(string));
    }

    public ClientSession acquireClientSession(Login login) throws DatabaseException {
        return this.acquireClientSession(new ConnectionPolicy(login));
    }

    public ClientSession acquireClientSession(ConnectionPolicy connectionPolicy) throws DatabaseException, ValidationException {
        Object object;
        if (!this.isConnected()) {
            throw ValidationException.loginBeforeAllocatingClientSessions();
        }
        this.log(2, "connection", "client_acquired");
        if (!connectionPolicy.isPooled() && connectionPolicy.getLogin() == null) {
            connectionPolicy.setPoolName(this.getDefaultConnectionPolicy().getPoolName());
            connectionPolicy.setLogin(this.getDefaultConnectionPolicy().getLogin());
        }
        if (connectionPolicy.isPooled()) {
            object = (ConnectionPool)this.getConnectionPools().get(connectionPolicy.getPoolName());
            if (object == null) {
                throw ValidationException.poolNameDoesNotExist(connectionPolicy.getPoolName());
            }
            connectionPolicy.setLogin(((ConnectionPool)object).getLogin());
        }
        object = null;
        if (this.getProject().hasIsolatedClasses()) {
            object = connectionPolicy.shouldUseExclusiveConnection() ? new ExclusiveIsolatedClientSession(this, connectionPolicy) : new IsolatedClientSession(this, connectionPolicy);
        } else {
            if (connectionPolicy.shouldUseExclusiveConnection()) {
                throw ValidationException.clientSessionCanNotUseExclusiveConnection();
            }
            object = this.isFinalizersEnabled() ? new FinalizedClientSession(this, connectionPolicy) : new ClientSession(this, connectionPolicy);
        }
        if (!connectionPolicy.isLazy()) {
            this.acquireClientConnection((ClientSession)object);
        }
        return object;
    }

    public oracle.toplink.sessions.Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWork acquireUnitOfWork() {
        return this.acquireClientSession().acquireUnitOfWork();
    }

    public void addConnectionPool(String string, Login login, int n, int n2) throws ValidationException {
        if (n > n2) {
            throw ValidationException.maxSizeLessThanMinSize();
        }
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool connectionPool = null;
        connectionPool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool(string, login, this) : new ConnectionPool(string, login, n, n2, this);
        this.addConnectionPool(connectionPool);
    }

    public void addConnectionPool(ConnectionPool connectionPool) {
        connectionPool.setOwner(this);
        this.getConnectionPools().put(connectionPool.getName(), connectionPool);
    }

    public void afterTransaction(boolean bl, boolean bl2, Accessor accessor) {
        SequencingCallback sequencingCallback = this.getSequencingHome().getSequencingCallback();
        if (sequencingCallback != null) {
            sequencingCallback.afterTransaction(accessor, bl);
        }
    }

    public Accessor allocateReadConnection() {
        Accessor accessor = this.getReadConnectionPool().acquireConnection();
        this.getEventManager().postAcquireConnection(accessor);
        return accessor;
    }

    public void connect() {
        this.updateStandardConnectionPools();
        this.getReadConnectionPool().startUp();
        this.setAccessor(this.allocateReadConnection());
        this.releaseReadConnection(this.getAccessor());
        Iterator iterator = this.getConnectionPools().values().iterator();
        while (iterator.hasNext()) {
            ((ConnectionPool)iterator.next()).startUp();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public Object executeCall(Call call, DatabaseRow databaseRow, DatabaseQuery databaseQuery) throws DatabaseException {
        Object object;
        block20: {
            boolean bl;
            RuntimeException runtimeException;
            block17: {
                runtimeException = null;
                object = null;
                bl = false;
                if (databaseQuery.getAccessor() == null) {
                    databaseQuery.setAccessor(this.allocateReadConnection());
                    bl = true;
                }
                object = databaseQuery.getAccessor().executeCall(call, databaseRow, this);
                Object var9_7 = null;
                if (!call.isFinished()) break block17;
                try {
                    if (bl) {
                        this.releaseReadConnection(databaseQuery.getAccessor());
                        databaseQuery.setAccessor(null);
                    }
                }
                catch (RuntimeException runtimeException2) {
                    if (runtimeException != null) break block17;
                    throw runtimeException2;
                }
            }
            if (runtimeException != null) {
                throw runtimeException;
            }
            break block20;
            {
                catch (RuntimeException runtimeException3) {
                    block18: {
                        runtimeException = runtimeException3;
                        Object var9_8 = null;
                        if (call.isFinished()) {
                            try {
                                if (bl) {
                                    this.releaseReadConnection(databaseQuery.getAccessor());
                                    databaseQuery.setAccessor(null);
                                }
                            }
                            catch (RuntimeException runtimeException4) {
                                if (runtimeException != null) break block18;
                                throw runtimeException4;
                            }
                        }
                    }
                    if (runtimeException != null) {
                        throw runtimeException;
                    }
                }
            }
            catch (Throwable throwable) {
                block19: {
                    Object var9_9 = null;
                    if (call.isFinished()) {
                        try {
                            if (bl) {
                                this.releaseReadConnection(databaseQuery.getAccessor());
                                databaseQuery.setAccessor(null);
                            }
                        }
                        catch (RuntimeException runtimeException5) {
                            if (runtimeException != null) break block19;
                            throw runtimeException5;
                        }
                    }
                }
                if (runtimeException != null) {
                    throw runtimeException;
                }
                throw throwable;
            }
        }
        return object;
    }

    public ConnectionPool getConnectionPool(String string) {
        return (ConnectionPool)this.getConnectionPools().get(string);
    }

    public Map getConnectionPools() {
        return this.connectionPools;
    }

    public ConnectionPolicy getDefaultConnectionPolicy() {
        if (this.defaultConnectionPolicy == null) {
            this.defaultConnectionPolicy = new ConnectionPolicy("default");
        }
        return this.defaultConnectionPolicy;
    }

    public ConnectionPool getDefaultConnectionPool() {
        return this.getConnectionPool("default");
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        if (databaseQuery.isObjectLevelModifyQuery()) {
            throw QueryException.invalidQueryOnServerSession(databaseQuery);
        }
        return this;
    }

    public int getMaxNumberOfNonPooledConnections() {
        return this.maxNumberOfNonPooledConnections;
    }

    public int getNumberOfNonPooledConnectionsUsed() {
        return this.numberOfNonPooledConnectionsUsed;
    }

    public int getNumberOfReadConnections() {
        return this.getReadConnectionPool().getMaxNumberOfConnections();
    }

    public ConnectionPool getReadConnectionPool() {
        return this.readConnectionPool;
    }

    public boolean isConnected() {
        if (this.getReadConnectionPool() == null) {
            return false;
        }
        return this.getReadConnectionPool().isConnected();
    }

    public boolean isServerSession() {
        return true;
    }

    public void logout() {
        super.logout();
        this.getReadConnectionPool().shutDown();
        Iterator iterator = this.getConnectionPools().values().iterator();
        while (iterator.hasNext()) {
            ((ConnectionPool)iterator.next()).shutDown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseClientSession(ClientSession clientSession) throws DatabaseException {
        if (clientSession.getConnectionPolicy().isPooled()) {
            ConnectionPool connectionPool = (ConnectionPool)this.getConnectionPools().get(clientSession.getConnectionPolicy().getPoolName());
            this.getEventManager().preReleaseConnection(clientSession.getWriteConnection());
            connectionPool.releaseConnection(clientSession.getWriteConnection());
            clientSession.setWriteConnection(null);
        } else {
            ServerSession serverSession = this;
            synchronized (serverSession) {
                clientSession.disconnect();
                clientSession.setWriteConnection(null);
                this.setNumberOfNonPooledConnectionsUsed(this.getNumberOfNonPooledConnectionsUsed() - 1);
                this.notify();
            }
        }
        if (clientSession.getConnectionPolicy().shouldUseExclusiveConnection()) {
            this.getEventManager().preReleaseExclusiveConnection(clientSession, clientSession.getWriteConnection());
        }
    }

    public void releaseReadConnection(Accessor accessor) {
        this.getEventManager().preReleaseConnection(accessor);
        this.getReadConnectionPool().releaseConnection(accessor);
    }

    public void setConnectionPools(Map map) {
        this.connectionPools = map;
    }

    public void setDefaultConnectionPolicy(ConnectionPolicy connectionPolicy) {
        this.defaultConnectionPolicy = connectionPolicy;
    }

    public void setDefaultConnectionPool() {
        this.addConnectionPool("default", this.getDatasourceLogin(), 5, 10);
    }

    public void setMaxNumberOfNonPooledConnections(int n) {
        this.maxNumberOfNonPooledConnections = n;
    }

    public void setNumberOfNonPooledConnectionsUsed(int n) {
        this.numberOfNonPooledConnectionsUsed = n;
    }

    public void setNumberOfReadConnections(int n) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.getReadConnectionPool().setMaxNumberOfConnections(n);
        this.getReadConnectionPool().setMinNumberOfConnections(n);
    }

    public void setReadConnectionPool(ConnectionPool connectionPool) {
        if (this.isConnected()) {
            throw ValidationException.cannotSetReadPoolSizeAfterLogin();
        }
        this.readConnectionPool = connectionPool;
        this.readConnectionPool.setOwner(this);
    }

    public void setReadConnectionPool(Login login) throws ValidationException {
        if (this.isConnected()) {
            throw ValidationException.poolsMustBeConfiguredBeforeLogin();
        }
        ConnectionPool connectionPool = null;
        connectionPool = login.shouldUseExternalConnectionPooling() ? new ExternalConnectionPool("read", login, this) : new ConnectionPool("read", login, 2, 2, this);
        this.readConnectionPool = connectionPool;
    }

    protected void updateStandardConnectionPools() {
        if (this.getDefaultConnectionPool() != null && this.getDefaultConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setDefaultConnectionPool();
        }
        if (this.getReadConnectionPool() != null && this.getReadConnectionPool().isThereConflictBetweenLoginAndType()) {
            this.setReadConnectionPool(this.getReadConnectionPool().getLogin());
        }
    }

    public void useExclusiveReadConnectionPool(int n, int n2) {
        this.setReadConnectionPool(new ConnectionPool("read", this.getDatasourceLogin(), n, n2, this));
    }

    public void useExternalReadConnectionPool() {
        this.setReadConnectionPool(new ExternalConnectionPool("read", this.getDatasourceLogin(), this));
    }

    public void useReadConnectionPool(int n, int n2) {
        this.setReadConnectionPool(new ReadConnectionPool("read", this.getDatasourceLogin(), n, n2, this));
    }

    public void validateQuery(DatabaseQuery databaseQuery) {
        if (databaseQuery.isObjectLevelReadQuery() && (databaseQuery.getDescriptor().isIsolated() || ((ObjectLevelReadQuery)databaseQuery).shouldUseExclusiveConnection())) {
            throw QueryException.isolatedQueryExecutedOnServerSession();
        }
    }

    public SequencingServer getSequencingServer() {
        return this.getSequencingHome().getSequencingServer();
    }
}

