/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.services;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.linkedlist.ExposedNodeLinkedList;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.HardCacheWeakIdentityMap;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseLogin;
import oracle.toplink.threetier.ConnectionPool;
import oracle.toplink.threetier.ServerSession;
import oracle.toplink.tools.profiler.PerformanceProfiler;

public class RuntimeServices {
    protected Session session;

    public RuntimeServices() {
    }

    public RuntimeServices(Session session) {
        this.session = session;
    }

    protected Session getSession() {
        return this.session;
    }

    public void setShouldLogMessages(boolean bl) {
        if (bl && this.getSession().getLogLevel(null) > 2) {
            this.getSession().setLogLevel(2);
        } else if (!bl) {
            this.getSession().setLogLevel(8);
        }
    }

    public boolean getShouldLogMessages() {
        return this.getSession().shouldLogMessages();
    }

    public void setShouldLogDebug(boolean bl) {
        if (bl) {
            this.getSession().setLogLevel(1);
        }
    }

    public boolean getShouldLogDebug() {
        return this.getSession().getLogLevel(null) <= 1;
    }

    public void setShouldLogExceptions(boolean bl) {
        if (bl && this.getSession().getLogLevel(null) > 6) {
            this.getSession().setLogLevel(6);
        }
    }

    public boolean getShouldLogExceptions() {
        return this.getSession().getLogLevel(null) <= 6;
    }

    public void setShouldLogExceptionStackTrace(boolean bl) {
    }

    public boolean getShouldLogExceptionStackTrace() {
        return this.getSession().getLogLevel(null) <= 2;
    }

    public void setShouldPrintDate(boolean bl) {
    }

    public boolean getShouldPrintDate() {
        return true;
    }

    public void setShouldPrintSession(boolean bl) {
    }

    public boolean getShouldPrintSession() {
        return true;
    }

    public void setShouldPrintThread(boolean bl) {
    }

    public boolean getShouldPrintThread() {
        return this.getSession().getLogLevel(null) <= 3;
    }

    public void setShouldPrintConnection(boolean bl) {
    }

    public boolean getShouldPrintConnection() {
        return true;
    }

    public void setShouldProfilePerformance(boolean bl) {
        if (bl && this.getSession().getProfiler() == null) {
            this.getSession().setProfiler(new PerformanceProfiler());
        } else if (!bl) {
            this.getSession().setProfiler(null);
        }
    }

    public boolean getShouldProfilePerformance() {
        return this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass());
    }

    public void setShouldLogPerformanceProfiler(boolean bl) {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            ((PerformanceProfiler)this.getSession().getProfiler()).setShouldLogProfile(bl);
        }
    }

    public boolean getShouldLogPerformanceProfiler() {
        if (this.getSession().getProfiler() != null && ClassConstants.PerformanceProfiler_Class.isAssignableFrom(this.getSession().getProfiler().getClass())) {
            return ((PerformanceProfiler)this.getSession().getProfiler()).shouldLogProfile();
        }
        return false;
    }

    public void setShouldCacheAllStatements(boolean bl) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setShouldCacheAllStatements(bl);
    }

    public boolean getShouldCacheAllStatements() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return false;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).shouldCacheAllStatements();
    }

    public void setStatementCacheSize(int n) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setStatementCacheSize(n);
    }

    public int getStatementCacheSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getStatementCacheSize();
    }

    public void setSequencePreallocationSize(int n) {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return;
        }
        ((DatabaseLogin)this.getSession().getDatasourceLogin()).setSequencePreallocationSize(n);
    }

    public int getSequencePreallocationSize() {
        if (!(this.getSession().getDatasourceLogin() instanceof DatabaseLogin)) {
            return 0;
        }
        return ((DatabaseLogin)this.getSession().getDatasourceLogin()).getSequencePreallocationSize();
    }

    public void updatePoolSize(String string, int n, int n2) {
        ConnectionPool connectionPool;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(string)) != null) {
            connectionPool.setMaxNumberOfConnections(n);
            connectionPool.setMinNumberOfConnections(n2);
        }
    }

    public List getAvailableConnectionPools() {
        Vector vector = null;
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Map map = ((ServerSession)this.getSession()).getConnectionPools();
            vector = new Vector(map.size());
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        } else {
            vector = new Vector();
        }
        return vector;
    }

    public List getSizeForPool(String string) {
        ConnectionPool connectionPool;
        Vector<Integer> vector = new Vector<Integer>(2);
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass()) && (connectionPool = ((ServerSession)this.getSession()).getConnectionPool(string)) != null) {
            vector.add(new Integer(connectionPool.getMaxNumberOfConnections()));
            vector.add(new Integer(connectionPool.getMinNumberOfConnections()));
        }
        return vector;
    }

    public void addNewConnectionPool(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6, String string7) throws ClassNotFoundException {
        this.addNewConnectionPool(string, n, n2, string2, string3, string4, string5, string6);
    }

    public void addNewConnectionPool(String string, int n, int n2, String string2, String string3, String string4, String string5, String string6) throws ClassNotFoundException {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            DatabaseLogin databaseLogin = new DatabaseLogin();
            databaseLogin.setPlatformClassName(string2);
            databaseLogin.setDriverClassName(string3);
            databaseLogin.setConnectionString(string4);
            databaseLogin.setUserName(string5);
            databaseLogin.setEncryptedPassword(string6);
            ((ServerSession)this.getSession()).addConnectionPool(string, databaseLogin, n2, n);
        }
    }

    public void resetAllConnections() {
        if (ClassConstants.ServerSession_Class.isAssignableFrom(this.getSession().getClass())) {
            Iterator iterator = ((ServerSession)this.getSession()).getConnectionPools().values().iterator();
            while (iterator.hasNext()) {
                ConnectionPool connectionPool = (ConnectionPool)iterator.next();
                connectionPool.shutDown();
                connectionPool.startUp();
            }
        } else if (ClassConstants.PublicInterfaceDatabaseSession_Class.isAssignableFrom(this.getSession().getClass())) {
            this.getSession().getAccessor().reestablishConnection(this.getSession());
        }
    }

    public List getClassesInSession() {
        return this.getSession().getIdentityMapAccessorInstance().getIdentityMapManager().getClassesRegistered();
    }

    public List getObjectsInIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        Vector<Object> vector = new Vector<Object>(identityMap.getSize());
        Enumeration enumeration = identityMap.keys();
        while (enumeration.hasMoreElements()) {
            vector.add(((CacheKey)enumeration.nextElement()).getObject());
        }
        return vector;
    }

    public Integer getNumberOfObjectsInIdentityMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        return new Integer(this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz).getSize());
    }

    public List getObjectsInIdentityMapSubCache(String string) throws ClassNotFoundException {
        return this.getObjectsInIdentityMapSubCacheAsMap(string);
    }

    public List getObjectsInIdentityMapSubCacheAsMap(String string) throws ClassNotFoundException {
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        Vector vector = new Vector(1);
        List list = new ArrayList(0);
        if (ClassConstants.HardCacheWeakIdentityMap_Class.isAssignableFrom(identityMap.getClass())) {
            list = ((HardCacheWeakIdentityMap)identityMap).getReferenceCache();
        }
        return list;
    }

    public Integer getNumberOfObjectsInIdentityMapSubCache(String string) throws ClassNotFoundException {
        Integer n = new Integer(0);
        Class clazz = (Class)this.getSession().getDatasourcePlatform().getConversionManager().convertObject(string, ClassConstants.CLASS);
        IdentityMap identityMap = this.getSession().getIdentityMapAccessorInstance().getIdentityMap(clazz);
        if (identityMap.getClass().isAssignableFrom(ClassConstants.HardCacheWeakIdentityMap_Class)) {
            ExposedNodeLinkedList exposedNodeLinkedList = ((HardCacheWeakIdentityMap)identityMap).getReferenceCache();
            n = new Integer(exposedNodeLinkedList.size());
        }
        return n;
    }

    public int getLogLevel(String string) {
        return this.getSession().getLogLevel(string);
    }

    public void setLogLevel(int n) {
        this.getSession().setLogLevel(n);
    }

    public boolean shouldLog(int n, String string) {
        return this.getSession().shouldLog(n, string);
    }

    public void setProfileWeight(int n) {
        if (this.getSession().isInProfile()) {
            this.getSession().getProfiler().setProfileWeight(n);
        }
    }
}

