/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import java.io.StringWriter;
import oracle.toplink.queryframework.DataModifyQuery;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.sequencing.QuerySequence;

public class TableSequence
extends QuerySequence {
    protected String tableName = "SEQUENCE";
    protected String counterFieldName = "SEQ_COUNT";
    protected String nameFieldName = "SEQ_NAME";
    protected String qualifier = "";

    public TableSequence() {
        super(false, true);
    }

    public TableSequence(String string) {
        super(string, false, true);
    }

    public TableSequence(String string, int n) {
        super(string, n, false, true);
    }

    public TableSequence(String string, String string2) {
        this(string);
        this.setTableName(string2);
    }

    public TableSequence(String string, String string2, String string3, String string4) {
        this(string);
        this.setTableName(string2);
        this.setNameFieldName(string3);
        this.setCounterFieldName(string4);
    }

    public TableSequence(String string, int n, String string2) {
        this(string, n);
        this.setTableName(string2);
    }

    public TableSequence(String string, int n, String string2, String string3, String string4) {
        this(string, n);
        this.setTableName(string2);
        this.setNameFieldName(string3);
        this.setCounterFieldName(string4);
    }

    public boolean equals(Object object) {
        if (object instanceof TableSequence) {
            TableSequence tableSequence = (TableSequence)object;
            if (TableSequence.equalNameAndSize(this, tableSequence)) {
                return this.getTableName().equals(tableSequence.getTableName()) && this.getCounterFieldName().equals(tableSequence.getCounterFieldName()) && this.getNameFieldName().equals(tableSequence.getNameFieldName());
            }
            return false;
        }
        return false;
    }

    public String getCounterFieldName() {
        return this.counterFieldName;
    }

    public void setCounterFieldName(String string) {
        this.counterFieldName = string;
    }

    public String getNameFieldName() {
        return this.nameFieldName;
    }

    public void setNameFieldName(String string) {
        this.nameFieldName = string;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getQualifiedTableName() {
        if (this.qualifier.equals("")) {
            return this.getTableName();
        }
        return this.qualifier + "." + this.getTableName();
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    protected ValueReadQuery buildSelectQuery() {
        ValueReadQuery valueReadQuery = new ValueReadQuery();
        valueReadQuery.addArgument(this.getNameFieldName());
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("SELECT " + this.getCounterFieldName());
        stringWriter.write(" FROM " + this.getQualifiedTableName());
        stringWriter.write(" WHERE " + this.getNameFieldName());
        stringWriter.write(" = #" + this.getNameFieldName());
        valueReadQuery.setSQLString(stringWriter.toString());
        return valueReadQuery;
    }

    protected DataModifyQuery buildUpdateQuery() {
        DataModifyQuery dataModifyQuery = new DataModifyQuery();
        dataModifyQuery.addArgument(this.getNameFieldName());
        dataModifyQuery.addArgument("PREALLOC_SIZE");
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("UPDATE " + this.getQualifiedTableName());
        stringWriter.write(" SET " + this.getCounterFieldName());
        stringWriter.write(" = " + this.getCounterFieldName());
        stringWriter.write(" + #PREALLOC_SIZE");
        stringWriter.write(" WHERE " + this.getNameFieldName() + " = #" + this.getNameFieldName());
        dataModifyQuery.setSQLString(stringWriter.toString());
        return dataModifyQuery;
    }

    public void onConnect() {
        super.onConnect();
        this.qualifier = this.getDatasourcePlatform().getTableQualifier();
    }

    public void onDisconnect() {
        this.qualifier = "";
        super.onDisconnect();
    }
}

