/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sequencing;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.publicinterface.Session;

public abstract class Sequence
implements Serializable,
Cloneable {
    protected String name = "";
    protected int size = 50;
    protected Platform platform;
    protected int depth;

    public Sequence() {
    }

    public Sequence(String string) {
        this();
        this.setName(string);
    }

    public Sequence(String string, int n) {
        this();
        this.setName(string);
        this.setPreallocationSize(n);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getPreallocationSize() {
        return this.size;
    }

    public void setPreallocationSize(int n) {
        this.size = n;
    }

    public Object clone() {
        try {
            Sequence sequence = (Sequence)super.clone();
            if (this.isConnected()) {
                sequence.depth = 1;
                sequence.onDisconnect(this.getDatasourcePlatform());
            }
            return sequence;
        }
        catch (Exception exception) {
            throw new InternalError("Clone failed");
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Sequence) {
            return Sequence.equalNameAndSize(this, (Sequence)object);
        }
        return false;
    }

    public static boolean equalNameAndSize(Sequence sequence, Sequence sequence2) {
        if (sequence == sequence2) {
            return true;
        }
        return sequence.getName().equals(sequence2.getName()) && sequence.getPreallocationSize() == sequence2.getPreallocationSize();
    }

    protected void setDatasourcePlatform(Platform platform) {
        this.platform = platform;
    }

    public Platform getDatasourcePlatform() {
        return this.platform;
    }

    public abstract boolean shouldAcquireValueAfterInsert();

    public boolean shouldUsePreallocation() {
        return !this.shouldAcquireValueAfterInsert();
    }

    public abstract boolean shouldUseTransaction();

    public abstract boolean shouldOverrideExistingValue(String var1, Object var2);

    public boolean shouldOverrideExistingValue(Object object) {
        return this.shouldOverrideExistingValue(this.getName(), object);
    }

    public abstract Object getGeneratedValue(Accessor var1, Session var2, String var3);

    public Object getGeneratedValue(Accessor accessor, Session session) {
        return this.getGeneratedValue(accessor, session, this.getName());
    }

    public abstract Vector getGeneratedVector(Accessor var1, Session var2, String var3, int var4);

    public Vector getGeneratedVector(Accessor accessor, Session session) {
        return this.getGeneratedVector(accessor, session, this.getName(), this.getPreallocationSize());
    }

    public void onConnect(Platform platform) {
        if (this.isConnected()) {
            this.verifyPlatform(platform);
        } else {
            this.setDatasourcePlatform(platform);
            this.onConnect();
        }
        ++this.depth;
    }

    protected abstract void onConnect();

    public void onDisconnect(Platform platform) {
        if (this.isConnected()) {
            --this.depth;
            if (this.depth == 0) {
                this.onDisconnect();
                this.setDatasourcePlatform(null);
            }
        }
    }

    protected abstract void onDisconnect();

    public boolean isConnected() {
        return this.platform != null;
    }

    protected void verifyPlatform(Platform platform) {
        if (this.getDatasourcePlatform() != platform) {
            String string = Integer.toString(System.identityHashCode(this.getDatasourcePlatform()));
            String string2 = ((DatasourcePlatform)this.getDatasourcePlatform()).toString() + '(' + string + ')';
            String string3 = Integer.toString(System.identityHashCode(platform));
            String string4 = ((DatasourcePlatform)platform).toString() + '(' + string3 + ')';
            throw ValidationException.sequenceCannotBeConnectedToTwoPlatforms(this.getName(), string2, string4);
        }
    }
}

