/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.sdk.SDKDataStoreException;
import oracle.toplink.sdk.SDKPlatform;
import oracle.toplink.sdk.SDKQueryException;
import oracle.toplink.sessions.DatasourceLogin;

public class SDKLogin
extends DatasourceLogin {
    private Class accessorClass;

    public SDKLogin() {
        this(new SDKPlatform());
    }

    public SDKLogin(Platform platform) {
        super(platform);
        this.initialize();
    }

    public Accessor buildAccessor() {
        try {
            return (Accessor)PrivilegedAccessController.newInstanceFromClass(this.getAccessorClass());
        }
        catch (InstantiationException instantiationException) {
            throw SDKDataStoreException.instantiationExceptionWhenInstantiatingAccessor(instantiationException, this.getAccessorClass());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw SDKDataStoreException.illegalAccessExceptionWhenInstantiatingAccessor(illegalAccessException, this.getAccessorClass());
        }
    }

    public Class getAccessorClass() {
        return this.accessorClass;
    }

    protected Class getDefaultAccessorClass() {
        return ClassConstants.SdkAccessor_Class;
    }

    protected void initialize() {
        this.accessorClass = this.getDefaultAccessorClass();
    }

    public SDKQueryException invalidAccessClass(Class clazz, Class clazz2) {
        return SDKQueryException.invalidAccessorClass(clazz, clazz2);
    }

    public void setAccessorClass(Class clazz) {
        if (!Helper.classImplementsInterface(clazz, ClassConstants.Accessor_Class)) {
            throw this.invalidAccessClass(ClassConstants.Accessor_Class, clazz);
        }
        this.accessorClass = clazz;
    }

    public String toString() {
        return Helper.getShortClassName(this) + "(" + this.getUserName() + ")";
    }
}

