/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.sdk;

import java.util.Vector;
import oracle.toplink.internal.sessions.CollectionChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.DatabaseMapping;

class SDKCollectionChangeRecord
extends CollectionChangeRecord
implements oracle.toplink.changesets.SDKCollectionChangeRecord {
    private Vector adds;
    private Vector removes;
    private Vector changedMapKeys;

    SDKCollectionChangeRecord(ObjectChangeSet objectChangeSet, String string, DatabaseMapping databaseMapping) {
        this.owner = objectChangeSet;
        this.attribute = string;
        this.mapping = databaseMapping;
    }

    void addAddedChangeSet(Object object) {
        this.getAdds().addElement(object);
    }

    void addChangedMapKeyChangeSet(Object object) {
        this.getChangedMapKeys().addElement(object);
    }

    void addRemovedChangeSet(Object object) {
        this.getRemoves().addElement(object);
    }

    public Vector getAdds() {
        if (this.adds == null) {
            this.adds = new Vector(1);
        }
        return this.adds;
    }

    public Vector getChangedMapKeys() {
        if (this.changedMapKeys == null) {
            this.changedMapKeys = new Vector(1);
        }
        return this.changedMapKeys;
    }

    public Vector getRemoves() {
        if (this.removes == null) {
            this.removes = new Vector(1);
        }
        return this.removes;
    }

    private boolean hasAdds() {
        return this.adds != null && !this.adds.isEmpty();
    }

    private boolean hasChangedMapKeys() {
        return this.changedMapKeys != null && !this.changedMapKeys.isEmpty();
    }

    public boolean hasChanges() {
        return this.hasAdds() || this.hasRemoves() || this.hasChangedMapKeys() || this.getOwner().isNew();
    }

    private boolean hasRemoves() {
        return this.removes != null && !this.removes.isEmpty();
    }

    private boolean removeAddedChangeSet(Object object) {
        if (this.adds == null) {
            return false;
        }
        return this.adds.remove(object);
    }

    private boolean removeRemovedChangeSet(Object object) {
        if (this.removes == null) {
            return false;
        }
        return this.removes.remove(object);
    }

    void simpleAddChangeSet(Object object) {
        if (!this.removeRemovedChangeSet(object)) {
            this.addAddedChangeSet(object);
        }
    }

    void simpleRemoveChangeSet(Object object) {
        if (!this.removeAddedChangeSet(object)) {
            this.addRemovedChangeSet(object);
        }
    }
}

