/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remotecommand.jms;

import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.toplink.exceptions.RemoteCommandManagerException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.remotecommand.RemoteConnection;
import oracle.toplink.internal.remotecommand.jms.JMSTopicRemoteConnection;
import oracle.toplink.remotecommand.DiscoveryManager;
import oracle.toplink.remotecommand.RemoteCommandManager;
import oracle.toplink.remotecommand.ServiceId;
import oracle.toplink.remotecommand.TransportManager;
import oracle.toplink.remotecommand.jms.JMSTopicDiscoveryManager;

public class JMSTopicTransportManager
extends TransportManager {
    protected String topicName;
    protected String connectionFactoryName;
    protected TopicConnection listeningConnection;
    protected Context remoteHostContext;
    protected JMSMessageListenerHelper listeningThread;
    public static final String DEFAULT_TOPIC = "jms/TopLinkTopic";
    public static final String DEFAULT_CONNECTION_FACTORY = "jms/TopLinkTopicConnectionFactory";

    public JMSTopicTransportManager(RemoteCommandManager remoteCommandManager) {
        this.rcm = remoteCommandManager;
        remoteCommandManager.setTransportManager(this);
        this.initialize();
    }

    public void connectBackToRemote(RemoteConnection remoteConnection) throws Exception {
        TopicConnectionFactory topicConnectionFactory = this.getTopicConnectionFactory();
        Topic topic = this.getTopic();
        try {
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            TopicSubscriber topicSubscriber = topicSession.createSubscriber(topic);
            JMSTopicRemoteConnection jMSTopicRemoteConnection = (JMSTopicRemoteConnection)remoteConnection;
            jMSTopicRemoteConnection.setListeningConnection(topicConnection);
            jMSTopicRemoteConnection.open();
            this.listeningThread = new JMSMessageListenerHelper(jMSTopicRemoteConnection, topicSubscriber);
            this.listeningThread.start();
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorCreatingJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), exception));
        }
    }

    public void createJMSTopicRemoteConnection() {
        TopicConnectionFactory topicConnectionFactory = this.getTopicConnectionFactory();
        Topic topic = this.getTopic();
        try {
            TopicConnection topicConnection = topicConnectionFactory.createTopicConnection();
            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
            TopicPublisher topicPublisher = topicSession.createPublisher(topic);
            JMSTopicRemoteConnection jMSTopicRemoteConnection = new JMSTopicRemoteConnection(this.rcm, topicPublisher, topicSession);
            this.addConnectionToExternalService(jMSTopicRemoteConnection);
        }
        catch (Exception exception) {
            this.rcm.handleException(RemoteCommandManagerException.errorCreatingJMSConnection(this.topicName, this.connectionFactoryName, this.getRemoteContextProperties(), exception));
        }
    }

    public void createLocalConnection() {
        this.createJMSTopicRemoteConnection();
    }

    public RemoteConnection createConnection(ServiceId serviceId) {
        return null;
    }

    public void setTopicConnectionFactoryName(String string) {
        this.connectionFactoryName = string;
    }

    public String getTopicConnectionFactoryName() {
        return this.connectionFactoryName;
    }

    public void setTopicName(String string) {
        this.topicName = string;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public void initialize() {
        super.initialize();
        this.topicName = DEFAULT_TOPIC;
        this.connectionFactoryName = DEFAULT_CONNECTION_FACTORY;
    }

    public String getTopicHostUrl() {
        return (String)this.getRemoteContextProperties().get("java.naming.provider.url");
    }

    public void setTopicHostUrl(String string) {
        this.getRemoteContextProperties().put("java.naming.provider.url", string);
        this.rcm.getServiceId().setURL(string);
    }

    public void setNamingServiceType(int n) {
        if (n != 0) {
            throw ValidationException.operationNotSupported("setNamingServiceType");
        }
    }

    protected Topic getTopic() {
        try {
            return (Topic)this.getRemoteHostContext().lookup(this.topicName);
        }
        catch (NamingException namingException) {
            this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(this.topicName, this.rcm.getUrl(), namingException));
            return null;
        }
    }

    protected TopicConnectionFactory getTopicConnectionFactory() {
        try {
            return (TopicConnectionFactory)this.getRemoteHostContext().lookup(this.connectionFactoryName);
        }
        catch (NamingException namingException) {
            this.rcm.handleException(RemoteCommandManagerException.errorLookingUpRemoteConnection(this.connectionFactoryName, this.rcm.getUrl(), namingException));
            return null;
        }
    }

    public DiscoveryManager createDiscoveryManager() {
        return new JMSTopicDiscoveryManager(this.rcm);
    }

    protected Context getRemoteHostContext() {
        if (this.remoteHostContext == null) {
            this.remoteHostContext = this.getRemoteHostContext(this.getTopicHostUrl());
        }
        return this.remoteHostContext;
    }

    public void removeLocalConnection() {
        Object[] objectArray;
        this.localConnection = null;
        this.listeningThread.isListeningToMessage = false;
        try {
            this.listeningThread.subscriber.close();
        }
        catch (JMSException jMSException) {
            objectArray = new Object[]{jMSException};
            this.rcm.logWarning("exception_thrown_when_attempting_to_close_connection", objectArray);
        }
        this.listeningThread = null;
        try {
            this.remoteHostContext.close();
        }
        catch (NamingException namingException) {
            objectArray = new Object[]{namingException};
            this.rcm.logWarning("exception_thrown_when_attempting_to_close_connection", objectArray);
        }
        this.remoteHostContext = null;
    }

    class JMSOnMessageHelper
    extends Thread {
        JMSTopicRemoteConnection jmsConnection = null;
        Message message = null;

        public JMSOnMessageHelper(JMSTopicRemoteConnection jMSTopicRemoteConnection, Message message) {
            this.jmsConnection = jMSTopicRemoteConnection;
            this.message = message;
        }

        public void run() {
            this.jmsConnection.onMessage(this.message);
        }
    }

    class JMSMessageListenerHelper
    extends Thread {
        protected JMSTopicRemoteConnection jmsConnection = null;
        protected TopicSubscriber subscriber = null;
        protected boolean isListeningToMessage = true;

        public JMSMessageListenerHelper(JMSTopicRemoteConnection jMSTopicRemoteConnection, TopicSubscriber topicSubscriber) {
            this.jmsConnection = jMSTopicRemoteConnection;
            this.subscriber = topicSubscriber;
        }

        public void run() {
            Object[] objectArray = new Object[]{JMSTopicTransportManager.this.topicName, JMSTopicTransportManager.this.getTopicHostUrl()};
            JMSTopicTransportManager.this.rcm.logDebug("start_listening_to_jms_topic", objectArray);
            block2: while (true) {
                try {
                    while (true) {
                        Message message = this.subscriber.receive();
                        if (!this.isListeningToMessage) break block2;
                        new JMSOnMessageHelper(this.jmsConnection, message).start();
                    }
                }
                catch (JMSException jMSException) {
                    JMSTopicTransportManager.this.rcm.handleException(RemoteCommandManagerException.errorReceivingJMSMessage((Exception)((Object)jMSException)));
                    continue;
                }
                break;
            }
            JMSTopicTransportManager.this.rcm.logDebug("stop_listening_to_jms_topic", objectArray);
        }
    }
}

