/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.rmi.wls;

import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.rmi.wls.RMIConnection;
import oracle.toplink.remote.rmi.wls.RMIRemoteSessionController;
import oracle.toplink.remote.rmi.wls.RMIRemoteSessionControllerDispatcher;

public class WLSClusteringService
extends AbstractJNDIClusteringService {
    private static Class DEFAULT_DISPATCHER_CLASS = class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher == null ? (class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher = WLSClusteringService.class$("oracle.toplink.remote.rmi.RMIRemoteSessionControllerDispatcher")) : class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    private static Class DEFAULT_CONNECTION_CLASS = class$oracle$toplink$remote$rmi$RMIConnection == null ? (class$oracle$toplink$remote$rmi$RMIConnection = WLSClusteringService.class$("oracle.toplink.remote.rmi.RMIConnection")) : class$oracle$toplink$remote$rmi$RMIConnection;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIConnection;

    public WLSClusteringService(oracle.toplink.sessions.Session session) {
        super(session);
        this.setAnnouncementDelay(30000);
    }

    public RemoteConnection createRemoteConnection(String string, Object object) {
        RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionController)object);
        rMIConnection.setServiceName(string);
        return rMIConnection;
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        return null;
    }

    public void registerDispatcher() {
        try {
            try {
                this.getLocalContext().createSubcontext("OracleTopLink");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                // empty catch block
            }
            this.getLocalContext().rebind("OracleTopLink." + this.getSessionId(), this.getDispatcher());
            this.getLocalContext().close();
            this.setContext(null);
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void deregisterDispatcher() {
        try {
            try {
                this.getLocalContext().createSubcontext("OracleTopLink");
            }
            catch (NameAlreadyBoundException nameAlreadyBoundException) {
                // empty catch block
            }
            this.getLocalContext().unbind("OracleTopLink." + this.getSessionId());
            this.getLocalContext().close();
            this.setContext(null);
            RMIRemoteSessionControllerDispatcher rMIRemoteSessionControllerDispatcher = (RMIRemoteSessionControllerDispatcher)this.getDispatcher();
            if (rMIRemoteSessionControllerDispatcher != null) {
                RMIRemoteSessionControllerDispatcher.unexportObject((Object)rMIRemoteSessionControllerDispatcher, (boolean)true);
            }
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public MulticastSocket getCommunicationSocket() {
        return null;
    }

    public Context getContext(Hashtable hashtable) {
        try {
            InitialContext initialContext = new InitialContext();
            return initialContext;
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(hashtable.toString(), namingException));
            return null;
        }
    }

    public Object getDispatcher() throws RemoteException {
        if (this.dispatcher == null) {
            this.dispatcher = new RMIRemoteSessionControllerDispatcher(this.getSession());
        }
        return this.dispatcher;
    }

    public void run() {
        ((Session)this.getSession()).log(1, "propagation", "initializing_local_discovery_communication_socket");
        this.setSessionId(this.buildSessionId());
        ((Session)this.getSession()).log(1, "propagation", "place_local_remote_session_dispatcher_into_naming_service");
        this.registerDispatcher();
        this.getSession().getCacheSynchronizationManager().setSessionRemoteConnection(this.getLocalRemoteConnection());
        try {
            WLSClusteringService.sleep(this.getAnnouncementDelay());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.retreiveRemoteSessions();
    }

    public RemoteConnection getLocalRemoteConnection() {
        try {
            RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionControllerDispatcher)this.getDispatcher());
            rMIConnection.setServiceName(this.getSessionId());
            return rMIConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public void retreiveRemoteSessions() {
        try {
            NamingEnumeration<Binding> namingEnumeration = this.getLocalContext().listBindings("OracleTopLink");
            while (namingEnumeration.hasMoreElements()) {
                Binding binding = (Binding)namingEnumeration.nextElement();
                if (binding.getName().equals(this.getSessionId())) continue;
                RemoteConnection remoteConnection = this.createRemoteConnection(binding.getName(), binding.getObject());
                this.getSession().getCacheSynchronizationManager().addRemoteConnection(remoteConnection);
            }
            namingEnumeration.close();
            this.getLocalContext().close();
            this.setContext(null);
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController("all", namingException));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

