/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote.rmi;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.rmi.RemoteException;
import java.util.Hashtable;
import javax.naming.NamingException;
import oracle.toplink.exceptions.SynchronizationException;
import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.remote.AbstractJNDIClusteringService;
import oracle.toplink.remote.rmi.RMIConnection;
import oracle.toplink.remote.rmi.RMIRemoteSessionController;
import oracle.toplink.remote.rmi.RMIRemoteSessionControllerDispatcher;
import oracle.toplink.sessions.Session;

public class RMIJNDIClusteringService
extends AbstractJNDIClusteringService {
    private static Class DEFAULT_DISPATCHER_CLASS = class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher == null ? (class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher = RMIJNDIClusteringService.class$("oracle.toplink.remote.rmi.RMIRemoteSessionControllerDispatcher")) : class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    private static Class DEFAULT_CONNECTION_CLASS = class$oracle$toplink$remote$rmi$RMIConnection == null ? (class$oracle$toplink$remote$rmi$RMIConnection = RMIJNDIClusteringService.class$("oracle.toplink.remote.rmi.RMIConnection")) : class$oracle$toplink$remote$rmi$RMIConnection;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIRemoteSessionControllerDispatcher;
    static /* synthetic */ Class class$oracle$toplink$remote$rmi$RMIConnection;

    public RMIJNDIClusteringService(String string, int n, Session session) {
        super(string, n, session);
    }

    public RMIJNDIClusteringService(Session session) {
        super(session);
    }

    public void registerDispatcher() {
        try {
            this.getLocalContext().rebind(this.getSessionId(), this.getDispatcher());
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public void deregisterDispatcher() {
        try {
            this.getLocalContext().unbind(this.getSessionId());
            RMIRemoteSessionControllerDispatcher rMIRemoteSessionControllerDispatcher = (RMIRemoteSessionControllerDispatcher)this.getDispatcher();
            if (rMIRemoteSessionControllerDispatcher != null) {
                RMIRemoteSessionControllerDispatcher.unexportObject(rMIRemoteSessionControllerDispatcher, true);
            }
        }
        catch (Exception exception) {
            this.getSession().handleException(SynchronizationException.errorBindingController(this.getSessionId(), exception));
        }
    }

    public RemoteConnection createRemoteConnection(String string, String string2) {
        try {
            Hashtable hashtable = (Hashtable)this.getInitialContextProperties().clone();
            hashtable.put("java.naming.provider.url", string2);
            return new RMIConnection((RMIRemoteSessionController)this.getContext(hashtable).lookup(string));
        }
        catch (NamingException namingException) {
            this.getSession().handleException(SynchronizationException.errorLookingUpController(string, namingException));
            return null;
        }
    }

    public MulticastSocket getCommunicationSocket() {
        if (this.communicationSocket == null) {
            try {
                this.communicationSocket = new MulticastSocket(this.getMulticastPort());
                this.communicationSocket.setTimeToLive(this.getTimeToLive());
                this.communicationSocket.joinGroup(InetAddress.getByName(this.getMulticastGroupAddress()));
            }
            catch (IOException iOException) {
                SynchronizationException synchronizationException = SynchronizationException.errorJoiningMulticastGroup(iOException);
                this.getSession().handleException(synchronizationException);
            }
        }
        return this.communicationSocket;
    }

    public Object getDispatcher() throws RemoteException {
        if (this.dispatcher == null) {
            this.dispatcher = new RMIRemoteSessionControllerDispatcher(this.getSession());
        }
        return this.dispatcher;
    }

    public RemoteConnection getLocalRemoteConnection() {
        try {
            RMIConnection rMIConnection = new RMIConnection((RMIRemoteSessionControllerDispatcher)this.getDispatcher());
            rMIConnection.setServiceName(this.getSessionId());
            return rMIConnection;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

