/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.remote;

import java.io.Serializable;
import oracle.toplink.exceptions.SynchronizationException;

public class SessionAnnouncement
implements Serializable {
    String sessionId;
    private String jndiHostURL;
    private String applicationName;

    public SessionAnnouncement(byte[] byArray) throws SynchronizationException {
        try {
            this.readFromBytes(byArray);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw SynchronizationException.errorUnmarshallingMsg(this.sessionId);
        }
    }

    public SessionAnnouncement(String string, String string2, String string3) {
        this.sessionId = string;
        this.jndiHostURL = string2;
        this.applicationName = string3;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void readFromBytes(byte[] byArray) {
        int n = 0;
        byte by = byArray[n];
        this.sessionId = new String(byArray, ++n, (int)by);
        byte by2 = byArray[n += by];
        this.jndiHostURL = new String(byArray, ++n, (int)by2);
        byte by3 = byArray[n += by2];
        this.applicationName = new String(byArray, ++n, (int)by3);
        n += by3;
    }

    public byte[] toBytes() {
        int n = 0;
        byte[] byArray = this.sessionId.getBytes();
        int n2 = byArray.length;
        byte[] byArray2 = this.jndiHostURL.getBytes();
        int n3 = this.jndiHostURL.length();
        byte[] byArray3 = this.applicationName.getBytes();
        int n4 = byArray3.length;
        byte[] byArray4 = new byte[n2 + n3 + n4 + 3];
        byArray4[n] = (byte)n2;
        System.arraycopy(byArray, 0, byArray4, ++n, n2);
        byArray4[n += n2] = (byte)n3;
        System.arraycopy(byArray2, 0, byArray4, ++n, n3);
        byArray4[n += n3] = (byte)n4;
        System.arraycopy(byArray3, 0, byArray4, ++n, n4);
        return byArray4;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getJNDIHostURL() {
        return this.jndiHostURL;
    }

    public void setJNDIHostURL(String string) {
        this.jndiHostURL = string;
    }
}

