/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.helper.TopLinkIdentityHashSet;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.remote.RemoteSessionController;
import oracle.toplink.internal.remote.Transporter;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.ComplexQueryResult;
import oracle.toplink.queryframework.Cursor;
import oracle.toplink.queryframework.CursoredStreamPolicy;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.QueryByExamplePolicy;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.queryframework.ScrollableCursorPolicy;
import oracle.toplink.queryframework.ValueReadQuery;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.tools.profiler.QueryMonitor;

public class ReadAllQuery
extends ObjectLevelReadQuery {
    protected Vector orderByExpressions;
    protected Vector batchReadAttributeExpressions;
    protected transient Map batchReadMappingQueries;
    protected List batchReadAttributes;
    protected ContainerPolicy containerPolicy;
    protected Expression startWithExpression;
    protected Expression connectByExpression;
    protected Vector orderSiblingsByExpressions;

    public ReadAllQuery() {
        this.useCollectionClass(ClassConstants.Vector_class);
    }

    public ReadAllQuery(Class clazz) {
        this();
        this.setReferenceClass(clazz);
    }

    public ReadAllQuery(Class clazz, Expression expression) {
        this();
        this.setReferenceClass(clazz);
        this.setSelectionCriteria(expression);
    }

    public ReadAllQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.setReferenceClass(clazz);
    }

    public ReadAllQuery(Class clazz, Call call) {
        this();
        this.setReferenceClass(clazz);
        this.setCall(call);
    }

    public ReadAllQuery(Object object, QueryByExamplePolicy queryByExamplePolicy) {
        this();
        this.setExampleObject(object);
        this.setQueryByExamplePolicy(queryByExamplePolicy);
    }

    public ReadAllQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public ReadAllQuery(Call call) {
        this();
        this.setCall(call);
    }

    public void addAscendingOrdering(String string) {
        this.addOrdering(this.getExpressionBuilder().get(string).ascending());
    }

    public void addBatchReadAttribute(String string) {
        if (!this.getQueryMechanism().isExpressionQueryMechanism()) {
            throw QueryException.batchReadingNotSupported(this);
        }
        this.getBatchReadAttributeExpressions().add(this.getExpressionBuilder().get(string));
    }

    public void addBatchReadAttribute(Expression expression) {
        this.getBatchReadAttributeExpressions().add(expression);
    }

    public void addDescendingOrdering(String string) {
        this.addOrdering(this.getExpressionBuilder().get(string).descending());
    }

    public void addOrdering(Expression expression) {
        this.getOrderByExpressions().addElement(expression);
        this.setIsPrepared(false);
    }

    public void cacheResult(Object object) {
        Collection collection = (Collection)this.getTemporaryCachedQueryResults();
        if (collection == null) {
            collection = (Collection)this.getContainerPolicy().containerInstance();
            this.setTemporaryCachedQueryResults(collection);
        }
        this.getContainerPolicy().addInto(object, (Object)collection, this.getSession());
    }

    protected Object checkEarlyReturnImpl(Session session, DatabaseRow databaseRow) {
        if (this.shouldCheckCacheOnly()) {
            if (this.shouldUseWrapperPolicy()) {
                this.getContainerPolicy().setElementDescriptor(this.getDescriptor());
            }
            Session session2 = session;
            while (session2.isUnitOfWork()) {
                session2 = ((UnitOfWork)session2).getParent();
            }
            Vector vector = session2.getIdentityMapAccessor().getAllFromIdentityMap(this.getSelectionCriteria(), this.getReferenceClass(), databaseRow, this.getInMemoryQueryIndirectionPolicy(), false);
            if (session.isUnitOfWork()) {
                vector = ((UnitOfWork)session).registerAllObjects(vector);
            }
            return this.getContainerPolicy().buildContainerFromVector(vector, session);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(Session session, DatabaseRow databaseRow) {
        this.checkDescriptor(session);
        if (this.isCustomQueryUsed() == null) {
            this.setIsCustomQueryUsed(!this.isUserDefined() && this.isExpressionQuery() && this.getSelectionCriteria() == null && !this.hasOrderByExpressions() && this.getDescriptor().getQueryManager().hasReadAllQuery());
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.getDescriptor().getQueryManager().getReadAllQuery();
        }
        return null;
    }

    public Object clone() {
        ReadAllQuery readAllQuery = (ReadAllQuery)super.clone();
        if (this.hasOrderByExpressions()) {
            readAllQuery.orderByExpressions = (Vector)this.getOrderByExpressions().clone();
        }
        readAllQuery.containerPolicy = this.getContainerPolicy().clone(readAllQuery);
        return readAllQuery;
    }

    protected Object conformResult(Object object, UnitOfWork unitOfWork, DatabaseRow databaseRow, boolean bl) {
        Object object2;
        Object object3;
        Object object4;
        IdentityHashtable identityHashtable = null;
        Expression expression = null;
        Cursor cursor = null;
        if (this.getSelectionCriteria() != null) {
            expression = (Expression)this.getSelectionCriteria().clone();
            expression.getBuilder().setSession(unitOfWork);
            expression.getBuilder().setQueryClass(this.getReferenceClass());
        }
        ContainerPolicy containerPolicy = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(object.getClass()) : this.getContainerPolicy();
        identityHashtable = unitOfWork.scanForConformingInstances(expression, this.getReferenceClass(), databaseRow, this);
        if (containerPolicy.isCursorPolicy()) {
            cursor = (Cursor)object;
            containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            cursor.setSession(unitOfWork);
            object = cursor.getObjectCollection();
            cursor.setInitiallyConformingIndex(identityHashtable);
            cursor.setSelectionCriteriaClone(expression);
            cursor.setTranslationRow(databaseRow);
        }
        Vector<Object> vector = null;
        if (bl) {
            object4 = (Vector)object;
            object3 = null;
            vector = new Vector(((Vector)object4).size());
            for (int i = 0; i < ((Vector)object4).size(); ++i) {
                Object object5;
                object2 = ((Vector)object4).elementAt(i);
                if (object2 == null || (object5 = this.conformIndividualResult(object2, unitOfWork, databaseRow, expression, identityHashtable, bl)) == null) continue;
                if (this.isOneToManyJoinQuery()) {
                    if (object3 == null) {
                        object3 = new TopLinkIdentityHashSet(((Vector)object4).size());
                    }
                    if (object3.contains(object5)) continue;
                    object3.add(object5);
                    vector.addElement(object5);
                    continue;
                }
                vector.addElement(object5);
            }
        } else {
            vector = new Vector<Object>(containerPolicy.sizeFor(object));
            object4 = unitOfWork.getParent();
            object3 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object3)) {
                Object object6 = containerPolicy.next(object3, (Session)object4);
                object2 = this.conformIndividualResult(object6, unitOfWork, databaseRow, expression, identityHashtable, bl);
                if (object2 == null) continue;
                vector.addElement(object2);
            }
        }
        object4 = containerPolicy.containerInstance(identityHashtable.size() + vector.size());
        Enumeration enumeration = identityHashtable.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            containerPolicy.addInto(object3, object4, unitOfWork);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            object3 = enumeration.nextElement();
            containerPolicy.addInto(object3, object4, unitOfWork);
        }
        if (cursor != null) {
            cursor.setObjectCollection((Vector)object4);
            if (unitOfWork.isNestedUnitOfWork()) {
                enumeration = cursor.getObjectCollection().elements();
                while (enumeration.hasMoreElements()) {
                    object2 = enumeration.nextElement();
                    identityHashtable.put(object2, object2);
                }
            }
            return cursor;
        }
        return object4;
    }

    public Object execute(Session session, DatabaseRow databaseRow) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            Collection collection;
            if (this.getContainerPolicy().overridesRead()) {
                throw QueryException.cannotCacheCursorResultsOnQuery(this);
            }
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared() && (collection = (Collection)this.getQueryResults(session, databaseRow, true)) != null) {
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadAllHits(this);
                }
                if (session.isUnitOfWork()) {
                    Collection collection2 = (Collection)this.getContainerPolicy().containerInstance();
                    Object object = this.getContainerPolicy().iteratorFor(collection);
                    while (this.getContainerPolicy().hasNext(object)) {
                        Object object2 = ((UnitOfWork)session).registerExistingObject(this.getContainerPolicy().next(object, session));
                        collection2.add(object2);
                    }
                    return collection2;
                }
                return collection;
            }
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadAllMisses(this);
        }
        return super.execute(session, databaseRow);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object object = null;
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().execute();
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            Object object2 = this.getDescriptor().getInterfacePolicy().selectAllObjectsUsingMultipleTableSubclassRead(this);
            this.setExecutionTime(System.currentTimeMillis());
            return object2;
        }
        Vector vector = this.getQueryMechanism().selectAllRows();
        this.setExecutionTime(System.currentTimeMillis());
        if (this.isOneToManyJoinQuery()) {
            this.setDataResults(vector);
        }
        object = this.getSession().isUnitOfWork() ? this.registerResultInUnitOfWork(vector, (UnitOfWork)this.getSession(), this.getTranslationRow(), true) : this.getQueryMechanism().buildObjectsFromRows(vector);
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexQueryResult = new ComplexQueryResult();
            complexQueryResult.setResult(object);
            complexQueryResult.setData(vector);
            return complexQueryResult;
        }
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectsCorrespondingToAll(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashtable(), this, this.getContainerPolicy());
    }

    public Vector getBatchReadAttributeExpressions() {
        if (this.batchReadAttributeExpressions == null) {
            this.batchReadAttributeExpressions = NonSynchronizedVector.newInstance();
        }
        return this.batchReadAttributeExpressions;
    }

    public ContainerPolicy getContainerPolicy() {
        return this.containerPolicy;
    }

    public Expression getStartWithExpression() {
        return this.startWithExpression;
    }

    public Expression getConnectByExpression() {
        return this.connectByExpression;
    }

    public Vector getOrderSiblingsByExpressions() {
        return this.orderSiblingsByExpressions;
    }

    public Vector getOrderByExpressions() {
        if (this.orderByExpressions == null) {
            this.orderByExpressions = NonSynchronizedVector.newInstance();
        }
        return this.orderByExpressions;
    }

    public boolean hasOrderByExpressions() {
        return this.orderByExpressions != null;
    }

    public boolean hasHierarchicalExpressions() {
        return this.startWithExpression != null || this.connectByExpression != null || this.orderSiblingsByExpressions != null;
    }

    public boolean hasBatchReadAttributes() {
        return this.batchReadAttributeExpressions != null && !this.batchReadAttributeExpressions.isEmpty();
    }

    public boolean isAttributeBatchRead(String string) {
        if (!this.hasBatchReadAttributes()) {
            return false;
        }
        Vector vector = this.getBatchReadAttributeExpressions();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            QueryKeyExpression queryKeyExpression = (QueryKeyExpression)vector.get(i);
            while (!queryKeyExpression.getBaseExpression().isExpressionBuilder()) {
                queryKeyExpression = (QueryKeyExpression)queryKeyExpression.getBaseExpression();
            }
            if (!queryKeyExpression.getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isAttributeBatchRead(Descriptor descriptor, String string) {
        if (!this.hasBatchReadAttributes()) {
            return false;
        }
        if (descriptor.isAggregateDescriptor() && descriptor != this.getDescriptor()) {
            return false;
        }
        if (this.batchReadAttributes != null) {
            return this.batchReadAttributes.contains(string);
        }
        return this.isAttributeBatchRead(string);
    }

    public Map getBatchReadMappingQueries() {
        return this.batchReadMappingQueries;
    }

    protected void setBatchReadMappingQueries(Map map) {
        this.batchReadMappingQueries = map;
    }

    public boolean isReadAllQuery() {
        return true;
    }

    protected void prepare() throws QueryException {
        super.prepare();
        this.getContainerPolicy().prepare(this, this.getSession());
        if (this.getContainerPolicy().overridesRead()) {
            return;
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return;
        }
        this.prepareSelectAllRows();
        this.computeBatchReadMappingQueries();
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        ReadAllQuery readAllQuery = (ReadAllQuery)databaseQuery;
        readAllQuery.setContainerPolicy(this.getContainerPolicy());
        readAllQuery.setCascadePolicy(this.getCascadePolicy());
        readAllQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        readAllQuery.setShouldMaintainCache(this.shouldMaintainCache());
        readAllQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        this.getContainerPolicy().prepareForExecution();
    }

    protected void prepareSelectAllRows() {
        this.getQueryMechanism().prepareSelectAllRows();
    }

    public Object registerResultInUnitOfWork(Object object, UnitOfWork unitOfWork, DatabaseRow databaseRow, boolean bl) {
        if (this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(object, unitOfWork, databaseRow, bl);
        }
        if (bl) {
            Vector vector = (Vector)object;
            Set set = null;
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object2 = containerPolicy.containerInstance(vector.size());
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                DatabaseRow databaseRow2 = (DatabaseRow)enumeration.nextElement();
                if (databaseRow2 == null) continue;
                Object object3 = this.buildObject(databaseRow2);
                if (this.isOneToManyJoinQuery()) {
                    if (set == null) {
                        set = new TopLinkIdentityHashSet(vector.size());
                    }
                    if (set.contains(object3)) continue;
                    set.add(object3);
                    containerPolicy.addInto(object3, object2, unitOfWork);
                    continue;
                }
                containerPolicy.addInto(object3, object2, unitOfWork);
            }
            return object2;
        }
        Cursor cursor = null;
        ContainerPolicy containerPolicy = this.getRedirector() != null ? ContainerPolicy.buildPolicyFor(object.getClass()) : this.getContainerPolicy();
        if (containerPolicy.isCursorPolicy()) {
            cursor = (Cursor)object;
            cursor.setSession(unitOfWork);
            containerPolicy = ContainerPolicy.buildPolicyFor(ClassConstants.Vector_class);
            object = cursor.getObjectCollection();
        }
        Object object4 = containerPolicy.containerInstance(containerPolicy.sizeFor(object));
        Session session = unitOfWork.getParent();
        Object object5 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object5)) {
            Object object6 = containerPolicy.next(object5, session);
            Object object7 = this.registerIndividualResult(object6, unitOfWork);
            containerPolicy.addInto(object7, object4, unitOfWork);
        }
        if (cursor != null) {
            cursor.setObjectCollection((Vector)object4);
            return cursor;
        }
        return object4;
    }

    public Object remoteExecute() {
        if (this.getContainerPolicy().overridesRead()) {
            return this.getContainerPolicy().remoteExecute();
        }
        Object object = this.checkEarlyReturn(this.getSession(), this.getTranslationRow());
        if (object != null) {
            return object;
        }
        return super.remoteExecute();
    }

    public IdentityHashtable replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersInAll(object, this.getContainerPolicy());
    }

    public void setBatchReadAttributeExpressions(Vector vector) {
        this.batchReadAttributeExpressions = vector;
    }

    public void setContainerPolicy(ContainerPolicy containerPolicy) {
        if (containerPolicy == null) {
            return;
        }
        this.containerPolicy = containerPolicy;
        this.setIsPrepared(false);
    }

    public void setHierarchicalQueryClause(Expression expression, Expression expression2, Vector vector) {
        this.startWithExpression = expression;
        this.connectByExpression = expression2;
        this.orderSiblingsByExpressions = vector;
        this.setIsPrepared(false);
    }

    public void setOrderByExpressions(Vector vector) {
        this.orderByExpressions = vector;
    }

    public void useCollectionClass(Class clazz) {
        this.setContainerPolicy(ContainerPolicy.buildPolicyFor(clazz));
    }

    public void useCursoredStream() {
        this.useCursoredStream(10, 5);
    }

    public void useCursoredStream(int n, int n2) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2));
    }

    public void useCursoredStream(int n, int n2, ValueReadQuery valueReadQuery) {
        this.setContainerPolicy(new CursoredStreamPolicy(this, n, n2, valueReadQuery));
    }

    public void useMapClass(Class clazz, String string) {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        ContainerPolicy containerPolicy = ContainerPolicy.buildPolicyFor(clazz);
        containerPolicy.setKeyMethod(string, this.getReferenceClass());
        this.setContainerPolicy(containerPolicy);
    }

    public void useScrollableCursor() {
        this.useScrollableCursor(10);
    }

    public void useScrollableCursor(int n) {
        this.setContainerPolicy(new ScrollableCursorPolicy(this, n));
    }

    public void useScrollableCursor(ScrollableCursorPolicy scrollableCursorPolicy) {
        scrollableCursorPolicy.setQuery(this);
        this.setContainerPolicy(scrollableCursorPolicy);
    }

    public void computeBatchReadMappingQueries() {
        if (this.hasBatchReadAttributes() && !this.getDescriptor().hasInheritance()) {
            this.batchReadAttributes = new ArrayList(this.getBatchReadAttributeExpressions().size());
            this.setBatchReadMappingQueries(new HashMap(this.getBatchReadAttributeExpressions().size()));
            this.computeNestedQueriesForBatchReadExpressions(this.getBatchReadAttributeExpressions());
        }
    }

    protected void computeNestedQueriesForBatchReadExpressions(Vector vector) {
        for (int i = 0; i < vector.size(); ++i) {
            DatabaseMapping databaseMapping;
            ObjectExpression objectExpression = (ObjectExpression)vector.get(i);
            objectExpression.getBuilder().setSession(this.getSession());
            objectExpression.getBuilder().setQueryClass(this.getReferenceClass());
            ObjectExpression objectExpression2 = objectExpression;
            while (!objectExpression2.getBaseExpression().isExpressionBuilder()) {
                objectExpression2 = (ObjectExpression)((QueryKeyExpression)objectExpression2).getBaseExpression();
            }
            this.batchReadAttributes.add(objectExpression2.getName());
            if (objectExpression.getBaseExpression() != objectExpression.getBuilder() || (databaseMapping = objectExpression.getMapping()) == null || !databaseMapping.isForeignReferenceMapping()) continue;
            ReadQuery readQuery = ((ForeignReferenceMapping)databaseMapping).prepareNestedBatchQuery(this);
            this.getBatchReadMappingQueries().put(databaseMapping, readQuery);
        }
    }
}

