/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.queryframework;

import java.util.Enumeration;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Cursor;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ReadQuery;

public abstract class CursorPolicy
extends ContainerPolicy {
    protected int pageSize;
    protected ReadQuery query;

    public CursorPolicy() {
        this.setPageSize(10);
    }

    public CursorPolicy(ReadQuery readQuery, int n) {
        this.setQuery(readQuery);
        this.setPageSize(n);
    }

    public ContainerPolicy clone(ReadQuery readQuery) {
        CursorPolicy cursorPolicy = (CursorPolicy)super.clone(readQuery);
        cursorPolicy.setQuery(readQuery);
        return cursorPolicy;
    }

    public abstract Object execute();

    public int getPageSize() {
        return this.pageSize;
    }

    public ReadQuery getQuery() {
        return this.query;
    }

    public boolean hasNext(Object object) {
        return ((Enumeration)object).hasMoreElements();
    }

    public boolean isCursoredStreamPolicy() {
        return false;
    }

    public boolean isCursorPolicy() {
        return true;
    }

    public boolean isScrollableCursorPolicy() {
        return false;
    }

    public Object iteratorFor(Object object) {
        return object;
    }

    protected Object next(Object object) {
        return ((Enumeration)object).nextElement();
    }

    public boolean overridesRead() {
        return true;
    }

    public void prepare(DatabaseQuery databaseQuery, Session session) throws QueryException {
        super.prepare(databaseQuery, session);
        Descriptor descriptor = this.getQuery().getDescriptor();
        if (descriptor != null && (!databaseQuery.isReportQuery() && descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses() && descriptor.getInheritancePolicy().hasMultipleTableChild() && !descriptor.getInheritancePolicy().hasView() && this.getQuery().isExpressionQuery() || descriptor.isDescriptorForInterface())) {
            throw QueryException.noCursorSupport(this.getQuery());
        }
        this.getQuery().getQueryMechanism().prepareCursorSelectAllRows();
    }

    public abstract Object remoteExecute();

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public void setQuery(ReadQuery readQuery) {
        this.query = readQuery;
    }

    public int sizeFor(Object object) {
        return ((Cursor)object).size();
    }

    protected Object toStringInfo() {
        return "page size = " + this.getPageSize();
    }
}

