/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.publicinterface;

import java.io.IOException;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.changesets.UnitOfWorkChangeSet;
import oracle.toplink.descriptors.CMPPolicy;
import oracle.toplink.descriptors.changetracking.AttributeChangeTrackingPolicy;
import oracle.toplink.exceptions.CommunicationException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.TopLinkException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.history.AsOfClause;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.descriptors.CascadeLockingPolicy;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.descriptors.TopLinkEntity;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.localization.ExceptionLocalization;
import oracle.toplink.internal.localization.LoggingLocalization;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sessions.AbstractSession;
import oracle.toplink.internal.sessions.CommitManager;
import oracle.toplink.internal.sessions.MergeManager;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.ObjectTracker;
import oracle.toplink.internal.sessions.UnitOfWorkIdentityMapAccessor;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.DescriptorEvent;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.DoesExistQuery;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.UpdateAllQuery;
import oracle.toplink.remotecommand.Command;
import oracle.toplink.remotecommand.MergeChangeSetCommand;

public class UnitOfWork
extends AbstractSession
implements oracle.toplink.sessions.UnitOfWork {
    protected transient IdentityHashtable cloneToOriginals;
    protected transient Session parent;
    protected IdentityHashtable cloneMapping;
    protected IdentityHashtable newObjectsCloneToOriginal;
    protected IdentityHashtable newObjectsOriginalToClone;
    protected IdentityHashtable deletedObjects;
    protected IdentityHashtable allClones;
    protected IdentityHashtable objectsDeletedDuringCommit;
    protected IdentityHashtable removedObjects;
    protected IdentityHashtable unregisteredNewObjects;
    protected IdentityHashtable unregisteredNewObjectsInParent;
    protected IdentityHashtable unregisteredExistingObjects;
    protected IdentityHashtable newObjectsInParentOriginalToClone;
    protected IdentityHashtable newObjectsInParent;
    protected IdentityHashtable newAggregates;
    protected oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet;
    protected UnitOfWork containerUnitOfWork;
    protected IdentityHashtable containerBeans;
    protected IdentityHashtable pessimisticLockedObjects;
    protected MergeManager lastUsedMergeManager;
    protected IdentityHashtable batchReadObjects;
    protected Hashtable readOnlyClasses;
    protected boolean wasTransactionBegunPrematurely;
    protected boolean shouldNewObjectsBeCached;
    protected boolean shouldPerformDeletesFirst;
    protected int shouldThrowConformExceptions;
    protected int validationLevel;
    public static final int None = 0;
    public static final int Partial = 1;
    public static final int Full = 2;
    protected boolean isSynchronized;
    protected int lifecycle;
    public static final int Birth = 0;
    public static final int CommitPending = 1;
    public static final int CommitTransactionPending = 2;
    public static final int WriteChangesFailed = 3;
    public static final int MergePending = 4;
    public static final int Death = 5;
    public static final int AfterExternalTransactionRolledBack = 6;
    public static final int DO_NOT_THROW_CONFORM_EXCEPTIONS = 0;
    public static final int THROW_ALL_CONFORM_EXCEPTIONS = 1;
    public static final int THROW_ONLY_VALUEHOLDER_EXCEPTIONS = 2;
    public static final String LOCK_QUERIES_PROPERTY = "LockQueriesProperties";
    protected static boolean SmartMerge = false;
    protected Hashtable optimisticReadLockObjects;
    public static final String ReadLockOnly = "no update";
    public static final String ReadLockUpdateVersion = "update version";
    protected List updateAllQueries;
    protected List deferredUpdateAllQueries;
    protected int cloneDepth = 0;
    protected Map objectsLockedForClone;
    protected Object transaction;
    protected ObjectTracker objectTracker;
    protected boolean shouldCheckWriteLock;
    protected boolean isNestedUnitOfWork;

    public UnitOfWork(Session session) {
        this.name = session.getName();
        this.parent = session;
        this.cloneMapping = new IdentityHashtable();
        this.project = session.getProject();
        this.profiler = session.getProfiler();
        this.isInProfile = session.isInProfile;
        this.sessionLog = session.getSessionLog();
        this.eventManager = session.getEventManager().clone(this);
        this.exceptionHandler = session.getExceptionHandler();
        this.setReadOnlyClasses(session.copyReadOnlyClasses());
        this.wasTransactionBegunPrematurely = false;
        this.shouldNewObjectsBeCached = false;
        this.validationLevel = 1;
        this.shouldPerformDeletesFirst = false;
        this.shouldThrowConformExceptions = 0;
        this.isSynchronized = false;
        this.lifecycle = 0;
        this.shouldCheckWriteLock = session.getDatasourceLogin().shouldSynchronizedReadOnWrite() || session.getDatasourceLogin().shouldSynchronizeWrites();
        this.isNestedUnitOfWork = session.isUnitOfWork();
        this.getEventManager().postAcquireUnitOfWork();
        this.incrementProfile("UnitOfWork");
    }

    public oracle.toplink.sessions.Session acquireHistoricalSession(AsOfClause asOfClause) throws ValidationException {
        throw ValidationException.cannotAcquireHistoricalSession();
    }

    public UnitOfWork acquireUnitOfWork() {
        UnitOfWork unitOfWork = super.acquireUnitOfWork();
        unitOfWork.discoverAllUnregisteredNewObjectsInParent();
        return unitOfWork;
    }

    public void addNewAggregate(Object object) {
        this.getNewAggregates().put(object, object);
    }

    public void addObjectDeletedDuringCommit(Object object) {
        this.getObjectsDeletedDuringCommit().put(object, this.keyFromObject(object));
    }

    public void addReadOnlyClass(Class clazz) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        this.getReadOnlyClasses().put(clazz, clazz);
        Descriptor descriptor = this.getDescriptor(clazz);
        if (descriptor.hasInheritance()) {
            Enumeration enumeration = descriptor.getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                Descriptor descriptor2 = (Descriptor)enumeration.nextElement();
                this.addReadOnlyClass(descriptor2.getJavaClass());
            }
        }
    }

    public void addReadOnlyClasses(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            this.addReadOnlyClass(clazz);
        }
    }

    public void addRemovedObject(Object object) {
        this.getRemovedObjects().put(object, object);
    }

    public void assignSequenceNumber(Object object) throws DatabaseException {
        this.startOperationProfile("assign sequence");
        try {
            ObjectBuilder objectBuilder = this.getDescriptor(object).getObjectBuilder();
            if (objectBuilder.getDescriptor().usesSequenceNumbers() && !this.getSequencing().shouldAcquireValueAfterInsert(object.getClass())) {
                Object object2 = objectBuilder.unwrapObject(object, this);
                objectBuilder.assignSequenceNumber(object2, this);
            }
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
        this.endOperationProfile("assign sequence");
    }

    public void assignSequenceNumbers() throws DatabaseException {
        Object object;
        this.discoverAllUnregisteredNewObjects();
        Sequencing sequencing = this.getSequencing();
        if (sequencing == null) {
            return;
        }
        int n = sequencing.whenShouldAcquireValueForAll();
        if (n == 1) {
            return;
        }
        boolean bl = n == -1;
        this.startOperationProfile("assign sequence");
        Enumeration enumeration = this.getUnregisteredNewObjects().keys();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!this.getDescriptor(object).usesSequenceNumbers() || this.isObjectRegistered(object) && !this.isCloneNewObject(object) || !bl && sequencing.shouldAcquireValueAfterInsert(object.getClass())) continue;
            this.getDescriptor(object).getObjectBuilder().assignSequenceNumber(object, this);
        }
        object = this.getNewObjectsCloneToOriginal().keys();
        while (object.hasMoreElements()) {
            Object e = object.nextElement();
            if (!this.getDescriptor(e).usesSequenceNumbers() || this.isObjectRegistered(e) && !this.isCloneNewObject(e) || !bl && sequencing.shouldAcquireValueAfterInsert(e.getClass())) continue;
            this.getDescriptor(e).getObjectBuilder().assignSequenceNumber(e, this);
        }
        this.endOperationProfile("assign sequence");
    }

    public void beginEarlyTransaction() throws DatabaseException {
        this.beginTransaction();
        this.setWasTransactionBegunPrematurely(true);
    }

    public void beginTransaction() throws DatabaseException {
        this.getParent().beginTransaction();
    }

    public Object buildOriginal(Object object) {
        Descriptor descriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.instantiateClone(object, this);
        if (this.checkIfAlreadyRegistered(object, descriptor) != null) {
            this.getCloneToOriginals().put(object, object2);
            return object2;
        }
        Object object3 = objectBuilder.instantiateClone(object, this);
        this.getCloneMapping().put(object, object3);
        this.getNewObjectsCloneToOriginal().put(object, object2);
        this.getNewObjectsOriginalToClone().put(object2, object);
        return object2;
    }

    public oracle.toplink.internal.sessions.UnitOfWorkChangeSet calculateChanges(IdentityHashtable identityHashtable, oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.getEventManager().preCalculateUnitOfWorkChangeSet();
        Enumeration enumeration = identityHashtable.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Descriptor descriptor = this.getDescriptor(e);
            if (!descriptor.getObjectChangePolicy().shouldCompareForChange(e, this, descriptor)) continue;
            ObjectChangeSet objectChangeSet = descriptor.getObjectChangePolicy().calculateChanges(e, this.getBackupClone(e), unitOfWorkChangeSet, this, descriptor);
            if (objectChangeSet != null && objectChangeSet.isNew()) {
                unitOfWorkChangeSet.addNewObjectChangeSet(objectChangeSet, this);
            } else {
                unitOfWorkChangeSet.addObjectChangeSet(objectChangeSet);
            }
            if (objectChangeSet == null || !objectChangeSet.hasChanges() || objectChangeSet.hasForcedChangesFromCascadeLocking()) continue;
            if (descriptor.hasCascadeLockingPolicies()) {
                Enumeration enumeration2 = descriptor.getCascadeLockingPolicies().elements();
                while (enumeration2.hasMoreElements()) {
                    ((CascadeLockingPolicy)enumeration2.nextElement()).lockNotifyParent(e, unitOfWorkChangeSet, this);
                }
                continue;
            }
            if (!descriptor.usesOptimisticLocking() || !descriptor.getOptimisticLockingPolicy().isCascaded()) continue;
            objectChangeSet.setHasForcedChangesFromCascadeLocking(true);
            unitOfWorkChangeSet.addObjectChangeSet(objectChangeSet);
        }
        this.getEventManager().postCalculateUnitOfWorkChangeSet(unitOfWorkChangeSet);
        return unitOfWorkChangeSet;
    }

    protected boolean canChangeReadOnlySet() {
        return !this.hasCloneMapping() && !this.hasDeletedObjects();
    }

    public boolean checkForUnregisteredExistingObject(Object object) {
        Descriptor descriptor = this.getDescriptor(object.getClass());
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
        Object object2 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
        if (object2 != null) {
            return true;
        }
        DoesExistQuery doesExistQuery = descriptor.getQueryManager().getDoesExistQuery();
        if (doesExistQuery.shouldCheckCacheForDoesExist()) {
            return false;
        }
        Boolean bl = (Boolean)doesExistQuery.checkEarlyReturn(object, vector, this, null);
        if (bl != null) {
            return bl != false;
        }
        doesExistQuery = (DoesExistQuery)doesExistQuery.clone();
        doesExistQuery.setObject(object);
        doesExistQuery.setPrimaryKey(vector);
        doesExistQuery.setDescriptor(descriptor);
        return (Boolean)this.executeQuery(doesExistQuery) != false;
    }

    public Object checkExistence(Object object) {
        Descriptor descriptor = this.getDescriptor(object.getClass());
        Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this, true);
        if (vector == null) {
            return null;
        }
        Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
        if (object2 != null) {
            if (this.shouldPerformFullValidation() && object2 != object && this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor) != object) {
                throw ValidationException.wrongObjectRegistered(object, object2);
            }
            return object2;
        }
        DoesExistQuery doesExistQuery = descriptor.getQueryManager().getDoesExistQuery();
        if (doesExistQuery.shouldCheckCacheForDoesExist()) {
            return null;
        }
        Boolean bl = (Boolean)doesExistQuery.checkEarlyReturn(object, vector, this, null);
        if (bl != null) {
            if (bl.booleanValue()) {
                return this.cloneAndRegisterObject(object, new CacheKey(vector), descriptor);
            }
            return null;
        }
        doesExistQuery = (DoesExistQuery)doesExistQuery.clone();
        doesExistQuery.setObject(object);
        doesExistQuery.setPrimaryKey(vector);
        doesExistQuery.setDescriptor(descriptor);
        if (((Boolean)this.executeQuery(doesExistQuery)).booleanValue()) {
            return this.cloneAndRegisterObject(object, new CacheKey(vector), descriptor);
        }
        return null;
    }

    protected Object checkIfAlreadyRegistered(Object object, Descriptor descriptor) {
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            return null;
        }
        Object object2 = this.getCloneMapping().get(object);
        if (object2 != null) {
            return object;
        }
        if (this.hasNewObjects() && (object2 = this.getNewObjectsOriginalToClone().get(object)) != null) {
            return object2;
        }
        if (this.isNestedUnitOfWork()) {
            if (this.hasNewObjectsInParentOriginalToClone()) {
                object2 = this.getNewObjectsInParentOriginalToClone().get(object);
            }
            if (object2 != null) {
                return object2;
            }
        }
        return null;
    }

    protected Object cloneAndRegisterNewObject(Object object) {
        Descriptor descriptor = this.getDescriptor(object);
        if (this.isNestedUnitOfWork() && descriptor.getObjectChangePolicy() instanceof AttributeChangeTrackingPolicy) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.instantiateWorkingCopyClone(object, this);
        this.getNewObjectsOriginalToClone().put(object, object2);
        this.getCloneMapping().put(object2, object2);
        objectBuilder.populateAttributesForClone(object, object2, this);
        this.registerNewObjectClone(object2, object);
        Object object3 = descriptor.getObjectChangePolicy().buildBackupClone(object2, objectBuilder, this);
        this.getCloneMapping().put(object2, object3);
        return object2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object cloneAndRegisterObject(Object object, CacheKey cacheKey, Descriptor descriptor) {
        CacheKey cacheKey2 = this.getIdentityMapAccessorInstance().acquireLock(cacheKey.getKey(), object.getClass(), descriptor);
        try {
            Object object2 = this.cloneAndRegisterObject(object, cacheKey, cacheKey2, descriptor);
            return object2;
        }
        finally {
            cacheKey2.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object cloneAndRegisterObject(Object object, CacheKey cacheKey, CacheKey cacheKey2, Descriptor descriptor) {
        Iterator iterator;
        Descriptor descriptor2 = descriptor;
        if (object.getClass() != descriptor.getJavaClass()) {
            descriptor2 = this.getDescriptor(object);
        }
        if (this.isNestedUnitOfWork() && descriptor2.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            throw ValidationException.nestedUOWNotSupportedForAttributeTracking();
        }
        ObjectBuilder objectBuilder = descriptor2.getObjectBuilder();
        Object object2 = objectBuilder.instantiateWorkingCopyClone(object, this);
        if (object2 instanceof TopLinkEntity) {
            ((TopLinkEntity)object2).setPKVector(cacheKey.getKey());
        }
        boolean bl = this.shouldCheckWriteLock && this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        boolean bl2 = false;
        if (!bl && this.objectsLockedForClone == null) {
            if (descriptor2.shouldAcquireCascadedLocks()) {
                this.objectsLockedForClone = this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireLocksForClone(object, descriptor2, cacheKey.getKey(), this.getParent());
            } else {
                cacheKey.acquireReadLock();
            }
            bl2 = true;
        }
        try {
            this.getCloneMapping().put(object2, object2);
            if (this.isNestedUnitOfWork() && this.isCloneNewObjectFromParent(object)) {
                this.getNewObjectsInParentOriginalToClone().put(object, object2);
            }
            if (descriptor2.hasFetchGroupManager()) {
                descriptor2.getFetchGroupManager().copyFetchGroupInto(object, object2);
            }
            this.getCloneToOriginals().put(object2, object);
            this.populateAndRegisterObject(object, object2, cacheKey2, cacheKey, descriptor2);
            Object var11_10 = null;
            if (bl) {
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                return object2;
            }
            if (!bl2) return object2;
            if (this.objectsLockedForClone == null) {
                cacheKey.releaseReadLock();
                return object2;
            }
            iterator = this.objectsLockedForClone.values().iterator();
        }
        catch (Throwable throwable) {
            Object var11_11 = null;
            if (bl) {
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                throw throwable;
            }
            if (!bl2) throw throwable;
            if (this.objectsLockedForClone == null) {
                cacheKey.releaseReadLock();
                throw throwable;
            }
            Iterator iterator2 = this.objectsLockedForClone.values().iterator();
            while (true) {
                if (!iterator2.hasNext()) {
                    this.objectsLockedForClone = null;
                    throw throwable;
                }
                ((CacheKey)iterator2.next()).releaseReadLock();
            }
        }
        while (iterator.hasNext()) {
            ((CacheKey)iterator.next()).releaseReadLock();
        }
        this.objectsLockedForClone = null;
        return object2;
    }

    public IdentityHashtable collectAndPrepareObjectsForCommit() {
        Object e;
        IdentityHashtable identityHashtable = new IdentityHashtable(1 + this.getCloneMapping().size());
        if (!this.getProject().isPureCMP2Project()) {
            this.assignSequenceNumbers();
        }
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            identityHashtable.put(e, e);
        }
        enumeration = this.getUnregisteredNewObjects().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            identityHashtable.put(e, e);
        }
        return identityHashtable;
    }

    public IdentityHashtable collectAndPrepareObjectsForNestedMerge() {
        Object e;
        IdentityHashtable identityHashtable = new IdentityHashtable(1 + this.getCloneMapping().size());
        this.discoverAllUnregisteredNewObjectsInParent();
        this.discoverAllUnregisteredNewObjects();
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            identityHashtable.put(e, e);
        }
        enumeration = this.getUnregisteredNewObjects().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            identityHashtable.put(e, e);
        }
        return identityHashtable;
    }

    public void commit() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        if (this.getLifecycle() == 2) {
            this.commitAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.isNestedUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.release();
    }

    public void commitAndResume() throws DatabaseException, OptimisticLockException {
        if (!this.isActive()) {
            throw ValidationException.cannotCommitUOWAgain();
        }
        if (this.isAfterWriteChangesFailed()) {
            throw ValidationException.unitOfWorkAfterWriteChangesFailed("commit");
        }
        if (this.hasUpdateAllQueries() || this.hasDeferredUpdateAllQueries()) {
            throw ValidationException.cannotCommitAndResumeUOWWithUpdateAllQueries();
        }
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            throw ValidationException.cannotCommitAndResumeSynchronizedUOW(this);
        }
        if (this.getLifecycle() == 2) {
            this.commitAndResumeAfterWriteChanges();
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWork();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeWithPreBuiltChangeSet(oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        if (!this.isNestedUnitOfWork() && this.isSynchronized()) {
            if (this.getParent().wasJTSTransactionInternallyStarted()) {
                this.commitInternallyStartedExternalTransaction();
            }
            return;
        }
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.getParent().isUnitOfWork()) {
            this.commitNestedUnitOfWork();
        } else {
            this.commitRootUnitOfWorkWithPreBuiltChangeSet(unitOfWorkChangeSet);
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    public void commitAndResumeOnFailure() throws DatabaseException, OptimisticLockException {
        IdentityMapManager identityMapManager = (IdentityMapManager)this.getIdentityMapAccessorInstance().getIdentityMapManager().clone();
        try {
            this.commitAndResume();
        }
        catch (RuntimeException runtimeException) {
            this.setUnitOfWorkChangeSet(null);
            this.getIdentityMapAccessorInstance().setIdentityMapManager(identityMapManager);
            this.log(2, "transaction", "resuming_unit_of_work_from_failure");
            throw runtimeException;
        }
    }

    protected void commitAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.setDead();
        this.release();
    }

    protected void commitAndResumeAfterWriteChanges() {
        this.commitTransactionAfterWriteChanges();
        this.mergeClonesAfterCompletion();
        this.log(2, "transaction", "resume_unit_of_work");
        this.synchronizeAndResume();
        this.getEventManager().postResumeUnitOfWork();
    }

    protected boolean commitInternallyStartedExternalTransaction() {
        boolean bl = false;
        if (!this.getParent().isInTransaction() || this.wasTransactionBegunPrematurely() && this.getParent().getTransactionMutex().getDepth() == 1) {
            bl = this.getParent().commitExternalTransaction();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void commitNestedUnitOfWork() {
        this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
        try {
            Enumeration enumeration;
            this.setAllClonesCollection(this.collectAndPrepareObjectsForNestedMerge());
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
            }
            this.unitOfWorkChangeSet = this.calculateChanges(this.getAllClones(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
            this.mergeChangesIntoParent();
            if (this.hasDeletedObjects()) {
                enumeration = this.getDeletedObjects().keys();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    Object object = this.getOriginalVersionOfObject(e);
                    if (object != null && ((UnitOfWork)this.getParent()).getNewObjectsCloneToOriginal().containsKey(object)) {
                        ((UnitOfWork)this.getParent()).unregisterObject(object);
                        continue;
                    }
                    ((UnitOfWork)this.getParent()).getDeletedObjects().put(object, this.keyFromObject(object));
                }
            }
            if (this.hasRemovedObjects()) {
                enumeration = this.getRemovedObjects().elements();
                while (enumeration.hasMoreElements()) {
                    ((UnitOfWork)this.getParent()).getCloneMapping().remove(enumeration.nextElement());
                }
            }
        }
        finally {
            this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
        }
    }

    public void commitRootUnitOfWork() throws DatabaseException, OptimisticLockException {
        if (this.usesOldCommit()) {
            this.commitToDatabaseOldCommit(true);
        } else {
            this.commitToDatabaseWithChangeSet(true);
        }
        this.mergeChangesIntoParent();
    }

    public void commitRootUnitOfWorkWithPreBuiltChangeSet(oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet) throws DatabaseException, OptimisticLockException {
        this.commitToDatabaseWithPreBuiltChangeSet(unitOfWorkChangeSet, true);
        this.mergeChangesIntoParent();
    }

    protected void commitToDatabaseOldCommit(boolean bl) throws DatabaseException, OptimisticLockException {
        try {
            this.startOperationProfile("UnitOfWorkCommits");
            this.getCommitManager().setIsActive(true);
            IdentityHashtable identityHashtable = this.collectAndPrepareObjectsForCommit();
            this.setAllClonesCollection((IdentityHashtable)identityHashtable.clone());
            try {
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                Vector vector = new Vector();
                if (this.hasDeletedObjects()) {
                    Enumeration enumeration = this.getDeletedObjects().keys();
                    while (enumeration.hasMoreElements()) {
                        vector.addElement(enumeration.nextElement());
                    }
                }
                if (this.shouldPerformDeletesFirst) {
                    this.getCommitManager().deleteAllObjects(vector);
                    int n = vector.size();
                    for (int i = 0; i < n; ++i) {
                        this.revertObject(vector.elementAt(i));
                    }
                    super.writeAllObjects(identityHashtable);
                } else {
                    super.writeAllObjects(identityHashtable);
                    this.getCommitManager().deleteAllObjects(vector);
                }
                this.getEventManager().prepareUnitOfWork();
                if (bl) {
                    this.commitTransaction();
                }
            }
            catch (RuntimeException runtimeException) {
                this.rollbackTransaction(bl);
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(runtimeException);
                }
                throw runtimeException;
            }
            this.endOperationProfile("UnitOfWorkCommits");
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    protected void commitToDatabase(boolean bl) {
        block19: {
            try {
                Enumeration enumeration;
                if (this.wasTransactionBegunPrematurely()) {
                    this.setWasTransactionBegunPrematurely(false);
                } else {
                    this.beginTransaction();
                }
                Vector vector = null;
                if (this.hasDeletedObjects()) {
                    vector = new Vector(this.getDeletedObjects().size());
                    enumeration = this.getDeletedObjects().keys();
                    while (enumeration.hasMoreElements()) {
                        vector.addElement(enumeration.nextElement());
                    }
                }
                if (this.shouldPerformDeletesFirst) {
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(vector);
                        enumeration = this.getObjectsDeletedDuringCommit().keys();
                        while (enumeration.hasMoreElements()) {
                            ObjectChangeSet objectChangeSet = (ObjectChangeSet)this.unitOfWorkChangeSet.getObjectChangeSetForClone(enumeration.nextElement());
                            if (objectChangeSet == null) continue;
                            objectChangeSet.clear();
                        }
                    }
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    this.issueUpdateAllQueryList();
                } else {
                    super.writeAllObjectsWithChangeSet(this.unitOfWorkChangeSet);
                    if (this.hasDeletedObjects()) {
                        this.getCommitManager().deleteAllObjects(vector);
                    }
                    this.issueUpdateAllQueryList();
                }
                this.getEventManager().prepareUnitOfWork();
                if (bl) {
                    try {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase()) {
                            this.setMergeManager(new MergeManager(this));
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                        }
                        this.commitTransaction();
                        break block19;
                    }
                    catch (RuntimeException runtimeException) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw runtimeException;
                    }
                    catch (Error error) {
                        if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                            this.setMergeManager(null);
                        }
                        throw error;
                    }
                }
                this.setWasTransactionBegunPrematurely(true);
            }
            catch (RuntimeException runtimeException) {
                this.rollbackTransaction(bl);
                if (this.hasExceptionHandler()) {
                    this.getExceptionHandler().handleException(runtimeException);
                }
                throw runtimeException;
            }
        }
    }

    protected void commitToDatabaseWithChangeSet(boolean bl) throws DatabaseException, OptimisticLockException {
        try {
            this.startOperationProfile("UnitOfWorkCommits");
            this.getCommitManager().setIsActive(true);
            IdentityHashtable identityHashtable = this.collectAndPrepareObjectsForCommit();
            this.setAllClonesCollection((IdentityHashtable)identityHashtable.clone());
            if (this.getUnitOfWorkChangeSet() == null) {
                this.setUnitOfWorkChangeSet(new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
            }
            this.calculateChanges(this.getAllClones(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
            if (this.getUnitOfWorkChangeSet().hasChanges() && (this.hasUpdateAllQueries() || this.hasDeferredUpdateAllQueries())) {
                throw ValidationException.cannotIssueUpdateAllQueryWithOtherWritesWithinUOW();
            }
            if (this.hasModifications()) {
                this.commitToDatabase(bl);
            } else {
                if (this.wasTransactionBegunPrematurely() && bl) {
                    this.setWasTransactionBegunPrematurely(false);
                    this.commitTransaction();
                }
                this.getCommitManager().setIsActive(false);
            }
            this.endOperationProfile("UnitOfWorkCommits");
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    protected void commitToDatabaseWithPreBuiltChangeSet(oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet, boolean bl) throws DatabaseException, OptimisticLockException {
        try {
            this.getCommitManager().setIsActive(true);
            this.setAllClonesCollection(new IdentityHashtable());
            this.setUnitOfWorkChangeSet(unitOfWorkChangeSet);
            this.commitToDatabase(bl);
        }
        catch (RuntimeException runtimeException) {
            this.handleException(runtimeException);
        }
    }

    public void commitTransaction() throws DatabaseException {
        this.getParent().commitTransaction();
    }

    protected void commitTransactionAfterWriteChanges() {
        if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
            try {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getUnitOfWorkChangeSet() != null) {
                    this.setMergeManager(new MergeManager(this));
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                this.setWasTransactionBegunPrematurely(false);
                this.commitTransaction();
            }
            catch (RuntimeException runtimeException) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                this.rollbackTransaction();
                this.release();
                this.handleException(runtimeException);
            }
            catch (Error error) {
                if (this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWriteDatabase() && this.getMergeManager() != null) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
                    this.setMergeManager(null);
                }
                throw error;
            }
        }
    }

    public Vector copyReadOnlyClasses() {
        return Helper.buildVectorFromHashtableElements(this.getReadOnlyClasses());
    }

    public Object deepMergeClone(Object object) {
        return this.mergeClone(object, 3);
    }

    public Object deepRevertObject(Object object) {
        return this.revertObject(object, 3);
    }

    public void deepUnregisterObject(Object object) {
        this.unregisterObject(object, 3);
    }

    public void deleteAllObjects(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.deleteObject(enumeration.nextElement());
        }
    }

    protected void discoverAllUnregisteredNewObjects() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        IdentityHashtable identityHashtable2 = new IdentityHashtable();
        IdentityHashtable identityHashtable3 = new IdentityHashtable();
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            this.discoverUnregisteredNewObjects(e, identityHashtable2, identityHashtable3, identityHashtable);
        }
        this.setUnregisteredNewObjects(identityHashtable2);
        this.setUnregisteredExistingObjects(identityHashtable3);
    }

    protected void discoverAllUnregisteredNewObjectsInParent() {
        IdentityHashtable identityHashtable = new IdentityHashtable();
        IdentityHashtable identityHashtable2 = new IdentityHashtable();
        if (this.isNestedUnitOfWork()) {
            Enumeration enumeration = ((UnitOfWork)this.getParent()).getCloneMapping().keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                ((UnitOfWork)this.getParent()).discoverUnregisteredNewObjects(e, identityHashtable2, new IdentityHashtable(), identityHashtable);
            }
        }
        this.setUnregisteredNewObjectsInParent(identityHashtable2);
    }

    public void discoverUnregisteredNewObjects(Object object, IdentityHashtable identityHashtable, IdentityHashtable identityHashtable2, IdentityHashtable identityHashtable3) {
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (UnitOfWork.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                if (UnitOfWork.isSmartMerge() && UnitOfWork.this.isOriginalNewObject(object)) {
                    return;
                }
                if (!UnitOfWork.this.isObjectRegistered(object)) {
                    if (UnitOfWork.this.shouldPerformNoValidation() && UnitOfWork.this.checkForUnregisteredExistingObject(object)) {
                        UnitOfWork.this.getUnregisteredExistingObjects().put(object, object);
                        this.setShouldBreak(true);
                        return;
                    }
                    ((IdentityHashtable)this.getResult()).put(object, object);
                }
            }
        };
        this.setUnregisteredExistingObjects(identityHashtable2);
        descriptorIterator.setVisitedObjects(identityHashtable3);
        descriptorIterator.setResult(identityHashtable);
        descriptorIterator.setSession(this);
        descriptorIterator.setShouldIterateOverWrappedObjects(false);
        descriptorIterator.startIterationOn(object);
    }

    public void dontPerformValidation() {
        this.setValidationLevel(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeCall(Call call, DatabaseRow databaseRow, DatabaseQuery databaseQuery) throws DatabaseException {
        Accessor accessor = databaseQuery.getSessionName() == null ? databaseQuery.getSession().getAccessor(databaseQuery.getReferenceClass()) : databaseQuery.getSession().getAccessor(databaseQuery.getSessionName());
        databaseQuery.setAccessor(accessor);
        try {
            Object object = databaseQuery.getAccessor().executeCall(call, databaseRow, this);
            return object;
        }
        finally {
            if (call.isFinished()) {
                databaseQuery.setAccessor(null);
            }
        }
    }

    public void forceUpdateToVersionField(Object object, boolean bl) {
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        this.getOptimisticReadLockObjects().put(descriptor.getObjectBuilder().unwrapObject(object, this), new Boolean(bl));
    }

    public Accessor getAccessor() {
        return this.getParent().getAccessor();
    }

    public CommitManager getCommitManager() {
        if (this.commitManager == null) {
            this.commitManager = new CommitManager(this);
            this.commitManager.setCommitOrder(this.getParent().getCommitManager().getCommitOrder());
        }
        return this.commitManager;
    }

    public Accessor getAccessor(Class clazz) {
        return this.getParent().getAccessor(clazz);
    }

    public Accessor getAccessor(String string) {
        return this.getParent().getAccessor(string);
    }

    public oracle.toplink.sessions.UnitOfWork getActiveUnitOfWork() {
        return this.getParent().getActiveUnitOfWork();
    }

    protected IdentityHashtable getAllClones() {
        return this.allClones;
    }

    public Vector getAllFromNewObjects(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (this.shouldNewObjectsBeCached() && expression != null) {
            return new Vector(1);
        }
        if (!this.hasNewObjects()) {
            return new Vector(1);
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.getNewObjectsOriginalToClone().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!clazz.isInstance(e)) continue;
            if (expression == null) {
                vector.addElement(e);
                continue;
            }
            if (!expression.doesConform(e, this, databaseRow, inMemoryQueryIndirectionPolicy)) continue;
            vector.addElement(e);
        }
        return vector;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getBackupClone(Object object) throws QueryException {
        Object object2 = this.getCloneMapping().get(object);
        if (object2 != null) {
            return object2;
        }
        if (this.isObjectRegistered(object)) {
            return this.getCloneMapping().get(object);
        }
        Vector vector = this.keyFromObject(object);
        if (this.getParent().getIdentityMapAccessor().containsObjectInIdentityMap(vector, object.getClass())) {
            if (this.getUnregisteredNewObjects().get(object) != null && this.isMergePending()) {
                return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
            }
            if (!this.hasObjectsDeletedDuringCommit()) throw QueryException.backupCloneIsOriginalFromParent(object);
            if (!this.getObjectsDeletedDuringCommit().containsKey(object)) throw QueryException.backupCloneIsOriginalFromParent(object);
            throw QueryException.backupCloneIsDeleted(object);
        }
        if (!this.hasNewObjects()) return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
        if (!this.getNewObjectsOriginalToClone().containsKey(object)) return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
        if (!UnitOfWork.isSmartMerge()) throw QueryException.backupCloneIsOriginalFromSelf(object);
        return this.getCloneMapping().get(this.getNewObjectsOriginalToClone().get(object));
    }

    public Object getBackupCloneForCommit(Object object) {
        Object object2 = this.getBackupClone(object);
        if (this.isCloneNewObject(object)) {
            return this.getDescriptor(object).getObjectBuilder().buildNewInstance();
        }
        return object2;
    }

    public oracle.toplink.internal.sessions.UnitOfWorkChangeSet getChanges() {
        IdentityHashtable identityHashtable = null;
        identityHashtable = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(identityHashtable, new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
    }

    public UnitOfWorkChangeSet getCurrentChanges() {
        IdentityHashtable identityHashtable = null;
        identityHashtable = this.collectAndPrepareObjectsForNestedMerge();
        return this.calculateChanges(identityHashtable, new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
    }

    public Session getParentIdentityMapSession(DatabaseQuery databaseQuery, boolean bl, boolean bl2) {
        if (bl && !bl2) {
            return this;
        }
        return this.getParent().getParentIdentityMapSession(databaseQuery, true, bl2);
    }

    public Session getExecutionSession(DatabaseQuery databaseQuery) {
        return this.getParent().getExecutionSession(databaseQuery);
    }

    public IdentityHashtable getCloneMapping() {
        if (this.cloneMapping == null) {
            this.cloneMapping = new IdentityHashtable();
        }
        return this.cloneMapping;
    }

    protected boolean hasCloneMapping() {
        return this.cloneMapping != null && !this.cloneMapping.isEmpty();
    }

    public IdentityHashtable getCloneToOriginals() {
        if (this.cloneToOriginals == null) {
            this.cloneToOriginals = new IdentityHashtable();
        }
        return this.cloneToOriginals;
    }

    protected boolean hasCloneToOriginals() {
        return this.cloneToOriginals != null && !this.cloneToOriginals.isEmpty();
    }

    public IdentityHashtable getContainerBeans() {
        if (this.containerBeans == null) {
            this.containerBeans = new IdentityHashtable();
        }
        return this.containerBeans;
    }

    public boolean hasContainerBeans() {
        return this.containerBeans != null && !this.containerBeans.isEmpty();
    }

    public boolean hasNewObjects() {
        return this.newObjectsOriginalToClone != null && !this.newObjectsOriginalToClone.isEmpty();
    }

    public UnitOfWork getContainerUnitOfWork() {
        if (this.containerUnitOfWork == null) {
            this.containerUnitOfWork = this.getParent().acquireNonSynchronizedUnitOfWork();
        }
        return this.containerUnitOfWork;
    }

    public Vector getDefaultReadOnlyClasses() {
        return this.getParent().getDefaultReadOnlyClasses();
    }

    public IdentityHashtable getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashtable();
        }
        return this.deletedObjects;
    }

    protected boolean hasDeletedObjects() {
        return this.deletedObjects != null && !this.deletedObjects.isEmpty();
    }

    public int getLifecycle() {
        return this.lifecycle;
    }

    public MergeManager getMergeManager() {
        return this.lastUsedMergeManager;
    }

    public IdentityHashtable getNewAggregates() {
        if (this.newAggregates == null) {
            this.newAggregates = new IdentityHashtable();
        }
        return this.newAggregates;
    }

    public synchronized IdentityHashtable getNewObjectsCloneToOriginal() {
        if (this.newObjectsCloneToOriginal == null) {
            this.newObjectsCloneToOriginal = new IdentityHashtable();
        }
        return this.newObjectsCloneToOriginal;
    }

    public IdentityHashtable getNewObjectsInParentOriginalToClone() {
        if (this.newObjectsInParentOriginalToClone == null) {
            this.newObjectsInParentOriginalToClone = new IdentityHashtable();
        }
        return this.newObjectsInParentOriginalToClone;
    }

    protected boolean hasNewObjectsInParentOriginalToClone() {
        return this.newObjectsInParentOriginalToClone != null && !this.newObjectsInParentOriginalToClone.isEmpty();
    }

    public boolean hasOptimisticReadLockObjects() {
        return this.optimisticReadLockObjects != null && !this.optimisticReadLockObjects.isEmpty();
    }

    public synchronized IdentityHashtable getNewObjectsOriginalToClone() {
        if (this.newObjectsOriginalToClone == null) {
            this.newObjectsOriginalToClone = new IdentityHashtable();
        }
        return this.newObjectsOriginalToClone;
    }

    public Sequencing getSequencing() {
        return this.getParent().getSequencing();
    }

    public ServerPlatform getServerPlatform() {
        return this.getParent().getServerPlatform();
    }

    public String getSessionTypeString() {
        return "UnitOfWork";
    }

    public void afterTransaction(boolean bl, boolean bl2) {
        if (!bl && bl2) {
            this.getParent().setWasJTSTransactionInternallyStarted(false);
            this.setLifecycle(6);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.getParent().afterTransaction(bl, bl2);
    }

    public Object getObjectFromNewObjects(Class clazz, Vector vector) {
        if (!this.hasNewObjects()) {
            return null;
        }
        ObjectBuilder objectBuilder = this.getDescriptor(clazz).getObjectBuilder();
        Enumeration enumeration = this.getNewObjectsOriginalToClone().elements();
        while (enumeration.hasMoreElements()) {
            Vector vector2;
            Object e = enumeration.nextElement();
            if (!clazz.isInstance(e) || !new CacheKey(vector2 = objectBuilder.extractPrimaryKeyFromObject(e, this)).equals(new CacheKey(vector))) continue;
            return e;
        }
        return null;
    }

    public Object getObjectFromNewObjects(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) {
        if (!this.hasNewObjects()) {
            return null;
        }
        Enumeration enumeration = this.getNewObjectsOriginalToClone().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!clazz.isInstance(e)) continue;
            if (expression == null) {
                return e;
            }
            if (!expression.doesConform(e, this, databaseRow, inMemoryQueryIndirectionPolicy)) continue;
            return e;
        }
        return null;
    }

    public IdentityHashtable getObjectsDeletedDuringCommit() {
        if (this.objectsDeletedDuringCommit == null) {
            this.objectsDeletedDuringCommit = new IdentityHashtable();
        }
        return this.objectsDeletedDuringCommit;
    }

    protected boolean hasObjectsDeletedDuringCommit() {
        return this.objectsDeletedDuringCommit != null && !this.objectsDeletedDuringCommit.isEmpty();
    }

    public Hashtable getOptimisticReadLockObjects() {
        if (this.optimisticReadLockObjects == null) {
            this.optimisticReadLockObjects = new Hashtable(2);
        }
        return this.optimisticReadLockObjects;
    }

    public Object getOriginalVersionOfNewObject(Object object) {
        if (!this.hasNewObjects()) {
            return null;
        }
        return this.getNewObjectsCloneToOriginal().get(object);
    }

    public Object getOriginalVersionOfObject(Object object) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object2, this);
        Object object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object2.getClass(), descriptor);
        if (object3 == null) {
            object3 = this.getOriginalVersionOfNewObject(object2);
        }
        if (object3 == null) {
            if (this.isClassReadOnly(object2.getClass(), descriptor)) {
                return object2;
            }
            if (this.hasCloneToOriginals()) {
                object3 = this.getCloneToOriginals().get(object);
            }
        }
        if (object3 == null) {
            object3 = this.buildOriginal(object2);
        }
        return object3;
    }

    public Object getOriginalVersionOfObjectOrNull(Object object) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Vector vector = objectBuilder.extractPrimaryKeyFromObject(object2, this);
        Object object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object2.getClass(), descriptor);
        if (object3 == null) {
            object3 = this.getOriginalVersionOfNewObject(object2);
        }
        if (object3 == null) {
            if (this.isClassReadOnly(object2.getClass(), descriptor)) {
                return object2;
            }
            if (this.hasCloneToOriginals()) {
                object3 = this.getCloneToOriginals().get(object);
            }
        }
        return object3;
    }

    public Session getParent() {
        return this.parent;
    }

    public Platform getPlatform(Class clazz) {
        return this.getParent().getPlatform(clazz);
    }

    public int getShouldThrowConformExceptions() {
        return this.shouldThrowConformExceptions;
    }

    public DatabaseQuery getQuery(String string, Vector vector) {
        DatabaseQuery databaseQuery = super.getQuery(string, vector);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string, vector);
        }
        return databaseQuery;
    }

    public DatabaseQuery getQuery(String string) {
        DatabaseQuery databaseQuery = super.getQuery(string);
        if (databaseQuery == null) {
            databaseQuery = this.getParent().getQuery(string);
        }
        return databaseQuery;
    }

    public Hashtable getReadOnlyClasses() {
        return this.readOnlyClasses;
    }

    protected IdentityHashtable getRemovedObjects() {
        if (this.removedObjects == null) {
            this.removedObjects = new IdentityHashtable();
        }
        return this.removedObjects;
    }

    protected boolean hasRemovedObjects() {
        return this.removedObjects != null && !this.removedObjects.isEmpty();
    }

    protected boolean hasUpdateAllQueries() {
        return this.updateAllQueries != null && !this.updateAllQueries.isEmpty();
    }

    protected boolean hasDeferredUpdateAllQueries() {
        return this.deferredUpdateAllQueries != null && !this.deferredUpdateAllQueries.isEmpty();
    }

    public int getState() {
        return this.lifecycle;
    }

    public ObjectTracker getObjectTracker() {
        return this.objectTracker;
    }

    public void setObjectTracker(ObjectTracker objectTracker) {
        this.objectTracker = objectTracker;
    }

    public Object getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Object object) {
        this.transaction = object;
    }

    public UnitOfWorkChangeSet getUnitOfWorkChangeSet() {
        return this.unitOfWorkChangeSet;
    }

    public IdentityHashtable getUnregisteredExistingObjects() {
        if (this.unregisteredExistingObjects == null) {
            this.unregisteredExistingObjects = new IdentityHashtable();
        }
        return this.unregisteredExistingObjects;
    }

    protected IdentityHashtable getUnregisteredNewObjects() {
        if (this.unregisteredNewObjects == null) {
            this.unregisteredNewObjects = new IdentityHashtable();
        }
        return this.unregisteredNewObjects;
    }

    protected IdentityHashtable getUnregisteredNewObjectsInParent() {
        if (this.unregisteredNewObjectsInParent == null) {
            this.unregisteredNewObjectsInParent = new IdentityHashtable();
        }
        return this.unregisteredNewObjectsInParent;
    }

    public int getValidationLevel() {
        return this.validationLevel;
    }

    public boolean hasChanges() {
        if (this.hasNewObjects()) {
            return true;
        }
        IdentityHashtable identityHashtable = this.collectAndPrepareObjectsForNestedMerge();
        if (!this.getUnregisteredNewObjects().isEmpty()) {
            return true;
        }
        if (this.hasDeletedObjects()) {
            return true;
        }
        oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet = this.calculateChanges(identityHashtable, new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
        return unitOfWorkChangeSet.hasChanges();
    }

    protected boolean hasModifications() {
        return this.getUnitOfWorkChangeSet().hasChanges() || this.hasDeletedObjects() || this.hasDeferredUpdateAllQueries() || ((oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).hasForcedChanges();
    }

    public void initializeIdentityMapAccessor() {
        this.identityMapAccessor = new UnitOfWorkIdentityMapAccessor(this, new IdentityMapManager(this));
    }

    public Object internalExecuteQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) throws DatabaseException, QueryException {
        if (!this.isActive()) {
            throw QueryException.querySentToInactiveUnitOfWork(databaseQuery);
        }
        return databaseQuery.executeInUnitOfWork(this, databaseRow);
    }

    public Object internalRegisterObject(Object object, Descriptor descriptor) {
        if (object == null) {
            return null;
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object object2 = this.checkIfAlreadyRegistered(object, descriptor);
        if (object2 == null) {
            UnitOfWork unitOfWork;
            if (this.isNestedUnitOfWork() && ((unitOfWork = (UnitOfWork)this.getParent()).isObjectRegistered(object) || this.isUnregisteredNewObjectInParent(object))) {
                if (this.isCloneNewObjectFromParent(object) || this.isUnregisteredNewObjectInParent(object)) {
                    object2 = this.cloneAndRegisterObject(object, new CacheKey(this.keyFromObject(object)), descriptor);
                } else {
                    Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                    object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, descriptor.getJavaClass(), descriptor);
                }
                return object2;
            }
            object2 = this.checkExistence(object);
            if (object2 == null) {
                object2 = this.cloneAndRegisterNewObject(object);
            }
        }
        return object2;
    }

    public boolean isActive() {
        return !this.isDead();
    }

    public boolean isClassReadOnly(Class clazz, Descriptor descriptor) {
        if (descriptor != null && descriptor.shouldBeReadOnly()) {
            return true;
        }
        return clazz != null && this.getReadOnlyClasses().containsKey(clazz);
    }

    public boolean isCloneNewObjectFromParent(Object object) {
        if (this.getParent().isUnitOfWork()) {
            if (((UnitOfWork)this.getParent()).isCloneNewObject(object)) {
                return true;
            }
            if (((UnitOfWork)this.getParent()).isObjectRegistered(object)) {
                object = ((UnitOfWork)this.getParent()).getCloneToOriginals().get(object);
            }
            return ((UnitOfWork)this.getParent()).isCloneNewObjectFromParent(object);
        }
        return false;
    }

    public boolean isCloneNewObject(Object object) {
        if (!this.hasNewObjects()) {
            return false;
        }
        return this.getNewObjectsCloneToOriginal().containsKey(object);
    }

    public boolean isCommitPending() {
        return this.getLifecycle() == 1;
    }

    public boolean isDead() {
        return this.getLifecycle() == 5;
    }

    public boolean isInTransaction() {
        return this.getParent().isInTransaction();
    }

    public boolean isMergePending() {
        return this.getLifecycle() == 4;
    }

    public boolean isAfterWriteChangesButBeforeCommit() {
        return this.getLifecycle() == 2 || this.getLifecycle() == 3;
    }

    protected boolean isAfterWriteChangesFailed() {
        return this.getLifecycle() == 3;
    }

    public boolean isNestedUnitOfWork() {
        return this.isNestedUnitOfWork;
    }

    public boolean isNewObjectInParent(Object object) {
        Object object2 = null;
        if (this.hasCloneToOriginals()) {
            object2 = this.getCloneToOriginals().get(object);
        }
        if (object2 != null) {
            return ((UnitOfWork)this.getParent()).getNewObjectsCloneToOriginal().containsKey(object2);
        }
        return false;
    }

    public boolean isObjectDeleted(Object object) {
        boolean bl = false;
        if (this.hasDeletedObjects()) {
            bl = this.getDeletedObjects().containsKey(object);
        }
        if (this.getParent().isUnitOfWork()) {
            return bl || ((UnitOfWork)this.getParent()).isObjectDeleted(object);
        }
        return bl;
    }

    public boolean isObjectNew(Object object) {
        return this.isCloneNewObject(object) || !this.isObjectRegistered(object) && !this.getReadOnlyClasses().contains(object.getClass());
    }

    public boolean isObjectRegistered(Object object) {
        if (this.getCloneMapping().containsKey(object)) {
            return true;
        }
        if (UnitOfWork.isSmartMerge() && this.getParent().getIdentityMapAccessor().containsObjectInIdentityMap(this.keyFromObject(object), object.getClass())) {
            this.mergeCloneWithReferences(object);
            return true;
        }
        return false;
    }

    public boolean isOriginalNewObject(Object object) {
        return this.hasNewObjects() && this.getNewObjectsOriginalToClone().containsKey(object) || this.getNewAggregates().containsKey(object);
    }

    public static boolean isSmartMerge() {
        return SmartMerge;
    }

    public void issueSQLbeforeCompletion() {
        this.issueSQLbeforeCompletion(true);
    }

    public void issueSQLbeforeCompletion(boolean bl) {
        if (this.getLifecycle() == 2) {
            this.commitTransactionAfterWriteChanges();
            return;
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        if (this.usesOldCommit()) {
            this.commitToDatabaseOldCommit(bl);
        } else {
            this.commitToDatabaseWithChangeSet(bl);
        }
    }

    protected void issueUpdateAllQueryList() {
        if (this.deferredUpdateAllQueries != null) {
            for (int i = 0; i < this.deferredUpdateAllQueries.size(); ++i) {
                Object[] objectArray = (Object[])this.deferredUpdateAllQueries.get(i);
                UpdateAllQuery updateAllQuery = (UpdateAllQuery)objectArray[0];
                DatabaseRow databaseRow = (DatabaseRow)objectArray[1];
                int n = updateAllQuery.getCacheUsage();
                updateAllQuery.setCacheUsage(0);
                this.getParent().executeQuery((DatabaseQuery)updateAllQuery, databaseRow);
                updateAllQuery.setCacheUsage(n);
            }
        }
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean isUnitOfWork() {
        return true;
    }

    public boolean isUnregisteredNewObjectInParent(Object object) {
        return this.getUnregisteredNewObjectsInParent().containsKey(object);
    }

    protected void mergeBmpAndWsEntities() {
        if (this.hasContainerBeans()) {
            Enumeration enumeration = this.getContainerBeans().keys();
            while (enumeration.hasMoreElements()) {
                this.mergeCloneWithReferences(enumeration.nextElement());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeChangesIntoParent() {
        oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet = (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
        if (unitOfWorkChangeSet == null) {
            this.setUnitOfWorkChangeSet(new oracle.toplink.internal.sessions.UnitOfWorkChangeSet());
            unitOfWorkChangeSet = (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet();
            this.calculateChanges(this.getAllClones(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
        }
        if (this.hasModifications()) {
            this.setPendingMerge();
            this.startOperationProfile("merge");
            this.getParent().getIdentityMapAccessorInstance().acquireWriteLock();
            MergeManager mergeManager = this.getMergeManager();
            if (mergeManager == null) {
                mergeManager = new MergeManager(this);
            }
            try {
                Object object;
                ObjectChangeSet objectChangeSet;
                Object object2;
                boolean bl = this.isNestedUnitOfWork();
                if (!bl) {
                    this.preMergeChanges();
                }
                this.getParent().getEventManager().preMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
                if (!bl && this.getDatasourceLogin().shouldSynchronizeObjectLevelReadWrite()) {
                    this.setMergeManager(mergeManager);
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().acquireRequiredLocks(this.getMergeManager(), (oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet());
                }
                Enumeration enumeration = ((oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getObjectChanges().elements();
                block4: while (enumeration.hasMoreElements()) {
                    Hashtable hashtable = (Hashtable)((Hashtable)enumeration.nextElement()).clone();
                    if (hashtable == null) continue;
                    object2 = hashtable.elements();
                    while (object2.hasMoreElements()) {
                        objectChangeSet = (ObjectChangeSet)object2.nextElement();
                        if (objectChangeSet.hasChanges()) {
                            object = objectChangeSet.getUnitOfWorkClone();
                            Descriptor descriptor = this.getDescriptor(object);
                            if (!bl && descriptor.shouldIsolateObjectsInUnitOfWork()) continue block4;
                            mergeManager.mergeChanges(object, objectChangeSet);
                            continue;
                        }
                        unitOfWorkChangeSet.removeObjectChangeSet(objectChangeSet);
                    }
                }
                if (this.updateAllQueries != null) {
                    for (int i = 0; i < this.updateAllQueries.size(); ++i) {
                        object2 = (UpdateAllQuery)this.updateAllQueries.get(i);
                        ((DatabaseQuery)object2).setSession(this.getParent());
                        ((UpdateAllQuery)object2).mergeChangesIntoSharedCache();
                    }
                }
                if (bl) {
                    enumeration = ((oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().elements();
                    while (enumeration.hasMoreElements()) {
                        IdentityHashtable identityHashtable = (IdentityHashtable)((IdentityHashtable)enumeration.nextElement()).clone();
                        if (identityHashtable == null) continue;
                        object2 = identityHashtable.elements();
                        while (object2.hasMoreElements()) {
                            objectChangeSet = (ObjectChangeSet)object2.nextElement();
                            if (objectChangeSet.hasChanges()) {
                                object = objectChangeSet.getUnitOfWorkClone();
                                mergeManager.mergeChanges(object, objectChangeSet);
                                continue;
                            }
                            unitOfWorkChangeSet.removeObjectChangeSet(objectChangeSet);
                        }
                    }
                }
                if (!bl) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(mergeManager);
                    this.setMergeManager(null);
                    this.postMergeChanges();
                    if (this.getParent().hasCacheSynchronizationManager()) {
                        if (this.hasDeletedObjects()) {
                            unitOfWorkChangeSet.addDeletedObjects(this.getDeletedObjects(), this);
                        }
                        if (this.hasObjectsDeletedDuringCommit()) {
                            unitOfWorkChangeSet.addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
                        }
                        this.getParent().getCacheSynchronizationManager().propagateChanges(unitOfWorkChangeSet);
                    }
                    if (this.getParent().shouldPropagateChanges() && this.getParent().getCommandManager() != null) {
                        if (this.hasDeletedObjects()) {
                            unitOfWorkChangeSet.addDeletedObjects(this.getDeletedObjects(), this);
                        }
                        if (this.hasObjectsDeletedDuringCommit()) {
                            unitOfWorkChangeSet.addDeletedObjects(this.getObjectsDeletedDuringCommit(), this);
                        }
                        boolean bl2 = false;
                        if (unitOfWorkChangeSet.hasChanges()) {
                            object2 = new MergeChangeSetCommand();
                            ((MergeChangeSetCommand)object2).setChangeSet(unitOfWorkChangeSet);
                            try {
                                bl2 = ((MergeChangeSetCommand)object2).convertChangeSetToByteArray(this);
                            }
                            catch (IOException iOException) {
                                throw CommunicationException.unableToPropagateChanges(((Command)object2).getServiceId().getId(), iOException);
                            }
                            if (bl2) {
                                this.getParent().getCommandManager().propagateCommand(object2);
                            }
                        }
                    }
                }
                Object var11_14 = null;
                if (!this.isNestedUnitOfWork() && !mergeManager.getAcquiredLocks().isEmpty()) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(mergeManager);
                    this.setMergeManager(null);
                }
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                this.getParent().getEventManager().postMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (!this.isNestedUnitOfWork() && !mergeManager.getAcquiredLocks().isEmpty()) {
                    this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(mergeManager);
                    this.setMergeManager(null);
                }
                this.getParent().getIdentityMapAccessorInstance().releaseWriteLock();
                this.getParent().getEventManager().postMergeUnitOfWorkChangeSet(unitOfWorkChangeSet);
                this.endOperationProfile("merge");
                throw throwable;
            }
            this.endOperationProfile("merge");
            {
            }
        }
    }

    public Object mergeClone(Object object) {
        return this.mergeClone(object, 2);
    }

    public Object mergeClone(Object object, int n) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "merge_clone");
        this.startOperationProfile("merge");
        ObjectBuilder objectBuilder = this.getDescriptor(object).getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeCloneIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        Object object3 = null;
        try {
            object3 = mergeManager.mergeChanges(object2, null);
        }
        catch (RuntimeException runtimeException) {
            object3 = this.handleException(runtimeException);
        }
        this.endOperationProfile("merge");
        return object3;
    }

    public void mergeClonesAfterCompletion() {
        if (!CMPPolicy.OPTIMIZE_PESSIMISTIC_CMP) {
            this.mergeChangesIntoParent();
        }
        this.getEventManager().postCommitUnitOfWork();
        this.log(2, "transaction", "end_unit_of_work_commit");
    }

    public Object mergeCloneWithReferences(Object object) {
        return this.mergeCloneWithReferences(object, 2);
    }

    public Object mergeCloneWithReferences(Object object, int n) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            if (n == 4) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
            }
            return object;
        }
        this.logDebugMessage(object, "merge_clone_with_references");
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeCloneWithReferencesIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        Object object3 = mergeManager.mergeChanges(object2, null);
        if (UnitOfWork.isSmartMerge()) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    public Object newInstance(Class clazz) {
        this.logDebugMessage(clazz, "new_instance");
        Descriptor descriptor = this.getDescriptor(clazz);
        Object object = descriptor.getObjectBuilder().buildNewInstance();
        return this.registerObject(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performRemove(Object object, IdentityHashtable identityHashtable) {
        try {
            if (object == null) {
                return;
            }
            Descriptor descriptor = this.getDescriptor(object);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
            }
            this.logDebugMessage(object, "deleting_object");
            this.startOperationProfile("deleted object");
            Object object2 = this.checkIfAlreadyRegistered(object, descriptor);
            if (object2 == null) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_detatched_entity", new Object[]{object}));
            }
            if (this.getDeletedObjects().contains(object)) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cannot_remove_removed_entity", new Object[]{object}));
            }
            this.getDeletedObjects().put(object, object);
            descriptor.getObjectBuilder().cascadePerformRemove(object, this, identityHashtable);
        }
        finally {
            this.endOperationProfile("deleted object");
        }
    }

    public void performFullValidation() {
        this.setValidationLevel(2);
    }

    public void performPartialValidation() {
        this.setValidationLevel(1);
    }

    protected void populateAndRegisterObject(Object object, Object object2, CacheKey cacheKey, CacheKey cacheKey2, Descriptor descriptor) {
        cacheKey.setObject(object2);
        cacheKey.setReadTime(cacheKey2.getReadTime());
        cacheKey.setWriteLockValue(cacheKey2.getWriteLockValue());
        descriptor.getObjectChangePolicy().setChangeListener(object2, this, descriptor);
        descriptor.getObjectChangePolicy().dissableEventProcessing(object2);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        objectBuilder.populateAttributesForClone(object, object2, this);
        Object object3 = descriptor.getObjectChangePolicy().buildBackupClone(object2, objectBuilder, this);
        if (object2 != object3) {
            this.getCloneMapping().put(object2, object3);
        }
        descriptor.getObjectChangePolicy().enableEventProcessing(object2);
    }

    protected void postMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            Enumeration enumeration = this.getObjectsDeletedDuringCommit().keys();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                Descriptor descriptor = this.getDescriptor(e);
                if (descriptor.shouldIsolateObjectsInUnitOfWork()) continue;
                this.getParent().getIdentityMapAccessorInstance().removeFromIdentityMap((Vector)this.getObjectsDeletedDuringCommit().get(e), e.getClass(), descriptor);
            }
        }
    }

    protected void preMergeChanges() {
        if (this.hasObjectsDeletedDuringCommit()) {
            Enumeration enumeration = this.getObjectsDeletedDuringCommit().keys();
            while (enumeration.hasMoreElements()) {
                Object object;
                Object e = enumeration.nextElement();
                this.getCloneMapping().remove(e);
                this.getAllClones().remove(e);
                if (!this.hasNewObjects() || (object = this.getNewObjectsCloneToOriginal().get(e)) == null) continue;
                this.getNewObjectsCloneToOriginal().remove(e);
                this.getNewObjectsOriginalToClone().remove(object);
            }
        }
    }

    public void printRegisteredObjects() {
        if (this.shouldLog(7, "cache")) {
            this.basicPrintRegisteredObjects();
        }
    }

    public Object processDeleteObjectQuery(DeleteObjectQuery deleteObjectQuery) {
        Serializable serializable;
        if (deleteObjectQuery.getObject() == null) {
            throw QueryException.objectToModifyNotSpecified(deleteObjectQuery);
        }
        Descriptor descriptor = this.getDescriptor(deleteObjectQuery.getObject());
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object = objectBuilder.unwrapObject(deleteObjectQuery.getObject(), this);
        if (descriptor.getEventManager().hasAnyEventListeners()) {
            serializable = new oracle.toplink.descriptors.DescriptorEvent(deleteObjectQuery.getObject());
            serializable.setEventCode(16);
            serializable.setSession(this);
            descriptor.getEventManager().executeEvent((oracle.toplink.descriptors.DescriptorEvent)serializable);
        }
        if (this.isClassReadOnly(object.getClass(), descriptor)) {
            throw QueryException.cannotDeleteReadOnlyObject(object);
        }
        if (this.isCloneNewObject(object)) {
            this.unregisterObject(object);
            return object;
        }
        serializable = objectBuilder.extractPrimaryKeyFromObject(object, this);
        Object object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap((Vector)serializable, object.getClass(), descriptor);
        if (object2 == null) {
            object2 = object;
        }
        object2 = objectBuilder.unwrapObject(object2, this);
        deleteObjectQuery.setObject(object2);
        if (!this.getCommitManager().isActive()) {
            this.getDeletedObjects().put(object2, serializable);
            return object2;
        }
        if (this.hasObjectsDeletedDuringCommit() && this.getObjectsDeletedDuringCommit().containsKey(object2)) {
            return object2;
        }
        return null;
    }

    protected void basicPrintRegisteredObjects() {
        Object e;
        Enumeration enumeration;
        String string = Helper.cr();
        StringWriter stringWriter = new StringWriter();
        stringWriter.write(LoggingLocalization.buildMessage("unitofwork_identity_hashcode", new Object[]{string, String.valueOf(System.identityHashCode(this))}));
        if (this.hasDeletedObjects()) {
            stringWriter.write(string + LoggingLocalization.buildMessage("deleted_objects"));
            enumeration = this.getDeletedObjects().keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(e).getObjectBuilder().extractPrimaryKeyFromObject(e, this)), "\t", String.valueOf(System.identityHashCode(e)), e}));
            }
        }
        stringWriter.write(string + LoggingLocalization.buildMessage("all_registered_clones"));
        enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(e).getObjectBuilder().extractPrimaryKeyFromObject(e, this)), "\t", String.valueOf(System.identityHashCode(e)), e}));
        }
        if (this.hasNewObjectsInParentOriginalToClone()) {
            stringWriter.write(string + LoggingLocalization.buildMessage("new_objects"));
            enumeration = this.getNewObjectsCloneToOriginal().keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                stringWriter.write(LoggingLocalization.buildMessage("key_identity_hash_code_object", new Object[]{string, Helper.printVector(this.getDescriptor(e).getObjectBuilder().extractPrimaryKeyFromObject(e, this)), "\t", String.valueOf(System.identityHashCode(e)), e}));
            }
        }
        this.log(7, "transaction", stringWriter.toString(), null, null, false);
    }

    public Vector registerAllObjects(Collection collection) {
        Vector<Object> vector = new Vector<Object>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            vector.addElement(this.registerObject(iterator.next()));
        }
        return vector;
    }

    public Vector registerAllObjects(Vector vector) throws DatabaseException, OptimisticLockException {
        Vector<Object> vector2 = new Vector<Object>(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            vector2.addElement(this.registerObject(enumeration.nextElement()));
        }
        return vector2;
    }

    public synchronized Object registerExistingObject(Object object) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        Object object3 = this.registerExistingObject(object2, descriptor);
        if (object2 != object) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerExistingObject(Object object, Descriptor descriptor) {
        Object object2;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerExistingObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        this.logDebugMessage(object, "register_existing");
        try {
            this.startOperationProfile("register");
            object2 = this.checkIfAlreadyRegistered(object, descriptor);
            if (object2 == null) {
                Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                object2 = this.getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
                if (object2 == null) {
                    object2 = this.cloneAndRegisterObject(object, new CacheKey(vector), descriptor);
                }
            }
            if (descriptor.hasFetchGroupManager() && descriptor.getFetchGroupManager().shouldWriteInto(object, object2)) {
                descriptor.getFetchGroupManager().writePartialIntoClones(object, object2, this);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return object2;
    }

    public synchronized Object registerNewContainerBean(Object object) {
        Object object2;
        Object object3;
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "register_new");
        this.startOperationProfile("register");
        this.setShouldNewObjectsBeCached(true);
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        if (this.shouldPerformFullValidation()) {
            object3 = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
            object2 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap((Vector)object3, descriptor.getJavaClass(), descriptor);
            if (object2 != null) {
                throw ValidationException.wrongObjectRegistered(object, object2);
            }
        }
        object3 = objectBuilder.buildNewInstance();
        objectBuilder.copyInto(object, object3);
        object2 = this.registerObject(object3);
        this.getContainerBeans().put(object, object2);
        this.endOperationProfile("register");
        return object;
    }

    public synchronized Object registerNewContainerBeanForCMP(Object object) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "register_new_bean");
        this.startOperationProfile("register");
        Object object2 = this.cloneAndRegisterNewObject(object);
        this.endOperationProfile("register");
        return object2;
    }

    public synchronized Object registerNewObject(Object object) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        this.registerNewObject(object2, descriptor);
        if (object2 == object) {
            return object;
        }
        return objectBuilder.wrapObject(object2, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerNewObject(Object object, Descriptor descriptor) {
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerNewObject");
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        try {
            this.logDebugMessage(object, "register_new");
            this.startOperationProfile("register");
            Object object2 = this.checkIfAlreadyRegistered(object, descriptor);
            if (object2 == null) {
                Object object3;
                Cloneable cloneable;
                if (this.shouldPerformFullValidation()) {
                    cloneable = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                    object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap((Vector)cloneable, object.getClass(), descriptor);
                    if (object3 != null) {
                        throw ValidationException.wrongObjectRegistered(object, object3);
                    }
                }
                cloneable = descriptor.getObjectBuilder();
                object3 = ((ObjectBuilder)cloneable).buildNewInstance();
                this.registerNewObjectClone(object, object3);
                Object object4 = ((ObjectBuilder)cloneable).buildNewInstance();
                this.getCloneMapping().put(object, object4);
                this.registerNewObjectInIdentityMap(object, object);
            }
        }
        finally {
            this.endOperationProfile("register");
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void registerNewObjectForPersist(Object object, IdentityHashtable identityHashtable) {
        try {
            Object object2;
            if (object == null) {
                return;
            }
            Descriptor descriptor = this.getDescriptor(object);
            if (descriptor == null || descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
                throw new IllegalArgumentException(ExceptionLocalization.buildMessage("not_an_entity", new Object[]{object}));
            }
            this.logDebugMessage(object, "register_new_for_persist");
            if (descriptor.getEventManager().hasAnyEventListeners()) {
                object2 = new oracle.toplink.descriptors.DescriptorEvent(object);
                ((DescriptorEvent)object2).setEventCode(15);
                ((DescriptorEvent)object2).setSession(this);
                descriptor.getEventManager().executeEvent((oracle.toplink.descriptors.DescriptorEvent)object2);
            }
            this.startOperationProfile("register");
            object2 = this.checkIfAlreadyRegistered(object, descriptor);
            if (object2 == null) {
                object.getClass();
                Vector vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object, this);
                Object object3 = this.getParent().getIdentityMapAccessorInstance().getFromIdentityMap(vector, object.getClass(), descriptor);
                if (object3 != null) {
                    throw new IllegalArgumentException(ExceptionLocalization.buildMessage("cant_persist_detatched_object", new Object[]{object}));
                }
                ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
                Object object4 = objectBuilder.buildNewInstance();
                this.registerNewObjectClone(object, object4);
                Object object5 = objectBuilder.buildNewInstance();
                this.getCloneMapping().put(object, object5);
                this.assignSequenceNumber(object);
                this.registerNewObjectInIdentityMap(object, object);
            } else if (this.isObjectDeleted(object)) {
                this.undeleteObject(object);
            }
            descriptor.getObjectBuilder().cascadeRegisterNewForCreate(object, this, identityHashtable);
        }
        finally {
            this.endOperationProfile("register");
        }
    }

    protected void registerNewObjectClone(Object object, Object object2) {
        this.registerNewObjectInIdentityMap(object, object2);
        this.getNewObjectsCloneToOriginal().put(object, object2);
        this.getNewObjectsOriginalToClone().put(object2, object);
    }

    protected void registerNewObjectInIdentityMap(Object object, Object object2) {
        Class<?> clazz = object.getClass();
        Descriptor descriptor = this.getDescriptor(clazz);
        boolean bl = descriptor.usesSequenceNumbers();
        if (this.shouldNewObjectsBeCached()) {
            Object e;
            int n;
            Vector vector = this.keyFromObject(object);
            boolean bl2 = false;
            for (n = 0; n < vector.size(); ++n) {
                e = vector.elementAt(n);
                if (e == null) {
                    bl2 = true;
                    continue;
                }
                if (!bl) continue;
                bl2 = this.getSequencing().shouldOverrideExistingValue(clazz, e);
            }
            if (bl2) {
                vector = descriptor.getObjectBuilder().extractPrimaryKeyFromObject(object2, this);
                bl2 = false;
                for (n = 0; n < vector.size(); ++n) {
                    e = vector.elementAt(n);
                    if (e == null) {
                        bl2 = true;
                        continue;
                    }
                    if (!bl) continue;
                    bl2 = this.getSequencing().shouldOverrideExistingValue(clazz, e);
                }
            }
            if (!bl2) {
                this.getIdentityMapAccessorInstance().putInIdentityMap(object, vector, null, 0L, descriptor);
            }
        }
    }

    public synchronized Object registerObject(Object object) {
        if (object == null) {
            return null;
        }
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        boolean bl = object2 != object;
        Object object3 = this.registerObject(object2, descriptor);
        if (bl) {
            return objectBuilder.wrapObject(object3, this);
        }
        return object3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Object registerObject(Object object, Descriptor descriptor) {
        Object object2;
        if (this.isClassReadOnly(descriptor.getJavaClass(), descriptor)) {
            return object;
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "registerObject");
        }
        this.logDebugMessage(object, "register");
        try {
            this.startOperationProfile("register");
            object2 = this.internalRegisterObject(object, descriptor);
        }
        finally {
            this.endOperationProfile("register");
        }
        return object2;
    }

    public void registerOriginalNewObjectFromNestedUnitOfWork(Object object, Object object2, Object object3) {
        this.getCloneMapping().put(object, object2);
        this.registerNewObjectClone(object, object3);
    }

    protected void registerWithTransactionIfRequired() {
        if (this.getParent().hasExternalTransactionController()) {
            boolean bl = this.getParent().wasJTSTransactionInternallyStarted();
            this.getParent().getExternalTransactionController().registerSynchronizationListener(this, this.getParent());
            if (!bl && this.getParent().wasJTSTransactionInternallyStarted()) {
                this.setWasTransactionBegunPrematurely(true);
            }
        }
    }

    public void removeForceUpdateToVersionField(Object object) {
        this.getOptimisticReadLockObjects().remove(object);
    }

    public void release() {
        this.log(2, "transaction", "release_unit_of_work");
        this.getEventManager().preReleaseUnitOfWork();
        if (this.getLifecycle() == 2) {
            if (this.hasModifications() || this.wasTransactionBegunPrematurely()) {
                this.rollbackTransaction(false);
                this.setWasTransactionBegunPrematurely(false);
            }
        } else if (this.wasTransactionBegunPrematurely() && !this.isNestedUnitOfWork()) {
            this.rollbackTransaction();
            this.setWasTransactionBegunPrematurely(false);
        }
        if (this.getMergeManager() != null && this.getMergeManager().getAcquiredLocks() != null && !this.getMergeManager().getAcquiredLocks().isEmpty()) {
            this.getParent().getIdentityMapAccessorInstance().getWriteLockManager().releaseAllAcquiredLocks(this.getMergeManager());
            this.setMergeManager(null);
        }
        this.setDead();
        this.setBatchReadObjects(null);
        this.getParent().releaseUnitOfWork(this);
        this.getEventManager().postReleaseUnitOfWork();
        if (this.getObjectTracker() != null) {
            this.getObjectTracker().releaseAllocatedObjects();
        }
    }

    public void removeAllReadOnlyClasses() throws ValidationException {
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().clear();
    }

    public void removeReadOnlyClass(Class clazz) throws ValidationException {
        if (!this.canChangeReadOnlySet()) {
            throw ValidationException.cannotModifyReadOnlyClassesSetAfterUsingUnitOfWork();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.cannotRemoveFromReadOnlyClassesInNestedUnitOfWork();
        }
        this.getReadOnlyClasses().remove(clazz);
    }

    protected void resetAllCloneCollection() {
        this.allClones = null;
    }

    public void revertAndResume() {
        Object e;
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.illegalOperationForUnitOfWorkLifecycle(this.getLifecycle(), "revertAndResume");
        }
        this.log(2, "transaction", "revert_unit_of_work");
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeOriginalIntoWorkingCopy();
        mergeManager.cascadeAllParts();
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            mergeManager.mergeChanges(e, null);
            Descriptor descriptor = this.getDescriptor(e);
            descriptor.getObjectChangePolicy().revertChanges(e, descriptor, this, this.getCloneMapping());
        }
        if (this.hasNewObjects()) {
            enumeration = this.getNewObjectsCloneToOriginal().keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                this.getCloneMapping().remove(e);
            }
            if (this.getUnitOfWorkChangeSet() != null) {
                ((oracle.toplink.internal.sessions.UnitOfWorkChangeSet)this.getUnitOfWorkChangeSet()).getNewObjectChangeSets().clear();
            }
        }
        this.setNewObjectsCloneToOriginal(null);
        this.setNewObjectsOriginalToClone(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashtable());
        this.setDeletedObjects(new IdentityHashtable());
        this.setRemovedObjects(new IdentityHashtable());
        this.setUnregisteredNewObjects(new IdentityHashtable());
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
        this.log(2, "transaction", "resume_unit_of_work");
    }

    public Object revertObject(Object object) {
        return this.revertObject(object, 2);
    }

    public Object revertObject(Object object, int n) {
        if (object == null) {
            return null;
        }
        this.logDebugMessage(object, "revert");
        Descriptor descriptor = this.getDescriptor(object);
        ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
        Object object2 = objectBuilder.unwrapObject(object, this);
        MergeManager mergeManager = new MergeManager(this);
        mergeManager.mergeOriginalIntoWorkingCopy();
        mergeManager.setCascadePolicy(n);
        try {
            mergeManager.mergeChanges(object2, null);
        }
        catch (RuntimeException runtimeException) {
            return this.handleException(runtimeException);
        }
        return object;
    }

    public void rollbackTransaction() throws DatabaseException {
        this.incrementProfile("UnitOfWorkRollbacks");
        this.getParent().rollbackTransaction();
    }

    protected void rollbackTransaction(boolean bl) throws DatabaseException {
        if (!bl && this.getParent().hasExternalTransactionController() && !this.getParent().wasJTSTransactionInternallyStarted()) {
            this.getParent().getExternalTransactionController().markTransactionForRollback();
        }
        this.rollbackTransaction();
    }

    public IdentityHashtable scanForConformingInstances(Expression expression, Class clazz, DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery) {
        IdentityHashtable identityHashtable;
        block6: {
            InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy = objectLevelReadQuery.getInMemoryQueryIndirectionPolicy();
            if (!inMemoryQueryIndirectionPolicy.shouldTriggerIndirection()) {
                inMemoryQueryIndirectionPolicy = new InMemoryQueryIndirectionPolicy(3);
            }
            identityHashtable = new IdentityHashtable();
            try {
                Enumeration enumeration;
                Object object;
                Vector vector = null;
                if (expression != null) {
                    vector = this.getIdentityMapAccessor().getAllFromIdentityMap(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy);
                    object = vector.elements();
                    while (object.hasMoreElements()) {
                        enumeration = object.nextElement();
                        if (this.isObjectDeleted(enumeration)) continue;
                        identityHashtable.put(enumeration, enumeration);
                    }
                }
                object = null;
                object = this.getAllFromNewObjects(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy);
                enumeration = ((Vector)object).elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    if (this.isObjectDeleted(e)) continue;
                    identityHashtable.put(e, e);
                }
            }
            catch (QueryException queryException) {
                if (this.getShouldThrowConformExceptions() != 1) break block6;
                throw queryException;
            }
        }
        return identityHashtable;
    }

    protected void setAllClonesCollection(IdentityHashtable identityHashtable) {
        this.allClones = identityHashtable;
    }

    protected void setCloneMapping(IdentityHashtable identityHashtable) {
        this.cloneMapping = identityHashtable;
    }

    protected void setContainerBeans(IdentityHashtable identityHashtable) {
        this.containerBeans = identityHashtable;
    }

    protected void setContainerUnitOfWork(UnitOfWork unitOfWork) {
        this.containerUnitOfWork = unitOfWork;
    }

    public void setDead() {
        this.setLifecycle(5);
    }

    protected void setDeletedObjects(IdentityHashtable identityHashtable) {
        this.deletedObjects = identityHashtable;
    }

    protected void setLifecycle(int n) {
        this.lifecycle = n;
    }

    public void setMergeManager(MergeManager mergeManager) {
        this.lastUsedMergeManager = mergeManager;
    }

    protected void setNewObjectsCloneToOriginal(IdentityHashtable identityHashtable) {
        this.newObjectsCloneToOriginal = identityHashtable;
    }

    protected void setNewObjectsOriginalToClone(IdentityHashtable identityHashtable) {
        this.newObjectsOriginalToClone = identityHashtable;
    }

    public void setObjectsDeletedDuringCommit(IdentityHashtable identityHashtable) {
        this.objectsDeletedDuringCommit = identityHashtable;
    }

    public void setParent(Session session) {
        this.parent = session;
    }

    public void setPendingMerge() {
        this.setLifecycle(4);
    }

    public void setReadOnlyClasses(Vector vector) {
        this.readOnlyClasses = new Hashtable(vector.size() + 10);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Class clazz = (Class)enumeration.nextElement();
            this.addReadOnlyClass(clazz);
        }
    }

    protected void setRemovedObjects(IdentityHashtable identityHashtable) {
        this.removedObjects = identityHashtable;
    }

    public void setShouldNewObjectsBeCached(boolean bl) {
        this.shouldNewObjectsBeCached = bl;
    }

    public void setShouldPerformDeletesFirst(boolean bl) {
        this.shouldPerformDeletesFirst = bl;
    }

    public void setShouldThrowConformExceptions(int n) {
        this.shouldThrowConformExceptions = n;
    }

    public static void setSmartMerge(boolean bl) {
        SmartMerge = bl;
    }

    public void setSynchronized() {
        this.isSynchronized = true;
    }

    public void setUnitOfWorkChangeSet(oracle.toplink.internal.sessions.UnitOfWorkChangeSet unitOfWorkChangeSet) {
        this.unitOfWorkChangeSet = unitOfWorkChangeSet;
    }

    protected void setUnregisteredExistingObjects(IdentityHashtable identityHashtable) {
        this.unregisteredExistingObjects = identityHashtable;
    }

    protected void setUnregisteredNewObjects(IdentityHashtable identityHashtable) {
        this.unregisteredNewObjects = identityHashtable;
    }

    protected void setUnregisteredNewObjectsInParent(IdentityHashtable identityHashtable) {
        this.unregisteredNewObjectsInParent = identityHashtable;
    }

    public void setValidationLevel(int n) {
        this.validationLevel = n;
    }

    public void setWasTransactionBegunPrematurely(boolean bl) {
        if (this.isNestedUnitOfWork()) {
            ((UnitOfWork)this.getParent()).setWasTransactionBegunPrematurely(bl);
        }
        this.wasTransactionBegunPrematurely = bl;
    }

    public Object shallowMergeClone(Object object) {
        return this.mergeClone(object, 1);
    }

    public Object shallowRevertObject(Object object) {
        return this.revertObject(object, 1);
    }

    public void shallowUnregisterObject(Object object) {
        this.unregisterObject(object, 1);
    }

    public boolean shouldNewObjectsBeCached() {
        return this.shouldNewObjectsBeCached;
    }

    public boolean shouldPerformDeletesFirst() {
        return this.shouldPerformDeletesFirst;
    }

    public boolean shouldPerformFullValidation() {
        return this.getValidationLevel() == 2;
    }

    public boolean shouldPerformNoValidation() {
        return this.getValidationLevel() == 0;
    }

    public boolean shouldPerformPartialValidation() {
        return this.getValidationLevel() == 1;
    }

    public void storeUpdateAllQuery(DatabaseQuery databaseQuery) {
        if (this.updateAllQueries == null) {
            this.updateAllQueries = new ArrayList();
        }
        this.updateAllQueries.add(databaseQuery);
    }

    public void storeDeferredUpdateAllQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow) {
        if (this.deferredUpdateAllQueries == null) {
            this.deferredUpdateAllQueries = new ArrayList();
        }
        this.deferredUpdateAllQueries.add(new Object[]{databaseQuery, databaseRow});
    }

    protected void synchronizeAndResume() {
        Object e;
        this.getPessimisticLockedObjects().clear();
        this.getProperties().remove(LOCK_QUERIES_PROPERTY);
        IdentityHashtable identityHashtable = new IdentityHashtable(1 + this.getCloneMapping().size());
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            e = enumeration.nextElement();
            if (this.isObjectDeleted(e) || this.getRemovedObjects().containsKey(e)) continue;
            Descriptor descriptor = this.getDescriptor(e);
            ObjectBuilder objectBuilder = descriptor.getObjectBuilder();
            descriptor.getObjectChangePolicy().revertChanges(e, descriptor, this, identityHashtable);
        }
        this.setCloneMapping(identityHashtable);
        if (this.hasObjectsDeletedDuringCommit()) {
            enumeration = this.getObjectsDeletedDuringCommit().keys();
            while (enumeration.hasMoreElements()) {
                e = enumeration.nextElement();
                this.getIdentityMapAccessor().removeFromIdentityMap((Vector)this.getObjectsDeletedDuringCommit().get(e), e.getClass());
            }
        }
        if (!this.isNestedUnitOfWork()) {
            this.setNewObjectsCloneToOriginal(null);
            this.setNewObjectsOriginalToClone(null);
        }
        this.setUnitOfWorkChangeSet(null);
        this.resetAllCloneCollection();
        this.setObjectsDeletedDuringCommit(new IdentityHashtable());
        this.setDeletedObjects(new IdentityHashtable());
        this.setRemovedObjects(new IdentityHashtable());
        this.setUnregisteredNewObjectsInParent(new IdentityHashtable());
        this.setUnregisteredNewObjects(new IdentityHashtable());
        if (this.isNestedUnitOfWork()) {
            this.discoverAllUnregisteredNewObjectsInParent();
        }
    }

    protected void undeleteObject(Object object) {
        this.getDeletedObjects().remove(object);
        if (this.getParent().isUnitOfWork()) {
            ((UnitOfWork)this.getParent()).undeleteObject(object);
        }
    }

    public void unregisterObject(Object object) {
        this.unregisterObject(object, 2);
    }

    public void unregisterObject(Object object, int n) {
        if (object == null) {
            return;
        }
        this.logDebugMessage(object, "unregister");
        Object object2 = this.getDescriptor(object).getObjectBuilder().unwrapObject(object, this);
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                Object object2;
                if (UnitOfWork.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                    this.setShouldBreak(true);
                    return;
                }
                Vector vector = this.getCurrentDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(object, UnitOfWork.this);
                UnitOfWork.this.getIdentityMapAccessorInstance().removeFromIdentityMap(vector, object.getClass(), this.getCurrentDescriptor());
                UnitOfWork.this.getCloneMapping().remove(object);
                if (UnitOfWork.this.hasNewObjects() && (object2 = UnitOfWork.this.getNewObjectsCloneToOriginal().remove(object)) != null) {
                    UnitOfWork.this.getNewObjectsOriginalToClone().remove(object2);
                }
            }
        };
        descriptorIterator.setSession(this);
        descriptorIterator.setCascadeDepth(n);
        descriptorIterator.startIterationOn(object2);
    }

    public void updateChangeTrackersIfRequired(Object object, ObjectChangeSet objectChangeSet, UnitOfWork unitOfWork, Descriptor descriptor) {
    }

    public void validateObjectSpace() {
        this.log(2, "transaction", "validate_object_space");
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                try {
                    if (UnitOfWork.this.isClassReadOnly(object.getClass(), this.getCurrentDescriptor())) {
                        this.setShouldBreak(true);
                        return;
                    }
                    UnitOfWork.this.getBackupClone(object);
                }
                catch (TopLinkException topLinkException) {
                    UnitOfWork.this.log(1, "transaction", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    UnitOfWork.this.log(2, "transaction", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    throw topLinkException;
                }
            }
        };
        descriptorIterator.setSession(this);
        Enumeration enumeration = this.getCloneMapping().keys();
        while (enumeration.hasMoreElements()) {
            descriptorIterator.startIterationOn(enumeration.nextElement());
        }
    }

    public boolean wasTransactionBegunPrematurely() {
        if (this.isNestedUnitOfWork()) {
            return ((UnitOfWork)this.getParent()).wasTransactionBegunPrematurely();
        }
        return this.wasTransactionBegunPrematurely;
    }

    public void writeChanges() {
        if (!this.isActive()) {
            throw ValidationException.inActiveUnitOfWork("writeChanges");
        }
        if (this.isAfterWriteChangesButBeforeCommit()) {
            throw ValidationException.cannotWriteChangesTwice();
        }
        if (this.isNestedUnitOfWork()) {
            throw ValidationException.writeChangesOnNestedUnitOfWork();
        }
        this.mergeBmpAndWsEntities();
        this.log(2, "transaction", "begin_unit_of_work_commit");
        this.getEventManager().preCommitUnitOfWork();
        this.setLifecycle(1);
        try {
            if (this.usesOldCommit()) {
                this.commitToDatabaseOldCommit(false);
            } else {
                this.commitToDatabaseWithChangeSet(false);
            }
        }
        catch (RuntimeException runtimeException) {
            this.setLifecycle(3);
            throw runtimeException;
        }
        this.setLifecycle(2);
    }

    public void writesCompleted() {
        this.getParent().writesCompleted();
    }

    private void logDebugMessage(Object object, String string) {
        this.log(1, "transaction", string, object);
    }

    public Object getWorkingCopyFromUnitOfWorkIdentityMap(Object object, Vector vector) {
        Descriptor descriptor = this.getDescriptor(object);
        if (descriptor == null) {
            throw DescriptorException.missingDescriptor(object.getClass().toString());
        }
        if (descriptor.isAggregateDescriptor() || descriptor.isAggregateCollectionDescriptor()) {
            throw ValidationException.cannotRegisterAggregateObjectInUnitOfWork(object.getClass());
        }
        Object object2 = this.getCloneMapping().get(object);
        if (object2 != null) {
            return object;
        }
        Object object3 = this.getIdentityMapAccessorInstance().getIdentityMapManager().getFromIdentityMap(vector, object.getClass(), descriptor);
        if (object3 != null) {
            return object3;
        }
        return null;
    }

    public IdentityHashtable getBatchReadObjects() {
        if (this.batchReadObjects == null) {
            this.batchReadObjects = new IdentityHashtable();
        }
        return this.batchReadObjects;
    }

    public void setBatchReadObjects(IdentityHashtable identityHashtable) {
        this.batchReadObjects = identityHashtable;
    }

    public IdentityHashtable getPessimisticLockedObjects() {
        if (this.pessimisticLockedObjects == null) {
            this.pessimisticLockedObjects = new IdentityHashtable();
        }
        return this.pessimisticLockedObjects;
    }

    public void addPessimisticLockedClone(Object object) {
        this.log(1, "transaction", "tracking_pl_object", object, new Integer(this.hashCode()));
        this.getPessimisticLockedObjects().put(object, object);
    }

    public boolean isPessimisticLocked(Object object) {
        return this.getPessimisticLockedObjects().containsKey(object);
    }

    public void releaseReadConnection(Accessor accessor) {
        this.getParent().releaseReadConnection(accessor);
    }
}

