/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml.jaxp;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import oracle.toplink.platform.xml.XMLParser;
import oracle.toplink.platform.xml.XMLPlatformException;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class JAXPParser
implements XMLParser {
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
    private EntityResolver entityResolver;
    private ErrorHandler errorHandler;

    public JAXPParser() {
        this.setNamespaceAware(true);
        this.setWhitespacePreserving(false);
    }

    public void setNamespaceAware(boolean bl) {
        this.documentBuilderFactory.setNamespaceAware(bl);
    }

    public void setWhitespacePreserving(boolean bl) {
        this.documentBuilderFactory.setIgnoringElementContentWhitespace(!bl);
    }

    public int getValidationMode() {
        if (!this.documentBuilderFactory.isValidating()) {
            return 0;
        }
        try {
            if (null == this.documentBuilderFactory.getAttribute(SCHEMA_LANGUAGE)) {
                return 2;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return 2;
        }
        return 3;
    }

    public void setValidationMode(int n) {
        switch (n) {
            case 0: {
                this.documentBuilderFactory.setValidating(false);
                return;
            }
            case 2: {
                this.documentBuilderFactory.setValidating(true);
                return;
            }
            case 3: {
                try {
                    this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
                    this.documentBuilderFactory.setValidating(true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                return;
            }
        }
    }

    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public void setXMLSchema(URL uRL) throws XMLPlatformException {
        if (null == uRL) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, uRL.toString());
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchema(uRL, exception);
        }
    }

    public void setXMLSchemas(Object[] objectArray) throws XMLPlatformException {
        if (null == objectArray || objectArray.length == 0) {
            return;
        }
        try {
            this.documentBuilderFactory.setAttribute(SCHEMA_LANGUAGE, XML_SCHEMA);
            this.documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, objectArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (Exception exception) {
            XMLPlatformException.xmlPlatformErrorResolvingXMLSchemas(objectArray, exception);
        }
    }

    public Document parse(InputSource inputSource) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputSource);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformParseException(sAXException);
        }
        catch (IOException iOException) {
            throw XMLPlatformException.xmlPlatformParseException(iOException);
        }
    }

    public Document parse(File file) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(file);
        }
        catch (SAXParseException sAXParseException) {
            throw XMLPlatformException.xmlPlatformSAXParseException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformParseException(sAXException);
        }
        catch (IOException iOException) {
            throw XMLPlatformException.xmlPlatformFileNotFoundException(file, iOException);
        }
    }

    public Document parse(InputStream inputStream) throws XMLPlatformException {
        try {
            return this.getDocumentBuilder().parse(inputStream);
        }
        catch (SAXParseException sAXParseException) {
            throw XMLPlatformException.xmlPlatformSAXParseException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw XMLPlatformException.xmlPlatformParseException(sAXException);
        }
        catch (IOException iOException) {
            throw XMLPlatformException.xmlPlatformParseException(iOException);
        }
    }

    public Document parse(Reader reader) throws XMLPlatformException {
        InputSource inputSource = new InputSource(reader);
        return this.parse(inputSource);
    }

    public Document parse(Source source) throws XMLPlatformException {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMResult dOMResult = new DOMResult();
            transformer.transform(source, dOMResult);
            return (Document)dOMResult.getNode();
        }
        catch (TransformerException transformerException) {
            throw XMLPlatformException.xmlPlatformParseException(transformerException);
        }
    }

    public Document parse(URL uRL) throws XMLPlatformException {
        try {
            InputStream inputStream = uRL.openStream();
            return this.parse(inputStream);
        }
        catch (IOException iOException) {
            throw XMLPlatformException.xmlPlatformParseException(iOException);
        }
    }

    private DocumentBuilder getDocumentBuilder() {
        try {
            DocumentBuilder documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setEntityResolver(this.entityResolver);
            documentBuilder.setErrorHandler(this.errorHandler);
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw XMLPlatformException.xmlPlatformParseException(parserConfigurationException);
        }
    }
}

