/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.xml;

import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;

public class XMLPlatformFactory {
    public static final String XML_PLATFORM_PROPERTY = "toplink.xml.platform";
    public static final String XDK_PLATFORM_CLASS_NAME = "oracle.toplink.platform.xml.xdk.XDKPlatform";
    public static final String JAXP_PLATFORM_CLASS_NAME = "oracle.toplink.platform.xml.jaxp.JAXPPlatform";
    private static XMLPlatformFactory instance;
    private Class xmlPlatformClass;

    private XMLPlatformFactory() {
    }

    public static XMLPlatformFactory getInstance() throws XMLPlatformException {
        if (null == instance) {
            instance = new XMLPlatformFactory();
        }
        return instance;
    }

    public Class getXMLPlatformClass() throws XMLPlatformException {
        if (null != this.xmlPlatformClass) {
            return this.xmlPlatformClass;
        }
        String string = System.getProperty(XML_PLATFORM_PROPERTY);
        if (null == string) {
            string = XDK_PLATFORM_CLASS_NAME;
        }
        try {
            ClassLoader classLoader = PrivilegedAccessController.getClassLoaderForClass(this.getClass());
            Class<?> clazz = classLoader.loadClass(string);
            this.setXMLPlatformClass(clazz);
            return this.xmlPlatformClass;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw XMLPlatformException.xmlPlatformClassNotFound(string, classNotFoundException);
        }
    }

    public void setXMLPlatformClass(Class clazz) {
        this.xmlPlatformClass = clazz;
    }

    public XMLPlatform getXMLPlatform() throws XMLPlatformException {
        try {
            return (XMLPlatform)PrivilegedAccessController.newInstanceFromClass(this.getXMLPlatformClass());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw XMLPlatformException.xmlPlatformCouldNotInstantiate(this.getXMLPlatformClass().getName(), instantiationException);
        }
    }
}

