/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.server;

import java.sql.Connection;
import java.sql.SQLException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.localization.ToStringLocalization;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.logging.AbstractSessionLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.platform.server.ServerLog;
import oracle.toplink.platform.server.ServerPlatform;
import oracle.toplink.sessions.DatabaseSession;
import oracle.toplink.sessions.ExternalTransactionController;

public abstract class ServerPlatformBase
implements ServerPlatform {
    protected Class externalTransactionControllerClass;
    private boolean isRuntimeServicesEnabled = true;
    private boolean isJTAEnabled = true;
    private boolean isCMP;
    private DatabaseSession databaseSession;

    public ServerPlatformBase(DatabaseSession databaseSession) {
        this.databaseSession = databaseSession;
        this.setIsCMP(false);
    }

    public DatabaseSession getDatabaseSession() {
        return this.databaseSession;
    }

    public String getServerNameAndVersion() {
        return ToStringLocalization.buildMessage("unknown");
    }

    public String getModuleName() {
        return "unknown";
    }

    public abstract Class getExternalTransactionControllerClass();

    public void setExternalTransactionControllerClass(Class clazz) {
        this.externalTransactionControllerClass = clazz;
    }

    public void initializeExternalTransactionController() {
        this.ensureNotLoggedIn();
        if (!this.isJTAEnabled() && !this.isCMP()) {
            return;
        }
        if (!this.isJTAEnabled() && this.isCMP()) {
            AbstractSessionLog.getLog().warning("jta_cannot_be_disabled_in_cmp");
        }
        try {
            if (this.getDatabaseSession().getExternalTransactionController() != null) {
                this.externalTransactionControllerNotNullWarning();
                return;
            }
            this.getDatabaseSession().setExternalTransactionController((ExternalTransactionController)PrivilegedAccessController.newInstanceFromClass(this.getExternalTransactionControllerClass()));
        }
        catch (InstantiationException instantiationException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
        catch (IllegalAccessException illegalAccessException) {
            throw ValidationException.cannotCreateExternalTransactionController(this.getExternalTransactionControllerClass().getName());
        }
    }

    protected void externalTransactionControllerNotNullWarning() {
        ((DatabaseSessionImpl)this.getDatabaseSession()).warning("External_transaction_controller_not_defined_by_server_platform", "ejb");
    }

    public boolean isJTAEnabled() {
        return this.isJTAEnabled;
    }

    public void disableJTA() {
        this.ensureNotLoggedIn();
        this.isJTAEnabled = false;
    }

    public boolean isRuntimeServicesEnabled() {
        return this.isRuntimeServicesEnabled;
    }

    public void disableRuntimeServices() {
        this.ensureNotLoggedIn();
        this.isRuntimeServicesEnabled = false;
    }

    public void registerMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificRegisterMBean();
    }

    public void serverSpecificRegisterMBean() {
    }

    public void unregisterMBean() {
        if (!this.isRuntimeServicesEnabled()) {
            return;
        }
        this.serverSpecificUnregisterMBean();
    }

    public Connection unwrapOracleConnection(Connection connection) {
        try {
            return connection.getMetaData().getConnection();
        }
        catch (SQLException sQLException) {
            ((DatabaseSessionImpl)this.getDatabaseSession()).log(6, "connection", "cannot_unwrap_connection", sQLException);
            return connection;
        }
    }

    public void serverSpecificUnregisterMBean() {
    }

    public void launchContainerRunnable(Runnable runnable) {
        new Thread(runnable).start();
    }

    protected void ensureNotLoggedIn() {
        if (this.getDatabaseSession() == null) {
            return;
        }
        if (this.getDatabaseSession().isConnected()) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(this.getClass().getName());
        }
    }

    public SessionLog getServerLog() {
        return new ServerLog();
    }

    public boolean isCMP() {
        return this.isCMP;
    }

    public void setIsCMP(boolean bl) {
        this.isCMP = bl;
    }
}

