/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.platform.database;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.expressions.ExpressionOperator;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.platform.database.DatabasePlatform;
import oracle.toplink.queryframework.ValueReadQuery;

public class TimesTenPlatform
extends DatabasePlatform {
    private boolean supportsForeignKeyConstraints = true;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$math$BigInteger;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$oracle$toplink$internal$expressions$RelationExpression;

    protected void appendByteArray(byte[] byArray, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("Ox");
            Helper.writeHexString(byArray, writer);
        } else {
            super.appendByteArray(byArray, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("DATE '");
            writer.write(Helper.printDate(date));
            writer.write("'");
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIME '");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIMESTAMP '");
            writer.write(Helper.printTimestampWithoutNanos(timestamp));
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("TIMESTAMP '");
            writer.write(Helper.printCalendarWithoutNanos(calendar));
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class, FieldTypeDefinition> hashtable = new Hashtable<Class, FieldTypeDefinition>();
        hashtable.put(class$java$lang$Boolean == null ? (class$java$lang$Boolean = TimesTenPlatform.class$("java.lang.Boolean")) : class$java$lang$Boolean, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(class$java$lang$Integer == null ? (class$java$lang$Integer = TimesTenPlatform.class$("java.lang.Integer")) : class$java$lang$Integer, new FieldTypeDefinition("INTEGER", false));
        hashtable.put(class$java$lang$Long == null ? (class$java$lang$Long = TimesTenPlatform.class$("java.lang.Long")) : class$java$lang$Long, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(class$java$lang$Float == null ? (class$java$lang$Float = TimesTenPlatform.class$("java.lang.Float")) : class$java$lang$Float, new FieldTypeDefinition("FLOAT", false));
        hashtable.put(class$java$lang$Double == null ? (class$java$lang$Double = TimesTenPlatform.class$("java.lang.Double")) : class$java$lang$Double, new FieldTypeDefinition("DOUBLE", false));
        hashtable.put(class$java$lang$Short == null ? (class$java$lang$Short = TimesTenPlatform.class$("java.lang.Short")) : class$java$lang$Short, new FieldTypeDefinition("SMALLINT", false));
        hashtable.put(class$java$lang$Byte == null ? (class$java$lang$Byte = TimesTenPlatform.class$("java.lang.Byte")) : class$java$lang$Byte, new FieldTypeDefinition("TINYINT", false));
        hashtable.put(class$java$math$BigInteger == null ? (class$java$math$BigInteger = TimesTenPlatform.class$("java.math.BigInteger")) : class$java$math$BigInteger, new FieldTypeDefinition("BIGINT", false));
        hashtable.put(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = TimesTenPlatform.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new FieldTypeDefinition("DECIMAL(38)", false));
        hashtable.put(class$java$lang$String == null ? (class$java$lang$String = TimesTenPlatform.class$("java.lang.String")) : class$java$lang$String, new FieldTypeDefinition("VARCHAR", 255));
        hashtable.put(class$java$lang$Character == null ? (class$java$lang$Character = TimesTenPlatform.class$("java.lang.Character")) : class$java$lang$Character, new FieldTypeDefinition("CHAR", 1));
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = TimesTenPlatform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("VARBINARY", 64000));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = TimesTenPlatform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("VARCHAR", 64000));
        hashtable.put(class$java$sql$Date == null ? (class$java$sql$Date = TimesTenPlatform.class$("java.sql.Date")) : class$java$sql$Date, new FieldTypeDefinition("DATE", false));
        hashtable.put(class$java$sql$Time == null ? (class$java$sql$Time = TimesTenPlatform.class$("java.sql.Time")) : class$java$sql$Time, new FieldTypeDefinition("TIME", false));
        hashtable.put(class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = TimesTenPlatform.class$("java.sql.Timestamp")) : class$java$sql$Timestamp, new FieldTypeDefinition("TIMESTAMP", false));
        return hashtable;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence(String string, Integer n) {
        return new ValueReadQuery("SELECT " + this.getQualifiedSequenceName(string) + ".NEXTVAL FROM DUAL");
    }

    public String getCreateViewString() {
        return "CREATE MATERIALIZED VIEW ";
    }

    protected String getQualifiedSequenceName(String string) {
        if (this.getTableQualifier().equals("")) {
            return string;
        }
        return this.getTableQualifier() + "." + string;
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT SYSDATE FROM DUAL");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(31, "CONCAT"));
        this.addOperator(this.operatorOuterJoin());
        this.addOperator(ExpressionOperator.ifNull());
    }

    public boolean isTimesTen() {
        return true;
    }

    protected ExpressionOperator operatorOuterJoin() {
        ExpressionOperator expressionOperator = new ExpressionOperator();
        expressionOperator.setSelector(6);
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(2);
        ((Vector)nonSynchronizedVector).addElement(" (+) = ");
        expressionOperator.printsAs(nonSynchronizedVector);
        expressionOperator.bePostfix();
        expressionOperator.setNodeClass(class$oracle$toplink$internal$expressions$RelationExpression == null ? (class$oracle$toplink$internal$expressions$RelationExpression = TimesTenPlatform.class$("oracle.toplink.internal.expressions.RelationExpression")) : class$oracle$toplink$internal$expressions$RelationExpression);
        return expressionOperator;
    }

    public boolean shouldPrintOuterJoinInWhereClause() {
        return true;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    public boolean supportsForeignKeyConstraints() {
        return this.supportsForeignKeyConstraints;
    }

    public void setSupportsForeignKeyConstraints(boolean bl) {
        this.supportsForeignKeyConstraints = bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

