/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox.schema;

import java.net.URL;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;

public abstract class XMLSchemaReference
implements oracle.toplink.platform.xml.XMLSchemaReference {
    protected String resource;
    protected String schemaContext;
    protected int type = 1;

    protected XMLSchemaReference() {
    }

    protected XMLSchemaReference(String string) {
        this();
        this.resource = string;
    }

    public String getResource() {
        return this.resource;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public abstract URL getURL();

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        if (n < 1 || n > 3 && n != 5) {
            throw XMLPlatformException.xmlPlatformInvalidTypeException(n);
        }
        this.type = n;
    }

    public String getSchemaContext() {
        return this.schemaContext;
    }

    public void setSchemaContext(String string) {
        this.schemaContext = string;
    }

    public boolean isValid(Document document, ErrorHandler errorHandler) {
        try {
            XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
            return xMLPlatform.validateDocument(document, this.getURL(), errorHandler);
        }
        catch (XMLPlatformException xMLPlatformException) {
            if (xMLPlatformException.getErrorCode() == 27006) {
                throw XMLMarshalException.errorResolvingXMLSchema(xMLPlatformException);
            }
            return false;
        }
    }
}

