/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.transform.Source;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.record.PlatformUnmarshaller;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLUnmarshallerHandler;
import oracle.toplink.ox.platform.XMLPlatform;
import oracle.toplink.ox.schema.XMLSchemaReference;
import oracle.toplink.sessions.DatabaseSession;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;

public class XMLUnmarshaller {
    public static final int NONVALIDATING = 0;
    public static final int SCHEMA_VALIDATION = 3;
    public static final int DTD_VALIDATION = 2;
    private XMLContext xmlContext;
    private XMLUnmarshallerHandler xmlUnmarshallerHandler;
    private PlatformUnmarshaller platformUnmarshaller;
    private boolean schemasAreInitialized;

    protected XMLUnmarshaller(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
        this.initialize();
    }

    private void initialize() {
        DatabaseSession databaseSession = this.xmlContext.getSession(0);
        XMLPlatform xMLPlatform = (XMLPlatform)databaseSession.getDatasourceLogin().getDatasourcePlatform();
        this.platformUnmarshaller = xMLPlatform.newPlatformUnmarshaller(this.xmlContext);
        this.platformUnmarshaller.setWhitespacePreserving(false);
        this.setValidationMode(0);
    }

    private void initializeSchemas() {
        if (!this.schemasAreInitialized) {
            HashSet<String> hashSet = new HashSet<String>();
            int n = this.xmlContext.getSessions().size();
            for (int i = 0; i < n; ++i) {
                Iterator iterator = ((DatabaseSession)this.xmlContext.getSessions().get(i)).getDescriptors().values().iterator();
                while (iterator.hasNext()) {
                    URL uRL;
                    XMLDescriptor xMLDescriptor = (XMLDescriptor)iterator.next();
                    XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
                    if (null == xMLSchemaReference || null == (uRL = xMLSchemaReference.getURL())) continue;
                    hashSet.add(uRL.toString());
                }
            }
            hashSet.remove(null);
            this.platformUnmarshaller.setSchemas(hashSet.toArray());
            this.schemasAreInitialized = true;
        }
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public int getValidationMode() {
        return this.platformUnmarshaller.getValidationMode();
    }

    public void setValidationMode(int n) {
        if (n == 3) {
            this.initializeSchemas();
        }
        this.platformUnmarshaller.setValidationMode(n);
    }

    public EntityResolver getEntityResolver() {
        return this.platformUnmarshaller.getEntityResolver();
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.platformUnmarshaller.setEntityResolver(entityResolver);
    }

    public ErrorHandler getErrorHandler() {
        return this.platformUnmarshaller.getErrorHandler();
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.platformUnmarshaller.setErrorHandler(errorHandler);
    }

    public Object unmarshal(File file) throws XMLMarshalException {
        if (file == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file, this);
    }

    public Object unmarshal(File file, Class clazz) throws XMLMarshalException {
        if (null == file || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(file, clazz, this);
    }

    public Object unmarshal(InputStream inputStream) throws XMLMarshalException {
        if (inputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream, this);
    }

    public Object unmarshal(InputStream inputStream, Class clazz) throws XMLMarshalException {
        if (null == inputStream || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputStream, clazz, this);
    }

    public Object unmarshal(Reader reader) throws XMLMarshalException {
        if (reader == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader, this);
    }

    public Object unmarshal(Reader reader, Class clazz) throws XMLMarshalException {
        if (null == reader || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(reader, clazz, this);
    }

    public Object unmarshal(URL uRL) throws XMLMarshalException {
        if (uRL == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(uRL, this);
    }

    public Object unmarshal(URL uRL, Class clazz) throws XMLMarshalException {
        if (null == uRL || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(uRL, clazz, this);
    }

    public Object unmarshal(InputSource inputSource) throws XMLMarshalException {
        if (inputSource == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource, this);
    }

    public Object unmarshal(InputSource inputSource, Class clazz) throws XMLMarshalException {
        if (null == inputSource || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(inputSource, clazz, this);
    }

    public Object unmarshal(Node node) throws XMLMarshalException {
        if (node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        if (node.getNodeType() == 9 || node.getNodeType() == 1 || node.getNodeType() == 11) {
            return this.platformUnmarshaller.unmarshal(node, this);
        }
        throw XMLMarshalException.unmarshalException();
    }

    public Object unmarshal(Node node, Class clazz) throws XMLMarshalException {
        if (null == node || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(node, clazz, this);
    }

    public Object unmarshal(Source source) throws XMLMarshalException {
        if (source == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(source, this);
    }

    public Object unmarshal(Source source, Class clazz) throws XMLMarshalException {
        if (null == source || null == clazz) {
            throw XMLMarshalException.nullArgumentException();
        }
        return this.platformUnmarshaller.unmarshal(source, clazz, this);
    }

    public XMLUnmarshallerHandler getUnmarshallerHandler() {
        if (null == this.xmlUnmarshallerHandler) {
            this.xmlUnmarshallerHandler = new XMLUnmarshallerHandler(this);
        }
        return this.xmlUnmarshallerHandler;
    }
}

