/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.ox;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Enumeration;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import oracle.toplink.exceptions.XMLMarshalException;
import oracle.toplink.internal.ox.FragmentContentHandler;
import oracle.toplink.internal.ox.TreeObjectBuilder;
import oracle.toplink.internal.ox.XMLObjectBuilder;
import oracle.toplink.internal.ox.XPathEngine;
import oracle.toplink.internal.ox.XPathFragment;
import oracle.toplink.ox.NamespaceResolver;
import oracle.toplink.ox.XMLContext;
import oracle.toplink.ox.XMLDescriptor;
import oracle.toplink.ox.XMLField;
import oracle.toplink.ox.record.ContentHandlerRecord;
import oracle.toplink.ox.record.FormattedWriterRecord;
import oracle.toplink.ox.record.MarshalRecord;
import oracle.toplink.ox.record.NodeRecord;
import oracle.toplink.ox.record.WriterRecord;
import oracle.toplink.ox.record.XMLRecord;
import oracle.toplink.platform.xml.XMLPlatform;
import oracle.toplink.platform.xml.XMLPlatformException;
import oracle.toplink.platform.xml.XMLPlatformFactory;
import oracle.toplink.platform.xml.XMLTransformer;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.sessions.DatabaseSession;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XMLMarshaller {
    private static final String DEFAULT_XML_ENCODING = "UTF-8";
    private static final String DEFAULT_XML_VERSION = "1.0";
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private XMLTransformer transformer;
    private XMLContext xmlContext;

    public XMLMarshaller(XMLContext xMLContext) {
        this.xmlContext = xMLContext;
        this.initialize();
    }

    private void initialize() {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        this.transformer = xMLPlatform.newXMLTransformer();
        this.setEncoding(DEFAULT_XML_ENCODING);
        this.setFormattedOutput(true);
    }

    public XMLContext getXMLContext() {
        return this.xmlContext;
    }

    public boolean isFormattedOutput() {
        return this.transformer.isFormattedOutput();
    }

    public void setFormattedOutput(boolean bl) {
        this.transformer.setFormattedOutput(bl);
    }

    public String getEncoding() {
        return this.transformer.getEncoding();
    }

    public void setEncoding(String string) {
        this.transformer.setEncoding(string);
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public String getNoNamespaceSchemaLocation() {
        return this.noNamespaceSchemaLocation;
    }

    public void setNoNamespaceSchemaLocation(String string) {
        this.noNamespaceSchemaLocation = string;
    }

    public void marshal(Object object, Result result) throws XMLMarshalException {
        if (object == null || result == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        if (!xMLDescriptor.shouldPreserveDocument()) {
            if (result instanceof DOMResult) {
                DOMResult dOMResult = (DOMResult)result;
                this.marshal(object, dOMResult.getNode());
            } else if (result instanceof SAXResult) {
                SAXResult sAXResult = (SAXResult)result;
                this.marshal(object, sAXResult.getHandler());
            } else {
                StreamResult streamResult = (StreamResult)result;
                Writer writer = streamResult.getWriter();
                if (null == writer) {
                    this.marshal(object, streamResult.getOutputStream());
                } else {
                    this.marshal(object, writer);
                }
            }
            return;
        }
        try {
            Document document = this.objectToXML(object);
            if (result instanceof SAXResult && this.isFragment()) {
                FragmentContentHandler fragmentContentHandler = new FragmentContentHandler(((SAXResult)result).getHandler());
                this.transformer.transform((Node)document, fragmentContentHandler);
            } else {
                this.transformer.transform((Node)document, result);
            }
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
    }

    public void marshal(Object object, OutputStream outputStream) throws XMLMarshalException {
        if (object == null || outputStream == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, this.getEncoding());
            this.marshal(object, outputStreamWriter);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw XMLMarshalException.marshalException(unsupportedEncodingException);
        }
    }

    public void marshal(Object object, Writer writer) throws XMLMarshalException {
        if (object == null || writer == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        if (!xMLDescriptor.shouldPreserveDocument()) {
            WriterRecord writerRecord = this.isFormattedOutput() ? new FormattedWriterRecord() : new WriterRecord();
            writerRecord.setWriter(writer);
            this.marshal(object, writerRecord);
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                throw XMLMarshalException.marshalException(iOException);
            }
            return;
        }
        try {
            Document document = this.objectToXML(object);
            this.transformer.transform((Node)document, writer);
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
    }

    public void marshal(Object object, ContentHandler contentHandler) throws XMLMarshalException {
        if (object == null || contentHandler == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        if (!xMLDescriptor.shouldPreserveDocument()) {
            ContentHandlerRecord contentHandlerRecord = new ContentHandlerRecord();
            contentHandlerRecord.setContentHandler(contentHandler);
            this.marshal(object, contentHandlerRecord);
            return;
        }
        try {
            Document document = this.objectToXML(object);
            if (this.isFragment()) {
                FragmentContentHandler fragmentContentHandler = new FragmentContentHandler(contentHandler);
                this.transformer.transform((Node)document, fragmentContentHandler);
            } else {
                this.transformer.transform((Node)document, contentHandler);
            }
        }
        catch (XMLPlatformException xMLPlatformException) {
            throw XMLMarshalException.marshalException(xMLPlatformException);
        }
    }

    public void marshal(Object object, Node node) throws XMLMarshalException {
        if (object == null || node == null) {
            throw XMLMarshalException.nullArgumentException();
        }
        try {
            XMLDescriptor xMLDescriptor = this.getDescriptor(object);
            if (!xMLDescriptor.shouldPreserveDocument()) {
                NodeRecord nodeRecord = new NodeRecord();
                nodeRecord.setDOM(node);
                if (null == xMLDescriptor.getDefaultRootElement() && node.getNodeType() == 1 && xMLDescriptor.getSchemaReference() != null && xMLDescriptor.getSchemaReference().getType() == 1) {
                    Attr attr = ((Element)node).getAttributeNodeNS("http://www.w3.org/2001/XMLSchema-instance", "type");
                    if (attr == null) {
                        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
                        String string = null;
                        if (null == namespaceResolver) {
                            namespaceResolver = new NamespaceResolver();
                            xMLDescriptor.setNamespaceResolver(namespaceResolver);
                        } else {
                            string = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance");
                        }
                        if (null == string) {
                            string = namespaceResolver.generatePrefix("xsi");
                        }
                        String string2 = xMLDescriptor.getSchemaReference().getSchemaContext();
                        ((Element)node).setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + string, "http://www.w3.org/2001/XMLSchema-instance");
                        ((Element)node).setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", string + ":" + "type", string2);
                    } else {
                        String string = xMLDescriptor.getSchemaReference().getSchemaContext();
                        attr.setValue(string);
                    }
                }
                this.marshal(object, nodeRecord);
                return;
            }
            Document document = this.objectToXML(object);
            DOMResult dOMResult = new DOMResult(node);
            this.transformer.transform((Node)document, (Result)dOMResult);
        }
        catch (Exception exception) {
            if (exception instanceof XMLMarshalException) {
                throw (XMLMarshalException)exception;
            }
            throw XMLMarshalException.marshalException(exception);
        }
    }

    public void marshal(Object object, MarshalRecord marshalRecord) {
        Enumeration enumeration;
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        String string = xMLDescriptor.getDefaultRootElement();
        XPathFragment xPathFragment = null;
        if (null != string) {
            xPathFragment = new XPathFragment(string);
        }
        TreeObjectBuilder treeObjectBuilder = (TreeObjectBuilder)xMLDescriptor.getObjectBuilder();
        NamespaceResolver namespaceResolver = xMLDescriptor.getNamespaceResolver();
        String string2 = null;
        if (null != this.getSchemaLocation() || null != this.getNoNamespaceSchemaLocation()) {
            if (null == namespaceResolver) {
                namespaceResolver = new NamespaceResolver();
            }
            if (null == (string2 = namespaceResolver.resolveNamespaceURI("http://www.w3.org/2001/XMLSchema-instance"))) {
                string2 = "xsi";
                namespaceResolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
            }
        }
        if (!this.isFragment()) {
            marshalRecord.startDocument(this.getEncoding(), DEFAULT_XML_VERSION);
        }
        DatabaseSession databaseSession = this.xmlContext.getSession(object);
        if (null != xPathFragment) {
            if (null != namespaceResolver) {
                enumeration = namespaceResolver.getPrefixes();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    String string4 = namespaceResolver.resolveNamespacePrefix(string3);
                    marshalRecord.startPrefixMapping(string3, string4);
                }
            }
            marshalRecord.openStartElement(xPathFragment, namespaceResolver);
            if (null != this.getSchemaLocation()) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", string2 + ":schemaLocation", this.getSchemaLocation());
            }
            if (null != this.getNoNamespaceSchemaLocation()) {
                marshalRecord.attribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", string2 + ":noNamespaceSchemaLocation", this.getNoNamespaceSchemaLocation());
            }
            treeObjectBuilder.marshalAttributes(marshalRecord, object, databaseSession);
            marshalRecord.namespaceDeclarations(namespaceResolver);
            marshalRecord.closeStartElement();
        }
        treeObjectBuilder.buildRow(marshalRecord, object, (Session)((Object)databaseSession), this);
        if (null != xPathFragment) {
            marshalRecord.endElement(xPathFragment, namespaceResolver);
            if (null != namespaceResolver) {
                enumeration = namespaceResolver.getPrefixes();
                while (enumeration.hasMoreElements()) {
                    marshalRecord.endPrefixMapping((String)enumeration.nextElement());
                }
            }
        }
        if (!this.isFragment()) {
            marshalRecord.endDocument();
        }
    }

    public Document objectToXML(Object object) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        String string = xMLDescriptor.getDefaultRootElement();
        if (null == string) {
            throw XMLMarshalException.defaultRootElementNotSpecified(xMLDescriptor);
        }
        if (xMLDescriptor.shouldPreserveDocument()) {
            XMLRecord xMLRecord = (XMLRecord)xMLDescriptor.getObjectBuilder().createRecord();
            return this.objectToXML(object, xMLDescriptor, xMLRecord);
        }
        NodeRecord nodeRecord = new NodeRecord();
        this.marshal(object, nodeRecord);
        return ((MarshalRecord)nodeRecord).getDocument();
    }

    public Document objectToXML(Object object, Node node) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = this.getDescriptor(object);
        String string = xMLDescriptor.getDefaultRootElement();
        if (null == string) {
            throw XMLMarshalException.defaultRootElementNotSpecified(xMLDescriptor);
        }
        if (xMLDescriptor.shouldPreserveDocument()) {
            XMLRecord xMLRecord = (XMLRecord)((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).createRecord(string, node);
            return this.objectToXML(object, xMLDescriptor, xMLRecord);
        }
        NodeRecord nodeRecord = new NodeRecord(string, node);
        this.marshal(object, nodeRecord);
        return ((MarshalRecord)nodeRecord).getDocument();
    }

    public Document objectToXML(Object object, XMLDescriptor xMLDescriptor, XMLRecord xMLRecord) {
        xMLRecord = (XMLRecord)xMLDescriptor.getObjectBuilder().buildRow(xMLRecord, object, (Session)((Object)this.xmlContext.getSession(object)));
        Document document = xMLRecord.getDocument();
        this.addSchemaLocations(document);
        return document;
    }

    public void addSchemaLocations(Document document) {
        XMLField xMLField;
        Element element = document.getDocumentElement();
        NamespaceResolver namespaceResolver = new NamespaceResolver();
        namespaceResolver.put("xmlns", "http://www.w3.org/2000/xmlns/");
        namespaceResolver.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.getSchemaLocation() != null || this.getNoNamespaceSchemaLocation() != null) {
            xMLField = new XMLField("@xmlns:xsi");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, "http://www.w3.org/2001/XMLSchema-instance");
        }
        if (this.getSchemaLocation() != null) {
            xMLField = new XMLField("@xsi:schemaLocation");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, this.getSchemaLocation());
        }
        if (this.getNoNamespaceSchemaLocation() != null) {
            xMLField = new XMLField("@xsi:noNamespaceSchemaLocation");
            xMLField.setNamespaceResolver(namespaceResolver);
            XPathEngine.getInstance().create(xMLField, element, this.getNoNamespaceSchemaLocation());
        }
    }

    protected XMLDescriptor getDescriptor(Object object) throws XMLMarshalException {
        XMLDescriptor xMLDescriptor = (XMLDescriptor)this.xmlContext.getSession(object).getDescriptor(object);
        if (xMLDescriptor == null) {
            throw XMLMarshalException.descriptorNotFoundInProject(object.getClass().getName());
        }
        return xMLDescriptor;
    }

    public void setFragment(boolean bl) {
        this.transformer.setFragment(bl);
    }

    public boolean isFragment() {
        return this.transformer.isFragment();
    }
}

