/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.oraclespecific;

import java.sql.Array;
import java.sql.Connection;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Hashtable;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BLOB;
import oracle.sql.CLOB;
import oracle.sql.REF;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;
import oracle.toplink.internal.databaseaccess.DatabaseAccessor;
import oracle.toplink.internal.databaseaccess.DatabaseCall;
import oracle.toplink.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.internal.databaseaccess.Platform;
import oracle.toplink.internal.databaseaccess.SimpleAppendCallCustomParameter;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.platform.database.oracle.OraclePlatform;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.Call;

public class Oracle8Platform
extends OraclePlatform {
    protected boolean usesLocatorForLOBWrite = true;
    protected int lobValueLimits = 0;
    static /* synthetic */ Class array$Ljava$lang$Byte;
    static /* synthetic */ Class array$Ljava$lang$Character;

    protected Hashtable buildFieldTypes() {
        Hashtable hashtable = super.buildFieldTypes();
        hashtable.put(array$Ljava$lang$Byte == null ? (array$Ljava$lang$Byte = Oracle8Platform.class$("[Ljava.lang.Byte;")) : array$Ljava$lang$Byte, new FieldTypeDefinition("BLOB", false));
        hashtable.put(array$Ljava$lang$Character == null ? (array$Ljava$lang$Character = Oracle8Platform.class$("[Ljava.lang.Character;")) : array$Ljava$lang$Character, new FieldTypeDefinition("CLOB", false));
        return hashtable;
    }

    public void copyInto(Platform platform) {
        super.copyInto(platform);
        if (!(platform instanceof Oracle8Platform)) {
            return;
        }
        Oracle8Platform oracle8Platform = (Oracle8Platform)platform;
        oracle8Platform.setShouldUseLocatorForLOBWrite(this.shouldUseLocatorForLOBWrite());
        oracle8Platform.setLobValueLimits(this.getLobValueLimits());
    }

    protected boolean lobValueExceedsLimit(Object object) {
        if (object == null) {
            return false;
        }
        int n = this.getLobValueLimits();
        if (object instanceof byte[]) {
            return ((byte[])object).length >= n;
        }
        if (object instanceof String) {
            return ((String)object).length() >= n;
        }
        return false;
    }

    public Object getCustomModifyValueForCall(Call call, Object object, DatabaseField databaseField, boolean bl) {
        Class clazz = databaseField.getType();
        if (ClassConstants.BLOB.equals(clazz) || ClassConstants.CLOB.equals(clazz)) {
            if (object == null) {
                return null;
            }
            object = this.convertToDatabaseType(object);
            if (this.shouldUseLocatorForLOBWrite() && this.lobValueExceedsLimit(object)) {
                ((DatabaseCall)call).addContext(databaseField, object);
                object = ClassConstants.BLOB.equals(clazz) ? (bl ? (Object)new byte[1] : new SimpleAppendCallCustomParameter("empty_blob()")) : (bl ? new String(" ") : new SimpleAppendCallCustomParameter("empty_clob()"));
            }
            return object;
        }
        return super.getCustomModifyValueForCall(call, object, databaseField, bl);
    }

    public boolean shouldUseCustomModifyForCall(DatabaseField databaseField) {
        Class clazz;
        if (this.shouldUseLocatorForLOBWrite() && (ClassConstants.BLOB.equals(clazz = databaseField.getType()) || ClassConstants.CLOB.equals(clazz))) {
            return true;
        }
        return super.shouldUseCustomModifyForCall(databaseField);
    }

    public void setShouldUseLocatorForLOBWrite(boolean bl) {
        this.usesLocatorForLOBWrite = bl;
    }

    public boolean shouldUseLocatorForLOBWrite() {
        return this.usesLocatorForLOBWrite;
    }

    public int getLobValueLimits() {
        return this.lobValueLimits;
    }

    public void setLobValueLimits(int n) {
        this.lobValueLimits = n;
    }

    public void writeLOB(DatabaseField databaseField, Object object, ResultSet resultSet, Session session) throws SQLException {
        if (this.isBlob(databaseField.getType())) {
            BLOB bLOB = (BLOB)resultSet.getObject(databaseField.getName());
            bLOB.putBytes(1L, (byte[])object);
            session.log(1, "sql", "write_BLOB", new Long(bLOB.length()), databaseField.getName());
        } else if (this.isClob(databaseField.getType())) {
            CLOB cLOB = (CLOB)resultSet.getObject(databaseField.getName());
            cLOB.putString(1L, (String)object);
            session.log(1, "sql", "write_CLOB", new Long(cLOB.length()), databaseField.getName());
        }
    }

    protected boolean isBlob(Class clazz) {
        return ClassConstants.BLOB.equals(clazz);
    }

    protected boolean isClob(Class clazz) {
        return ClassConstants.CLOB.equals(clazz);
    }

    public Array createArray(String string, Object[] objectArray, Session session) throws SQLException {
        Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
        return new ARRAY(new ArrayDescriptor(string, connection), connection, (Object)objectArray);
    }

    public Struct createStruct(String string, Object[] objectArray, Session session) throws SQLException {
        Connection connection = ((DatabaseAccessor)session.getAccessor()).getConnection();
        return new STRUCT(new StructDescriptor(string, connection), connection, objectArray);
    }

    public Object getRefValue(Ref ref) throws SQLException {
        return ((REF)ref).getValue();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

