/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.objectrelational;

import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Vector;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.expressions.QueryKeyExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.ObjectReferenceChangeRecord;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.objectrelational.ObjectRelationalDatabaseField;
import oracle.toplink.objectrelational.ObjectRelationalDescriptor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.WriteObjectQuery;

public class ReferenceMapping
extends ObjectReferenceMapping {
    protected DatabaseField field;

    protected Vector collectFields() {
        Vector<DatabaseField> vector = new Vector<DatabaseField>(1);
        vector.addElement(this.getField());
        return vector;
    }

    public DatabaseField getField() {
        return this.field;
    }

    public String getFieldName() {
        return this.getField().getName();
    }

    public Expression getJoinCriteria(QueryKeyExpression queryKeyExpression) {
        return null;
    }

    public boolean hasConstraintDependency() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        this.setReferenceDescriptor(session.getDescriptor(this.getReferenceClass()));
        if (this.referenceDescriptor == null) {
            throw DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this);
        }
        ObjectRelationalDatabaseField objectRelationalDatabaseField = (ObjectRelationalDatabaseField)this.getField();
        objectRelationalDatabaseField.setSqlType(2006);
        if (this.referenceDescriptor instanceof ObjectRelationalDescriptor) {
            objectRelationalDatabaseField.setSqlTypeName(((ObjectRelationalDescriptor)this.referenceDescriptor).getStructureName());
        }
        this.getDescriptor().buildField(this.getField());
        this.setFields(this.collectFields());
    }

    public boolean isReferenceMapping() {
        return true;
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        Object object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object == null) {
            return;
        }
        if (this.isPrivateOwned()) {
            InsertObjectQuery insertObjectQuery = new InsertObjectQuery();
            insertObjectQuery.setIsExecutionClone(true);
            insertObjectQuery.setObject(object);
            insertObjectQuery.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(insertObjectQuery);
        } else {
            ObjectChangeSet objectChangeSet = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object;
        if (!this.isAttributeValueInstantiated(writeObjectQuery.getObject())) {
            return;
        }
        if (this.isPrivateOwned() && (object = this.readPrivateOwnedForObject(writeObjectQuery)) != null) {
            writeObjectQuery.setProperty(this, object);
        }
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        object = this.getRealAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        if (object != null) {
            ObjectChangeSet objectChangeSet = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object);
            writeObjectQuery2.setObjectChangeSet(objectChangeSet);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
    }

    protected void setField(DatabaseField databaseField) {
        this.field = databaseField;
    }

    public void setFieldName(String string) {
        this.setField(new ObjectRelationalDatabaseField(string));
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Struct struct;
        Ref ref = (Ref)databaseRow.get(this.getField());
        if (ref == null) {
            return null;
        }
        try {
            struct = (Struct)session.getPlatform().getRefValue(ref);
        }
        catch (SQLException sQLException) {
            throw DatabaseException.sqlException(sQLException);
        }
        DatabaseRow databaseRow2 = ((ObjectRelationalDescriptor)this.getReferenceDescriptor()).buildRowFromStructure(struct);
        return this.getReferenceDescriptor().getObjectBuilder().buildObject(objectLevelReadQuery, databaseRow2);
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        Object object2 = this.getRealAttributeValueFromObject(object, session);
        if (object2 == null) {
            databaseRow.put(this.getField(), (Object)null);
            return;
        }
        Ref ref = ((ObjectRelationalDescriptor)this.getReferenceDescriptor()).getRef(object2, session);
        databaseRow.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((ObjectReferenceChangeRecord)changeRecord).getNewValue();
        Object object = objectChangeSet.getUnitOfWorkClone();
        if (object == null) {
            return;
        }
        Ref ref = ((ObjectRelationalDescriptor)this.getReferenceDescriptor()).getRef(object, session);
        databaseRow.put(this.getField(), (Object)ref);
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        databaseRow.put(this.getField(), (Object)null);
    }
}

