/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.CascadeLockingPolicy;
import oracle.toplink.internal.expressions.ObjectExpression;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.indirection.ProxyIndirectionPolicy;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ObjectReferenceMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class OneToOneMapping
extends ObjectReferenceMapping
implements RelationalMapping {
    protected Map sourceToTargetKeyFields;
    protected Map targetToSourceKeyFields;
    protected boolean shouldVerifyDelete;
    protected transient Expression privateOwnedCriteria;
    protected boolean usesJoining;

    public OneToOneMapping() {
        this.selectionQuery = new ReadObjectQuery();
        this.sourceToTargetKeyFields = new HashMap(2);
        this.targetToSourceKeyFields = new HashMap(2);
        this.foreignKeyFields = NonSynchronizedVector.newInstance(1);
        this.isForeignKeyRelationship = false;
        this.shouldVerifyDelete = true;
        this.usesJoining = false;
    }

    public boolean isRelationalMapping() {
        return true;
    }

    public void addForeignKeyFieldName(String string, String string2) {
        DatabaseField databaseField = new DatabaseField(string);
        DatabaseField databaseField2 = new DatabaseField(string2);
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(databaseField);
        this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        DatabaseField databaseField = new DatabaseField(string2);
        DatabaseField databaseField2 = new DatabaseField(string);
        this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
    }

    public Expression buildObjectJoinExpression(Expression expression, Object object, Session session) {
        Expression expression2 = ((ObjectExpression)expression).getBaseExpression();
        Expression expression3 = null;
        if (object == null) {
            if (!this.isForeignKeyRelationship()) {
                throw QueryException.cannotCompareTargetForeignKeysToNull(expression2, object, this);
            }
            Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator.next();
                Expression expression4 = expression2.getField(databaseField).equal(null);
                if (expression3 == null) {
                    expression3 = expression4;
                    continue;
                }
                expression3 = expression3.and(expression4);
            }
        } else {
            if (!this.getReferenceDescriptor().getJavaClass().isInstance(object)) {
                object = ProxyIndirectionPolicy.getValueFromProxy(object);
                if (!this.getReferenceDescriptor().getJavaClass().isInstance(object)) {
                    throw QueryException.incorrectClassForObjectComparison(expression2, object, this);
                }
            }
            Enumeration enumeration = this.extractKeyFromReferenceObject(object, session).elements();
            Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField = (DatabaseField)iterator.next();
                Expression expression5 = expression2.getField(databaseField).equal(enumeration.nextElement());
                if (expression3 == null) {
                    expression3 = expression5;
                    continue;
                }
                expression3 = expression3.and(expression5);
            }
        }
        return expression3;
    }

    public Expression buildObjectJoinExpression(Expression expression, Expression expression2, Session session) {
        Expression expression3 = ((ObjectExpression)expression).getBaseExpression();
        Expression expression4 = null;
        Iterator iterator = this.getSourceToTargetKeyFields().values().iterator();
        Iterator iterator2 = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator2.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator2.next();
            DatabaseField databaseField2 = (DatabaseField)iterator.next();
            Expression expression5 = expression3.getField(databaseField).equal(expression2.getField(databaseField2));
            if (expression4 == null) {
                expression4 = expression5;
                continue;
            }
            expression4 = expression4.and(expression5);
        }
        return expression4;
    }

    public Object clone() {
        DatabaseField databaseField;
        DatabaseField databaseField2;
        DatabaseField databaseField3;
        DatabaseField databaseField4;
        OneToOneMapping oneToOneMapping = (OneToOneMapping)super.clone();
        oneToOneMapping.setForeignKeyFields(NonSynchronizedVector.newInstance(this.getForeignKeyFields().size()));
        oneToOneMapping.setSourceToTargetKeyFields(new HashMap(this.getSourceToTargetKeyFields().size()));
        oneToOneMapping.setTargetToSourceKeyFields(new HashMap(this.getTargetToSourceKeyFields().size()));
        Hashtable<DatabaseField, DatabaseField> hashtable = new Hashtable<DatabaseField, DatabaseField>(this.getTargetToSourceKeyFields().size());
        Iterator iterator = this.getForeignKeyFields().elements();
        while (iterator.hasMoreElements()) {
            databaseField4 = (DatabaseField)iterator.nextElement();
            databaseField3 = (DatabaseField)databaseField4.clone();
            hashtable.put(databaseField4, databaseField3);
            oneToOneMapping.getForeignKeyFields().addElement(databaseField3);
        }
        iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            databaseField4 = (DatabaseField)iterator.next();
            databaseField3 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField4);
            databaseField2 = (DatabaseField)hashtable.get(databaseField3);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField3.clone();
                hashtable.put(databaseField3, databaseField2);
            }
            if ((databaseField = (DatabaseField)hashtable.get(databaseField4)) == null) {
                databaseField = (DatabaseField)databaseField4.clone();
                hashtable.put(databaseField4, databaseField);
            }
            oneToOneMapping.getSourceToTargetKeyFields().put(databaseField, databaseField2);
        }
        iterator = this.getTargetToSourceKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            databaseField4 = (DatabaseField)iterator.next();
            databaseField3 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField4);
            databaseField2 = (DatabaseField)hashtable.get(databaseField4);
            if (databaseField2 == null) {
                databaseField2 = (DatabaseField)databaseField4.clone();
                hashtable.put(databaseField4, databaseField2);
            }
            if ((databaseField = (DatabaseField)hashtable.get(databaseField3)) == null) {
                databaseField = (DatabaseField)databaseField3.clone();
                hashtable.put(databaseField3, databaseField);
            }
            oneToOneMapping.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        }
        return oneToOneMapping;
    }

    public void dontUseJoining() {
        this.setUsesJoining(false);
    }

    protected Vector extractForeignKeyFromRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().getConversionManager().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    protected Vector extractKeyFromReferenceObject(Object object, Session session) {
        Vector<Object> vector = new Vector<Object>();
        Iterator iterator = this.getSourceToTargetKeyFields().values().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            vector.addElement(this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, session));
        }
        return vector;
    }

    public Vector extractPrimaryKeysForReferenceObjectFromRow(DatabaseRow databaseRow) {
        List list = this.getReferenceDescriptor().getPrimaryKeyFields();
        Vector<Object> vector = new Vector<Object>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)list.get(i);
            DatabaseField databaseField2 = (DatabaseField)this.getTargetToSourceKeyFields().get(databaseField);
            if (databaseField2 == null) {
                return new Vector(1);
            }
            vector.addElement(databaseRow.get(databaseField2));
        }
        return vector;
    }

    protected void postPrepareNestedBatchQuery(ReadQuery readQuery, ReadAllQuery readAllQuery) {
        if (!readAllQuery.isDistinctComputed()) {
            ((ObjectLevelReadQuery)readQuery).useDistinct();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session, DatabaseRow databaseRow2) {
        Hashtable<CacheKey, Object> hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, session);
            if (hashtable == null) {
                Vector vector = (Vector)session.executeQuery(databaseQuery, databaseRow2);
                hashtable = new Hashtable<CacheKey, Object>();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    Object e = enumeration.nextElement();
                    CacheKey cacheKey = new CacheKey(this.extractKeyFromReferenceObject(e, session));
                    hashtable.put(cacheKey, session.wrapObject(e));
                }
                this.setBatchReadObjects(hashtable, databaseQuery, session);
            }
        }
        return hashtable.get(new CacheKey(this.extractForeignKeyFromRow(databaseRow, session)));
    }

    public Class getFieldClassification(DatabaseField databaseField) throws DescriptorException {
        DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
        if (databaseField2 == null) {
            return null;
        }
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField2);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField2);
    }

    public Vector getForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getForeignKeyFields().size());
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    protected Map getForeignKeysToPrimaryKeys() {
        if (this.isForeignKeyRelationship()) {
            return this.getSourceToTargetKeyFields();
        }
        return this.getTargetToSourceKeyFields();
    }

    public Vector getOrderedForeignKeyFields() {
        List list = this.getPrimaryKeyDescriptor().getPrimaryKeyFields();
        Vector<DatabaseField> vector = new Vector<DatabaseField>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            DatabaseField databaseField = (DatabaseField)list.get(i);
            boolean bl = false;
            Iterator iterator = this.getForeignKeysToPrimaryKeys().keySet().iterator();
            while (iterator.hasNext()) {
                DatabaseField databaseField2 = (DatabaseField)iterator.next();
                if (!this.getForeignKeysToPrimaryKeys().get(databaseField2).equals(databaseField)) continue;
                bl = true;
                vector.addElement(databaseField2);
                break;
            }
            if (bl) continue;
            throw DescriptorException.missingForeignKeyTranslation(this, databaseField);
        }
        return vector;
    }

    protected Descriptor getPrimaryKeyDescriptor() {
        if (this.isForeignKeyRelationship()) {
            return this.getReferenceDescriptor();
        }
        return this.getDescriptor();
    }

    public Expression getPrivateOwnedCriteria() {
        if (this.privateOwnedCriteria == null) {
            this.initializePrivateOwnedCriteria();
        }
        return this.privateOwnedCriteria;
    }

    public Vector getSourceToTargetKeyFieldAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getSourceToTargetKeyFields().size());
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator iterator2 = this.getSourceToTargetKeyFields().values().iterator();
        while (iterator.hasNext()) {
            String string = ((DatabaseField)iterator.next()).getQualifiedName();
            String string2 = ((DatabaseField)iterator2.next()).getQualifiedName();
            vector.addElement(new Association(string, string2));
        }
        return vector;
    }

    public Map getSourceToTargetKeyFields() {
        return this.sourceToTargetKeyFields;
    }

    public Map getTargetToSourceKeyFields() {
        return this.targetToSourceKeyFields;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            this.getDescriptor().buildField(databaseField);
        }
        if (!this.getTargetToSourceKeyFields().isEmpty() || !this.getSourceToTargetKeyFields().isEmpty()) {
            if (this.getTargetToSourceKeyFields().isEmpty() || this.getSourceToTargetKeyFields().isEmpty()) {
                this.initializeForeignKeysWithDefaults(session);
            } else {
                this.initializeForeignKeys(session);
            }
        }
        if (this.shouldInitializeSelectionCriteria()) {
            this.initializeSelectionCriteria(session);
        } else {
            this.setShouldVerifyDelete(false);
        }
        this.setFields(this.collectFields());
    }

    protected void initializeForeignKeys(Session session) {
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        Iterator iterator2 = this.getTargetToSourceKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)iterator2.next();
            this.getDescriptor().buildField(databaseField);
            this.getReferenceDescriptor().buildField(databaseField2);
        }
    }

    protected void initializeForeignKeysWithDefaults(Session session) {
        if (this.isForeignKeyRelationship()) {
            if (this.getSourceToTargetKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List list = this.getReferenceDescriptor().getPrimaryKeyFields();
            if (list.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField databaseField = (DatabaseField)this.getSourceToTargetKeyFields().keySet().iterator().next();
            this.getDescriptor().buildField(databaseField);
            this.getSourceToTargetKeyFields().put(databaseField, list.get(0));
            this.getTargetToSourceKeyFields().put(list.get(0), databaseField);
        } else {
            if (this.getTargetToSourceKeyFields().size() != 1) {
                throw DescriptorException.foreignKeysDefinedIncorrectly(this);
            }
            List list = this.getDescriptor().getPrimaryKeyFields();
            if (list.size() != 1) {
                throw DescriptorException.sizeMismatchOfForeignKeys(this);
            }
            DatabaseField databaseField = (DatabaseField)this.getTargetToSourceKeyFields().keySet().iterator().next();
            this.getReferenceDescriptor().buildField(databaseField);
            this.getTargetToSourceKeyFields().put(databaseField, list.get(0));
            this.getSourceToTargetKeyFields().put(list.get(0), databaseField);
        }
    }

    protected void initializePrivateOwnedCriteria() {
        if (!this.isForeignKeyRelationship()) {
            this.setPrivateOwnedCriteria(this.getSelectionCriteria());
        } else {
            Expression expression = this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression();
            ExpressionBuilder expressionBuilder = new ExpressionBuilder();
            Expression expression2 = expressionBuilder.getManualQueryKey(this.getAttributeName() + "-back-ref", this.getDescriptor());
            Expression expression3 = expression.rebuildOn(expression2);
            Expression expression4 = expression2.twist(this.getSelectionCriteria(), expressionBuilder);
            if (this.getDescriptor().getQueryManager().getAdditionalJoinExpression() != null) {
                Expression expression5 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression().rebuildOn(expression2);
                expression4 = expression4 == null ? expression5 : expression4.and(expression5);
            }
            this.setPrivateOwnedCriteria(expression3.and(expression4));
        }
    }

    protected void initializeSelectionCriteria(Session session) {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            Expression expression = ((Expression)expressionBuilder).getField(databaseField2).equal(expressionBuilder.getParameter(databaseField));
            Expression expression2 = expression.and(this.getSelectionCriteria());
            this.setSelectionCriteria(expression2);
        }
    }

    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceToTargetKeyFields(), !this.isForeignKeyRelationship());
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public Expression buildSelectionCriteria() {
        if (this.getSourceToTargetKeyFields().isEmpty()) {
            throw DescriptorException.noForeignKeysAreSpecified(this);
        }
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Iterator iterator = this.getSourceToTargetKeyFields().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField2).equal(expressionBuilder.getParameter(databaseField));
            if (expression == null) {
                expression = expression2;
                continue;
            }
            expression = expression2.and(expression);
        }
        return expression;
    }

    public void buildShallowOriginalFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        Descriptor descriptor = this.getReferenceDescriptor();
        DatabaseRecord databaseRecord = new DatabaseRecord();
        Object object2 = this.getSourceToTargetKeyFields().keySet().iterator();
        while (object2.hasNext()) {
            DatabaseField databaseField = (DatabaseField)object2.next();
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            databaseRecord.put(databaseField2, databaseRow.get(databaseField));
        }
        object2 = descriptor.getObjectBuilder().buildNewInstance();
        descriptor.getObjectBuilder().buildAttributesIntoShallowObject(object2, databaseRow, objectLevelReadQuery);
        object2 = this.getIndirectionPolicy().valueFromRow(object2);
        this.setAttributeValueInObject(object, object2);
    }

    public boolean isOneToOneMapping() {
        return true;
    }

    protected Object readPrivateOwnedForObject(ObjectLevelModifyQuery objectLevelModifyQuery) throws DatabaseException {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            return super.readPrivateOwnedForObject(objectLevelModifyQuery);
        }
        if (!this.shouldVerifyDelete()) {
            return null;
        }
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)this.getSelectionQuery().clone();
        readObjectQuery.setSelectionCriteria(this.getPrivateOwnedCriteria());
        return objectLevelModifyQuery.getSession().executeQuery((DatabaseQuery)readObjectQuery, objectLevelModifyQuery.getTranslationRow());
    }

    public void rehashFieldDependancies(Session session) {
        this.setSourceToTargetKeyFields(Helper.rehashMap(this.getSourceToTargetKeyFields()));
    }

    public void setForeignKeyFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.setIsForeignKeyRelationship(true);
        this.getForeignKeyFields().addElement(databaseField);
        this.getSourceToTargetKeyFields().put(databaseField, new DatabaseField());
    }

    public void setForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setForeignKeyFields(nonSynchronizedVector);
    }

    protected void setPrivateOwnedCriteria(Expression expression) {
        this.privateOwnedCriteria = expression;
    }

    public void setShouldVerifyDelete(boolean bl) {
        this.shouldVerifyDelete = bl;
    }

    public void setSourceToTargetKeyFieldAssociations(Vector vector) {
        this.setSourceToTargetKeyFields(new HashMap(vector.size() + 1));
        this.setTargetToSourceKeyFields(new HashMap(vector.size() + 1));
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            DatabaseField databaseField = new DatabaseField((String)association.getKey());
            DatabaseField databaseField2 = new DatabaseField((String)association.getValue());
            this.getSourceToTargetKeyFields().put(databaseField, databaseField2);
            this.getTargetToSourceKeyFields().put(databaseField2, databaseField);
        }
    }

    public void setSourceToTargetKeyFields(Map map) {
        this.sourceToTargetKeyFields = map;
    }

    public void setTargetForeignKeyFieldName(String string) {
        DatabaseField databaseField = new DatabaseField(string);
        this.getTargetToSourceKeyFields().put(databaseField, new DatabaseField());
    }

    public void setTargetToSourceKeyFields(Map map) {
        this.targetToSourceKeyFields = map;
    }

    public void setUsesJoining(boolean bl) {
        if (bl == this.usesJoining) {
            return;
        }
        this.usesJoining = bl;
        if (this.getDescriptor() != null) {
            this.getDescriptor().reInitializeJoinedAttributes();
        }
    }

    public boolean shouldUseJoining() {
        return this.usesJoining;
    }

    public boolean shouldVerifyDelete() {
        return this.shouldVerifyDelete;
    }

    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isJoiningSupported() {
        return true;
    }

    public void useJoining() {
        this.setUsesJoining(true);
    }

    public void writeFromAttributeIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
            Object object2 = null;
            if (object != null) {
                object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField2, session);
            }
            databaseRow.add(databaseField, object2);
        }
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) {
        DatabaseRow databaseRow = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow != null) {
            Object object2 = databaseRow.get(databaseField);
            try {
                object2 = session.getDatasourcePlatform().convertObject(object2, this.getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            return object2;
        }
        Object object3 = this.getRealAttributeValueFromObject(object, session);
        if (object3 == null) {
            return null;
        }
        DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
        return this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object3, databaseField2, session);
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Cloneable cloneable;
        int n;
        boolean bl = objectLevelReadQuery.isAttributeJoined(this.descriptor, this.getAttributeName());
        if (!bl && !objectLevelReadQuery.hasPartialAttributeExpressions()) {
            int n2 = this.fields.size();
            for (n = 0; n < n2; ++n) {
                cloneable = (DatabaseField)this.fields.get(n);
                if (databaseRow.get((DatabaseField)cloneable) != null) continue;
                return this.indirectionPolicy.nullValueFromRow();
            }
        }
        if (bl || objectLevelReadQuery.hasPartialAttributeExpressions()) {
            Vector vector;
            DatabaseRow databaseRow2 = databaseRow;
            if (objectLevelReadQuery.getJoinedMappingIndexes() != null) {
                n = (Integer)objectLevelReadQuery.getJoinedMappingIndexes().get(this);
                cloneable = Helper.copyVector(databaseRow.getFields(), n, databaseRow.size());
                Vector vector2 = Helper.copyVector(databaseRow.getValues(), n, databaseRow.size());
                databaseRow2 = new DatabaseRecord((Vector)cloneable, vector2);
            }
            if (bl && objectLevelReadQuery.isOuterJoinedAttributeQuery() && (vector = this.referenceDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(databaseRow2, objectLevelReadQuery.getSession())) == null) {
                return this.indirectionPolicy.nullValueFromRow();
            }
            ObjectLevelReadQuery objectLevelReadQuery2 = null;
            if (objectLevelReadQuery.getJoinedMappingQueryClones() == null) {
                objectLevelReadQuery.setJoinedMappingQueryClones(new HashMap(5));
            }
            if ((objectLevelReadQuery2 = (ObjectLevelReadQuery)objectLevelReadQuery.getJoinedMappingQueryClones().get(this)) == null) {
                if (objectLevelReadQuery.getJoinedMappingQueries() != null) {
                    objectLevelReadQuery2 = (ObjectLevelReadQuery)objectLevelReadQuery.getJoinedMappingQueries().get(this);
                    objectLevelReadQuery2 = (ObjectLevelReadQuery)objectLevelReadQuery2.clone();
                } else {
                    objectLevelReadQuery2 = this.prepareNestedJoinQuery(objectLevelReadQuery);
                }
                objectLevelReadQuery.getJoinedMappingQueryClones().put(this, objectLevelReadQuery2);
            }
            objectLevelReadQuery2.setTranslationRow(databaseRow2);
            objectLevelReadQuery2.setSession(objectLevelReadQuery.getSession());
            objectLevelReadQuery2.setQueryId(objectLevelReadQuery.getQueryId());
            Object object = this.referenceDescriptor.getObjectBuilder().buildObject(objectLevelReadQuery2, databaseRow2);
            if (objectLevelReadQuery2.shouldUseWrapperPolicy() && objectLevelReadQuery2.getSession().isUnitOfWork()) {
                object = this.referenceDescriptor.getObjectBuilder().wrapObject(object, objectLevelReadQuery2.getSession());
            }
            return this.indirectionPolicy.valueFromRow(object);
        }
        return super.valueFromRow(databaseRow, objectLevelReadQuery, session);
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        DatabaseRow databaseRow2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow2 == null) {
            Object object2 = this.getRealAttributeValueFromObject(object, session);
            Enumeration enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
                Object object3 = null;
                if (object2 != null) {
                    object3 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, session);
                }
                databaseRow.add(databaseField, object3);
            }
        } else {
            Enumeration enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                Object object4 = databaseRow2.get(databaseField);
                databaseRow.add(databaseField, object4);
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsert(Object object, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseRow.add(databaseField, null);
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
        DatabaseRow databaseRow2 = this.getIndirectionPolicy().extractReferenceRow(this.getAttributeValueFromObject(object));
        if (databaseRow2 == null) {
            Object object2 = this.getRealAttributeValueFromObject(object, session);
            Enumeration enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                DatabaseField databaseField2 = (DatabaseField)this.getSourceToTargetKeyFields().get(databaseField);
                Object object3 = null;
                if (object2 != null) {
                    object3 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object2, databaseField2, session);
                }
                databaseRow.add(databaseField, object3);
            }
        } else {
            Enumeration enumeration = this.getForeignKeyFields().elements();
            while (enumeration.hasMoreElements()) {
                DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
                Object object4 = databaseRow2.get(databaseField);
                databaseRow.add(databaseField, object4);
            }
        }
    }

    public void writeFromObjectIntoRowForShallowInsertWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseRow.add(databaseField, null);
        }
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly() || !this.isForeignKeyRelationship()) {
            return;
        }
        Enumeration enumeration = this.getForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            databaseRow.add(databaseField, null);
        }
    }
}

