/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.ConversionException;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.OptimisticLockException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.expressions.ExpressionBuilder;
import oracle.toplink.internal.descriptors.CascadeLockingPolicy;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.queryframework.ContainerPolicy;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.internal.sessions.UnitOfWorkChangeSet;
import oracle.toplink.mappings.CollectionMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.DeleteAllQuery;
import oracle.toplink.queryframework.DeleteObjectQuery;
import oracle.toplink.queryframework.InsertObjectQuery;
import oracle.toplink.queryframework.ObjectLevelModifyQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class OneToManyMapping
extends CollectionMapping
implements RelationalMapping {
    protected transient Vector targetForeignKeyFields;
    protected transient Vector sourceKeyFields;
    protected transient Map targetForeignKeysToSourceKeys = new HashMap(2);
    protected transient Map sourceKeysToTargetForeignKeys = new HashMap(2);

    public OneToManyMapping() {
        this.sourceKeyFields = NonSynchronizedVector.newInstance(1);
        this.targetForeignKeyFields = NonSynchronizedVector.newInstance(1);
        this.deleteAllQuery = new DeleteAllQuery();
    }

    public boolean isRelationalMapping() {
        return true;
    }

    protected void addTargetForeignKeyField(DatabaseField databaseField, DatabaseField databaseField2) {
        this.getTargetForeignKeyFields().addElement(databaseField);
        this.getSourceKeyFields().addElement(databaseField2);
    }

    public void addTargetForeignKeyFieldName(String string, String string2) {
        this.addTargetForeignKeyField(new DatabaseField(string), new DatabaseField(string2));
    }

    protected Expression buildDefaultSelectionCriteria() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Iterator iterator = this.getTargetForeignKeysToSourceKeys().keySet().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            DatabaseField databaseField2 = (DatabaseField)this.getTargetForeignKeysToSourceKeys().get(databaseField);
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    public Expression buildSelectionCriteria() {
        Expression expression = null;
        ExpressionBuilder expressionBuilder = new ExpressionBuilder();
        Enumeration enumeration = this.getSourceKeyFields().elements();
        Enumeration enumeration2 = this.getTargetForeignKeyFields().elements();
        while (enumeration2.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration2.nextElement();
            DatabaseField databaseField2 = (DatabaseField)enumeration.nextElement();
            Expression expression2 = ((Expression)expressionBuilder).getField(databaseField).equal(expressionBuilder.getParameter(databaseField2));
            expression = expression2.and(expression);
        }
        return expression;
    }

    public Object clone() {
        OneToManyMapping oneToManyMapping = (OneToManyMapping)super.clone();
        oneToManyMapping.setTargetForeignKeysToSourceKeys(new HashMap(this.getTargetForeignKeysToSourceKeys()));
        return oneToManyMapping;
    }

    protected void deleteAll(DeleteObjectQuery deleteObjectQuery) throws DatabaseException {
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ((DeleteAllQuery)this.getDeleteAllQuery()).executeDeleteAll(deleteObjectQuery.getSession().getSessionForClass(this.getReferenceClass()), deleteObjectQuery.getTranslationRow(), this.getContainerPolicy().vectorFor(object, deleteObjectQuery.getSession()));
    }

    protected void deleteReferenceObjectsLeftOnDatabase(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        Object object = this.readPrivateOwnedForObject(deleteObjectQuery);
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            deleteObjectQuery.getSession().deleteObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
        }
    }

    protected Hashtable executeBatchQuery(DatabaseQuery databaseQuery, Session session, DatabaseRow databaseRow) {
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        ContainerPolicy containerPolicy2 = ((ReadAllQuery)databaseQuery).getContainerPolicy();
        Object object = null;
        object = session.executeQuery(databaseQuery, databaseRow);
        Hashtable hashtable = new Hashtable(containerPolicy2.sizeFor(object));
        Object object2 = containerPolicy2.iteratorFor(object);
        while (containerPolicy2.hasNext(object2)) {
            Object object3 = containerPolicy2.next(object2, session);
            CacheKey cacheKey = new CacheKey(this.extractForeignKeyFromReferenceObject(object3, session));
            Object object4 = hashtable.get(cacheKey);
            if (object4 == null) {
                object4 = containerPolicy.containerInstance();
                hashtable.put(cacheKey, object4);
            }
            containerPolicy.addInto(object3, object4, session);
        }
        return hashtable;
    }

    protected Vector extractForeignKeyFromReferenceObject(Object object, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        Iterator iterator = this.getTargetForeignKeysToSourceKeys().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            DatabaseField databaseField = (DatabaseField)entry.getKey();
            DatabaseField databaseField2 = (DatabaseField)entry.getValue();
            if (object == null) {
                vector.addElement(null);
                continue;
            }
            Object object2 = this.getReferenceDescriptor().getObjectBuilder().extractValueFromObjectForField(object, databaseField, session);
            try {
                object2 = session.getDatasourcePlatform().convertObject(object2, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField2));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object2);
        }
        return vector;
    }

    protected Vector extractKeyFromRow(DatabaseRow databaseRow, Session session) {
        Vector<Object> vector = new Vector<Object>(this.getTargetForeignKeysToSourceKeys().size());
        Iterator iterator = this.getTargetForeignKeysToSourceKeys().values().iterator();
        while (iterator.hasNext()) {
            DatabaseField databaseField = (DatabaseField)iterator.next();
            Object object = databaseRow.get(databaseField);
            try {
                object = session.getDatasourcePlatform().convertObject(object, this.getDescriptor().getObjectBuilder().getFieldClassification(databaseField));
            }
            catch (ConversionException conversionException) {
                throw ConversionException.couldNotBeConverted((Object)this, this.getDescriptor(), conversionException);
            }
            vector.addElement(object);
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery databaseQuery, DatabaseRow databaseRow, Session session, DatabaseRow databaseRow2) {
        Hashtable hashtable = null;
        DatabaseQuery databaseQuery2 = databaseQuery;
        synchronized (databaseQuery2) {
            hashtable = this.getBatchReadObjects(databaseQuery, session);
            if (hashtable == null) {
                hashtable = this.executeBatchQuery(databaseQuery, session, databaseRow2);
                this.setBatchReadObjects(hashtable, databaseQuery, session);
            }
        }
        databaseQuery2 = hashtable.get(new CacheKey(this.extractKeyFromRow(databaseRow, session)));
        if (databaseQuery2 == null) {
            return this.getContainerPolicy().containerInstance();
        }
        return databaseQuery2;
    }

    public Vector getSourceKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getSourceKeyFields().size());
        Enumeration enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getSourceKeyFields() {
        return this.sourceKeyFields;
    }

    public Map getSourceKeysToTargetForeignKeys() {
        return this.sourceKeysToTargetForeignKeys;
    }

    public Vector getTargetForeignKeyFieldNames() {
        Vector<String> vector = new Vector<String>(this.getTargetForeignKeyFields().size());
        Enumeration enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(((DatabaseField)enumeration.nextElement()).getQualifiedName());
        }
        return vector;
    }

    public Vector getTargetForeignKeyFields() {
        return this.targetForeignKeyFields;
    }

    public Map getTargetForeignKeysToSourceKeys() {
        return this.targetForeignKeysToSourceKeys;
    }

    public Map getTargetForeignKeyToSourceKeys() {
        return this.getTargetForeignKeysToSourceKeys();
    }

    public boolean hasInverseConstraintDependency() {
        return true;
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        if (!this.isSourceKeySpecified()) {
            this.setSourceKeyFields(NonSynchronizedVector.newInstance(this.getDescriptor().getPrimaryKeyFields()));
        }
        this.initializeTargetForeignKeysToSourceKeys();
        if (this.shouldInitializeSelectionCriteria()) {
            this.setSelectionCriteria(this.buildDefaultSelectionCriteria());
        }
        this.initializeDeleteAllQuery();
    }

    protected void initializeDeleteAllQuery() {
        ((DeleteAllQuery)this.getDeleteAllQuery()).setReferenceClass(this.getReferenceClass());
        if (!this.hasCustomDeleteAllQuery()) {
            if (this.getSelectionCriteria() == null) {
                this.getDeleteAllQuery().setSelectionCriteria(this.buildDefaultSelectionCriteria());
            } else {
                this.getDeleteAllQuery().setSelectionCriteria(this.getSelectionCriteria());
            }
        }
    }

    protected void initializeTargetForeignKeysToSourceKeys() throws DescriptorException {
        if (this.getTargetForeignKeyFields().isEmpty()) {
            if (this.shouldInitializeSelectionCriteria()) {
                throw DescriptorException.noTargetForeignKeysSpecified(this);
            }
            return;
        }
        if (this.getTargetForeignKeyFields().size() != this.getSourceKeyFields().size()) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        Enumeration enumeration = this.getTargetForeignKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getReferenceDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
        enumeration = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            this.getDescriptor().buildField((DatabaseField)enumeration.nextElement());
        }
        enumeration = this.getTargetForeignKeyFields().elements();
        Enumeration enumeration2 = this.getSourceKeyFields().elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Object e2 = enumeration2.nextElement();
            this.getTargetForeignKeysToSourceKeys().put(e, e2);
            this.getSourceKeysToTargetForeignKeys().put(e2, e);
        }
    }

    public boolean isOneToManyMapping() {
        return true;
    }

    protected boolean isSourceKeySpecified() {
        return !this.getSourceKeyFields().isEmpty();
    }

    protected boolean mustDeleteReferenceObjectsOneByOne() {
        Descriptor descriptor = this.getReferenceDescriptor();
        return descriptor.hasDependencyOnParts() || descriptor.usesOptimisticLocking() || descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses() || descriptor.hasMultipleTables();
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (writeObjectQuery.shouldCascadeOnlyDependentParts()) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        Object object2 = containerPolicy.iteratorFor(object);
        while (containerPolicy.hasNext(object2)) {
            Serializable serializable;
            Object object3 = containerPolicy.next(object2, writeObjectQuery.getSession());
            if (this.isPrivateOwned()) {
                serializable = new InsertObjectQuery();
                serializable.setIsExecutionClone(true);
                serializable.setObject(object3);
                serializable.setCascadePolicy(writeObjectQuery.getCascadePolicy());
                writeObjectQuery.getSession().executeQuery((DatabaseQuery)serializable);
                continue;
            }
            if (writeObjectQuery.getSession().getCommitManager().isCommitInPreModify(object3)) continue;
            serializable = null;
            UnitOfWorkChangeSet unitOfWorkChangeSet = null;
            if (writeObjectQuery.getSession().isUnitOfWork() && ((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet() != null) {
                unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWork)writeObjectQuery.getSession()).getUnitOfWorkChangeSet();
                serializable = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object3);
            }
            WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
            writeObjectQuery2.setIsExecutionClone(true);
            writeObjectQuery2.setObject(object3);
            writeObjectQuery2.setCascadePolicy(writeObjectQuery.getCascadePolicy());
            writeObjectQuery.getSession().executeQuery(writeObjectQuery2);
        }
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(writeObjectQuery)) {
            return;
        }
        if (!this.isAttributeValueInstantiatedOrChanged(writeObjectQuery.getObject())) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(writeObjectQuery.getObject(), writeObjectQuery.getSession());
        Object object2 = this.readPrivateOwnedForObject(writeObjectQuery);
        this.compareObjectsAndWrite(object2, object, writeObjectQuery);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.shouldObjectModifyCascadeToParts(deleteObjectQuery)) {
            return;
        }
        Object object = this.getRealCollectionAttributeValueFromObject(deleteObjectQuery.getObject(), deleteObjectQuery.getSession());
        ContainerPolicy containerPolicy = this.getContainerPolicy();
        if (this.mustDeleteReferenceObjectsOneByOne()) {
            Object object2 = containerPolicy.iteratorFor(object);
            while (containerPolicy.hasNext(object2)) {
                DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
                deleteObjectQuery2.setIsExecutionClone(true);
                deleteObjectQuery2.setObject(containerPolicy.next(object2, deleteObjectQuery.getSession()));
                deleteObjectQuery2.setCascadePolicy(deleteObjectQuery.getCascadePolicy());
                deleteObjectQuery.getSession().executeQuery(deleteObjectQuery2);
            }
            if (!deleteObjectQuery.getSession().isUnitOfWork()) {
                this.deleteReferenceObjectsLeftOnDatabase(deleteObjectQuery);
            }
        } else {
            this.deleteAll(deleteObjectQuery);
        }
    }

    public void prepareCascadeLockingPolicy() {
        CascadeLockingPolicy cascadeLockingPolicy = new CascadeLockingPolicy(this.getDescriptor(), this.getReferenceDescriptor());
        cascadeLockingPolicy.setQueryKeyFields(this.getSourceKeysToTargetForeignKeys());
        this.getReferenceDescriptor().addCascadeLockingPolicy(cascadeLockingPolicy);
    }

    public void setDeleteAllSQLString(String string) {
        DeleteAllQuery deleteAllQuery = new DeleteAllQuery();
        deleteAllQuery.setSQLString(string);
        this.setCustomDeleteAllQuery(deleteAllQuery);
    }

    public void setSourceKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setSourceKeyFields(nonSynchronizedVector);
    }

    public void setSourceKeyFields(Vector vector) {
        this.sourceKeyFields = vector;
    }

    public void setTargetForeignKeyFieldName(String string) {
        this.getTargetForeignKeyFields().addElement(new DatabaseField(string));
    }

    public void setTargetForeignKeyFieldNames(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw DescriptorException.targetForeignKeysSizeMismatch(this);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.addTargetForeignKeyFieldName(stringArray[i], stringArray2[i]);
        }
    }

    public void setTargetForeignKeyFieldNames(Vector vector) {
        NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance(vector.size());
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((Vector)nonSynchronizedVector).addElement(new DatabaseField((String)enumeration.nextElement()));
        }
        this.setTargetForeignKeyFields(nonSynchronizedVector);
    }

    public void setTargetForeignKeyFields(Vector vector) {
        this.targetForeignKeyFields = vector;
    }

    protected void setTargetForeignKeysToSourceKeys(Map map) {
        this.targetForeignKeysToSourceKeys = map;
    }

    protected boolean shouldObjectModifyCascadeToParts(ObjectLevelModifyQuery objectLevelModifyQuery) {
        if (this.isReadOnly()) {
            return false;
        }
        if (this.isPrivateOwned()) {
            return true;
        }
        return objectLevelModifyQuery.shouldCascadeAllParts();
    }

    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isJoiningSupported() {
        return true;
    }

    public boolean verifyDelete(Object object, Session session) throws DatabaseException {
        if (this.isPrivateOwned()) {
            Object object2 = this.getRealCollectionAttributeValueFromObject(object, session);
            ContainerPolicy containerPolicy = this.getContainerPolicy();
            Object object3 = containerPolicy.iteratorFor(object2);
            while (containerPolicy.hasNext(object3)) {
                if (session.verifyDelete(containerPolicy.next(object3, session))) continue;
                return false;
            }
        }
        return true;
    }

    public Object valueFromRow(DatabaseRow databaseRow, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        boolean bl;
        List list = objectLevelReadQuery.getDataResults();
        if (list != null && ((bl = objectLevelReadQuery.isAttributeJoined(this.getDescriptor(), this.getAttributeName())) || objectLevelReadQuery.hasPartialAttributeExpressions())) {
            Object object = this.getContainerPolicy().containerInstance();
            ObjectLevelReadQuery objectLevelReadQuery2 = null;
            objectLevelReadQuery2 = objectLevelReadQuery.getJoinedMappingQueries() != null ? (ObjectLevelReadQuery)objectLevelReadQuery.getJoinedMappingQueries().get(this) : this.prepareNestedJoinQuery(objectLevelReadQuery);
            objectLevelReadQuery2.setSession(objectLevelReadQuery.getSession());
            objectLevelReadQuery2.setQueryId(objectLevelReadQuery.getQueryId());
            Vector vector = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(databaseRow, objectLevelReadQuery.getSession());
            CacheKey cacheKey = new CacheKey(vector);
            HashSet<CacheKey> hashSet = new HashSet<CacheKey>();
            for (int i = 0; i < list.size(); ++i) {
                Vector vector2;
                Cloneable cloneable;
                DatabaseRow databaseRow2 = (DatabaseRow)list.get(i);
                DatabaseRow databaseRow3 = databaseRow2;
                if (databaseRow3 == null) continue;
                if (objectLevelReadQuery.getJoinedMappingIndexes() != null) {
                    int n = (Integer)objectLevelReadQuery.getJoinedMappingIndexes().get(this);
                    cloneable = Helper.copyVector(databaseRow3.getFields(), n, databaseRow3.size());
                    vector2 = Helper.copyVector(databaseRow3.getValues(), n, databaseRow3.size());
                    databaseRow3 = new DatabaseRecord((Vector)cloneable, vector2);
                }
                objectLevelReadQuery2.setTranslationRow(databaseRow3);
                Vector vector3 = this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(databaseRow2, objectLevelReadQuery.getSession());
                cloneable = new CacheKey(vector3);
                if (!cacheKey.equals((CacheKey)cloneable)) continue;
                vector2 = this.getReferenceDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(databaseRow3, objectLevelReadQuery.getSession());
                if (vector2 == null) {
                    return this.getIndirectionPolicy().valueFromRow(object);
                }
                CacheKey cacheKey2 = new CacheKey(vector2);
                if (hashSet.contains(cacheKey2)) continue;
                hashSet.add(cacheKey2);
                Object object2 = this.getReferenceDescriptor().getObjectBuilder().buildObject(objectLevelReadQuery2, databaseRow3);
                objectLevelReadQuery2.setTranslationRow(null);
                this.getContainerPolicy().addInto(object2, object, objectLevelReadQuery.getSession());
                list.set(i, null);
            }
            return this.getIndirectionPolicy().valueFromRow(object);
        }
        return super.valueFromRow(databaseRow, objectLevelReadQuery, session);
    }
}

