/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.mappings;

import java.io.Serializable;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.changetracking.DeferredChangeDetectionPolicy;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.DescriptorException;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.ObjectBuilder;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.DatabaseField;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.helper.NonSynchronizedVector;
import oracle.toplink.internal.sessions.AggregateChangeRecord;
import oracle.toplink.internal.sessions.ChangeRecord;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.mappings.AggregateMapping;
import oracle.toplink.mappings.Association;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.ForeignReferenceMapping;
import oracle.toplink.mappings.RelationalMapping;
import oracle.toplink.mappings.foundation.AbstractTransformationMapping;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;
import oracle.toplink.queryframework.ObjectLevelReadQuery;
import oracle.toplink.queryframework.ReadAllQuery;
import oracle.toplink.queryframework.ReadObjectQuery;
import oracle.toplink.queryframework.WriteObjectQuery;
import oracle.toplink.sessions.DatabaseRecord;

public class AggregateObjectMapping
extends AggregateMapping
implements RelationalMapping {
    protected boolean isNullAllowed = true;
    protected transient Map aggregateToSourceFieldNames = new HashMap(5);

    public boolean isRelationalMapping() {
        return true;
    }

    public void addFieldNameTranslation(String string, String string2) {
        String string3 = string2.substring(string2.lastIndexOf(46) + 1);
        this.getAggregateToSourceFieldNames().put(string3, string);
    }

    protected boolean allAggregateFieldsAreNull(DatabaseRow databaseRow) {
        Enumeration enumeration = this.getReferenceFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow.get(databaseField);
            if (object == null) continue;
            return false;
        }
        return true;
    }

    public void allowNull() {
        this.setIsNullAllowed(true);
    }

    protected boolean backupAttributeValueIsNull(WriteObjectQuery writeObjectQuery) {
        Object object;
        return writeObjectQuery.getSession().isUnitOfWork() && (object = this.getAttributeValueFromObject(writeObjectQuery.getBackupClone())) == null;
    }

    protected Object buildAggregateFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, boolean bl) throws DatabaseException {
        Serializable serializable;
        if (this.isNullAllowed() && this.allAggregateFieldsAreNull(databaseRow)) {
            return null;
        }
        Object object2 = null;
        Session session = objectLevelReadQuery.getSession();
        Descriptor descriptor = this.getReferenceDescriptor();
        boolean bl2 = true;
        if (descriptor.hasInheritance()) {
            serializable = descriptor.getInheritancePolicy().classFromRow(databaseRow, session);
            descriptor = this.getReferenceDescriptor((Class)serializable, objectLevelReadQuery.getSession());
            if (objectLevelReadQuery.shouldRefreshIdentityMapResult() && (object2 = this.getMatchingAttributeValueFromObject(databaseRow, object, objectLevelReadQuery.getSession(), descriptor)) != null && object2.getClass() != serializable) {
                object2 = descriptor.getObjectBuilder().buildNewInstance();
                bl2 = false;
            }
        } else if (objectLevelReadQuery.shouldRefreshIdentityMapResult()) {
            object2 = this.getMatchingAttributeValueFromObject(databaseRow, object, objectLevelReadQuery.getSession(), descriptor);
        }
        if (object2 == null) {
            object2 = descriptor.getObjectBuilder().buildNewInstance();
            bl2 = false;
        }
        serializable = objectLevelReadQuery;
        if (objectLevelReadQuery.isPartialAttribute(this.getAttributeName()) || objectLevelReadQuery.isAttributeJoined(this.getDescriptor(), this.getAttributeName())) {
            serializable = (ObjectLevelReadQuery)objectLevelReadQuery.deepClone();
            if (objectLevelReadQuery.hasPartialAttributeExpressions()) {
                ((ObjectLevelReadQuery)serializable).setPartialAttributeExpressions(this.extractNestedExpressions(objectLevelReadQuery.getPartialAttributeExpressions(), ((ObjectLevelReadQuery)serializable).getExpressionBuilder(), false));
            } else {
                ((ObjectLevelReadQuery)serializable).setJoinedAttributeExpressions(this.extractNestedExpressions(objectLevelReadQuery.getJoinedAttributeExpressions(), ((ObjectLevelReadQuery)serializable).getExpressionBuilder(), false));
            }
            ((DatabaseQuery)serializable).setDescriptor(descriptor);
        }
        if (objectLevelReadQuery.isReadAllQuery() && ((ReadAllQuery)objectLevelReadQuery).isAttributeBatchRead(this.getDescriptor(), this.getAttributeName())) {
            serializable = (ObjectLevelReadQuery)objectLevelReadQuery.clone();
            ((DatabaseQuery)serializable).setProperties(objectLevelReadQuery.getProperties());
            ((ReadAllQuery)serializable).setBatchReadAttributeExpressions(this.extractNestedExpressions(((ReadAllQuery)objectLevelReadQuery).getBatchReadAttributeExpressions(), ((ObjectLevelReadQuery)serializable).getExpressionBuilder(), false));
        }
        if (bl) {
            descriptor.getObjectBuilder().buildAttributesIntoShallowObject(object2, databaseRow, (ObjectLevelReadQuery)serializable);
        } else if (objectLevelReadQuery.getSession().isUnitOfWork()) {
            descriptor.getObjectBuilder().buildAttributesIntoWorkingCopyClone(object2, (ObjectLevelReadQuery)serializable, databaseRow, (UnitOfWork)objectLevelReadQuery.getSession(), bl2);
        } else {
            descriptor.getObjectBuilder().buildAttributesIntoObject(object2, databaseRow, (ObjectLevelReadQuery)serializable, bl2);
        }
        return object2;
    }

    protected DatabaseRow buildNullReferenceRow() {
        DatabaseRecord databaseRecord = new DatabaseRecord(this.getReferenceFields().size());
        Enumeration enumeration = this.getReferenceFields().elements();
        while (enumeration.hasMoreElements()) {
            databaseRecord.put((DatabaseField)enumeration.nextElement(), (Object)null);
        }
        return databaseRecord;
    }

    public Expression buildObjectJoinExpression(Expression expression, Object object, Session session) {
        Expression expression2 = null;
        Expression expression3 = null;
        Object object2 = null;
        Descriptor descriptor = this.getReferenceDescriptor();
        if (object != null && !descriptor.getJavaClass().isInstance(object)) {
            throw QueryException.incorrectClassForObjectComparison(expression, object, this);
        }
        Enumeration enumeration = descriptor.getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            object2 = object == null ? null : databaseMapping.getAttributeValueFromObject(object);
            expression3 = expression.get(databaseMapping.getAttributeName()).equal(object2);
            if (expression2 == null) {
                expression2 = expression3;
                continue;
            }
            expression2 = expression2.and(expression3);
        }
        return expression2;
    }

    public Expression buildObjectJoinExpression(Expression expression, Expression expression2, Session session) {
        Expression expression3 = null;
        Enumeration enumeration = this.getReferenceDescriptor().getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = (DatabaseMapping)enumeration.nextElement();
            String string = databaseMapping.getAttributeName();
            Expression expression4 = expression.get(string).equal(expression2.get(string));
            if (expression3 == null) {
                expression3 = expression4;
                continue;
            }
            expression3 = expression3.and(expression4);
        }
        return expression3;
    }

    protected DatabaseRow buildRowFromAggregate(Object object, Object object2, Session session) throws DescriptorException {
        return this.buildRowFromAggregate(object, object2, session, false);
    }

    protected DatabaseRow buildRowFromAggregate(Object object, Object object2, Session session, boolean bl) throws DescriptorException {
        if (object2 == null) {
            if (this.isNullAllowed()) {
                return this.buildNullReferenceRow();
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        if (!bl && session.isClassReadOnly(object2.getClass())) {
            return new DatabaseRecord(1);
        }
        return this.getObjectBuilder(object2, session).buildRow(object2, session);
    }

    protected DatabaseRow buildRowFromAggregateWithChangeRecord(ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, Session session) throws DescriptorException {
        return this.buildRowFromAggregateWithChangeRecord(changeRecord, objectChangeSet, session, false);
    }

    protected DatabaseRow buildRowFromAggregateWithChangeRecord(ChangeRecord changeRecord, ObjectChangeSet objectChangeSet, Session session, boolean bl) throws DescriptorException {
        if (objectChangeSet == null) {
            if (this.isNullAllowed()) {
                return this.buildNullReferenceRow();
            }
            Object object = ((ObjectChangeSet)changeRecord.getOwner()).getUnitOfWorkClone();
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        if (!bl && session.isClassReadOnly(objectChangeSet.getClassType(session))) {
            return new DatabaseRecord(1);
        }
        return this.getReferenceDescriptor(objectChangeSet.getClassType(session), session).getObjectBuilder().buildRowWithChangeSet(objectChangeSet, session);
    }

    protected DatabaseRow buildRowFromAggregateForUpdate(WriteObjectQuery writeObjectQuery, Object object) throws DescriptorException {
        if (object == null) {
            if (this.isNullAllowed()) {
                if (this.backupAttributeValueIsNull(writeObjectQuery)) {
                    return new DatabaseRecord(1);
                }
                return this.buildNullReferenceRow();
            }
            throw DescriptorException.nullForNonNullAggregate(writeObjectQuery.getObject(), this);
        }
        if (!(writeObjectQuery.getBackupClone() == null || this.getMatchingBackupAttributeValue(writeObjectQuery, object) != null && object.getClass().equals(this.getMatchingBackupAttributeValue(writeObjectQuery, object).getClass()))) {
            return this.getObjectBuilder(object, writeObjectQuery.getSession()).buildRow(object, writeObjectQuery.getSession());
        }
        if (writeObjectQuery.getSession().isClassReadOnly(object.getClass())) {
            return new DatabaseRecord(1);
        }
        WriteObjectQuery writeObjectQuery2 = (WriteObjectQuery)writeObjectQuery.clone();
        writeObjectQuery2.setObject(object);
        if (writeObjectQuery.getSession().isUnitOfWork()) {
            Object object2 = this.getMatchingBackupAttributeValue(writeObjectQuery, object);
            if (object2 == null) {
                object2 = this.getObjectBuilder(object, writeObjectQuery.getSession()).buildNewInstance();
            }
            writeObjectQuery2.setBackupClone(object2);
        }
        return this.getObjectBuilder(object, writeObjectQuery.getSession()).buildRowForUpdate(writeObjectQuery2);
    }

    public void buildClone(Object object, Object object2, UnitOfWork unitOfWork) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = this.buildClonePart(object, object3, unitOfWork);
        if (object4 != null) {
            Descriptor descriptor = this.getReferenceDescriptor(object4, (Session)unitOfWork);
            descriptor.getObjectChangePolicy().setAggregateChangeListener(object2, object4, unitOfWork, descriptor, this.getAttributeName());
        }
        this.setAttributeValueInObject(object2, object4);
    }

    public void buildCloneFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, UnitOfWork unitOfWork, Session session) {
        Object object2 = this.buildAggregateFromRow(databaseRow, object, objectLevelReadQuery, false);
        Descriptor descriptor = this.getReferenceDescriptor(object2, (Session)unitOfWork);
        descriptor.getObjectChangePolicy().setAggregateChangeListener(object, object2, unitOfWork, descriptor, this.getAttributeName());
        this.setAttributeValueInObject(object, object2);
    }

    public void buildShallowOriginalFromRow(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) {
        Object object2 = this.buildAggregateFromRow(databaseRow, object, objectLevelReadQuery, true);
        this.setAttributeValueInObject(object, object2);
    }

    protected DatabaseRow buildTemplateInsertRow(Session session) {
        DatabaseRow databaseRow = this.getReferenceDescriptor().getObjectBuilder().buildTemplateInsertRow(session);
        List list = (List)this.getReferenceDescriptor().getMappings().clone();
        if (this.getReferenceDescriptor().hasInheritance()) {
            Enumeration enumeration = this.getReferenceDescriptor().getInheritancePolicy().getChildDescriptors().elements();
            while (enumeration.hasMoreElements()) {
                Enumeration enumeration2 = ((Descriptor)enumeration.nextElement()).getMappings().elements();
                while (enumeration2.hasMoreElements()) {
                    DatabaseMapping databaseMapping = (DatabaseMapping)enumeration2.nextElement();
                    if (list.contains(databaseMapping)) continue;
                    databaseMapping.writeInsertFieldsIntoRow(databaseRow, session);
                    list.add(databaseMapping);
                }
            }
        }
        return databaseRow;
    }

    public void cascadePerformRemoveIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWork);
        if (object2 == null) {
            return;
        }
        if (!identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadePerformRemove(object2, unitOfWork, identityHashtable);
        }
    }

    public void cascadeRegisterNewIfRequired(Object object, UnitOfWork unitOfWork, IdentityHashtable identityHashtable) {
        Object object2 = this.getRealAttributeValueFromObject(object, unitOfWork);
        if (object2 == null) {
            return;
        }
        if (!identityHashtable.contains(object2)) {
            identityHashtable.put(object2, object2);
            ObjectBuilder objectBuilder = this.getReferenceDescriptor(object2.getClass(), (Session)unitOfWork).getObjectBuilder();
            objectBuilder.cascadeRegisterNewForCreate(object2, unitOfWork, identityHashtable);
        }
    }

    protected Vector collectFields() {
        return this.getReferenceFields();
    }

    public void dontAllowNull() {
        this.setIsNullAllowed(false);
    }

    public Vector getAggregateToSourceFieldNameAssociations() {
        Vector<Association> vector = new Vector<Association>(this.getAggregateToSourceFieldNames().size());
        Iterator iterator = this.getAggregateToSourceFieldNames().keySet().iterator();
        Iterator iterator2 = this.getAggregateToSourceFieldNames().values().iterator();
        while (iterator.hasNext()) {
            vector.addElement(new Association(iterator.next(), iterator2.next()));
        }
        return vector;
    }

    public Map getAggregateToSourceFieldNames() {
        return this.aggregateToSourceFieldNames;
    }

    public Class getFieldClassification(DatabaseField databaseField) {
        DatabaseMapping databaseMapping = this.getReferenceDescriptor().getObjectBuilder().getMappingForField(databaseField);
        if (databaseMapping == null) {
            return null;
        }
        return databaseMapping.getFieldClassification(databaseField);
    }

    protected Object getMatchingAttributeValueFromObject(DatabaseRow databaseRow, Object object, Session session, Descriptor descriptor) {
        return this.getAttributeValueFromObject(object);
    }

    protected Object getMatchingBackupAttributeValue(WriteObjectQuery writeObjectQuery, Object object) {
        return this.getAttributeValueFromObject(writeObjectQuery.getBackupClone());
    }

    protected Descriptor getReferenceDescriptor(Class clazz, Session session) {
        if (this.getReferenceDescriptor().getJavaClass().equals(clazz)) {
            return this.getReferenceDescriptor();
        }
        Descriptor descriptor = this.getReferenceDescriptor().getInheritancePolicy().getSubclassDescriptor(clazz);
        if (descriptor == null) {
            throw DescriptorException.noSubClassMatch(clazz, this);
        }
        return descriptor;
    }

    protected Vector getReferenceFields() {
        return this.getReferenceDescriptor().getAllFields();
    }

    public boolean hasDependency() {
        return this.getReferenceDescriptor().hasDependencyOnParts();
    }

    public void initialize(Session session) throws DescriptorException {
        super.initialize(session);
        Descriptor descriptor = (Descriptor)this.getReferenceDescriptor().clone();
        if (descriptor.isChildDescriptor()) {
            Descriptor descriptor2 = session.getDescriptor(descriptor.getInheritancePolicy().getParentClass());
            this.initializeParentInheritance(descriptor2, descriptor, session);
        }
        if (!this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            descriptor.setObjectChangePolicy(new DeferredChangeDetectionPolicy());
        }
        this.setReferenceDescriptor(descriptor);
        this.initializeReferenceDescriptor(descriptor);
        descriptor.preInitialize(session);
        descriptor.initialize(session);
        this.translateFields(descriptor, session);
        if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().hasChildren()) {
            this.initializeChildInheritance(descriptor, session);
        }
        this.setFields(this.collectFields());
    }

    public void initializeChildInheritance(Descriptor descriptor, Session session) throws DescriptorException {
        if (descriptor.getInheritancePolicy().hasChildren()) {
            Vector vector = descriptor.getInheritancePolicy().getChildDescriptors();
            NonSynchronizedVector nonSynchronizedVector = NonSynchronizedVector.newInstance();
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Descriptor descriptor2 = (Descriptor)((Descriptor)enumeration.nextElement()).clone();
                descriptor2.getInheritancePolicy().setParentDescriptor(descriptor);
                this.initializeReferenceDescriptor(descriptor2);
                descriptor2.preInitialize(session);
                descriptor2.initialize(session);
                this.translateFields(descriptor2, session);
                ((Vector)nonSynchronizedVector).addElement(descriptor2);
                this.initializeChildInheritance(descriptor2, session);
            }
            descriptor.getInheritancePolicy().setChildDescriptors(nonSynchronizedVector);
        }
    }

    public void initializeParentInheritance(Descriptor descriptor, Descriptor descriptor2, Session session) throws DescriptorException {
        Cloneable cloneable;
        Descriptor descriptor3 = (Descriptor)descriptor.clone();
        if (descriptor3.getInheritancePolicy().isChildDescriptor()) {
            cloneable = session.getDescriptor(descriptor3.getJavaClass());
            this.initializeParentInheritance((Descriptor)cloneable, descriptor, session);
        }
        this.initializeReferenceDescriptor(descriptor3);
        cloneable = NonSynchronizedVector.newInstance(1);
        ((Vector)cloneable).addElement(descriptor2);
        descriptor3.getInheritancePolicy().setChildDescriptors((Vector)cloneable);
        descriptor3.preInitialize(session);
        descriptor3.initialize(session);
        this.translateFields(descriptor3, session);
    }

    protected void initializeReferenceDescriptor(Descriptor descriptor) {
        descriptor.setDefaultTable(this.getDescriptor().getDefaultTable());
        descriptor.setTables(this.getDescriptor().getTables());
        descriptor.setPrimaryKeyFields(this.getDescriptor().getPrimaryKeyFields());
    }

    public boolean isAggregateObjectMapping() {
        return true;
    }

    public boolean isChangeTrackingSupported() {
        return ClassConstants.ChangeTracker_Class.isAssignableFrom(this.getReferenceClass());
    }

    public boolean isCascadedLockingSupported() {
        return true;
    }

    public boolean isNullAllowed() {
        return this.isNullAllowed;
    }

    public void postInitialize(Session session) throws DescriptorException {
        super.postInitialize(session);
        if (this.getReferenceDescriptor() != null) {
            this.getReferenceDescriptor().postInitialize(session);
        }
    }

    public Object readFromReturnRowIntoObject(DatabaseRow databaseRow, Object object, ReadObjectQuery readObjectQuery, Collection collection) throws DatabaseException {
        int n;
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            object2 = this.readFromRowIntoObject(databaseRow, object, readObjectQuery);
            collection.add(this);
            return object2;
        }
        for (n = 0; n < this.getReferenceFields().size(); ++n) {
            DatabaseField databaseField = (DatabaseField)this.getReferenceFields().elementAt(n);
            if (!databaseRow.containsKey(databaseField)) continue;
            this.getObjectBuilder(object2, readObjectQuery.getSession()).assignReturnValueForField(object2, readObjectQuery, databaseRow, databaseField, collection);
        }
        if (this.isNullAllowed()) {
            n = 1;
            for (int i = 0; i < this.getReferenceFields().size() && n != 0; ++i) {
                DatabaseField databaseField = (DatabaseField)this.fields.elementAt(i);
                if (databaseRow.containsKey(databaseField)) {
                    n = databaseRow.get(databaseField) == null ? 1 : 0;
                    continue;
                }
                Object object3 = this.valueFromObject(object, databaseField, readObjectQuery.getSession());
                if (object3 == null) {
                    DatabaseMapping databaseMapping;
                    Object object4 = this.getDescriptor().getObjectBuilder().getBaseValueForField(databaseField, object);
                    if (object4 == null) continue;
                    DatabaseMapping databaseMapping2 = this.getDescriptor().getObjectBuilder().getBaseMappingForField(databaseField);
                    if (databaseMapping2.isForeignReferenceMapping()) {
                        databaseMapping = (ForeignReferenceMapping)databaseMapping2;
                        if (!((ForeignReferenceMapping)databaseMapping).usesIndirection()) continue;
                        n = ((ForeignReferenceMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4) ? 1 : 0;
                        continue;
                    }
                    if (!databaseMapping2.isTransformationMapping() || !((AbstractTransformationMapping)(databaseMapping = (AbstractTransformationMapping)databaseMapping2)).usesIndirection()) continue;
                    n = ((AbstractTransformationMapping)databaseMapping).getIndirectionPolicy().objectIsInstantiated(object4) ? 1 : 0;
                    continue;
                }
                n = 0;
            }
            if (n != 0) {
                object2 = null;
                this.setAttributeValueInObject(object, object2);
            }
        }
        collection.add(this);
        return object2;
    }

    public Object readFromRowIntoObject(DatabaseRow databaseRow, Object object, ObjectLevelReadQuery objectLevelReadQuery, Session session) throws DatabaseException {
        Object object2 = this.buildAggregateFromRow(databaseRow, object, objectLevelReadQuery, false);
        this.setAttributeValueInObject(object, object2);
        return object2;
    }

    public void rehashFieldDependancies(Session session) {
        this.getReferenceDescriptor().rehashFieldDependancies(session);
    }

    public void setAggregateToSourceFieldNameAssociations(Vector vector) {
        Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(vector.size() + 1);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Association association = (Association)enumeration.nextElement();
            hashtable.put(association.getKey(), association.getValue());
        }
        this.setAggregateToSourceFieldNames(hashtable);
    }

    protected void setAggregateToSourceFieldNames(Map map) {
        this.aggregateToSourceFieldNames = map;
    }

    public void setIsNullAllowed(boolean bl) {
        this.isNullAllowed = bl;
    }

    protected void translateFields(Descriptor descriptor, Session session) {
        Enumeration enumeration = descriptor.getFields().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            String string = databaseField.getName();
            String string2 = (String)this.getAggregateToSourceFieldNames().get(string);
            if (string2 == null) continue;
            DatabaseField databaseField2 = new DatabaseField(string2);
            if (databaseField2.getName().equals(string2)) {
                databaseField.setName(string2);
                continue;
            }
            databaseField.setName(databaseField2.getName());
            databaseField.setTable(descriptor.getTable(databaseField2.getTable().getName()));
        }
        descriptor.rehashFieldDependancies(session);
    }

    public void writeFromAttributeIntoRow(Object object, DatabaseRow databaseRow, Session session) {
        DatabaseRow databaseRow2 = this.buildRowFromAggregate(null, object, session);
        Enumeration enumeration = databaseRow2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object2 = databaseRow2.get(databaseField);
            databaseRow.put(databaseField, object2);
        }
    }

    public Object valueFromObject(Object object, DatabaseField databaseField, Session session) throws DescriptorException {
        Object object2 = this.getAttributeValueFromObject(object);
        if (object2 == null) {
            if (this.isNullAllowed()) {
                return null;
            }
            throw DescriptorException.nullForNonNullAggregate(object, this);
        }
        return this.getObjectBuilder(object2, session).extractValueFromObjectForField(object2, databaseField, session);
    }

    public void writeFromObjectIntoRow(Object object, DatabaseRow databaseRow, Session session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.buildRowFromAggregate(object, this.getAttributeValueFromObject(object), session);
        Enumeration enumeration = databaseRow2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object2 = databaseRow2.get(databaseField);
            databaseRow.add(databaseField, object2);
        }
    }

    public void writeFromObjectIntoRowWithChangeRecord(ChangeRecord changeRecord, DatabaseRow databaseRow, Session session) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.buildRowFromAggregateWithChangeRecord(changeRecord, (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject(), session);
        Enumeration enumeration = databaseRow2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow2.get(databaseField);
            databaseRow.add(databaseField, object);
        }
    }

    public void writeFromObjectIntoRowForUpdate(WriteObjectQuery writeObjectQuery, DatabaseRow databaseRow) throws DescriptorException {
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.buildRowFromAggregateForUpdate(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        Enumeration enumeration = databaseRow2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow2.get(databaseField);
            databaseRow.add(databaseField, object);
        }
    }

    public void writeInsertFieldsIntoRow(DatabaseRow databaseRow, Session session) {
        if (this.isReadOnly()) {
            return;
        }
        DatabaseRow databaseRow2 = this.buildTemplateInsertRow(session);
        Enumeration enumeration = databaseRow2.keys();
        while (enumeration.hasMoreElements()) {
            DatabaseField databaseField = (DatabaseField)enumeration.nextElement();
            Object object = databaseRow2.get(databaseField);
            databaseRow.add(databaseField, object);
        }
    }
}

