/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.logging;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.localization.LoggingLocalization;
import oracle.toplink.internal.localization.TraceLocalization;
import oracle.toplink.logging.DefaultSessionLog;
import oracle.toplink.logging.SessionLog;
import oracle.toplink.logging.SessionLogEntry;
import oracle.toplink.publicinterface.Session;

public abstract class AbstractSessionLog
implements SessionLog,
Cloneable {
    protected int level;
    protected static SessionLog defaultLog;
    protected oracle.toplink.sessions.Session session;
    protected String sessionType;
    protected String sessionHashCode;
    protected static String SEVERE_PREFIX;
    protected static String WARNING_PREFIX;
    protected static String INFO_PREFIX;
    protected static String CONFIG_PREFIX;
    protected static String FINE_PREFIX;
    protected static String FINER_PREFIX;
    protected static String FINEST_PREFIX;
    protected static String TOPLINK_PREFIX;
    protected static String CONNECTION_STRING;
    protected static String THREAD_STRING;
    protected Writer writer = new PrintWriter(System.out);
    protected DateFormat dateFormat;
    protected Boolean shouldLogExceptionStackTrace;
    protected Boolean shouldPrintDate;
    protected Boolean shouldPrintThread;
    protected Boolean shouldPrintSession;
    protected Boolean shouldPrintConnection;

    public int getLevel() {
        return this.getLevel(null);
    }

    public int getLevel(String string) {
        return this.level;
    }

    public void setLevel(int n) {
        this.setLevel(n, null);
    }

    public void setLevel(int n, String string) {
        this.level = n;
    }

    public boolean shouldLog(int n) {
        return this.shouldLog(n, null);
    }

    public boolean shouldLog(int n, String string) {
        return this.level <= n && !this.isOff();
    }

    public static SessionLog getLog() {
        if (defaultLog == null) {
            defaultLog = new DefaultSessionLog();
        }
        return defaultLog;
    }

    public static void setLog(SessionLog sessionLog) {
        defaultLog = sessionLog;
        defaultLog.setSession(null);
    }

    public oracle.toplink.sessions.Session getSession() {
        return this.session;
    }

    public void setSession(oracle.toplink.sessions.Session session) {
        if (this.session == null) {
            this.session = session;
            this.buildSessionType();
            this.buildSessionHashCode();
        }
    }

    public void log(int n, String string) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, null, false);
    }

    public void log(int n, String string, Object object) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object});
    }

    public void log(int n, String string, Object object, Object object2) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object, object2});
    }

    public void log(int n, String string, Object object, Object object2, Object object3) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(n, string, new Object[]{object, object2, object3});
    }

    public void log(int n, String string, Object[] objectArray) {
        this.log(n, string, objectArray, true);
    }

    public void log(int n, String string, Object[] objectArray, boolean bl) {
        if (!this.shouldLog(n)) {
            return;
        }
        this.log(new SessionLogEntry(n, null, string, objectArray, null, bl));
    }

    public abstract void log(SessionLogEntry var1);

    public synchronized void log(oracle.toplink.sessions.SessionLogEntry sessionLogEntry) {
        if (!this.shouldLog(sessionLogEntry.getLevel())) {
            return;
        }
        SessionLogEntry sessionLogEntry2 = new SessionLogEntry((Session)this.getSession());
        sessionLogEntry2.setException(sessionLogEntry.getException());
        sessionLogEntry2.setLevel(sessionLogEntry.getLevel());
        sessionLogEntry2.setMessage(sessionLogEntry.getMessage());
        sessionLogEntry2.setDate(sessionLogEntry.getDate());
        sessionLogEntry2.setConnection(sessionLogEntry.getConnection());
        sessionLogEntry2.setNameSpace(sessionLogEntry.getNameSpace());
        sessionLogEntry2.setParameters(sessionLogEntry.getParameters());
        this.log(sessionLogEntry2);
    }

    public boolean shouldPrintSession() {
        return this.shouldPrintSession == null || this.shouldPrintSession != false;
    }

    public void setShouldPrintSession(boolean bl) {
        this.shouldPrintSession = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintConnection() {
        return this.shouldPrintConnection == null || this.shouldPrintConnection != false;
    }

    public void setShouldPrintConnection(boolean bl) {
        this.shouldPrintConnection = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldLogExceptions() {
        return this.level <= 6;
    }

    public void setShouldLogExceptions(boolean bl) {
        if (bl && this.level > 6) {
            this.setLevel(6);
        }
    }

    public boolean shouldLogExceptionStackTrace() {
        if (this.shouldLogExceptionStackTrace == null) {
            return this.getLevel() <= 2;
        }
        return this.shouldLogExceptionStackTrace;
    }

    public void setShouldLogExceptionStackTrace(boolean bl) {
        this.shouldLogExceptionStackTrace = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintDate() {
        return this.shouldPrintDate == null || this.shouldPrintDate != false;
    }

    public void setShouldPrintDate(boolean bl) {
        this.shouldPrintDate = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public boolean shouldPrintThread() {
        if (this.shouldPrintThread == null) {
            return this.getLevel() <= 3;
        }
        return this.shouldPrintThread;
    }

    public void setShouldPrintThread(boolean bl) {
        this.shouldPrintThread = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public boolean shouldLogDebug() {
        return this.level <= 1;
    }

    public void setShouldLogDebug(boolean bl) {
        if (bl) {
            this.setLevel(1);
        }
    }

    protected DateFormat buildDefaultDateFormat() {
        return new SimpleDateFormat("yyyy.MM.dd hh:mm:ss.SSS");
    }

    public DateFormat getDateFormat() {
        if (this.dateFormat == null) {
            this.dateFormat = this.buildDefaultDateFormat();
        }
        return this.dateFormat;
    }

    protected String getDateString(Date date) {
        return this.getDateFormat().format(date);
    }

    protected String getSupplementDetailString(SessionLogEntry sessionLogEntry) {
        StringWriter stringWriter = new StringWriter();
        if (this.shouldPrintDate()) {
            stringWriter.write(this.getDateString(sessionLogEntry.getDate()));
            stringWriter.write("--");
        }
        if (this.shouldPrintSession() && sessionLogEntry.getSession() != null) {
            stringWriter.write(this.getSessionString(sessionLogEntry.getSession()));
            stringWriter.write("--");
        }
        if (this.shouldPrintConnection() && sessionLogEntry.getConnection() != null) {
            stringWriter.write(this.getConnectionString(sessionLogEntry.getConnection()));
            stringWriter.write("--");
        }
        if (this.shouldPrintThread()) {
            stringWriter.write(this.getThreadString(sessionLogEntry.getThread()));
            stringWriter.write("--");
        }
        return stringWriter.toString();
    }

    protected String getSessionString(oracle.toplink.sessions.Session session) {
        if (session != null) {
            return ((Session)session).getLogSessionString();
        }
        return this.getSessionString();
    }

    protected void buildSessionType() {
        this.sessionType = this.session != null ? ((Session)this.session).getSessionTypeString() : null;
    }

    protected void buildSessionHashCode() {
        this.sessionHashCode = this.session != null ? String.valueOf(System.identityHashCode(this.session)) : null;
    }

    protected String getSessionString() {
        return this.sessionType + "(" + this.sessionHashCode + ")";
    }

    protected String getConnectionString(Accessor accessor) {
        if (accessor.getDatasourceConnection() == null) {
            return CONNECTION_STRING + "(" + String.valueOf(System.identityHashCode(accessor)) + ")";
        }
        return CONNECTION_STRING + "(" + String.valueOf(System.identityHashCode(accessor.getDatasourceConnection())) + ")";
    }

    protected String getThreadString(Thread thread) {
        return THREAD_STRING + "(" + String.valueOf(thread) + ")";
    }

    protected void printPrefixString(int n) {
        try {
            switch (n) {
                case 7: {
                    if (SEVERE_PREFIX == null) {
                        SEVERE_PREFIX = LoggingLocalization.buildMessage("toplink_severe");
                    }
                    this.getWriter().write(SEVERE_PREFIX);
                    break;
                }
                case 6: {
                    if (WARNING_PREFIX == null) {
                        WARNING_PREFIX = LoggingLocalization.buildMessage("toplink_warning");
                    }
                    this.getWriter().write(WARNING_PREFIX);
                    break;
                }
                case 5: {
                    if (INFO_PREFIX == null) {
                        INFO_PREFIX = LoggingLocalization.buildMessage("toplink_info");
                    }
                    this.getWriter().write(INFO_PREFIX);
                    break;
                }
                case 4: {
                    if (CONFIG_PREFIX == null) {
                        CONFIG_PREFIX = LoggingLocalization.buildMessage("toplink_config");
                    }
                    this.getWriter().write(CONFIG_PREFIX);
                    break;
                }
                case 3: {
                    if (FINE_PREFIX == null) {
                        FINE_PREFIX = LoggingLocalization.buildMessage("toplink_fine");
                    }
                    this.getWriter().write(FINE_PREFIX);
                    break;
                }
                case 2: {
                    if (FINER_PREFIX == null) {
                        FINER_PREFIX = LoggingLocalization.buildMessage("toplink_finer");
                    }
                    this.getWriter().write(FINER_PREFIX);
                    break;
                }
                case 1: {
                    if (FINEST_PREFIX == null) {
                        FINEST_PREFIX = LoggingLocalization.buildMessage("toplink_finest");
                    }
                    this.getWriter().write(FINEST_PREFIX);
                    break;
                }
                default: {
                    if (TOPLINK_PREFIX == null) {
                        TOPLINK_PREFIX = LoggingLocalization.buildMessage("toplink");
                    }
                    this.getWriter().write(TOPLINK_PREFIX);
                    break;
                }
            }
        }
        catch (IOException iOException) {
            throw ValidationException.logIOError(iOException);
        }
    }

    public void setDateFormat(DateFormat dateFormat) {
        this.dateFormat = dateFormat;
    }

    protected String formatMessage(SessionLogEntry sessionLogEntry) {
        String string = sessionLogEntry.getMessage();
        if (sessionLogEntry.shouldTranslate()) {
            string = sessionLogEntry.getLevel() > 3 ? LoggingLocalization.buildMessage(string, sessionLogEntry.getParameters()) : TraceLocalization.buildMessage(string, sessionLogEntry.getParameters());
        } else if (string.indexOf("{0") >= 0) {
            string = MessageFormat.format(string, sessionLogEntry.getParameters());
        }
        return string;
    }

    public void throwing(Throwable throwable) {
        if (this.shouldLog(2)) {
            SessionLogEntry sessionLogEntry = new SessionLogEntry(null, throwable);
            sessionLogEntry.setLevel(2);
            this.log(sessionLogEntry);
        }
    }

    public void severe(String string) {
        this.log(7, string, null);
    }

    public void warning(String string) {
        this.log(6, string, null);
    }

    public void info(String string) {
        this.log(5, string, null);
    }

    public void config(String string) {
        this.log(4, string, null);
    }

    public void fine(String string) {
        this.log(3, string, null);
    }

    public void finer(String string) {
        this.log(2, string, null);
    }

    public void finest(String string) {
        this.log(1, string, null);
    }

    public void logThrowable(int n, Throwable throwable) {
        if (this.shouldLog(n)) {
            this.log(new SessionLogEntry(null, n, null, throwable));
        }
    }

    public boolean isOff() {
        return this.level == 8;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    static {
        SEVERE_PREFIX = null;
        WARNING_PREFIX = null;
        INFO_PREFIX = null;
        CONFIG_PREFIX = null;
        FINE_PREFIX = null;
        FINER_PREFIX = null;
        FINEST_PREFIX = null;
        TOPLINK_PREFIX = null;
        CONNECTION_STRING = "Connection";
        THREAD_STRING = "Thread";
    }
}

