/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.jts;

import java.util.Hashtable;
import oracle.toplink.exceptions.DatabaseException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.sessions.ExternalTransactionController;

public abstract class AbstractExternalTransactionController
implements ExternalTransactionController {
    protected Hashtable unitsOfWork = new Hashtable();
    protected Session session;

    public boolean hasActiveUnitOfWork() {
        Object object = null;
        try {
            object = this.getExternalTransaction();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
        if (object == null) {
            return false;
        }
        return this.getUnitsOfWork().get(object) != null;
    }

    public UnitOfWork getActiveUnitOfWork() {
        Object object = null;
        try {
            object = this.getExternalTransaction();
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
        if (object == null) {
            return null;
        }
        UnitOfWork unitOfWork = (UnitOfWork)this.getUnitsOfWork().get(object);
        if (unitOfWork == null) {
            unitOfWork = this.getSession().acquireUnitOfWork();
            this.addUnitOfWork(object, unitOfWork);
        }
        return unitOfWork;
    }

    public abstract Object getExternalTransaction() throws Exception;

    public Session getSession() {
        return this.session;
    }

    public Hashtable getUnitsOfWork() {
        return this.unitsOfWork;
    }

    public abstract void register(UnitOfWork var1, Session var2) throws Exception;

    public void registerSynchronizationListener(UnitOfWork unitOfWork, Session session) throws DatabaseException {
        try {
            unitOfWork.log(2, "transaction", "JTS_register");
            this.register(unitOfWork, session);
            unitOfWork.setSynchronized();
        }
        catch (Exception exception) {
            throw DatabaseException.cannotRegisterSynchronizatonListenerForUnitOfWork(exception);
        }
    }

    public void removeActiveUnitOfWork(Object object) {
        try {
            this.getUnitsOfWork().remove(object);
        }
        catch (Exception exception) {
            throw ValidationException.jtsExceptionRaised(exception);
        }
    }

    public void setSession(Session session) {
        this.session = session;
    }

    protected void setUnitsOfWork(Hashtable hashtable) {
        this.unitsOfWork = hashtable;
    }

    protected void addUnitOfWork(Object object, UnitOfWork unitOfWork) {
        this.getUnitsOfWork().put(object, unitOfWork);
    }
}

