/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.weaving;

import java.lang.instrument.ClassFileTransformer;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.descriptors.FieldsLockingPolicy;
import oracle.toplink.descriptors.changetracking.AttributeChangeTrackingPolicy;
import oracle.toplink.descriptors.changetracking.ObjectChangePolicy;
import oracle.toplink.indirection.ValueHolderInterface;
import oracle.toplink.internal.descriptors.OptimisticLockingPolicy;
import oracle.toplink.internal.weaving.AttributeDetails;
import oracle.toplink.internal.weaving.ClassDetails;
import oracle.toplink.internal.weaving.TopLinkWeaver;
import oracle.toplink.mappings.AggregateObjectMapping;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.OneToOneMapping;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import org.objectweb.asm.Type;

public class TransformerFactory {
    public static final String WEAVER_NULL_PROJECT = "weaver_null_project";
    public static final String WEAVER_DISABLE_BY_SYSPROP = "weaver_disable_by_system_property";
    public static final String WEAVER_ADDING_EMBEDDABLE = "weaver_adding_embeddable_class";
    public static final String WEAVER_FOUND_USER_IMPL_CT = "weaver_user_impl_change_tracking";
    public static final String WEAVER_DISABLE_CT_MISSING_FIELD = "weaver_change_tracking_disabled_missing_field";
    public static final String WEAVER_DISABLE_CT_NOT_SUPPORTED = "weaver_change_tracking_disabled_not_supported";
    public static final String WEAVER_DISABLE_VH_MISSING_FIELD = "weaver_valueholders_disabled_missing_field";
    public static final String TRACKER_CLASS_NAME = "oracle.toplink.descriptors.changetracking.ChangeTracker";
    public static final String WEAVER_FOUND_FIELD_LOCK = "weaver_found_field_lock";
    public static final String WEAVER_CLASS_NOT_IN_PROJECT = "weaver_class_not_in_project";
    public static final String WEAVER_PROCESSING_CLASS = "weaver_processing_class";
    public static final String GLOBAL_WEAVE_CHANGETRACKING = "toplink.weaving.changetracking";
    protected oracle.toplink.sessions.Session session;
    protected Collection entityClasses;
    protected Map classDetailsMap;

    public static ClassFileTransformer createTransformer(oracle.toplink.sessions.Session session, Collection collection) {
        if (session == null) {
            throw new IllegalArgumentException("Weaver session cannot be null");
        }
        if (session.getProject() == null) {
            ((Session)session).log(7, "weaver", WEAVER_NULL_PROJECT, null);
            throw new IllegalArgumentException("Weaver session's project cannot be null");
        }
        TransformerFactory transformerFactory = new TransformerFactory(session, collection);
        return transformerFactory.buildTopLinkWeaver();
    }

    public TransformerFactory(oracle.toplink.sessions.Session session, Collection collection) {
        this.session = session;
        this.entityClasses = collection;
        this.classDetailsMap = new HashMap();
        this.buildClassDetails();
    }

    public ClassFileTransformer buildTopLinkWeaver() {
        return new TopLinkWeaver(this.session, this.classDetailsMap);
    }

    protected void buildClassDetails() {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(TransformerFactory.GLOBAL_WEAVE_CHANGETRACKING, "true");
            }
        });
        boolean bl = true;
        if ("false".equalsIgnoreCase(string)) {
            bl = false;
            this.log(4, WEAVER_DISABLE_BY_SYSPROP, new Object[]{GLOBAL_WEAVE_CHANGETRACKING});
        }
        if (this.entityClasses != null && this.entityClasses.size() > 0) {
            Object object;
            for (Object object2 : this.entityClasses) {
                object = this.session.getProject().getDescriptor((Class)object2);
                if (object == null) {
                    this.log(2, WEAVER_CLASS_NOT_IN_PROJECT, new Object[]{((Class)object2).getName()});
                    continue;
                }
                this.log(2, WEAVER_PROCESSING_CLASS, new Object[]{((Class)object2).getName()});
                if (((Descriptor)object).isAggregateDescriptor()) {
                    this.collectClassDetailsForAggregate((Class)object2, bl);
                    continue;
                }
                boolean bl2 = this.canWeaveValueHolders((Class)object2);
                boolean bl3 = this.canWeaveChangeTracking((Descriptor)object, (Class)object2, bl);
                if (!bl3 && !bl2) continue;
                this.addToClassDetails((Descriptor)object, (Class)object2, bl3, bl2);
            }
            for (Object object2 : this.classDetailsMap.values()) {
                object = (ClassDetails)this.classDetailsMap.get(((ClassDetails)object2).getSuperClassName());
                if (object == null) continue;
                ((ClassDetails)object2).setSuperClassDetails((ClassDetails)object);
            }
        }
    }

    protected boolean canWeaveChangeTracking(Descriptor descriptor, Class clazz, boolean bl) {
        if (!bl) {
            return false;
        }
        Class<?>[] classArray = clazz.getInterfaces();
        for (int i = 0; i < classArray.length; ++i) {
            Class<?> clazz2 = classArray[i];
            if (!clazz2.getName().equals(TRACKER_CLASS_NAME)) continue;
            this.log(2, WEAVER_FOUND_USER_IMPL_CT, new Object[]{clazz.getName(), TRACKER_CLASS_NAME});
            return false;
        }
        OptimisticLockingPolicy optimisticLockingPolicy = descriptor.getOptimisticLockingPolicy();
        if (optimisticLockingPolicy != null && optimisticLockingPolicy instanceof FieldsLockingPolicy) {
            this.log(2, WEAVER_FOUND_FIELD_LOCK, new Object[]{clazz.getName()});
            return false;
        }
        return this.doMappingsSupportChangeTracking(descriptor, clazz, bl);
    }

    protected boolean canWeaveValueHolders(Class clazz) {
        boolean bl = true;
        boolean bl2 = false;
        Vector vector = this.session.getProject().getDescriptor(clazz).getMappings();
        for (DatabaseMapping databaseMapping : vector) {
            String string = databaseMapping.getAttributeName();
            if (!databaseMapping.isOneToOneMapping()) continue;
            if (!TransformerFactory.hasField(clazz, string)) {
                this.log(6, WEAVER_DISABLE_VH_MISSING_FIELD, new Object[]{clazz.getName(), string});
                bl = false;
                continue;
            }
            OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
            Class<ValueHolderInterface> clazz2 = null;
            try {
                clazz2 = clazz.getDeclaredField(string).getType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!oneToOneMapping.getIndirectionPolicy().usesIndirection() || clazz2 == null || clazz2.isAssignableFrom(ValueHolderInterface.class)) continue;
            bl2 = true;
            bl = true;
        }
        return bl & bl2;
    }

    protected boolean collectClassDetailsForAggregate(Class clazz, boolean bl) {
        if (!bl) {
            return false;
        }
        if (!this.entityClasses.contains(clazz)) {
            return false;
        }
        boolean bl2 = true;
        String string = clazz.getName().replace('.', '/');
        ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(string);
        if (classDetails != null) {
            return classDetails.weavedChangeTracking();
        }
        Descriptor descriptor = this.session.getDescriptor(clazz);
        bl2 = this.doMappingsSupportChangeTracking(descriptor, clazz, bl);
        this.addToClassDetails(descriptor, clazz, string, bl2, this.canWeaveValueHolders(clazz));
        return bl2;
    }

    protected Map buildAttributesMap(Descriptor descriptor, boolean bl) {
        HashMap<String, AttributeDetails> hashMap = new HashMap<String, AttributeDetails>();
        for (DatabaseMapping databaseMapping : descriptor.getMappings()) {
            String string = databaseMapping.getAttributeName();
            Class clazz = descriptor.getJavaClass();
            Class<?> clazz2 = null;
            try {
                clazz2 = clazz.getDeclaredField(string).getType();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (clazz2 == null) continue;
            Type type = Type.getType(clazz2);
            AttributeDetails attributeDetails = new AttributeDetails(string, type);
            if (databaseMapping.isCollectionMapping()) {
                attributeDetails.setCollectionMapping(true);
            } else if (databaseMapping.isOneToOneMapping()) {
                OneToOneMapping oneToOneMapping = (OneToOneMapping)databaseMapping;
                attributeDetails.referenceClass = oneToOneMapping.getReferenceClassName();
                attributeDetails.weaveVH(bl);
            }
            hashMap.put(string, attributeDetails);
        }
        return hashMap;
    }

    protected static boolean hasField(Class clazz, String string) {
        if ("java.lang.Object".equals(clazz.getName())) {
            return false;
        }
        boolean bl = false;
        try {
            Field field = clazz.getDeclaredField(string);
            bl = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl ? bl : TransformerFactory.hasField(clazz.getSuperclass(), string);
    }

    protected void log(int n, String string, Object[] objectArray) {
        ((Session)this.session).log(n, "weaver", string, objectArray);
    }

    protected void addToClassDetails(Descriptor descriptor, Class clazz, boolean bl, boolean bl2) {
        this.addToClassDetails(descriptor, clazz, clazz.getName().replace('.', '/'), bl, bl2);
    }

    protected void addToClassDetails(Descriptor descriptor, Class clazz, String string, boolean bl, boolean bl2) {
        ObjectChangePolicy objectChangePolicy;
        String string2 = clazz.getSuperclass().getName().replace('.', '/');
        ClassDetails classDetails = new ClassDetails();
        classDetails.setClassName(string);
        classDetails.setSuperClassName(string2);
        classDetails.weaveChangeTracking(bl);
        classDetails.weaveValueHolders(bl2);
        if (bl && (objectChangePolicy = descriptor.getObjectChangePolicy()).isDeferredChangeDetectionPolicy()) {
            descriptor.setObjectChangePolicy(new AttributeChangeTrackingPolicy());
        }
        classDetails.setAttributesMap(this.buildAttributesMap(descriptor, bl2));
        this.classDetailsMap.put(string, classDetails);
    }

    protected boolean doMappingsSupportChangeTracking(Descriptor descriptor, Class clazz, boolean bl) {
        Vector vector = descriptor.getMappings();
        for (DatabaseMapping databaseMapping : vector) {
            String string = databaseMapping.getAttributeName();
            if (!TransformerFactory.hasField(clazz, string)) {
                this.log(6, WEAVER_DISABLE_CT_MISSING_FIELD, new Object[]{clazz.getName(), string});
                return false;
            }
            if (databaseMapping.isAggregateMapping()) {
                AggregateObjectMapping aggregateObjectMapping = (AggregateObjectMapping)databaseMapping;
                if (this.collectClassDetailsForAggregate(aggregateObjectMapping.getReferenceClass(), bl)) continue;
                return false;
            }
            if (databaseMapping.isChangeTrackingSupported()) continue;
            this.log(2, WEAVER_DISABLE_CT_NOT_SUPPORTED, new Object[]{clazz.getName(), string});
            return false;
        }
        return true;
    }
}

