/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.helper.ConcurrencyManager;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.internal.sessions.IdentityMapAccessor;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ReadQuery;

public class UnitOfWorkIdentityMapAccessor
extends IdentityMapAccessor {
    public UnitOfWorkIdentityMapAccessor(Session session, IdentityMapManager identityMapManager) {
        super(session, identityMapManager);
    }

    public void clearQueryCache() {
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache(readQuery);
    }

    public void clearQueryCache(String string) {
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getQuery(string));
    }

    public void clearQueryCache(String string, Class clazz) {
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessor().clearQueryCache((ReadQuery)this.session.getDescriptor(clazz).getQueryManager().getQuery(string));
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        if (this.getIdentityMapManager().containsKey(vector, clazz, descriptor)) {
            return true;
        }
        return ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessorInstance().containsObjectInIdentityMap(vector, clazz, descriptor);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, DatabaseRow databaseRow, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        return super.getAllFromIdentityMap(expression, clazz, databaseRow, inMemoryQueryIndirectionPolicy, true);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        return super.getFromIdentityMapWithDeferredLock(vector, clazz, true, descriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        Object object = super.getFromIdentityMap(vector, clazz, true, descriptor);
        if (object != null) {
            return object;
        }
        return this.getAndCloneCacheKeyFromParent(vector, clazz, bl, descriptor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getAndCloneCacheKeyFromParent(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        UnitOfWork unitOfWork = (UnitOfWork)this.getSession();
        IdentityMapAccessor identityMapAccessor = unitOfWork.getParent().getIdentityMapAccessorInstance();
        CacheKey cacheKey = identityMapAccessor.getCacheKeyForObject(vector, clazz, descriptor);
        if (cacheKey == null && unitOfWork.getParent().isUnitOfWork()) {
            ((UnitOfWorkIdentityMapAccessor)identityMapAccessor).getAndCloneCacheKeyFromParent(vector, clazz, bl, descriptor);
            cacheKey = identityMapAccessor.getCacheKeyForObject(vector, clazz, descriptor);
        }
        Object object = null;
        if (cacheKey != null && (bl || !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis()))) {
            ConcurrencyManager concurrencyManager = cacheKey.getMutex();
            synchronized (concurrencyManager) {
                object = cacheKey.getObject();
                try {
                    while (cacheKey.isAcquired() && object == null) {
                        cacheKey.getMutex().wait(5L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (object == null) {
                    return null;
                }
            }
        }
        return null;
        if (this.getSession().isClassReadOnly(clazz, descriptor)) {
            return object;
        }
        return unitOfWork.cloneAndRegisterObject(object, cacheKey, descriptor);
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        return ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessorInstance().getQueryResult(readQuery, vector, bl);
    }

    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessorInstance().putQueryResult(readQuery, vector, object);
    }

    public void initializeAllIdentityMaps() {
        super.initializeAllIdentityMaps();
        ((UnitOfWork)this.getSession()).getParent().getIdentityMapAccessor().initializeAllIdentityMaps();
    }
}

