/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.internal.helper.IdentityHashtable;
import oracle.toplink.internal.sessions.ObjectChangeSet;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;

public class UnitOfWorkChangeSet
implements Serializable,
oracle.toplink.changesets.UnitOfWorkChangeSet {
    protected transient Hashtable objectChanges;
    protected transient Hashtable newObjectChangeSets;
    protected transient IdentityHashtable cloneToObjectChangeSet;
    protected transient IdentityHashtable objectChangeSetToUOWClone;
    protected IdentityHashtable aggregateList;
    protected IdentityHashtable allChangeSets;
    protected IdentityHashtable deletedObjects;
    protected boolean hasChanges;
    protected boolean hasForcedChanges;
    private transient Vector sdkAllChangeSets;
    private transient int objectChangeSetCounter = 0;

    public UnitOfWorkChangeSet() {
        this.setHasChanges(false);
    }

    public UnitOfWorkChangeSet(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
        this.allChangeSets = (IdentityHashtable)objectInputStream.readObject();
        this.deletedObjects = (IdentityHashtable)objectInputStream.readObject();
    }

    public void addDeletedObjects(IdentityHashtable identityHashtable, Session session) {
        Enumeration enumeration = identityHashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            Descriptor descriptor = session.getDescriptor(e);
            if (descriptor.isAggregateCollectionDescriptor()) continue;
            ObjectChangeSet objectChangeSet = descriptor.getObjectBuilder().createObjectChangeSet(e, this, false, session);
            objectChangeSet.setShouldBeDeleted(true);
            this.getDeletedObjects().put(objectChangeSet, objectChangeSet);
        }
    }

    public void addObjectChangeSet(ObjectChangeSet objectChangeSet) {
        if (objectChangeSet == null) {
            return;
        }
        boolean bl = objectChangeSet.hasChanges();
        if (bl) {
            this.setHasChanges(true);
            this.hasForcedChanges = this.hasForcedChanges || objectChangeSet.hasForcedChanges();
        } else {
            this.hasForcedChanges = true;
        }
        if (!objectChangeSet.isAggregate()) {
            if (bl) {
                this.getAllChangeSets().put(objectChangeSet, objectChangeSet);
            }
            if (objectChangeSet.getCacheKey() != null) {
                Hashtable<ObjectChangeSet, ObjectChangeSet> hashtable = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objectChangeSet.getClassName());
                if (hashtable == null) {
                    hashtable = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                    this.getObjectChanges().put(objectChangeSet.getClassName(), hashtable);
                    hashtable.put(objectChangeSet, objectChangeSet);
                } else {
                    hashtable.put(objectChangeSet, objectChangeSet);
                }
            }
        }
    }

    public void addNewObjectChangeSet(ObjectChangeSet objectChangeSet, Session session) {
        if (objectChangeSet == null) {
            return;
        }
        IdentityHashtable identityHashtable = (IdentityHashtable)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(session));
        if (identityHashtable == null) {
            identityHashtable = new IdentityHashtable();
            this.getNewObjectChangeSets().put(objectChangeSet.getClassType(session), identityHashtable);
        }
        identityHashtable.put(objectChangeSet, objectChangeSet);
    }

    public ObjectChangeSet findObjectChangeSet(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        Hashtable hashtable = (Hashtable)this.getObjectChanges().get(objectChangeSet.getClassName());
        ObjectChangeSet objectChangeSet2 = null;
        if (hashtable != null) {
            objectChangeSet2 = (ObjectChangeSet)hashtable.get(objectChangeSet);
        }
        if (objectChangeSet2 == null) {
            objectChangeSet2 = (ObjectChangeSet)this.getObjectChangeSetForClone(objectChangeSet.getUnitOfWorkClone());
        }
        return objectChangeSet2;
    }

    public ObjectChangeSet findOrIntegrateObjectChangeSet(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        if (objectChangeSet == null) {
            return objectChangeSet;
        }
        ObjectChangeSet objectChangeSet2 = this.findObjectChangeSet(objectChangeSet, unitOfWorkChangeSet);
        if (objectChangeSet2 == null) {
            objectChangeSet2 = new ObjectChangeSet(objectChangeSet.getPrimaryKeys(), objectChangeSet.getUnitOfWorkClone(), this, objectChangeSet.isNew());
            this.addObjectChangeSetForIdentity(objectChangeSet2, objectChangeSet2.getUnitOfWorkClone());
        }
        return objectChangeSet2;
    }

    public void addObjectChangeSetForIdentity(ObjectChangeSet objectChangeSet, Object object) {
        if (objectChangeSet == null || object == null) {
            return;
        }
        if (objectChangeSet.isAggregate()) {
            this.getAggregateList().put(objectChangeSet, objectChangeSet);
        }
        objectChangeSet.setId(++this.objectChangeSetCounter);
        this.getObjectChangeSetToUOWClone().put(objectChangeSet, object);
        this.getCloneToObjectChangeSet().put(object, objectChangeSet);
    }

    protected IdentityHashtable getAggregateList() {
        if (this.aggregateList == null) {
            this.aggregateList = new IdentityHashtable();
        }
        return this.aggregateList;
    }

    public IdentityHashtable getAllChangeSets() {
        if (this.allChangeSets == null) {
            this.allChangeSets = new IdentityHashtable();
        }
        return this.allChangeSets;
    }

    public byte[] getByteArrayRepresentation(Session session) throws IOException {
        Serializable serializable;
        Serializable serializable2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        IdentityHashtable identityHashtable = new IdentityHashtable();
        Enumeration enumeration = this.getAllChangeSets().elements();
        while (enumeration.hasMoreElements()) {
            serializable2 = (ObjectChangeSet)enumeration.nextElement();
            serializable = session.getDescriptor(((ObjectChangeSet)serializable2).getClassType(session));
            int n = ((Descriptor)serializable).getCacheSynchronizationType();
            if (((ObjectChangeSet)serializable2).isNew() && n != 3) continue;
            ((ObjectChangeSet)serializable2).setSynchronizationType(n);
            ((ObjectChangeSet)serializable2).prepareChangeRecordsForSynchronization(session);
            identityHashtable.put(serializable2, serializable2);
        }
        serializable2 = new IdentityHashtable();
        enumeration = this.getDeletedObjects().keys();
        while (enumeration.hasMoreElements()) {
            serializable = (ObjectChangeSet)enumeration.nextElement();
            Descriptor descriptor = session.getDescriptor(((ObjectChangeSet)serializable).getClassType(session));
            int n = descriptor.getCacheSynchronizationType();
            if (n == 4) continue;
            ((ObjectChangeSet)serializable).setSynchronizationType(n);
            ((ObjectChangeSet)serializable).prepareChangeRecordsForSynchronization(session);
            ((IdentityHashtable)serializable2).put(serializable, serializable);
        }
        if (identityHashtable.isEmpty() && ((IdentityHashtable)serializable2).isEmpty()) {
            return null;
        }
        objectOutputStream.writeObject(identityHashtable);
        objectOutputStream.writeObject(serializable2);
        return byteArrayOutputStream.toByteArray();
    }

    public IdentityHashtable getCloneToObjectChangeSet() {
        if (this.cloneToObjectChangeSet == null) {
            this.cloneToObjectChangeSet = new IdentityHashtable();
        }
        return this.cloneToObjectChangeSet;
    }

    public IdentityHashtable getDeletedObjects() {
        if (this.deletedObjects == null) {
            this.deletedObjects = new IdentityHashtable();
        }
        return this.deletedObjects;
    }

    public Hashtable getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new Hashtable(2);
        }
        return this.objectChanges;
    }

    public oracle.toplink.changesets.ObjectChangeSet getObjectChangeSetForClone(Object object) {
        if (object == null || this.getCloneToObjectChangeSet() == null) {
            return null;
        }
        return (oracle.toplink.changesets.ObjectChangeSet)this.getCloneToObjectChangeSet().get(object);
    }

    protected IdentityHashtable getObjectChangeSetToUOWClone() {
        if (this.objectChangeSetToUOWClone == null) {
            this.objectChangeSetToUOWClone = new IdentityHashtable();
        }
        return this.objectChangeSetToUOWClone;
    }

    public Object getUOWCloneForObjectChangeSet(oracle.toplink.changesets.ObjectChangeSet objectChangeSet) {
        if (objectChangeSet == null || this.getObjectChangeSetToUOWClone() == null) {
            return null;
        }
        return this.getObjectChangeSetToUOWClone().get(objectChangeSet);
    }

    public boolean hasChanges() {
        return this.hasChanges || !this.getDeletedObjects().isEmpty();
    }

    public void setHasChanges(boolean bl) {
        this.hasChanges = bl;
    }

    public boolean hasForcedChanges() {
        return this.hasForcedChanges;
    }

    public ObjectChangeSet mergeObjectChanges(ObjectChangeSet objectChangeSet, UnitOfWorkChangeSet unitOfWorkChangeSet) {
        ObjectChangeSet objectChangeSet2 = this.findOrIntegrateObjectChangeSet(objectChangeSet, unitOfWorkChangeSet);
        if (objectChangeSet2 != null) {
            objectChangeSet2.mergeObjectChanges(objectChangeSet, this, unitOfWorkChangeSet);
        }
        return objectChangeSet2;
    }

    public void mergeUnitOfWorkChangeSet(UnitOfWorkChangeSet unitOfWorkChangeSet, Session session, boolean bl) {
        Object object;
        Object object2;
        Object object3;
        Iterator iterator = unitOfWorkChangeSet.getObjectChanges().values().iterator();
        while (iterator.hasNext()) {
            object3 = (Hashtable)iterator.next();
            object2 = ((Hashtable)object3).values().iterator();
            while (object2.hasNext()) {
                object = (ObjectChangeSet)object2.next();
                if (((ObjectChangeSet)(object = this.mergeObjectChanges((ObjectChangeSet)object, unitOfWorkChangeSet))).isNew() && !bl) {
                    this.addNewObjectChangeSet((ObjectChangeSet)object, session);
                    continue;
                }
                this.addObjectChangeSet((ObjectChangeSet)object);
            }
        }
        object3 = unitOfWorkChangeSet.getDeletedObjects().elements();
        while (object3.hasMoreElements()) {
            object2 = (ObjectChangeSet)object3.nextElement();
            object = this.findObjectChangeSet((ObjectChangeSet)object2, unitOfWorkChangeSet);
            if (object == null) {
                object = object2;
            }
            this.getDeletedObjects().put(object, object);
        }
    }

    public void putNewObjectInChangesList(ObjectChangeSet objectChangeSet, Session session) {
        this.addObjectChangeSet(objectChangeSet);
        this.removeObjectChangeSetFromNewList(objectChangeSet, session);
    }

    public void removeObjectChangeSetFromNewList(ObjectChangeSet objectChangeSet, Session session) {
        IdentityHashtable identityHashtable = (IdentityHashtable)this.getNewObjectChangeSets().get(objectChangeSet.getClassType(session));
        if (identityHashtable != null) {
            identityHashtable.remove(objectChangeSet);
        }
    }

    public void removeObjectChangeSet(ObjectChangeSet objectChangeSet) {
        if (objectChangeSet == null) {
            return;
        }
        Object object = this.getObjectChangeSetToUOWClone().get(objectChangeSet);
        if (objectChangeSet.isAggregate()) {
            this.getAggregateList().remove(objectChangeSet);
        } else {
            Hashtable hashtable = (Hashtable)this.getObjectChanges().get(object.getClass().getName());
            if (hashtable != null) {
                hashtable.remove(objectChangeSet);
            }
        }
        this.getObjectChangeSetToUOWClone().remove(objectChangeSet);
        if (object != null) {
            this.getCloneToObjectChangeSet().remove(object);
        }
        this.getAllChangeSets().remove(objectChangeSet);
    }

    protected void setCloneToObjectChangeSet(IdentityHashtable identityHashtable) {
        this.cloneToObjectChangeSet = identityHashtable;
    }

    protected void setObjectChanges(Hashtable hashtable) {
        this.objectChanges = hashtable;
    }

    protected void setObjectChangeSetToUOWClone(IdentityHashtable identityHashtable) {
        this.objectChangeSetToUOWClone = identityHashtable;
    }

    public Vector getInternalAllChangeSets() {
        if (this.sdkAllChangeSets != null) {
            return this.sdkAllChangeSets;
        }
        Vector vector = new Vector();
        Enumeration enumeration = this.getDeletedObjects().elements();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        enumeration = this.getAllChangeSets().keys();
        while (enumeration.hasMoreElements()) {
            vector.add(enumeration.nextElement());
        }
        int n = 1;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            ((ObjectChangeSet)enumeration2.nextElement()).setId(n);
            ++n;
        }
        enumeration2 = this.getAggregateList().keys();
        while (enumeration2.hasMoreElements()) {
            ((ObjectChangeSet)enumeration2.nextElement()).setId(n);
            ++n;
        }
        if (vector.size() == 0) {
            return null;
        }
        return vector;
    }

    public Hashtable getNewObjectChangeSets() {
        if (this.newObjectChangeSets == null) {
            this.newObjectChangeSets = new Hashtable();
        }
        return this.newObjectChangeSets;
    }

    public void setInternalAllChangeSets(Vector vector) {
        if (vector == null) {
            return;
        }
        this.sdkAllChangeSets = vector;
        for (int i = 0; i < vector.size(); ++i) {
            ObjectChangeSet objectChangeSet = (ObjectChangeSet)vector.elementAt(i);
            objectChangeSet.setUOWChangeSet(this);
            if (objectChangeSet.isAggregate()) {
                this.getAggregateList().put(objectChangeSet, objectChangeSet);
            } else if (objectChangeSet.shouldBeDeleted()) {
                this.getDeletedObjects().put(objectChangeSet, objectChangeSet);
            } else {
                this.getAllChangeSets().put(objectChangeSet, objectChangeSet);
            }
            if (objectChangeSet.getCacheKey() == null) continue;
            Hashtable<ObjectChangeSet, ObjectChangeSet> hashtable = (Hashtable<ObjectChangeSet, ObjectChangeSet>)this.getObjectChanges().get(objectChangeSet.getClassName());
            if (hashtable == null) {
                hashtable = new Hashtable<ObjectChangeSet, ObjectChangeSet>(2);
                this.getObjectChanges().put(objectChangeSet.getClassName(), hashtable);
            }
            hashtable.put(objectChangeSet, objectChangeSet);
        }
    }
}

