/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sessions;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.internal.descriptors.DescriptorIterator;
import oracle.toplink.internal.helper.WriteLockManager;
import oracle.toplink.internal.identitymaps.CacheKey;
import oracle.toplink.internal.identitymaps.IdentityMap;
import oracle.toplink.internal.identitymaps.IdentityMapManager;
import oracle.toplink.publicinterface.DatabaseRow;
import oracle.toplink.publicinterface.Descriptor;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.queryframework.InMemoryQueryIndirectionPolicy;
import oracle.toplink.queryframework.ReadQuery;
import oracle.toplink.sessions.DatabaseRecord;
import oracle.toplink.sessions.Record;

public class IdentityMapAccessor
implements oracle.toplink.sessions.IdentityMapAccessor,
Serializable {
    protected IdentityMapManager identityMapManager = null;
    protected Session session = null;

    public IdentityMapAccessor(Session session, IdentityMapManager identityMapManager) {
        this.session = session;
        this.identityMapManager = identityMapManager;
    }

    public CacheKey acquireDeferredLock(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().acquireDeferredLock(vector, clazz, descriptor);
    }

    public CacheKey acquireLock(Vector vector, Class clazz, Descriptor descriptor) {
        return this.acquireLock(vector, clazz, false, descriptor);
    }

    public CacheKey acquireLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        return this.getIdentityMapManager().acquireLock(vector, clazz, bl, descriptor);
    }

    public CacheKey acquireLockNoWait(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        return this.getIdentityMapManager().acquireLockNoWait(vector, clazz, bl, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKey(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKey(vector, clazz, descriptor);
    }

    public CacheKey acquireReadLockOnCacheKeyNoWait(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().acquireReadLockOnCacheKeyNoWait(vector, clazz, descriptor);
    }

    public boolean acquireWriteLock() {
        return this.getIdentityMapManager().acquireWriteLock();
    }

    public void clearQueryCache() {
        this.getIdentityMapManager().clearQueryCache();
    }

    public void clearQueryCache(ReadQuery readQuery) {
        this.getIdentityMapManager().clearQueryCache(readQuery);
    }

    public void clearQueryCache(String string) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getQuery(string));
    }

    public void clearQueryCache(String string, Class clazz) {
        this.getIdentityMapManager().clearQueryCache((ReadQuery)this.session.getDescriptor(clazz).getQueryManager().getQuery(string));
    }

    public boolean containsObjectInIdentityMap(Object object) {
        return this.containsObjectInIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        return this.containsObjectInIdentityMap(vector, clazz, descriptor);
    }

    public boolean containsObjectInIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().containsKey(vector, clazz, descriptor);
    }

    public boolean containsObjectInIdentityMap(Record record, Class clazz) {
        return this.containsObjectInIdentityMap(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    protected Vector extractPrimaryKeyFromRow(Record record, Class clazz) {
        return this.session.getDescriptor(clazz).getObjectBuilder().extractPrimaryKeyFromRow((DatabaseRow)record, this.session);
    }

    public Vector getClassesRegistered() {
        return this.getIdentityMapManager().getClassesRegistered();
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, record, new InMemoryQueryIndirectionPolicy());
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) throws QueryException {
        return this.getIdentityMapManager().getAllFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl);
    }

    public Vector getAllFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.getAllFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, true);
    }

    public Object getFromIdentityMap(Object object) {
        return this.getFromIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public CacheKey getCacheKeyForObject(Object object) {
        return this.getCacheKeyForObject(this.getSession().keyFromObject(object), object.getClass(), this.getSession().getDescriptor(object.getClass()));
    }

    public CacheKey getCacheKeyForObject(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().getCacheKeyForObject(vector, clazz, descriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz) {
        return this.getFromIdentityMap(vector, clazz, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getFromIdentityMap(vector, clazz, true, descriptor);
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl) {
        return this.getIdentityMapManager().getFromIdentityMap(vector, clazz, bl, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(vector, clazz, bl, descriptor);
    }

    public Object getFromIdentityMap(Record record, Class clazz) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow((DatabaseRow)record, clazz), clazz);
    }

    public Object getFromIdentityMap(Record record, Class clazz, boolean bl) {
        return this.getFromIdentityMap(this.extractPrimaryKeyFromRow((DatabaseRow)record, clazz), clazz, bl);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record) throws QueryException {
        return this.getFromIdentityMap(expression, clazz, record, new InMemoryQueryIndirectionPolicy());
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy) throws QueryException {
        return this.getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, false);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl) {
        return this.getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl, true);
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl, boolean bl2) {
        return this.getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl, bl2, this.getSession().getDescriptor(clazz));
    }

    public Object getFromIdentityMap(Expression expression, Class clazz, Record record, InMemoryQueryIndirectionPolicy inMemoryQueryIndirectionPolicy, boolean bl, boolean bl2, Descriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMap(expression, clazz, record, inMemoryQueryIndirectionPolicy, bl, bl2, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getFromIdentityMapWithDeferredLock(vector, clazz, true, descriptor);
    }

    public Object getFromIdentityMapWithDeferredLock(Vector vector, Class clazz, boolean bl, Descriptor descriptor) {
        return this.getIdentityMapManager().getFromIdentityMapWithDeferredLock(vector, clazz, bl, descriptor);
    }

    public IdentityMapManager getIdentityMapManager() {
        if (this.session.hasBroker()) {
            return this.getSession().getBroker().getIdentityMapAccessorInstance().getIdentityMapManager();
        }
        return this.identityMapManager;
    }

    public IdentityMap getIdentityMap(Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        if (descriptor == null) {
            throw ValidationException.missingDescriptor(clazz.getName());
        }
        return this.getIdentityMapManager().getIdentityMap(descriptor);
    }

    public Object getQueryResult(ReadQuery readQuery, Vector vector, boolean bl) {
        return this.getIdentityMapManager().getQueryResult(readQuery, vector, bl);
    }

    public long getRemainingValidTime(Object object) {
        Vector vector = this.getSession().keyFromObject(object);
        Descriptor descriptor = this.getSession().getDescriptor(object);
        CacheKey cacheKey = this.getCacheKeyForObject(vector, object.getClass(), descriptor);
        if (cacheKey == null) {
            throw QueryException.objectDoesNotExistInCache(object);
        }
        return descriptor.getCacheInvalidationPolicy().getRemainingValidTime(cacheKey);
    }

    public Session getSession() {
        return this.session;
    }

    public Object getWrapper(Vector vector, Class clazz) {
        return this.getIdentityMapManager().getWrapper(vector, clazz);
    }

    public WriteLockManager getWriteLockManager() {
        return this.getIdentityMapManager().getWriteLockManager();
    }

    public Object getWriteLockValue(Object object) {
        return this.getWriteLockValue(this.getSession().keyFromObject(object), object.getClass());
    }

    public Object getWriteLockValue(Vector vector, Class clazz) {
        return this.getWriteLockValue(vector, clazz, this.getSession().getDescriptor(clazz));
    }

    public Object getWriteLockValue(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().getWriteLockValue(vector, clazz, descriptor);
    }

    public void initializeAllIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_all_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
    }

    public void initializeIdentityMap(Class clazz) {
        this.getSession().log(2, "cache", "initialize_identitymap", clazz);
        this.getIdentityMapManager().initializeIdentityMap(clazz);
    }

    public void initializeIdentityMaps() {
        this.getSession().log(2, "cache", "initialize_identitymaps");
        this.getIdentityMapManager().initializeIdentityMaps();
        this.getSession().getCommitManager().reinitialize();
    }

    public void invalidateObject(Object object) {
        this.invalidateObject(this.getSession().keyFromObject(object), object.getClass());
    }

    public void invalidateObject(Vector vector, Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        CacheKey cacheKey = this.getCacheKeyForObject(vector, clazz, descriptor);
        if (cacheKey != null) {
            cacheKey.setInvalidationState(-1);
        }
    }

    public void invalidateObject(Record record, Class clazz) {
        this.invalidateObject(this.extractPrimaryKeyFromRow(record, clazz), clazz);
    }

    public void invalidateObjects(Expression expression) {
        this.invalidateObjects(this.getAllFromIdentityMap(expression, expression.getBuilder().getQueryClass(), new DatabaseRecord(1)));
    }

    public void invalidateObjects(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.invalidateObject(enumeration.nextElement());
        }
    }

    public void invalidateClass(Class clazz) {
        this.invalidateClass(clazz, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateClass(Class clazz, boolean bl) {
        IdentityMap identityMap;
        IdentityMap identityMap2 = identityMap = this.getIdentityMap(clazz);
        synchronized (identityMap2) {
            Enumeration enumeration = identityMap.keys();
            while (enumeration.hasMoreElements()) {
                CacheKey cacheKey = (CacheKey)enumeration.nextElement();
                Object object = cacheKey.getObject();
                if (!bl && (object == null || !object.getClass().equals(clazz))) continue;
                cacheKey.setInvalidationState(-1);
            }
        }
    }

    public void invalidateAll() {
        Enumeration enumeration = this.getIdentityMapManager().getIdentityMapClasses();
        while (enumeration.hasMoreElements()) {
            this.invalidateClass((Class)enumeration.nextElement());
        }
    }

    public boolean isValid(Object object) {
        return this.isValid(this.getSession().keyFromObject(object), object.getClass());
    }

    public boolean isValid(Vector vector, Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        CacheKey cacheKey = this.getCacheKeyForObject(vector, clazz, descriptor);
        if (cacheKey == null) {
            throw QueryException.classPkDoesNotExistInCache(clazz, vector);
        }
        return !descriptor.getCacheInvalidationPolicy().isInvalidated(cacheKey, System.currentTimeMillis());
    }

    public boolean isValid(DatabaseRow databaseRow, Class clazz) {
        return this.isValid(this.extractPrimaryKeyFromRow(databaseRow, clazz), clazz);
    }

    public void printIdentityMap(Class clazz) {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMap(clazz);
        }
    }

    public void printIdentityMaps() {
        if (this.getSession().shouldLog(7, "cache")) {
            this.getIdentityMapManager().printIdentityMaps();
        }
    }

    public void printIdentityMapLocks() {
        if (this.getSession().shouldLog(1, "cache")) {
            this.getIdentityMapManager().printLocks();
        }
    }

    public Object putInIdentityMap(Object object) {
        return this.putInIdentityMap(object, this.getSession().keyFromObject(object));
    }

    public Object putInIdentityMap(Object object, Vector vector) {
        return this.putInIdentityMap(object, vector, null);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2) {
        return this.putInIdentityMap(object, vector, object2, 0L);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2, long l) {
        Descriptor descriptor = this.getSession().getDescriptor(object);
        return this.putInIdentityMap(object, vector, object2, l, descriptor);
    }

    public Object putInIdentityMap(Object object, Vector vector, Object object2, long l, Descriptor descriptor) {
        CacheKey cacheKey = this.internalPutInIdentityMap(object, vector, object2, l, descriptor);
        if (cacheKey == null) {
            return null;
        }
        return cacheKey.getObject();
    }

    public void putQueryResult(ReadQuery readQuery, Vector vector, Object object) {
        this.getIdentityMapManager().putQueryResult(readQuery, vector, object);
    }

    public CacheKey internalPutInIdentityMap(Object object, Vector vector, Object object2, long l, Descriptor descriptor) {
        return this.getIdentityMapManager().putInIdentityMap(object, vector, object2, l, descriptor);
    }

    public void releaseWriteLock() {
        this.getIdentityMapManager().releaseWriteLock();
    }

    public Object removeFromIdentityMap(Object object) {
        return this.removeFromIdentityMap(this.getSession().keyFromObject(object), object.getClass());
    }

    public Object removeFromIdentityMap(Vector vector, Class clazz) {
        Descriptor descriptor = this.getSession().getDescriptor(clazz);
        return this.removeFromIdentityMap(vector, clazz, descriptor);
    }

    public Object removeFromIdentityMap(Vector vector, Class clazz, Descriptor descriptor) {
        return this.getIdentityMapManager().removeFromIdentityMap(vector, clazz, descriptor);
    }

    public void setIdentityMapManager(IdentityMapManager identityMapManager) {
        this.identityMapManager = identityMapManager;
    }

    public void setWrapper(Vector vector, Class clazz, Object object) {
        this.getIdentityMapManager().setWrapper(vector, clazz, object);
    }

    public void updateWriteLockValue(Object object, Object object2) {
        this.updateWriteLockValue(this.getSession().keyFromObject(object), object.getClass(), object2);
    }

    public void updateWriteLockValue(Vector vector, Class clazz, Object object) {
        this.getIdentityMapManager().setWriteLockValue(vector, clazz, object);
    }

    public void validateCache() {
        this.getSession().log(2, "cache", "validate_cache");
        DescriptorIterator descriptorIterator = new DescriptorIterator(){

            public void iterate(Object object) {
                if (!IdentityMapAccessor.this.containsObjectInIdentityMap(this.session.getDescriptor(object.getClass()).getObjectBuilder().extractPrimaryKeyFromObject(object, this.getSession()), object.getClass())) {
                    this.session.log(1, "cache", "stack_of_visited_objects_that_refer_to_the_corrupt_object", this.getVisitedStack());
                    this.session.log(2, "cache", "corrupt_object_referenced_through_mapping", this.getCurrentMapping());
                    this.session.log(2, "cache", "corrupt_object", object);
                }
            }
        };
        descriptorIterator.setSession(this.getSession());
        Iterator iterator = this.getSession().getDescriptors().values().iterator();
        while (iterator.hasNext()) {
            Class clazz = ((Descriptor)iterator.next()).getJavaClass();
            Enumeration enumeration = this.getIdentityMap(clazz).elements();
            while (enumeration.hasMoreElements()) {
                descriptorIterator.startIterationOn(enumeration.nextElement());
            }
        }
    }
}

