/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sequencing;

import oracle.toplink.internal.remote.RemoteConnection;
import oracle.toplink.internal.sequencing.ClientSessionSequencing;
import oracle.toplink.internal.sequencing.RemoteConnectionSequencing;
import oracle.toplink.internal.sequencing.Sequencing;
import oracle.toplink.internal.sequencing.SequencingHome;
import oracle.toplink.internal.sequencing.SequencingManager;
import oracle.toplink.internal.sequencing.SessionBrokerSequencing;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.remote.RemoteSession;
import oracle.toplink.sessionbroker.SessionBroker;
import oracle.toplink.threetier.ClientSession;

public class SequencingFactory {
    public static Sequencing createSequencing(Session session) {
        SessionBroker sessionBroker;
        Sequencing sequencing = null;
        if (session.isClientSession()) {
            ClientSession clientSession = (ClientSession)session;
            if (ClientSessionSequencing.sequencingServerExists(clientSession)) {
                sequencing = new ClientSessionSequencing(clientSession);
            }
        } else if (session.isRemoteSession()) {
            RemoteConnection remoteConnection = ((RemoteSession)session).getRemoteConnection();
            if (RemoteConnectionSequencing.masterSequencingExists(remoteConnection)) {
                sequencing = new RemoteConnectionSequencing(remoteConnection);
            }
        } else if (session.isBroker() && SessionBrokerSequencing.atLeastOneSessionHasSequencing(sessionBroker = (SessionBroker)session)) {
            sequencing = new SessionBrokerSequencing(sessionBroker);
        }
        return sequencing;
    }

    public static SequencingHome createSequencingHome(DatabaseSession databaseSession) {
        SequencingManager sequencingManager = null;
        if (!databaseSession.isBroker()) {
            sequencingManager = new SequencingManager(databaseSession);
        }
        return sequencingManager;
    }
}

