/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.sequencing;

import oracle.toplink.exceptions.ConcurrencyException;
import oracle.toplink.internal.databaseaccess.Accessor;
import oracle.toplink.internal.sequencing.SequencingConnectionHandler;
import oracle.toplink.publicinterface.DatabaseSession;
import oracle.toplink.sessions.Login;

class DatabaseSessionConnectionHandler
implements SequencingConnectionHandler {
    DatabaseSession ownerSession;
    Login login;
    Accessor accessor;
    boolean isBusy;

    DatabaseSessionConnectionHandler(DatabaseSession databaseSession, Login login) {
        this.ownerSession = databaseSession;
        this.login = login;
        this.accessor = login.buildAccessor();
    }

    public void onConnect() {
        if (!this.isConnected()) {
            this.accessor.connect(this.login, this.ownerSession);
        }
    }

    public boolean isConnected() {
        return this.accessor.isConnected();
    }

    public synchronized Accessor acquireAccessor() {
        if (this.isBusy) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                throw ConcurrencyException.waitFailureOnSequencingForDatabaseSession(interruptedException);
            }
        }
        this.isBusy = true;
        return this.accessor;
    }

    public synchronized void releaseAccessor(Accessor accessor) {
        this.isBusy = false;
        this.notify();
    }

    public void onDisconnect() {
        if (this.isConnected()) {
            this.accessor.disconnect(this.ownerSession);
        }
    }

    protected void finalize() throws Throwable {
        this.onDisconnect();
    }
}

