/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.io.Serializable;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.expressions.Expression;
import oracle.toplink.mappings.DatabaseMapping;
import oracle.toplink.mappings.foundation.AbstractDirectMapping;
import oracle.toplink.queryframework.ReportQuery;

public class ReportItem
implements Serializable {
    protected Expression attributeExpression;
    protected String name;
    protected AbstractDirectMapping mapping;

    public ReportItem() {
    }

    public ReportItem(String string, Expression expression) {
        this.name = string;
        this.attributeExpression = expression;
    }

    public Expression getAttributeExpression() {
        return this.attributeExpression;
    }

    public AbstractDirectMapping getMapping() {
        return this.mapping;
    }

    public String getName() {
        return this.name;
    }

    public void initialize(ReportQuery reportQuery) throws QueryException {
        if (this.getMapping() == null) {
            DatabaseMapping databaseMapping = reportQuery.getLeafMappingFor(this.getAttributeExpression(), reportQuery.getDescriptor());
            if (databaseMapping != null && !databaseMapping.isDirectToFieldMapping()) {
                throw QueryException.invalidExpressionForQueryItem(this.getAttributeExpression(), reportQuery);
            }
            this.setMapping((AbstractDirectMapping)databaseMapping);
        }
    }

    public boolean isPlaceHolder() {
        return this.getAttributeExpression() == null;
    }

    public void setMapping(AbstractDirectMapping abstractDirectMapping) {
        this.mapping = abstractDirectMapping;
    }

    public String toString() {
        return "ReportQueryItem(" + this.getName() + " -> " + this.getAttributeExpression() + ")";
    }
}

