/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.internal.queryframework;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import oracle.toplink.exceptions.QueryException;
import oracle.toplink.exceptions.ValidationException;
import oracle.toplink.internal.helper.ClassConstants;
import oracle.toplink.internal.helper.Helper;
import oracle.toplink.internal.queryframework.InterfaceContainerPolicy;
import oracle.toplink.internal.security.PrivilegedAccessController;
import oracle.toplink.publicinterface.Session;
import oracle.toplink.publicinterface.UnitOfWork;
import oracle.toplink.queryframework.DatabaseQuery;

public class MapContainerPolicy
extends InterfaceContainerPolicy {
    protected String keyMethodName;
    protected transient Method keyMethod;
    protected Class elementClass;
    protected String elementClassName;

    public MapContainerPolicy() {
    }

    public MapContainerPolicy(Class clazz) {
        super(clazz);
    }

    public MapContainerPolicy(String string) {
        super(string);
    }

    public void prepare(DatabaseQuery databaseQuery, Session session) throws QueryException {
        if (this.getElementClass() == null && databaseQuery.getDescriptor() != null) {
            this.setElementClass(databaseQuery.getDescriptor().getJavaClass());
        }
        super.prepare(databaseQuery, session);
    }

    public boolean addInto(Object object, Object object2, Object object3, Session session) {
        Object object4 = object2;
        if (this.hasElementDescriptor()) {
            object4 = this.getElementDescriptor().getObjectBuilder().wrapObject(object2, session);
        }
        try {
            if (object != null) {
                return ((Map)object3).put(object, object4) != null;
            }
            return ((Map)object3).put(this.keyFrom(object2, session), object4) != null;
        }
        catch (ClassCastException classCastException) {
            throw QueryException.mapKeyNotComparable(object2, object3);
        }
    }

    public void clear(Object object) {
        try {
            ((Map)object).clear();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object, "clear()");
        }
    }

    public boolean compareKeys(Object object, Session session) {
        Object object2 = null;
        object2 = ((UnitOfWork)session).isClassReadOnly(object.getClass()) ? ((UnitOfWork)session).getOriginalVersionOfObject(object) : ((UnitOfWork)session).getBackupClone(object);
        return this.keyFrom(object2, session).equals(this.keyFrom(object, session));
    }

    protected boolean contains(Object object, Object object2) {
        return ((Map)object2).containsValue(object);
    }

    public Class getElementClass() {
        return this.elementClass;
    }

    public String getElementClassName() {
        if (this.elementClassName == null && this.elementClass != null) {
            this.elementClassName = this.elementClass.getName();
        }
        return this.elementClassName;
    }

    public Class getInterfaceType() {
        return ClassConstants.Map_Class;
    }

    public Method getKeyMethod() {
        if (this.keyMethod == null) {
            try {
                this.keyMethod = Helper.getDeclaredMethod(this.elementClass, this.keyMethodName, null);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw ValidationException.methodNotDeclaredInItemClass(this.keyMethodName, this.elementClass);
            }
        }
        return this.keyMethod;
    }

    public String getKeyMethodName() {
        return this.keyMethodName;
    }

    public boolean isMapPolicy() {
        return true;
    }

    public Object iteratorFor(Object object) {
        return ((Map)object).values().iterator();
    }

    public Object keyFrom(Object object, Session session) {
        Object object2 = object;
        if (this.hasElementDescriptor()) {
            object2 = this.getElementDescriptor().getObjectBuilder().unwrapObject(object, session);
        }
        try {
            return PrivilegedAccessController.invokeMethod(this.getKeyMethod(), object2, null);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw QueryException.cannotAccessMethodOnObject(this.getKeyMethod(), object2);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw QueryException.calledMethodThrewException(this.getKeyMethod(), object2, invocationTargetException);
        }
    }

    public boolean removeFrom(Object object, Object object2, Object object3, Session session) {
        try {
            Object var5_5 = null;
            var5_5 = object != null ? ((Map)object3).remove(object) : ((Map)object3).remove(this.keyFrom(object2, session));
            return var5_5 != null;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object3, "remove(Object element)");
        }
    }

    public boolean removeFromWithIdentity(Object object, Object object2, Session session) {
        boolean bl = false;
        Vector vector = new Vector(1);
        try {
            Iterator iterator = ((Map)object2).keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                if (((Map)object2).get(k) != object) continue;
                vector.addElement(k);
                bl = true;
            }
            if (bl) {
                for (int i = 0; i < vector.size(); ++i) {
                    ((Map)object2).remove(vector.elementAt(i));
                }
            }
            return bl;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw QueryException.methodNotValid(object2, "remove(Object element)");
        }
    }

    public void setElementClass(Class clazz) {
        this.elementClass = clazz;
    }

    public void setElementClassName(String string) {
        this.elementClassName = string;
    }

    public boolean isValidContainer(Object object) {
        return object instanceof Map;
    }

    public void setKeyMethod(String string, Class clazz) {
        this.keyMethodName = string;
        this.elementClass = clazz;
    }

    public void setKeyMethod(String string, String string2) {
        this.keyMethodName = string;
        this.elementClassName = string2;
    }

    public void setKeyMethodName(String string) {
        this.keyMethodName = string;
    }

    public int sizeFor(Object object) {
        return ((Map)object).size();
    }

    public void validateElementAndRehashIfRequired(Object object, Object object2, Session session, Object object3) {
        Object object4;
        if (session.isUnitOfWork() && !this.keyFrom(object4 = ((UnitOfWork)session).getBackupClone(object), session).equals(this.keyFrom(object, session))) {
            this.removeFrom(object4, object2, session);
            this.addInto(object3, object2, session);
        }
    }
}

